<?
	//$_POST['net_protocol'] - tcp or udp
	//$_POST['protocol'] - device protocol, like coban, teltonika, xexun
	//$_POST['ip'] - IP address of GPS device
	//$_POST['port'] - PORT of GPS device
	//$_POST['imei'] - device 15 char ID
	//$_POST['dt_server'] - 0 UTC date and time in "YYYY-MM-DD HH-MM-SS" format
	//$_POST['dt_tracker'] - 0 UTC date and time in "YYYY-MM-DD HH-MM-SS" format
	//$_POST['lat'] - latitude with +/-
	//$_POST['lng'] - longitude with +/-
	//$_POST['altitude'] - in meters
	//$_POST['angle'] - in degree
	//$_POST['speed'] - in km/h
	//$_POST['loc_valid'] - 1 means valid location, 0 means not valid location
	//$_POST['params'] - stores array of params like acc, di, do, ai...
	//$_POST['event'] - possible events: sos, bracon, bracoff, dismount, disassem, door, mandown, shock, tow, pwrcut, gpscut, jamming, lowdc, lowbat, haccel, hbrake, hcorn
	
	include ('s_init.php');
	include ('s_events.php');
	include ('../func/fn_common.php');
	include ('../tools/gc_func.php');

		$timestamp = gmdate("Y-m-d H:i:s");
		$content = "[$timestamp] $message";
	
		if (!is_null($data)) {
			$content .= ' | Data: ' . json_encode($data);
		}
	
		// error_log($content . PHP_EOL, 3, 'insert_db_loc.log');
	

	function insert_db_loc($loc) 
{
	global $ms;

	// Log initial data
	
	$loc['imei'] = strtoupper(trim($loc['imei']));
	$loc['lat'] = (double)sprintf('%0.6f', $loc['lat']);
	$loc['lng'] = (double)sprintf('%0.6f', $loc['lng']);
	$loc['altitude'] = floor($loc['altitude']);
	$loc['angle'] = floor($loc['angle']);
	$loc['speed'] = floor($loc['speed']);
	$loc['protocol'] = strtolower($loc['protocol']);
	$loc['net_protocol'] = strtolower($loc['net_protocol']);


	if (!ctype_alnum($loc['imei'])) { 
		return 'imei'; 
	}
	if ($loc['speed'] > 1000) { 
		return 'speed'; 
	}
	if (!checkObjectExistsSystem($loc['imei'])) {
		insert_db_unused($loc);
		return "existsn't"; 
	}

	// Log date validation checks
	if ((substr($loc['dt_tracker'], 0, 4) > (gmdate('Y') + 10)) || (substr($loc['dt_tracker'], 0, 4) < (gmdate('Y') - 10))) {
		if (substr($loc['dt_tracker'], 5, 5) == gmdate('m-d')) {
			$loc['dt_tracker'] = gmdate('Y').substr($loc['dt_tracker'], 4, 15);
		} else {
			$loc['dt_tracker'] = gmdate("Y-m-d H:i:s");
		}
	}

	if (strtotime($loc['dt_tracker']) >= strtotime(gmdate("Y-m-d H:i:s").' +1 days')) {
		return 'too far'; 
	}

	if (strtotime($loc['dt_tracker']) >= strtotime(gmdate("Y-m-d H:i:s").' +1 hours')) {
		$loc['dt_tracker'] = gmdate("Y-m-d H:i:s");
	}

	$loc['dt_tracker'] = adjustObjectTime($loc['imei'], $loc['dt_tracker']);

	$loc_prev = get_gs_objects_data($loc['imei']);

	if (($loc_prev['forward_loc_data'] == 'true') && ($loc_prev['forward_loc_data_imei'] != '')) {
		if (!checkObjectExistsSystem($loc_prev['forward_loc_data_imei'])) {
			return 'no forward_loc_data_imei'; 
		}
		$loc['imei'] = $loc_prev['forward_loc_data_imei'];
		$loc_prev = get_gs_objects_data($loc['imei']);
	}

	// Latitude and longitude validation logs
	if ($loc['lat'] != $loc_prev['lat'] && abs($loc['lat']) == abs($loc_prev['lat'])) {
		return 'incorrect lat and lng signs'; 
	}
	if ($loc['lng'] != $loc_prev['lng'] && abs($loc['lng']) == abs($loc_prev['lng'])) {
		return 'incorrect lat and lng signs'; 
	}

	$loc = loc_accvirt($loc, $loc_prev);

	$is_ble = false;
	if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {
		foreach ($loc['params'] as $key => $value) {
			if (substr($key, 0, 3) == 'ble') {
				$is_ble = true;
				break;
			}
		}

		if ((strtotime($loc_prev['dt_last_params_ble']) <= strtotime(gmdate("Y-m-d H:i:s")." - 2 minutes")) && ($is_ble == false)) {
			$loc['params'] = mergeParamsBLE($loc_prev['params'], $loc['params'], false, true);
		} else {
			$loc['params'] = mergeParamsBLE($loc_prev['params'], $loc['params'], $is_ble, false);
		}
	}

	// Final location data processing
	$loc = loc_unassign_driver($loc, $loc_prev);
	$loc = loc_ignore_acc($loc, $loc_prev);

	ksort($loc['params']);
	if ($loc['loc_valid'] == 0 && ($loc['lat'] == 0 || $loc['lng'] == 0) && strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {
		$loc['lat'] = $loc_prev['lat'];
		$loc['lng'] = $loc_prev['lng'];
		$loc['altitude'] = $loc_prev['altitude'];
		$loc['angle'] = $loc_prev['angle'];
		$loc['speed'] = 0;
	}

	// Insert data and final operations
	insert_db_objects($loc, $loc_prev, $is_ble);

	insert_db_status($loc, $loc_prev);

	insert_db_odo_engh($loc, $loc_prev);

	insert_db_ri($loc, $loc_prev);

	insert_db_dtc($loc);

	if (loc_filter($loc, $loc_prev) == false) {
		insert_db_object_data($loc);

		if (($loc['lat'] != 0) && ($loc['lng'] != 0) && strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {
			check_events($loc, $loc_prev, true, true, false);
		} else {
			check_events($loc, false, false, false, false);
		}
	}
}

	
	function insert_db_noloc($loc)
	{
		global $ms;
		
		// format data
		$loc['imei'] = strtoupper(trim($loc['imei']));
		$loc['protocol'] = strtolower($loc['protocol']);
		$loc['net_protocol'] = strtolower($loc['net_protocol']);
		
		// check for wrong IMEI
		if (!ctype_alnum($loc['imei']))
		{
			return false;
		}
		
		// check if object exists in system
		if (!checkObjectExistsSystem($loc['imei']))
		{
			return false;
		}
		
		// get previous known location
		$loc_prev = get_gs_objects_data($loc['imei']);
		
		// forward loc data
		if (($loc_prev['forward_loc_data'] == 'true') && ($loc_prev['forward_loc_data_imei'] != ''))
		{
			if (!checkObjectExistsSystem($loc_prev['forward_loc_data_imei']))
			{
				return false;
			}
			
			$loc['imei'] = $loc_prev['forward_loc_data_imei'];
			$loc_prev = get_gs_objects_data($loc['imei']);
		}
		
		// add previous known location
		$loc['dt_tracker'] = $loc_prev['dt_tracker'];
		$loc['lat'] = $loc_prev['lat'];
		$loc['lng'] = $loc_prev['lng'];
		$loc['altitude'] = $loc_prev['altitude'];
		$loc['angle'] = $loc_prev['angle'];
		
		// check speed for reset
		$loc['speed'] = $loc_prev['speed'];
		if ($loc['speed'] > 0)
		{
			$dt_difference = strtotime(gmdate("Y-m-d H:i:s")) - strtotime($loc['dt_tracker']);
			if($dt_difference >= 150)
			{
				$loc['speed'] = 0;
			}	
		}
		
		$loc['loc_valid'] = $loc_prev['loc_valid'];
		
		// accvirt
		$loc = loc_accvirt($loc, $loc_prev);
		
		// set params BLE dt flag
		$is_ble = false;
		
		// check for params BLE and udpate flag
		foreach ($loc['params'] as $key => $value)
		{
			if (substr($key, 0, 3) == 'ble')
			{
				$is_ble = true;
				break;
			}				
		}			
		// remove params BLE if more than 5 minutes passed from last BLE packet
		if ((strtotime($loc_prev['dt_last_params_ble']) <= strtotime(gmdate("Y-m-d H:i:s")." - 2 minutes")) && ($is_ble == false))
		{
			$loc['params'] = mergeParamsBLE($loc_prev['params'], $loc['params'], false, true);
		}
		else
		{
			$loc['params'] = mergeParamsBLE($loc_prev['params'], $loc['params'], $is_ble, false);	
		}
			
		// check if there is any sensor values to ignore due to ignition off
		$loc = loc_ignore_acc($loc, $loc_prev);
		
		// unassign driver if acc is off
		$loc = loc_unassign_driver($loc, $loc_prev);
		
		// sort params array
		ksort($loc['params']);
		
		$q = "UPDATE gs_objects SET 	`protocol`='".$loc['protocol']."',
										`net_protocol`='".$loc['net_protocol']."',
										`ip`='".$loc['ip']."',
										`port`='".$loc['port']."',
										`dt_server`='".$loc['dt_server']."',
										`speed`='".$loc['speed']."',
										`params`='".json_encode($loc['params'])."'";
										
										
		// add last params BLE dt
		if ($is_ble)
		{
			$q .= ",`dt_last_params_ble`='".gmdate("Y-m-d H:i:s")."'";
		}
									
		$q .= " WHERE imei='".$loc['imei']."'";
						
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
		
		// check if location exists
		if (($loc['lat'] != 0) && ($loc['lng'] != 0))
		{
			insert_db_status($loc, $loc_prev);
			
			insert_db_odo_engh($loc, $loc_prev);
			
			insert_db_ri($loc, $loc_prev);
			
			insert_db_dtc($loc);
			
			check_events($loc, $loc_prev, false, true, false);
		}
	}
	
	function insert_db_imgloc($loc)
	{
		global $ms, $gsValues;
		
		// format data
		$loc['imei'] = strtoupper(trim($loc['imei']));
		$loc['lat'] = (double)sprintf('%0.6f', $loc['lat']);
		$loc['lng'] = (double)sprintf('%0.6f', $loc['lng']);
		$loc['altitude'] = floor($loc['altitude']);
		$loc['angle'] = floor($loc['angle']);
		$loc['speed'] = floor($loc['speed']);
		$loc['protocol'] = strtolower($loc['protocol']);
		$loc['net_protocol'] = strtolower($loc['net_protocol']);
		
		// check for wrong IMEI
		if (!ctype_alnum($loc['imei']))
		{
			return false;
		}
		
		// check if object exists in system
		if (!checkObjectExistsSystem($loc['imei']))
		{
			return false;
		}
		
		if (($loc['lat'] == 0) || ($loc['lng'] == 0))
		{
			// get previous known location
			$loc_prev = get_gs_objects_data($loc['imei']);
		
			$loc['lat'] = $loc_prev['lat'];
			$loc['lng'] = $loc_prev['lng'];
			$loc['altitude'] = $loc_prev['altitude'];
			$loc['angle'] = $loc_prev['angle'];
			$loc['speed'] = $loc_prev['speed'];
		}
		
		$img_file = $loc['imei'].'_'.$loc['dt_server'].'.jpg';
		$img_file = str_replace('-', '', $img_file);
		$img_file = str_replace(':', '', $img_file);
		$img_file = str_replace(' ', '_', $img_file);
		
		// save to database
		$q = "INSERT INTO gs_object_img (img_file,
										imei,
										dt_server,
										dt_tracker,
										lat,
										lng,
										altitude,
										angle,
										speed,
										params
										) VALUES (
										'".$img_file."',
										'".$loc['imei']."',
										'".$loc['dt_server']."',
										'".$loc['dt_tracker']."',
										'".$loc['lat']."',
										'".$loc['lng']."',
										'".$loc['altitude']."',
										'".$loc['angle']."',
										'".$loc['speed']."',
										'".json_encode($loc['params'])."')";
				    
		$r = mysqli_query($ms, $q);
		
		// save last img file for every IMEI
		$q = "UPDATE `gs_objects` SET `last_img_file`='".$img_file."' WHERE `imei`='".$loc['imei']."'";
		$r = mysqli_query($ms, $q);
		
		 // save file
		$img_path = $gsValues['PATH_ROOT'].'/data/img/';
		$img_path = $img_path.basename($img_file);
		
		if (!isFilePathValid($img_path))
		{
			die;
		}
		
		$postdata = hex2bin($loc["img"]);
				
		if(substr($postdata,0,3) == "\xFF\xD8\xFF")
		{
			$fp = fopen($img_path,"w");
			fwrite($fp,$postdata);
			fclose($fp);
		}
	}
	
	function insert_db_unused($loc)
	{
		global $ms;
		
		$q = "INSERT INTO `gs_objects_unused` (imei, protocol, net_protocol, ip, port, dt_server, count)
						VALUES ('".$loc['imei']."', '".$loc['protocol']."', '".$loc['net_protocol']."', '".$loc['ip']."', '".$loc['port']."', '".$loc['dt_server']."', '1')
						ON DUPLICATE KEY UPDATE protocol = '".$loc['protocol']."', net_protocol = '".$loc['net_protocol']."', ip = '".$loc['ip']."', port = '".$loc['port']."', dt_server = '".$loc['dt_server']."', count = count + 1";
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
	}
	function insert_db_objects($loc, $loc_prev, $is_ble)
{
	global $ms;

	// Log start of function

	if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {			

		if ($loc['loc_valid'] == 1) {

			if ($loc['angle'] == 0) {
				$loc['angle'] = getAngle($loc_prev['lat'], $loc_prev['lng'], $loc['lat'], $loc['lng']);
			}
			
			$q = "UPDATE gs_objects SET `protocol`='".$loc['protocol']."',
										`net_protocol`='".$loc['net_protocol']."',
										`ip`='".$loc['ip']."',
										`port`='".$loc['port']."',
										`dt_server`='".$loc['dt_server']."',
										`dt_tracker`='".$loc['dt_tracker']."',
										`lat`='".$loc['lat']."',
										`lng`='".$loc['lng']."',
										`altitude`='".$loc['altitude']."',
										`angle`='".$loc['angle']."',
										`speed`='".$loc['speed']."',
										`loc_valid`='1',
										`params`='".json_encode($loc['params'])."'";

			// Log if BLE data is present
			if ($is_ble) {
				$q .= ",`dt_last_params_ble`='".gmdate("Y-m-d H:i:s")."'";
			}

			$q .= " WHERE imei='".$loc['imei']."'";
			$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
		} else {
			$loc['speed'] = 0;

			if (($loc['lat'] != 0) && ($loc['lng'] != 0)) {

				$q = "UPDATE gs_objects SET `protocol`='".$loc['protocol']."',
											`net_protocol`='".$loc['net_protocol']."',
											`ip`='".$loc['ip']."',
											`port`='".$loc['port']."',
											`dt_server`='".$loc['dt_server']."',
											`dt_tracker`='".$loc['dt_tracker']."',
											`lat`='".$loc['lat']."',
											`lng`='".$loc['lng']."',
											`altitude`='".$loc['altitude']."',
											`angle`='".$loc['angle']."',
											`speed`='".$loc['speed']."',
											`loc_valid`='0',
											`params`='".json_encode($loc['params'])."'";

				// Log if BLE data is present
				if ($is_ble) {
					$q .= ",`dt_last_params_ble`='".gmdate("Y-m-d H:i:s")."'";
				}

				$q .= " WHERE imei='".$loc['imei']."'";
			} else {
				$q = "UPDATE gs_objects SET `protocol`='".$loc['protocol']."',
											`net_protocol`='".$loc['net_protocol']."',
											`ip`='".$loc['ip']."',
											`port`='".$loc['port']."',
											`dt_server`='".$loc['dt_server']."',
											`dt_tracker`='".$loc['dt_tracker']."',
											`speed`='".$loc['speed']."',
											`loc_valid`='0',
											`params`='".json_encode($loc['params'])."'";

				// Log if BLE data is present
				if ($is_ble) {
					$q .= ",`dt_last_params_ble`='".gmdate("Y-m-d H:i:s")."'";
				}

				$q .= " WHERE imei='".$loc['imei']."'";
			}

			$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
		}
	} else {
		$q = "UPDATE gs_objects SET `protocol`='".$loc['protocol']."',
									`net_protocol`='".$loc['net_protocol']."',
									`ip`='".$loc['ip']."',
									`port`='".$loc['port']."',
									`dt_server`='".$loc['dt_server']."'
									WHERE imei='".$loc['imei']."'";
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
	}
	
	// Log completion of function
}
function insert_db_object_data($loc)
{
	global $ms;

	// Log start of function

	if (($loc['lat'] != 0) && ($loc['lng'] != 0)) {

		$q = "INSERT INTO gs_object_data_".$loc['imei']."(
				dt_server,
				dt_tracker,
				lat,
				lng,
				altitude,
				angle,
				speed,
				params
			) VALUES (
				'".$loc['dt_server']."',
				'".$loc['dt_tracker']."',
				'".$loc['lat']."',
				'".$loc['lng']."',
				'".$loc['altitude']."',
				'".$loc['angle']."',
				'".$loc['speed']."',
				'".json_encode($loc['params'])."'
			)";
		
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
	} else {
	}

	// Log completion of function
}

	
	function insert_db_status($loc, $loc_prev)
	{
		global $ms;
		
		if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker']))
		{
			// error_log('597) if (strtotime($loc[dt_tracker]) >= strtotime($loc_prev[dt_tracker]))',3,'insert_db_status.log');
			$imei = $loc['imei'];
			$params = $loc['params'];
			
			$dt_last_stop = strtotime($loc_prev['dt_last_stop']);
			$dt_last_idle = strtotime($loc_prev['dt_last_idle']);
			$dt_last_move = strtotime($loc_prev['dt_last_move']);
			
			// error_log("605) dt_last_stop:".$dt_last_stop."dt_last_move:".$dt_last_move."dt_last_idle:".$dt_last_idle."loc_valid: ".$loc['loc_valid'],3,"dt_last_idle.log");

			if ($loc['loc_valid'] == 1)
			{

				// status stop
				// error_log('611) '.$dt_last_stop." <= 0 || ".$dt_last_stop." < ".$dt_last_move." && ".$loc['speed']." == 0",3,"dt_last_idle.log");
				if ((($dt_last_stop <= 0) || ($dt_last_stop < $dt_last_move)) && ($loc['speed'] == 0))
				{
					$q = "UPDATE gs_objects SET `dt_last_stop`='".$loc['dt_server']."' WHERE imei='".$imei."'";			
					$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
					
					$dt_last_stop = strtotime($loc['dt_server']);
				}
				
				// status moving
				if (($dt_last_stop >= $dt_last_move) && ($loc['speed'] > 0))
				{
					$q = "UPDATE gs_objects SET `dt_last_move`='".$loc['dt_server']."' WHERE imei='".$imei."'";			
					$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
					
					$dt_last_move = strtotime($loc['dt_server']);
				}
			}
			else
			{
				// error_log('else linea 624',3,'insert_db_status.log');
				// status stop
				if ((($dt_last_stop <= 0) || ($dt_last_stop < $dt_last_move)) && ($loc['speed'] == 0))
				{
					$q = "UPDATE gs_objects SET `dt_last_stop`='".$loc['dt_server']."' WHERE imei='".$imei."'";			
					$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
					
					$dt_last_stop = strtotime($loc['dt_server']);
				}
			}
			
			// status idle
			// error_log($dt_last_stop." >= ".$dt_last_move." && ".$dt_last_idle." <= 0",3,"dt_last_idle.log");
			if ($dt_last_stop >= $dt_last_move)
			{
				$sensor = getSensorFromType($imei, 'acc');
				$acc = $sensor[0]['param'];
				// error_log("648) acc:".$acc.' params: ' . var_dump($params),3,"dt_last_idle.log");
				if (isset($params[$acc]))
				{
					$test = ($params[$acc] == 1) && ($dt_last_idle <= 0) ? (($params[$acc] == 0) && ($dt_last_idle > 0) ? 'true' : 'false') : 'false';
					// error_log('test: '.$test,3,"dt_last_idle.log");
					if (($params[$acc] == 1) && ($dt_last_idle <= 0))
					{
						$q = "UPDATE gs_objects SET `dt_last_idle`='".$loc['dt_server']."' WHERE imei='".$imei."'";
						$r = mysqli_query($ms, $q) or die(mysqli_error($ms));	
						// error_log("657) dt_last_idle:".$loc['dt_server'],3,"dt_last_idle.log");
					}
					else if (($params[$acc] == 0) && ($dt_last_idle > 0))
					{
						$q = "UPDATE gs_objects SET `dt_last_idle`='0000-00-00 00:00:00' WHERE imei='".$imei."'";
						$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
					}
				}
				// error_log("params:".print_r($params,true)."dt_last_stop:".$dt_last_stop."dt_last_move:".$dt_last_move."dt_last_idle:".$dt_last_idle,3,"dt_last_idle.log");
			}
			else
			{
				if ($dt_last_idle > 0)
				{
					$q = "UPDATE gs_objects SET `dt_last_idle`='0000-00-00 00:00:00' WHERE imei='".$imei."'";
					$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
				}
			}
		}
	}
	function insert_db_odo_engh($loc, $loc_prev)
{
	global $ms;

	$imei = $loc['imei'];
	$params = $loc['params'];
	$params_prev = $loc_prev['params'];

	// Log start of function

	// Odometer GPS type
	if ($loc_prev['odometer_type'] == 'gps') {

		if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker']) && $loc['loc_valid'] == 1) {

			if (($loc_prev['lat'] != 0) && ($loc_prev['lng'] != 0) && ($loc['speed'] > 3)) {
				$odometer = getLengthBetweenCoordinates($loc_prev['lat'], $loc_prev['lng'], $loc['lat'], $loc['lng']);

				if ($odometer > 0) {
					$q = 'UPDATE gs_objects SET `odometer` = odometer + '.$odometer.' WHERE imei="'.$imei.'"';
					$r = mysqli_query($ms, $q);

					// Update mileage
					$q = 'UPDATE gs_objects SET `mileage_1` = mileage_1 + '.$odometer.' WHERE imei="'.$imei.'"';
					$r = mysqli_query($ms, $q);
				}
			}
		}
	}

	// Odometer sensor type
	if ($loc_prev['odometer_type'] == 'sen') {

		$sensor = getSensorFromType($imei, 'odo');
		if ($sensor) {
			$sensor_ = $sensor[0];
			$odo = getSensorValue($params, $sensor_);
			$result_type = $sensor_['result_type'];

			if ($result_type == 'abs') {
				if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {
					$q = 'UPDATE gs_objects SET `odometer` = '.$odo['value'].' WHERE imei="'.$imei.'"';
					$r = mysqli_query($ms, $q);

					$mileage_1 = $odo['value'] - $loc_prev['odometer'];
					if ($mileage_1 > 0) {
						$q = 'UPDATE gs_objects SET `mileage_1` = mileage_1 + '.$mileage_1.' WHERE imei="'.$imei.'"';
						$r = mysqli_query($ms, $q);
					}
				}
			}

			if ($result_type == 'rel' && $odo['value'] > 0) {
				$q = 'UPDATE gs_objects SET `odometer` = odometer + '.$odo['value'].' WHERE imei="'.$imei.'"';
				$r = mysqli_query($ms, $q);

				$q = 'UPDATE gs_objects SET `mileage_1` = mileage_1 + '.$odo['value'].' WHERE imei="'.$imei.'"';
				$r = mysqli_query($ms, $q);
			}
		}
	}

	// Engine hours ACC type
	if ($loc_prev['engine_hours_type'] == 'acc') {

		if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker']) && $loc['loc_valid'] == 1) {
			$sensor = getSensorFromType($imei, 'acc');
			$acc = $sensor[0]['param'];
			$engine_hours = 0;

			if (isset($params_prev[$acc]) && isset($params[$acc]) && ($params_prev[$acc] == '1') && ($params[$acc] == '1')) {
				$engine_hours = strtotime($loc['dt_tracker']) - strtotime($loc_prev['dt_tracker']);
				if ($engine_hours <= 300) {
					$q = 'UPDATE gs_objects SET `engine_hours` = engine_hours + '.$engine_hours.' WHERE imei="'.$imei.'"';
					$r = mysqli_query($ms, $q);
				}
			}
		}
	}

	// Engine hours sensor type
	if ($loc_prev['engine_hours_type'] == 'sen') {

		$sensor = getSensorFromType($imei, 'engh');
		if ($sensor) {
			$sensor_ = $sensor[0];
			$engh = getSensorValue($params, $sensor_);
			$result_type = $sensor_['result_type'];

			if ($result_type == 'abs' && strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {
				$q = 'UPDATE gs_objects SET `engine_hours` = '.$engh['value'].' WHERE imei="'.$imei.'"';
				$r = mysqli_query($ms, $q);
			}

			if ($result_type == 'rel' && $engh['value'] > 0) {
				$q = 'UPDATE gs_objects SET `engine_hours` = engine_hours + '.$engh['value'].' WHERE imei="'.$imei.'"';
				$r = mysqli_query($ms, $q);
			}
		}
	}

	// Log completion of function
}

function insert_db_ri($loc, $loc_prev)
{
	global $ms;

	// Log start of function

	if (strtotime($loc['dt_tracker']) >= strtotime($loc_prev['dt_tracker'])) {

		// Define group array for logbook
		$group_array = array('da', 'pa', 'ta');

		// Iterate over each group in the group array
		for ($i = 0; $i < count($group_array); ++$i) {
			$group = $group_array[$i];

			// Retrieve sensor data for the current group
			$sensor = getSensorFromType($loc['imei'], $group);
			if ($sensor !== false) {
				$sensor_ = $sensor[0];
				$sensor_data = getSensorValue($loc['params'], $sensor_);
				$assign_id = $sensor_data['value'];

				// Check if assign_id is not zero
				if ((string)$assign_id != '0') {
					$sensor_data_prev = getSensorValue($loc_prev['params'], $sensor_);
					$assign_id_prev = $sensor_data_prev['value'];

					// Insert new data if assign_id has changed
					if ((string)$assign_id != (string)$assign_id_prev) {
						insert_db_ri_data($loc['dt_server'], $loc['dt_tracker'], $loc['imei'], $group, $assign_id, $loc['lat'], $loc['lng']);
					}
				}
			} else {
			}
		}
	} else {
	}

	// Log completion of function
}

	
	function insert_db_ri_data($dt_server, $dt_tracker, $imei, $group, $assign_id, $lat, $lng)
	{
		global $ms;
		
		$address = geocoderGetAddress($lat, $lng);
		
		$q = 'INSERT INTO gs_rilogbook_data  (	`dt_server`,
							`dt_tracker`,
							`imei`,
							`group`,
							`assign_id`,
							`lat`,
							`lng`,
							`address`
							) VALUES (
							"'.$dt_server.'",
							"'.$dt_tracker.'",
							"'.$imei.'",
							"'.$group.'",
							"'.$assign_id.'",
							"'.$lat.'",
							"'.$lng.'",
							"'.mysqli_real_escape_string($ms, $address).'")';
							
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
	}
	function insert_db_dtc($loc)
{
	global $ms;

	// Log start of function

	if (isset($loc['event'])) {

		if (substr($loc['event'], 0, 3) == 'dtc') {
			$dtcs = str_replace("dtc:", "", $loc['event']);
			$dtcs = explode(',', $dtcs);

			// Process each DTC code
			for ($i = 0; $i < count($dtcs); ++$i) {
				if ($dtcs[$i] != '') {
					insert_db_dtc_data($loc['dt_server'], $loc['dt_tracker'], $loc['imei'], strtoupper($dtcs[$i]), $loc['lat'], $loc['lng']);
				}
			}
		}
	} else {
	}

	// Log completion of function
}

	function insert_db_dtc_data($dt_server, $dt_tracker, $imei, $code, $lat, $lng)
	{
		global $ms;
		
		// check for duplicates during past 24 hours
		$q = "SELECT * FROM `gs_dtc_data` WHERE `imei`='".$imei."' AND `code`='".$code."' AND dt_server > DATE_SUB(UTC_DATE(), INTERVAL 1 DAY)";
		$r = mysqli_query($ms, $q);
		
		$num = mysqli_num_rows($r);
		
		if ($num == 0)
		{
			$address = geocoderGetAddress($lat, $lng);
					
			$q = 'INSERT INTO gs_dtc_data  (`dt_server`,
							`dt_tracker`,
							`imei`,
							`code`,
							`lat`,
							`lng`,
							`address`
							) VALUES (
							"'.$dt_server.'",
							"'.$dt_tracker.'",
							"'.$imei.'",
							"'.$code.'",
							"'.$lat.'",
							"'.$lng.'",
							"'.mysqli_real_escape_string($ms, $address).'")';
								
			$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
		}
	}
	
	function get_gs_objects_data($imei)
	{
		global $ms;
		
		$q = "SELECT * FROM gs_objects WHERE `imei`='".$imei."'";
		$r = mysqli_query($ms, $q) or die(mysqli_error($ms));
		$row = mysqli_fetch_array($r);
		
		if ($row)
		{
			$row['params'] = json_decode($row['params'],true);
			
			return $row;
		}
		else
		{
			return false;
		}
	}
	
	function loc_ignore_acc($loc, $loc_prev)
	{
		$ignore_sensors = array();
		$acc_sensor = getSensorFromType($loc['imei'], 'acc');
		
		if ($acc_sensor)
		{
			$sensors = getObjectSensors($loc['imei']);
			
			foreach ($sensors as $key=>$value)
			{
				if ($value['acc_ignore'] == 'true')
				{
					$ignore_sensors[] = $value;
				}
			}
			
			foreach ($ignore_sensors as $key=>$value)
			{
				$sensor_data = getSensorValue($loc['params'], $acc_sensor[0]);
					
				if ($sensor_data['value'] == 0)					
				{
					if (isset($loc_prev['params'][$value['param']]))
					{
						$loc['params'][$value['param']] = $loc_prev['params'][$value['param']];	
					}
					else
					{
						unset($loc['params'][$value['param']]);
					}						
				}					
			}		
		}
		
		return $loc;
	}
	
	function loc_accvirt($loc, $loc_prev)
	{
		if ($loc_prev['accvirt'] == 'true')
		{
			// error_log("deberia llegar acá si es tru: ".json_encode($loc),3,"loc_accvirt.log");
			if (json_decode($loc_prev['accvirt_cn'],true) != null)
			{
				$accvirt_cn = json_decode($loc_prev['accvirt_cn'],true);
						
				$cn_1 = false;
				$cn_0 = false;
				
				// check if param exits	

				// rdante: VALORES DEFAULT ACCVIRT	

				// $default = array(
				// 	'param' => '',
				// 	'accvirt_1_cn' => 'gr',
				// 	'accvirt_0_cn' => 'lw',
				// 	'accvirt_1_val' => 12,
				// 	'accvirt_0_val' => 10
				// );

				if (isset($loc['params'][$accvirt_cn['param']]))
				{					 
					if ($accvirt_cn['accvirt_1_cn'] == 'eq')
					{
						if ($loc['params'][$accvirt_cn['param']] == $accvirt_cn['accvirt_1_val']) $cn_1 = true;
					}					
					else if ($accvirt_cn['accvirt_1_cn'] == 'gr')
					{
						if ($loc['params'][$accvirt_cn['param']] > $accvirt_cn['accvirt_1_val']) $cn_1 = true;
					}					
					else if ($accvirt_cn['accvirt_1_cn'] == 'lw')
					{
						if ($loc['params'][$accvirt_cn['param']] < $accvirt_cn['accvirt_1_val']) $cn_1 = true;
					}
					
					if ($accvirt_cn['accvirt_0_cn'] == 'eq')
					{
						if ($loc['params'][$accvirt_cn['param']] == $accvirt_cn['accvirt_0_val']) $cn_0 = true;
					}
					else if ($accvirt_cn['accvirt_0_cn'] == 'gr')
					{
						if ($loc['params'][$accvirt_cn['param']] > $accvirt_cn['accvirt_0_val']) $cn_0 = true;
					}					
					else if ($accvirt_cn['accvirt_0_cn'] == 'lw')
					{
						if ($loc['params'][$accvirt_cn['param']] < $accvirt_cn['accvirt_0_val']) $cn_0 = true;
					}
					
					if (($cn_1) && (!$cn_0))
					{
						$loc['params']['accvirt'] = '1';
					}
					else if ((!$cn_1) && ($cn_0))
					{
						$loc['params']['accvirt'] = '0';
					}					
				}
			}
		}
		else
		{
			unset($loc['params']['accvirt']);
			// error_log("no tru: ".json_encode($loc),3,"loc_accvirt.log");
		}
		
		return $loc;
	}
	
	function loc_unassign_driver($loc, $loc_prev)
	{
		global $ms;
		
		if ($loc_prev['unassign_driver'] == 'true')
		{
			$acc_sensor = getSensorFromType($loc['imei'], 'acc');
			$da_sensor = getSensorFromType($loc['imei'], 'da');
		
			if (($acc_sensor) && ($da_sensor))
			{
				$acc_loc = getSensorValue($loc['params'], $acc_sensor[0]);
				
				if ($acc_loc['value'] == 0)
				{
					$loc['params'][$da_sensor[0]['param']] = '0';
				}
			}
		}
		
		return $loc;
	}
	
	function loc_filter($loc, $loc_prev)
	{
		global $ms, $gsValues;
		
		if ($gsValues['LOCATION_FILTER'] == false)
		{
			return false;
		}
		
		if (isset($loc['lat']) && isset($loc['lng']) && isset($loc['params']))
		{
			if (($loc['event'] == '') && ($loc_prev['params'] == $loc['params']))
			{
				$dt_difference = abs(strtotime($loc['dt_server']) - strtotime($loc_prev['dt_server']));
				
				if($dt_difference < 120)
				{
					// skip same location
					if (($loc_prev['lat'] == $loc['lat']) && ($loc_prev['lng'] == $loc['lng']) && ($loc_prev['speed'] == $loc['speed']))
					{
						return true;
					}
					
					// skip drift
					$distance = getLengthBetweenCoordinates($loc_prev['lat'], $loc_prev['lng'], $loc['lat'], $loc['lng']);
					if (($dt_difference < 30) && ($distance < 0.01) && ($loc['speed'] < 3) && ($loc_prev['speed'] == 0))
					{
						return true;
					}
				}
			}
		}
		
		return false;
	}
	
	function loc_filter_india($loc)
	{
		$lock_india_vertices = '6.795535,77.409668,23.483401,67.609863,27.877928,69.719238,29.382175,72.465820,37.195331,72.290039,37.579413,75.761719,29.573457,98.129883,25.125393,96.789551,20.550509,91.604004,6.096860,94.965820,10.444598,80.617676,6.795535,77.409668';
		$imeis = explode(",", '111111111111111,222222222222222,333333333333333');
		if (!in_array($loc['imei'], $imeis))
		{
			if (isPointInPolygon($lock_india_vertices, $loc['lat'], $loc['lng']))
			{
				return true;
			}	
		}
		return false;
	}
?>