// console.log("called.. ");
// #################################################
// VALIDATION FUNCTIONS
// #################################################
var utilsRulerData = new Array();
(utilsRulerData.enabled = !1),
    utilsRulerData.line_layer,
    utilsRulerData.label_layer;
var utilsAreaData = new Array();
(utilsAreaData.enabled = !1), utilsAreaData.area_layer;
var utilsRouteBetweenPointsData = new Array();
utilsRouteBetweenPointsData.route_points = !1;
var utilsFollowObjectData = new Array(),
    utilsStreetViewData = new Array();
function isMobileVersion() {
    if (document.URL.indexOf("mobile") != -1) {
        return true;
    } else {
        return false;
    }
}

function isObjectFollow() {
    // console.log('test')
    if (document.URL.indexOf("func/fn_object.follow.php") != -1) {
        return true;
    } else {
        return false;
    }
}

function isSharePosition() {
    // console.log('test')

    if (document.URL.indexOf("mod/share/index.php") != -1) {
        return true;
    } else {
        return false;
    }
}

function isNumber(num) {
    // console.log('test')

    return Number(parseFloat(num)) == num;
}

function isEven(num) {
    // console.log('test')

    return num % 2 == 0;
}

function isIntValid(value) {
    // console.log('test')

    var er = /^[0-9-]{1,100}$/;

    return er.test(value) ? true : false;
}

function isHexValid(hex) {
    // console.log('test')

    if (hex.match(/^[0-9A-F]{1,1024}$/) && isEven(hex.length)) {
        return true;
    } else {
        return false;
    }
}

function isEmailValid(email) {
    // console.log('test')

    var RegExp = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,15}$/;

    if (email.match(RegExp)) {
        return true;
    }
    return false;
}

function isIMEIValid(imei) {
    // console.log('test')

    var RegExp = /^[a-zA-Z0-9]{1,15}$/;

    if (imei.match(RegExp)) {
        return true;
    }

    return false;
}

function isNumberKey(evt) {
    // console.log('test')

    var charCode = evt.which ? evt.which : event.keyCode;
    if (
        charCode > 31 &&
        (charCode < 48 || charCode > 57) &&
        charCode != 45 &&
        charCode != 46
    ) {
        return false;
    }

    return true;
}

function isPointInPolygon(poly, pt) {
    // console.log('test')

    for (var c = false, i = -1, l = poly.length, j = l - 1; ++i < l; j = i)
        ((poly[i].y <= pt.y && pt.y < poly[j].y) ||
            (poly[j].y <= pt.y && pt.y < poly[i].y)) &&
            pt.x <
            ((poly[j].x - poly[i].x) * (pt.y - poly[i].y)) /
            (poly[j].y - poly[i].y) +
            poly[i].x &&
            (c = !c);
    return c;
}

function strMatches(str, search) {
    // console.log('test')

    if (str && str.indexOf(search) != -1) {
        str = str.toLowerCase();
        search = search.toLowerCase();
        return true;
    } else {
        return false;
    }
}

function strUcFirst(str) {
    // console.log('test')

    return str.charAt(0).toUpperCase() + str.slice(1);
}

// #################################################
// END VALIDATION FUNCTIONS
// #################################################

// #################################################
// CONVERSION/MATH FUNCTIONS
// #################################################

function calcString(str) {
    // console.log('test')

    var result = 0;
    try {
        str = str.trim();
        str = str.replace(/[^-()\d/*+.]/g, "");
        return result + eval(str);
    } catch (err) {
        return result;
    }
}

function convSpeedUnits(val, from, to) {
    // console.log('test')

    return Math.floor(convDistanceUnits(val, from, to));
}

function convDistanceUnits(val, from, to) {
    // console.log('test')

    if (from == "km") {
        if (to == "mi") {
            val = val * 0.621371;
        } else if (to == "nm") {
            val = val * 0.539957;
        }
    } else if (from == "mi") {
        if (to == "km") {
            val = val * 1.60934;
        } else if (to == "nm") {
            val = val * 0.868976;
        }
    } else if (from == "nm") {
        if (to == "km") {
            val = val * 1.852;
        } else if (to == "nm") {
            val = val * 1.15078;
        }
    }

    return val;
}

function textToLinks(text) {
    // console.log('test')

    var exp =
        /(\b(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/gi;
    return text.replace(exp, "<a href='$1' target='_blank'>$1</a>");
}

function hexToAscii(hex) {
    var str = "";
    if (isHexValid(hex)) {
        for (i = 0; i < hex.length; i += 2) {
            str += String.fromCharCode(parseInt(hex.substr(i, 2), 16));
        }
    }
    return str;
}

function strToBoolean(str) {
    if (str == "true") {
        return true;
    } else {
        return false;
    }
}

function booleanToStr(bool) {
    if (bool == true) {
        return "true";
    } else {
        return "false";
    }
}

function uniqueArray(a) {
    a.sort();
    for (var i = 1; i < a.length;) {
        if (a[i - 1] == a[i]) {
            a.splice(i, 1);
        } else {
            i++;
        }
    }
    return a;
}

function toRad(Value) {
    return (Value * Math.PI) / 180;
}

function toDeg(Value) {
    return (Value * 180) / Math.PI;
}

function getAngle(lat1, lon1, lat2, lon2) {
    var dLat = toRad(lat2 - lat1);
    var dLon = toRad(lon2 - lon1);

    lat1 = toRad(lat1);
    lat2 = toRad(lat2);

    var y = Math.sin(dLon) * Math.cos(lat2);
    var x =
        Math.cos(lat1) * Math.sin(lat2) -
        Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
    var angle = toDeg(Math.atan2(y, x));

    if (angle < 0) {
        angle = 360 + angle;
    }

    return Math.abs(angle).toFixed(0);
}

function getAreaFromLatLngs(latlngs) {
    // // console.log('here')
    var pointsCount = latlngs.length,
        area = 0.0,
        d2r = 0.017453292519943295,
        p1,
        p2;

    if (pointsCount > 2) {
        for (var i = 0; i < pointsCount; i++) {
            p1 = latlngs[i];
            p2 = latlngs[(i + 1) % pointsCount];
            area +=
                (p2.lng - p1.lng) *
                d2r *
                (2 + Math.sin(p1.lat * d2r) + Math.sin(p2.lat * d2r));
        }

        area = (area * 6378137.0 * 6378137.0) / 2.0;
    }

    return Math.abs(area); // sq meters
}

function getLengthFromLatLngs(latlngs) {
    var dist = 0;

    for (var i = 0; i < latlngs.length - 1; i++) {
        var latlng1 = latlngs[i];
        var latlng2 = latlngs[i + 1];

        dist += getLengthBetweenCoordinates(
            latlng1.lat,
            latlng1.lng,
            latlng2.lat,
            latlng2.lng
        );
    }

    return dist;
}

function getLengthBetweenCoordinates(lat1, lng1, lat2, lng2) {
    var R = 6371; // Radius of the earth in km
    var dLat = toRad(lat2 - lat1); // deg2rad below
    var dLon = toRad(lng2 - lng1);
    var a =
        Math.sin(dLat / 2) * Math.sin(dLat / 2) +
        Math.cos(toRad(lat1)) *
        Math.cos(toRad(lat2)) *
        Math.sin(dLon / 2) *
        Math.sin(dLon / 2);
    var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    var d = R * c; // Distance in km

    return d;
}

function getTimeDetails(sec, show_days) {
    var seconds = 0;
    var hours = 0;
    var minutes = 0;

    if (sec % 86400 <= 0) {
        days = sec / 86400;
    }
    if (sec % 86400 > 0) {
        var rest = sec % 86400;
        var days = (sec - rest) / 86400;

        if (rest % 3600 > 0) {
            var rest1 = rest % 3600;
            var hours = (rest - rest1) / 3600;

            if (rest1 % 60 > 0) {
                var rest2 = rest1 % 60;
                minutes = (rest1 - rest2) / 60;
                seconds = rest2;
            } else {
                minutes = rest1 / 60;
            }
        } else {
            hours = rest / 3600;
        }
    }

    days = parseFloat(days);
    hours = parseFloat(hours);
    minutes = parseFloat(minutes);
    seconds = parseFloat(seconds);

    if (show_days == false) {
        hours += days * 24;
        days = 0;
    }

    if (days > 0) {
        days = days + " " + la["UNIT_D"] + " ";
    } else {
        days = "";
    }
    if (hours > 0) {
        hours = hours + " " + la["UNIT_H"] + " ";
    } else {
        hours = "";
    }
    if (minutes > 0) {
        minutes = minutes + " " + la["UNIT_MIN"] + " ";
    } else {
        minutes = "";
    }
    seconds = seconds + " " + la["UNIT_S"];

    return days + hours + minutes + seconds;
}

function getTimestampFromDate(date) {
    date = Date.parse(date);
    return date;
}

function getDatetimeFromTimestamp(ts) {
    var dt = new Date(ts);

    var year = dt.getUTCFullYear();

    var month = dt.getUTCMonth();
    month = month + 1; // because js months start from 0
    if (month.toString().length == 1) month = "0" + month;

    var date = dt.getUTCDate();
    if (date.toString().length == 1) date = "0" + date;

    var h = dt.getUTCHours();
    if (h.toString().length == 1) h = "0" + h;

    var min = dt.getUTCMinutes();
    if (min.toString().length == 1) min = "0" + min;

    var s = dt.getUTCSeconds();
    if (s.toString().length == 1) s = "0" + s;

    return year + "-" + month + "-" + date + " " + h + ":" + min + ":" + s;
}

function getTimeDifference(laterdate, earlierdate) {
    laterdate = new Date(laterdate.replace(" ", "T"));
    earlierdate = new Date(earlierdate.replace(" ", "T"));

    var difference = laterdate.getTime() - earlierdate.getTime();

    var daysDifference = Math.floor(difference / 1000 / 60 / 60 / 24);
    difference -= daysDifference * 1000 * 60 * 60 * 24;

    var hoursDifference = Math.floor(difference / 1000 / 60 / 60);
    difference -= hoursDifference * 1000 * 60 * 60;

    var minutesDifference = Math.floor(difference / 1000 / 60);
    difference -= minutesDifference * 1000 * 60;

    var secondsDifference = Math.floor(difference / 1000);

    var d, h, m, s;
    if (daysDifference > 0) {
        d = daysDifference + " " + la["UNIT_D"] + " ";
    } else {
        d = "";
    }
    if (hoursDifference > 0) {
        h = hoursDifference + " " + la["UNIT_H"] + " ";
    } else {
        h = "";
    }
    if (minutesDifference > 0) {
        m = minutesDifference + " " + la["UNIT_MIN"] + " ";
    } else {
        m = "";
    }
    if (secondsDifference > 0) {
        s = secondsDifference + " " + la["UNIT_S"] + "";
    } else {
        s = "";
    }

    return d + h + m + s;
}

function getDateDifference(date1, date2) {
    // The number of milliseconds in one day
    var ONE_DAY = 1000 * 60 * 60 * 24;

    // Convert both dates to milliseconds
    var date1_ms = date1.getTime();
    var date2_ms = date2.getTime();

    // Calculate the difference in milliseconds
    var difference_ms = Math.abs(date1_ms - date2_ms);

    // Convert back to days and return
    return Math.round(difference_ms / ONE_DAY);
}

function sortSelectList(select) {
    var tmpAry = new Array();
    for (var i = 0; i < select.options.length; i++) {
        tmpAry[i] = new Array();
        tmpAry[i] = {
            value: select.options[i].value,
            text: select.options[i].text,
        };
    }

    tmpAry = sortArrayByElement(tmpAry, "text");

    while (select.options.length > 0) {
        select.options[0] = null;
    }

    for (var i = 0; i < tmpAry.length; i++) {
        var op = new Option(tmpAry[i].text, tmpAry[i].value);
        select.options[i] = op;
    }
    return;
}

function sortNumber(a, b) {
    return a - b;
}

function sortString(a, b) {
    var x = a.toLowerCase();
    var y = b.toLowerCase();
    return x < y ? -1 : x > y ? 1 : 0;
}

function sortArrayByElement(arr, el) {
    arr = arr.slice(0);

    arr.sort(function (a, b) {
        var x = a[el].toLowerCase();
        var y = b[el].toLowerCase();
        return x < y ? -1 : x > y ? 1 : 0;
    });

    return arr;
}

function arrayMove(arr, fromIndex, toIndex) {
    var element = arr[fromIndex];
    arr.splice(fromIndex, 1);
    arr.splice(toIndex, 0, element);

    return;
}

function strLink(str) {
    //URLs starting with http://, https://, or ftp://
    var replacePattern1 =
        /(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/gim;
    var replacedText = str.replace(
        replacePattern1,
        '<a href="$1" target="_blank">$1</a>'
    );

    //URLs starting with www. (without // before it, or it'd re-link the ones done above)
    var replacePattern2 = /(^|[^\/])(www\.[\S]+(\b|$))/gim;
    var replacedText = replacedText.replace(
        replacePattern2,
        '$1<a href="http://$2" target="_blank">$2</a>'
    );

    //Change email addresses to mailto:: links
    var replacePattern3 = /(\w+@[a-zA-Z_]+?\.[a-zA-Z]{2,6})/gim;
    var replacedText = replacedText.replace(
        replacePattern3,
        '<a href="mailto:$1">$1</a>'
    );

    return replacedText;
}

function stripHTML(str) {
    str = str.replace(
        /(<\?[a-z]*(\s[^>]*)?\?(>|$)|<!\[[a-z]*\[|\]\]>|<!DOCTYPE[^>]*?(>|$)|<!--[\s\S]*?(-->|$)|<[a-z?!\/]([a-z0-9_:.])*(\s[^>]*)?(>|$))/gi,
        ""
    );
    return str;
}
function transformToHistoryRoute(data) {
    var temp_angle = 0;

    var sroute = data.route;
    var route = [];
    for (var i = 0; i < sroute.length; i++) {
        // calculate angle
        if (i > 0) {
            var lat1 = sroute[i - 1][1];
            var lon1 = sroute[i - 1][2];
            var lat2 = sroute[i][1];
            var lon2 = sroute[i][2];
            sroute[i][4] = getAngle(lat1, lon1, lat2, lon2);

            if (lat1 == lat2 && lon1 == lon2) {
                sroute[i][4] = temp_angle;
            }
        }

        // fix 0 angle during speed 0
        if (sroute[i][4] > 0) {
            var temp_angle = sroute[i][4];
        }

        if (sroute[i][5] == 0) {
            sroute[i][4] = temp_angle;
        }

        route.push({
            dt_tracker: sroute[i][0],
            lat: sroute[i][1],
            lng: sroute[i][2],
            altitude: sroute[i][3],
            angle: sroute[i][4],
            speed: sroute[i][5],
            params: sroute[i][6],
        });
    }

    var sstops = data.stops;
    var stops = [];
    if (sstops != undefined) {
        for (var i = 0; i < sstops.length; i++) {
            stops.push({
                id_start: sstops[i][0],
                id_end: sstops[i][1],
                lat: sstops[i][2],
                lng: sstops[i][3],
                altitude: sstops[i][4],
                angle: sstops[i][5],
                speed: 0,
                dt_start: sstops[i][6],
                dt_end: sstops[i][7],
                duration: sstops[i][8],
                fuel_consumption: sstops[i][9],
                fuel_cost: sstops[i][10],
                engine_idle: sstops[i][11],
                params: sstops[i][12],
            });
        }
    }

    var sdrives = data.drives;
    var drives = [];
    if (sdrives != undefined) {
        for (var i = 0; i < sdrives.length; i++) {
            drives.push({
                id_start_s: sdrives[i][0],
                id_start: sdrives[i][1],
                id_end: sdrives[i][2],
                dt_start_s: sdrives[i][3],
                dt_start: sdrives[i][4],
                dt_end: sdrives[i][5],
                duration: sdrives[i][6],
                route_length: sdrives[i][7],
                top_speed: sdrives[i][8],
                avg_speed: sdrives[i][9],
                fuel_consumption: sdrives[i][10],
                fuel_cost: sdrives[i][11],
                engine_work: sdrives[i][12],
                fuel_consumption_per_100km: sdrives[i][13],
                fuel_consumption_mpg: sdrives[i][14],
            });
        }
    }

    var sevents = data.events;
    // // console.log(sevents)
    var events = [];
    if (sevents != undefined) {
        for (var i = 0; i < sevents.length; i++) {
            events.push({
                event_desc: sevents[i][0],
                dt_tracker: sevents[i][1],
                lat: sevents[i][2],
                lng: sevents[i][3],
                altitude: sevents[i][4],
                angle: sevents[i][5],
                speed: sevents[i][6],
                params: sevents[i][7],
            });
        }
    }

    data["route"] = route;
    data["stops"] = stops;
    data["drives"] = drives;
    data["events"] = events;

    return data;
}


function switchDateFilter(e) {
    if ("history" == e) var t = "side_panel_history_";
    else if ("report" == e) t = "dialog_report_";
    else if ("tasks" == e) t = "dialog_tasks_";
    else if ("rilogbook" == e) t = "dialog_rilogbook_";
    else if ("dtc" == e) t = "dialog_dtc_";
    else if ("img" == e) t = "dialog_image_gallery_";
    switch (
    ((document.getElementById(t + "hour_from").value = "00"),
        (document.getElementById(t + "hour_to").value = "00"),
        (document.getElementById(t + "minute_from").value = "00"),
        (document.getElementById(t + "minute_to").value = "00"),
        document.getElementById(t + "filter").value)
    ) {
        case "0":
            (document.getElementById(t + "date_from").value =
                moment().format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value =
                    moment().format("YYYY-MM-DD"));
            break;
        case "1":
            (document.getElementById(t + "date_from").value =
                moment().format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById(t + "hour_from").value = moment()
                    .subtract("hour", 1)
                    .format("HH")),
                (document.getElementById(t + "hour_to").value = moment().format("HH")),
                (document.getElementById(t + "minute_from").value = moment()
                    .subtract("hour", 1)
                    .format("mm")),
                (document.getElementById(t + "minute_to").value =
                    moment().format("mm"));
            break;
        case "2":
            (document.getElementById(t + "date_from").value =
                moment().format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .add("days", 1)
                    .format("YYYY-MM-DD"));
            break;
        case "3":
            (document.getElementById(t + "date_from").value = moment()
                .subtract("days", 1)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value =
                    moment().format("YYYY-MM-DD"));
            break;
        case "4":
            (document.getElementById(t + "date_from").value = moment()
                .subtract("days", 2)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .subtract("days", 1)
                    .format("YYYY-MM-DD"));
            break;
        case "5":
            (document.getElementById(t + "date_from").value = moment()
                .subtract("days", 3)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .subtract("days", 2)
                    .format("YYYY-MM-DD"));
            break;
        case "6":
            (document.getElementById(t + "date_from").value = moment()
                .isoWeekday(1)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .add("days", 1)
                    .format("YYYY-MM-DD"));
            break;
        case "7":
            (document.getElementById(t + "date_from").value = moment()
                .isoWeekday(1)
                .subtract("week", 1)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .isoWeekday(1)
                    .format("YYYY-MM-DD"));
            break;
        case "8":
            (document.getElementById(t + "date_from").value = moment()
                .startOf("month")
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .add("days", 1)
                    .format("YYYY-MM-DD"));
            break;
        case "9":
            (document.getElementById(t + "date_from").value = moment()
                .startOf("month")
                .subtract("month", 1)
                .format("YYYY-MM-DD")),
                (document.getElementById(t + "date_to").value = moment()
                    .startOf("month")
                    .format("YYYY-MM-DD"));
    }
    $("#" + t + "hour_from").multipleSelect("refresh"),
        $("#" + t + "hour_to").multipleSelect("refresh"),
        $("#" + t + "minute_from").multipleSelect("refresh"),
        $("#" + t + "minute_to").multipleSelect("refresh");
}
// #################################################
// END CONVERSION/MATH FUNCTIONS
// #################################################

// #################################################
// MULTISELECT FUNCTIONS
// #################################################

function multiselectClear(select) {
    var optgroups = select.getElementsByTagName("optgroup");
    for (var i = optgroups.length - 1; i >= 0; i--) {
        select.removeChild(optgroups[i]);
    }

    select.options.length = 0;
}

function multiselectSetGroups(select, groups_arr) {
    for (var key in groups_arr) {
        var group = groups_arr[key];

        if (group.items.length > 0) {
            var optgroup = $('<optgroup label="' + group.name + '" />');

            for (var key in group.items) {
                var item = group.items[key];
                $('<option value="' + item.value + '"/>')
                    .html(item.name)
                    .appendTo(optgroup);
            }

            optgroup.appendTo(select);
        }
    }
}
function multiselectIsSelected(select) {
    var valid = false;
    for (var i = 0; i < select.options.length; i++) {
        if (select.options[i].selected) {
            valid = true;
            break;
        }
    }

    return valid;
}

function multiselectGetValues(select) {
    var selected = "";
    for (var i = 0; i < select.options.length; i++) {
        if (select.options[i].selected) {
            selected += select.options[i].value + ",";
        }
    }

    return selected.slice(0, -1);
}

function multiselectSetValues(select, values) {
    for (var i = 0; i < select.options.length; i++) {
        if ($.inArray(select.options[i].value, values) > -1) {
            select.options[i].selected = true;
        } else {
            select.options[i].selected = false;
        }
    }
}

// #################################################
// END MULTISELECT FUNCTIONS
// #################################################

// #################################################
// VARIOUS GUI FUNCTIONS
// #################################################

function scrollToBottom(id) {
    var obj = document.getElementById(id);
    obj.scrollTop = obj.scrollHeight;
}

function getAllProtocolsArray() {
    var arr_protocols = new Array();

    for (var imei in settingsObjectData) {
        var protocol = settingsObjectData[imei]["protocol"];
        arr_protocols.push(protocol);
    }

    return uniqueArray(arr_protocols);
}

function getEngineIcon(status) {
    var path = "";

    if (isMobileVersion()) {
        path = "../";
    }

    switch (status) {
        case 0:
            return (
                '<img src="' +
                path +
                'theme/images/engine-off.svg" style="width: 16px;" title="' +
                la["ENGINE_OFF"] +
                '"/>'
            );
            break;
        case 1:
            return (
                '<img src="' +
                path +
                'theme/images/engine-on.svg" style="width: 16px;" title="' +
                la["ENGINE_ON"] +
                '"/>'
            );
            break;
    }
}

function getConnectionIcon(status) {
    var path = "";

    if (isMobileVersion()) {
        path = "../";
    }

    switch (status) {
        case 0:
            return (
                '<img src="' +
                path +
                'theme/images/connection-no.svg" style="width: 16px;" title="' +
                la["CONNECTION_NO_GPS_NO"] +
                '"/>'
            );
            break;
        case 1:
            return (
                '<img src="' +
                path +
                'theme/images/connection-gsm.svg" style="width: 16px;" title="' +
                la["CONNECTION_YES_GPS_NO"] +
                '"/>'
            );
            break;
        case 2:
            return (
                '<img src="' +
                path +
                'theme/images/connection-gsm-gps.svg" style="width: 16px;" title="' +
                la["CONNECTION_YES_GPS_YES"] +
                '"/>'
            );
            break;
    }
}

function getObjectListColor(status, ohc_color) {
    var color = "";

    if (status == "off") {
        if (settingsUserData["ohc"]["no_connection"] == true) {
            color = settingsUserData["ohc"]["no_connection_color"];
        }
    } else if (status == "s") {
        if (settingsUserData["ohc"]["stopped"] == true) {
            color = settingsUserData["ohc"]["stopped_color"];
        }
    } else if (status == "m") {
        if (settingsUserData["ohc"]["moving"] == true) {
            color = settingsUserData["ohc"]["moving_color"];
        }
    } else if (status == "i") {
        if (settingsUserData["ohc"]["engine_idle"] == true) {
            color = settingsUserData["ohc"]["engine_idle_color"];
        }
    }

    if (ohc_color != false) {
        color = ohc_color;
    }

    return color;
}

function getMarkerIcon(imei, speed, status, arrow_color) {
    if (settingsObjectData[imei]["map_icon"] == "arrow") {
        var arrow = settingsObjectData[imei]["map_arrows"]["arrow_stopped"];

        if (status == false) {
            speed = convSpeedUnits(speed, "km", settingsUserData["unit_distance"]);

            var min_idle_speed =
                settingsObjectData[imei]["accuracy"]["min_idle_speed"];

            min_idle_speed = convSpeedUnits(
                min_idle_speed,
                "km",
                settingsUserData["unit_distance"]
            );

            if (speed > min_idle_speed) {
                arrow = settingsObjectData[imei]["map_arrows"]["arrow_moving"];
            }
        } else {
            if (status == "off") {
                arrow = settingsObjectData[imei]["map_arrows"]["arrow_no_connection"];
            } else if (status == "m") {
                arrow = settingsObjectData[imei]["map_arrows"]["arrow_moving"];
            } else if (status == "i") {
                if (
                    settingsObjectData[imei]["map_arrows"]["arrow_engine_idle"] != "off"
                ) {
                    arrow = settingsObjectData[imei]["map_arrows"]["arrow_engine_idle"];
                }
            }

            if (arrow_color != false) {
                arrow = arrow_color;
            }
        }

        return mapMarkerIcons[arrow];
    } else {
        var icon = settingsObjectData[imei]["icon"];
        return mapMarkerIcons[icon];
    }
}

function urlPosition(lat, lng) {
    var position =
        '<a href="https://maps.google.com/maps?q=' +
        lat +
        "," +
        lng +
        '&t=m" target="_blank">' +
        parseFloat(lat).toFixed(6) +
        " &deg;, " +
        parseFloat(lng).toFixed(6) +
        " &deg;</a>";

    return position;
}

function fileExist(url) {
    var xhr = new XMLHttpRequest();
    xhr.open("HEAD", url, false);
    xhr.send();

    if (xhr.status == "301" || xhr.status == "404") {
        return false;
    } else {
        return true;
    }
}

function imageExists(url, response) {
    var image = new Image();

    image.onload = function () {
        response(true);
    };
    image.onerror = function () {
        response(false);
    };

    image.src = url;
}

function loadLanguage(response) {
    var path = "func/fn_lng.php";

    if (isMobileVersion() || isObjectFollow()) {
        var path = "../" + path;
    } else if (isSharePosition()) {
        var path = "../../" + path;
    }

    var data = {
        cmd: "load_language",
    };

    $.ajax({
        type: "POST",
        url: path,
        data: data,
        dataType: "json",
        cache: false,
        success: function (result) {
            la = result;
            console.log('la - '+la)
            if ($.jgrid != undefined) {
                $.jgrid.nav.addtitle = la["ADD"];
                $.jgrid.nav.refreshtitle = la["RELOAD"];
                $.jgrid.defaults.recordtext = la["GRID_VIEW_TEXT"];
                $.jgrid.defaults.emptyrecords = la["NO_RECORDS_TO_VIEW"];
                $.jgrid.defaults.loadtext = la["LOADING"];
                $.jgrid.defaults.pgtext = la["GRID_PAGE_TEXT"];
            }

            response(true);
        },
    });
}

function switchLanguageCPanel() {
    var language = document.getElementById("system_language").value;

    var data = {
        cmd: "save_user_language",
        language: language,
    };

    $.ajax({
        type: "POST",
        url: "func/fn_settings.php",
        data: data,
        cache: false,
        success: function (result) {
            if (result == "OK") {
                window.open("cpanel.php", "_self", false);
            }
        },
    });
}

function switchLanguageTracking() {
    var language = document.getElementById("system_language").value;

    var data = {
        cmd: "save_user_language",
        language: language,
    };

    $.ajax({
        type: "POST",
        url: "func/fn_settings.php",
        data: data,
        cache: false,
        success: function (result) {
            if (result == "OK") {
                window.open("tracking.php", "_self", false);
            }
        },
    });
}

function switchLanguageLogin() {
    var language = document.getElementById("system_language").value;
    window.open("index.php?lng=" + language, "_self", false);
}

function getNearestMarker(imei, lat, lng) {
    var name = "";
    var distance = 0;

    for (var marker_id in placesMarkerData["markers"]) {
        var marker = placesMarkerData["markers"][marker_id];

        var marker_lat = marker.data.lat;
        var marker_lng = marker.data.lng;

        var temp = getLengthBetweenCoordinates(lat, lng, marker_lat, marker_lng);

        if (distance > temp || distance == 0) {
            distance = temp;
            name = marker.data.name;
        }
    }

    distance = convDistanceUnits(
        distance,
        "km",
        settingsUserData["unit_distance"]
    );

    distance = distance.toFixed(2);

    distance += " " + la["UNIT_DISTANCE"];

    var result = [];
    result["name"] = name;
    result["distance"] = distance;

    return result;
}

function getNearestZone(imei, lat, lng) {
    var in_zone_vertices = [];
    var name = "";
    var distance = 0;

    for (var zone_id in placesZoneData["zones"]) {
        var zone = placesZoneData["zones"][zone_id];

        var zone_vertices = zone.data.vertices.split(",");

        for (j = 0; j < zone_vertices.length; j += 2) {
            var zone_lat = zone_vertices[j];
            var zone_lng = zone_vertices[j + 1];

            var temp = getLengthBetweenCoordinates(lat, lng, zone_lat, zone_lng);

            if (distance > temp || distance == 0) {
                distance = temp;
                name = zone.data.name;
                in_zone_vertices = zone_vertices;
            }
        }
    }

    // prepare polygon array to check if it is in zone
    var polygon = [];
    for (j = 0; j < in_zone_vertices.length; j += 2) {
        var zone_lat = parseFloat(in_zone_vertices[j]);
        var zone_lng = parseFloat(in_zone_vertices[j + 1]);
        polygon.push({ x: zone_lat, y: zone_lng });
    }

    // if in zone, reset distance
    if (isPointInPolygon(polygon, { x: lat, y: lng }) == true) {
        distance = 0;
    }

    distance = convDistanceUnits(
        distance,
        "km",
        settingsUserData["unit_distance"]
    );

    distance = distance.toFixed(2);

    distance += " " + la["UNIT_DISTANCE"];

    var result = [];
    result["name"] = name;
    result["distance"] = distance;

    return result;
}

function switchLanguageTracking() {
    var language = document.getElementById("system_language").value;

    var data = {
        cmd: "save_user_language",
        language: language,
    };

    $.ajax({
        type: "POST",
        url: "func/fn_settings.php",
        data: data,
        cache: false,
        success: function (result) {
            if (result == "OK") {
                window.open("tracking.php", "_self", false);
            }
        },
    });
}

function switchLanguageLogin() {
    var language = document.getElementById("system_language").value;
    window.open("index.php?lng=" + language, "_self", false);
}

function getNearestMarker(imei, lat, lng) {
    var name = "";
    var distance = 0;

    for (var marker_id in placesMarkerData["markers"]) {
        var marker = placesMarkerData["markers"][marker_id];

        var marker_lat = marker.data.lat;
        var marker_lng = marker.data.lng;

        var temp = getLengthBetweenCoordinates(lat, lng, marker_lat, marker_lng);

        if (distance > temp || distance == 0) {
            distance = temp;
            name = marker.data.name;
        }
    }

    distance = convDistanceUnits(
        distance,
        "km",
        settingsUserData["unit_distance"]
    );

    distance = distance.toFixed(2);

    distance += " " + la["UNIT_DISTANCE"];

    var result = [];
    result["name"] = name;
    result["distance"] = distance;

    return result;
}
function getNearestZone(imei, lat, lng) {
    var in_zone_vertices = [];
    var name = "";
    var distance = 0;

    for (var zone_id in placesZoneData["zones"]) {
        var zone = placesZoneData["zones"][zone_id];

        var zone_vertices = zone.data.vertices.split(",");

        for (j = 0; j < zone_vertices.length; j += 2) {
            var zone_lat = zone_vertices[j];
            var zone_lng = zone_vertices[j + 1];

            var temp = getLengthBetweenCoordinates(lat, lng, zone_lat, zone_lng);

            if (distance > temp || distance == 0) {
                distance = temp;
                name = zone.data.name;
                in_zone_vertices = zone_vertices;
            }
        }
    }

    // prepare polygon array to check if it is in zone
    var polygon = [];
    for (j = 0; j < in_zone_vertices.length; j += 2) {
        var zone_lat = parseFloat(in_zone_vertices[j]);
        var zone_lng = parseFloat(in_zone_vertices[j + 1]);
        polygon.push({ x: zone_lat, y: zone_lng });
    }

    // if in zone, reset distance
    if (isPointInPolygon(polygon, { x: lat, y: lng }) == true) {
        distance = 0;
    }

    distance = convDistanceUnits(
        distance,
        "km",
        settingsUserData["unit_distance"]
    );

    distance = distance.toFixed(2);

    distance += " " + la["UNIT_DISTANCE"];

    var result = [];
    result["name"] = name;
    result["distance"] = distance;

    return result;
}
function imgOpen() {
    utilsCheckPrivileges("image_gallery") &&
        ($("#dialog_image_gallery").dialog("open"), imgLoadData());
}
function imgLoadData() {
    clearTimeout(timer_imgLoadData),
        (timer_imgLoadData = setTimeout(
            "imgLoadData();",
            1e3 * gsValues.img_refresh
        )),
        1 == $("#dialog_image_gallery").dialog("isOpen")
            ? $("#image_gallery_list_grid").trigger("reloadGrid")
            : clearTimeout(timer_imgLoadData);
}
function imgFilter() {
    var e = "func/fn_img.php?cmd=load_img_list",
        t = document.getElementById("dialog_image_gallery_object_list").value,
        a =
            document.getElementById("dialog_image_gallery_date_from").value +
            " " +
            document.getElementById("dialog_image_gallery_hour_from").value +
            ":" +
            document.getElementById("dialog_image_gallery_minute_from").value +
            ":00",
        i =
            document.getElementById("dialog_image_gallery_date_to").value +
            " " +
            document.getElementById("dialog_image_gallery_hour_to").value +
            ":" +
            document.getElementById("dialog_image_gallery_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        a != i && (e += "&dtf=" + a + "&dtt=" + i),
        $("#image_gallery_list_grid")
            .jqGrid("setGridParam", {
                url: e,
            })
            .trigger("reloadGrid");
}
function imgDelete(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_img",
                    img_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_img.php",
                    data: a,
                    success: function (e) {
                        "OK" == e &&
                            ((document.getElementById("image_gallery_img").innerHTML = ""),
                                (document.getElementById("image_gallery_img_data").innerHTML =
                                    ""),
                                $("#image_gallery_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}
function imgDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#image_gallery_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_imgs",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_img.php",
                            data: a,
                            success: function (e) {
                                "OK" == e &&
                                    ((document.getElementById("image_gallery_img").innerHTML =
                                        ""),
                                        (document.getElementById(
                                            "image_gallery_img_data"
                                        ).innerHTML = ""),
                                        $("#image_gallery_list_grid").trigger("reloadGrid"));
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function imgDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_IMAGES, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_img.php",
                    data: {
                        cmd: "delete_all_imgs",
                    },
                    success: function (e) {
                        "OK" == e &&
                            ((document.getElementById("image_gallery_img").innerHTML = ""),
                                (document.getElementById("image_gallery_img_data").innerHTML =
                                    ""),
                                $("#image_gallery_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}

// function objectLoadData() {
//     clearTimeout(timer_objectLoadData);
//     $.ajax({
//         type: "POST",
//         url: "func/fn_objects.php",
//         data: {
//             cmd: "load_object_data"
//         },
//         dataType: "json",
//         cache: !1,
//         error: function (e, t) {
//             // console.log('error', e, t)
//             timer_objectLoadData = setTimeout("objectLoadData();", 1e3 * gsValues.map_refresh)
//         },
//         success: function (e) {
//             // console.log(e)
//             for (var t in e)
//                 e[t] = transformToObjectData(e[t]);
//             if (Object.keys(objectsData).length != Object.keys(e).length)
//                 objectsData = e;
//             else
//                 for (var t in e) {
//                     if (objectsData[t].connection = e[t].connection,
//                         objectsData[t].status = e[t].status,
//                         objectsData[t].status_string = e[t].status_string,
//                         objectsData[t].odometer = e[t].odometer,
//                         objectsData[t].engine_hours = e[t].engine_hours,
//                         objectsData[t].service = e[t].service,
//                         objectsData[t].last_img_file = e[t].last_img_file,
//                         "" == objectsData[t].data)
//                         objectsData[t].data = e[t].data;
//                     else {
//                         if (objectsData[t].data.length >= settingsObjectData[t].tail_points && objectsData[t].data.pop(),
//                             objectsData[t].data.unshift(e[t].data[0]),
//                             1 == objectsData[t].selected && 1 == gsValues.map_street_view)
//                             utilsStreetView(objectsData[t].data[0].lat, objectsData[t].data[0].lng, objectsData[t].data[0].angle);
//                         1 == objectsData[t].selected && 1 == gsValues.map_camera && utilsCamera(t)
//                     }
//                     settingsObjectData[t].protocol = e[t].protocol,
//                         settingsObjectData[t].odometer = e[t].odometer,
//                         settingsObjectData[t].engine_hours = Math.floor(e[t].engine_hours / 60 / 60)
//                 }
//             objectUpdateList(),
//                 objectAddAllToMap(),

//                 "fit" == settingsUserData.map_sp && 0 == gsValues.map_fit_objects_finished && (fitObjectsOnMap(),
//                     gsValues.map_fit_objects_finished = !0),
//                 objectFollow(),
//                 1 == $("#dialog_dashboard").dialog("isOpen") && dashboardInitObjects(),
//                 timer_objectLoadData = setTimeout("objectLoadData();", 1e3 * gsValues.map_refresh)
//         }
//     })
// }

var guiDragbarObjectsHandler = function (e) {
    $("#map").css("pointer-events", "none"), resizeGridObjects(e.pageY);
},
    guiDragbarEventsHandler = function (e) {
        $("#map").css("pointer-events", "none"), resizeGridEvents(e.pageY);
    },
    guiDragbarHistoryHandler = function (e) {
        $("#map").css("pointer-events", "none"), resizeGridHistory(e.pageY);
    },
    guiDragbarBottomPanelHandler = function (e) {
        "block" == document.getElementById("bottom_panel").style.display &&
            ($("#map").css("pointer-events", "none"), resizeBottomPanel(e.pageY));
    };
function addPopupToMap(e, t, a, i, o) {
    // // console.log(e, t, a, i, o)
    if ("" != o && i != o) {
        if (1 == gsValues.map_popup_detailed)
            var s = 'style="display:none;"',
                n = "";
        else (s = ""), (n = 'style="display:none;"');
        (i = '<div id="popup_short" ' + s + ">" + i),
            (i +=
                '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="switchPopupDetailed(true);">' +
                la.DETAILED +
                "</a></div>"),
            (i += "</div>"),
            (i += '<div id="popup_detailed" ' + n + ">" + o),
            (i +=
                '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="switchPopupDetailed(false);">' +
                la.SHORT +
                "</a></div>"),
            (i += "</div>");
    }
    mapPopup = L.popup({
        offset: a,
    })
        .setLatLng([e, t])
        .setContent(i)
        .openOn(map);
}
function switchPopupDetailed(e) {
    switch (e) {
        case !1:
            (document.getElementById("popup_short").style.display = ""),
                (document.getElementById("popup_detailed").style.display = "none"),
                (gsValues.map_popup_detailed = !1);
            break;
        case !0:
            (document.getElementById("popup_short").style.display = "none"),
                (document.getElementById("popup_detailed").style.display = ""),
                (gsValues.map_popup_detailed = !0);
    }
}
function destroyMapPopup() {
    map.closePopup();
}
function loadingData(e) {
    document.getElementById("loading_data_panel").style.display =
        1 == e ? "" : "none";
}
function notifyBox(e, t, a, i) {
    $.pnotify({
        title: t,
        text: a,
        type: e,
        opacity: 0.8,
        closer_hover: !1,
        sticker_hover: !1,
        hide: i,
    });
}
function notifyDialog(e) {
    (document.getElementById("dialog_notify_text").innerHTML = e),
        $("#dialog_notify").dialog("open");
}
$(window).resize(function () {
    $("#dialog_dashboard").hasClass("ui-dialog-content") &&
        1 == $("#dialog_dashboard").dialog("isOpen") &&
        dashboardResize();
}),
    ($.pnotify.defaults.history = !1),
    ($.pnotify.defaults.styling = "jqueryui");
var confirmResponseValue = !1;

function confirmDialog(e, t) {
    (confirmResponseValue = !1),
        (document.getElementById("dialog_confirm_text").innerHTML = e),
        $("#dialog_confirm").dialog("destroy"),
        $("#dialog_confirm").dialog({
            autoOpen: !1,
            width: "auto",
            height: "auto",
            minHeight: "auto",
            modal: !0,
            resizable: !1,
            draggable: !1,
            dialogClass: "dialog-notify-titlebar",
            close: function (e, a) {
                t(confirmResponseValue);
            },
            create: function (e, t) {
                $(this).parent().css("maxWidth", "600px");
            },
        }),
        $("#dialog_confirm").dialog("open");
}
function confirmResponse(e) {
    (confirmResponseValue = e), $("#dialog_confirm").dialog("close");
}
function loadObjectMapMarkerIcons() {
    var e = new Array();
    for (var t in settingsObjectData) {
        var a = settingsObjectData[t];
        e.push(a.icon);
    }
    for (e = uniqueArray(e), i = 0; i < e.length; i++) {
        var o = e[i],
            s = e[i],
            n = settingsUserData.map_is;
        mapMarkerIcons[o] = L.icon({
            iconUrl: s,
            iconSize: [28 * n, 28 * n],
            iconAnchor: [14 * n, 14 * n],
            popupAnchor: [0, 0],
        });
    }
}
function addPointerOverMarker(e) {
    e.events.register("mouseover", e, function (e) {
        (document.getElementById("map").style.cursor = "pointer"),
            OpenLayers.Event.stop(e);
    }),
        e.events.register("mouseout", e, function (e) {
            (document.getElementById("map").style.cursor = "auto"),
                OpenLayers.Event.stop(e);
        });
}
function rotateMarker(e, t, a) {
    $("#" + e.markers[t].icon.imageDiv.id).css(
        "-moz-transform",
        "rotate(" + a + "deg)"
    ),
        $("#" + e.markers[t].icon.imageDiv.id).css(
            "-webkit-transform",
            "rotate(" + a + "deg)"
        ),
        $("#" + e.markers[t].icon.imageDiv.id).css(
            "-o-transform",
            "rotate(" + a + "deg)"
        );
}

function createCluster(e) {
    var t = settingsUserData.map_is;
    if ("objects" == e)
        var a = "img/markers/clusters/objects.svg",
            o = "marker-cluster";
    else {
        if ("markers" != e) return !1;
        (a = "img/markers/clusters/markers.svg"), (o = "marker-cluster");
    }
    if (1 == gsValues.map_clusters) var s = gsValues.map_max_zoom + 1;
    else s = gsValues.map_min_zoom;
    var n = new L.MarkerClusterGroup({
        spiderfyDistanceMultiplier: 2 * t,
        spiderfyOnMaxZoom: !0,
        showCoverageOnHover: !1,
        maxClusterRadius: 60,
        disableClusteringAtZoom: s,
        iconCreateFunction: function (e) {
            var i = e.getChildCount(),
                s = " cluster-";
            return (
                (s += i < 10 ? "small" : i < 100 ? "medium" : "large"),
                L.divIcon({
                    html: '<div><img src="' + a + '"><span>' + i + "</span></div>",
                    className: o + s,
                    iconSize: L.point(40 * t, 40 * t),
                    iconAnchor: [14 * t, 14 * t],
                    popupAnchor: [40 * t, 0 * t],
                })
            );
        },
    });
    return (
        "objects" == e &&
        "true" == settingsUserData.map_ocp &&
        n.on("clustermouseover", function (e) {
            var t = settingsUserData.map_is,
                a = e.layer.getAllChildMarkers(),
                o = "",
                s = !1;
            for (i = 0; i < a.length; i++) {
                var n = a[i].imei,
                    l = settingsObjectData[n]?.name;
                if ("" != objectsData[n]?.data) {
                    var d = objectsData[n].data[0].speed,
                        r = getSensorFromType(n, "acc");
                    if (0 == r || 0 == objectsData[n].connection) var _ = "";
                    else if (
                        1 == getSensorValue(objectsData[n].data[0].params, r[0]).value
                    )
                        _ = getEngineIcon(1);
                    else _ = getEngineIcon(0);
                } else (d = 0), (_ = "");
                var c = getConnectionIcon(objectsData[n].connection);
                (o +=
                    '<tr><td style="white-space: nowrap;"><strong>' +
                    l +
                    '</strong></td><td></td><td style="white-space: nowrap;">' +
                    d +
                    " " +
                    la.UNIT_SPEED +
                    "</td><td>" +
                    _ +
                    "</td><td>" +
                    c +
                    "</td></tr>"),
                    i > 9 && (s = !0);
            }
            (o = "<table>" + o + "</table>"),
                s && (o = '<div class="object-cluster-popup">' + o + "</div>"),
                addPopupToMap(e.latlng.lat, e.latlng.lng, [0, -14 * t], o, "");
        }),
        n
    );
}
function mapViewControls() {
    return L.Control.extend({
        options: {
            position: "topleft",
        },
        onAdd: function (e) {
            var t = L.DomUtil.create("div", "leaflet-control leaflet-bar");
            (linkObjects = L.DomUtil.create("a", "", t)),
                (linkObjects.id = "map_control_objects"),
                (linkObjects.href = "#"),
                (linkObjects.title = la.ENABLE_DISABLE_OBJECTS),
                (linkObjects.className = ""),
                (iconObjects = L.DomUtil.create("span", "", linkObjects)),
                (iconObjects.className = "icon-objects");
            var a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkObjects, "dblclick", a),
                L.DomEvent.on(linkObjects, "mousedown", a),
                L.DomEvent.on(linkObjects, "click", function (t) {
                    1 == e.hasLayer(mapLayers.realtime)
                        ? (e.removeLayer(mapLayers.realtime),
                            (iconObjects.className = "icon-objects disabled"),
                            (gsValues.map_objects = !1))
                        : (e.addLayer(mapLayers.realtime),
                            (iconObjects.className = "icon-objects"),
                            (gsValues.map_objects = !0));
                }),
                (linkObjectLabels = L.DomUtil.create("a", "", t)),
                (linkObjectLabels.id = "map_control_object_labels"),
                (linkObjectLabels.href = "#"),
                (linkObjectLabels.title = la.ENABLE_DISABLE_OBJECT_LABELS),
                (linkObjectLabels.className = ""),
                (iconObjectLabels = L.DomUtil.create("span", "", linkObjectLabels)),
                (iconObjectLabels.className = "icon-text");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkObjectLabels, "dblclick", a),
                L.DomEvent.on(linkObjectLabels, "mousedown", a),
                L.DomEvent.on(linkObjectLabels, "click", function (e) {
                    if (1 == gsValues.map_object_labels) {
                        for (var t in objectsData)
                            objectsData[t].layers.marker.closeTooltip();
                        (iconObjectLabels.className = "icon-text disabled"),
                            (gsValues.map_object_labels = !1);
                    } else {
                        for (var t in objectsData)
                            objectsData[t].layers.marker.openTooltip();
                        (iconObjectLabels.className = "icon-text"),
                            (gsValues.map_object_labels = !0);
                    }
                }),
                (linkMarkers = L.DomUtil.create("a", "", t)),
                (linkMarkers.id = "map_control_markers"),
                (linkMarkers.href = "#"),
                (linkMarkers.title = la.ENABLE_DISABLE_MARKERS),
                (linkMarkers.className = ""),
                (iconMarkers = L.DomUtil.create("span", "", linkMarkers)),
                (iconMarkers.className = "icon-markers");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkMarkers, "dblclick", a),
                L.DomEvent.on(linkMarkers, "mousedown", a),
                L.DomEvent.on(linkMarkers, "click", function (t) {
                    1 == e.hasLayer(mapLayers.places_markers)
                        ? (e.removeLayer(mapLayers.places_markers),
                            (iconMarkers.className = "icon-markers disabled"),
                            (gsValues.map_markers = !1))
                        : (e.addLayer(mapLayers.places_markers),
                            (iconMarkers.className = "icon-markers"),
                            (gsValues.map_markers = !0));
                }),
                (linkRoutes = L.DomUtil.create("a", "", t)),
                (linkRoutes.id = "map_control_routes"),
                (linkRoutes.href = "#"),
                (linkRoutes.title = la.ENABLE_DISABLE_ROUTES),
                (linkRoutes.className = ""),
                (iconRoutes = L.DomUtil.create("span", "", linkRoutes)),
                (iconRoutes.className = "icon-routes");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkRoutes, "dblclick", a),
                L.DomEvent.on(linkRoutes, "mousedown", a),
                L.DomEvent.on(linkRoutes, "click", function (t) {
                    1 == e.hasLayer(mapLayers.places_routes)
                        ? (e.removeLayer(mapLayers.places_routes),
                            (iconRoutes.className = "icon-routes disabled"),
                            (gsValues.map_routes = !1))
                        : (e.addLayer(mapLayers.places_routes),
                            (iconRoutes.className = "icon-routes"),
                            (gsValues.map_routes = !0));
                }),
                (linkZones = L.DomUtil.create("a", "", t)),
                (linkZones.id = "map_control_zones"),
                (linkZones.href = "#"),
                (linkZones.title = la.ENABLE_DISABLE_ZONES),
                (linkZones.className = ""),
                (iconZones = L.DomUtil.create("span", "", linkZones)),
                (iconZones.className = "icon-zones");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkZones, "dblclick", a),
                L.DomEvent.on(linkZones, "mousedown", a),
                L.DomEvent.on(linkZones, "click", function (t) {
                    1 == e.hasLayer(mapLayers.places_zones)
                        ? (e.removeLayer(mapLayers.places_zones),
                            (iconZones.className = "icon-zones disabled"),
                            (gsValues.map_zones = !1))
                        : (e.addLayer(mapLayers.places_zones),
                            (iconZones.className = "icon-zones"),
                            (gsValues.map_zones = !0));
                }),
                (linkKML = L.DomUtil.create("a", "", t)),
                (linkKML.id = "map_control_kml"),
                (linkKML.href = "#"),
                (linkKML.title = la.ENABLE_DISABLE_KML),
                (linkKML.className = ""),
                (iconKml = L.DomUtil.create("span", "", linkKML)),
                (iconKml.className = "icon-kml");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkKML, "dblclick", a),
                L.DomEvent.on(linkKML, "mousedown", a),
                L.DomEvent.on(linkKML, "click", function (t) {
                    1 == e.hasLayer(mapLayers.kml)
                        ? (e.removeLayer(mapLayers.kml),
                            (iconKml.className = "icon-kml disabled"),
                            (gsValues.map_kml = !1))
                        : (e.addLayer(mapLayers.kml),
                            (iconKml.className = "icon-kml"),
                            (gsValues.map_kml = !0));
                }),
                0 == settingsUserData.privileges_kml &&
                (linkKML.style.display = "none"),
                (linkClusters = L.DomUtil.create("a", "", t)),
                (linkClusters.id = "map_control_clusters"),
                (linkClusters.href = "#"),
                (linkClusters.title = la.ENABLE_DISABLE_CLUSTERS),
                (linkClusters.className = ""),
                (iconClusters = L.DomUtil.create("span", "", linkClusters)),
                1 == gsValues.map_clusters
                    ? (iconClusters.className = "icon-clusters")
                    : (iconClusters.className = "icon-clusters disabled");
            a = L.DomEvent.stopPropagation;
            // if (
            //     (L.DomEvent.on(linkClusters, "dblclick", a),
            //         L.DomEvent.on(linkClusters, "mousedown", a),
            //         L.DomEvent.on(linkClusters, "click", function (e) {
            //             1 == gsValues.map_clusters
            //                 ? ((mapLayers.realtime.options.disableClusteringAtZoom =
            //                     gsValues.map_min_zoom),
            //                     (mapLayers.places_markers.options.disableClusteringAtZoom =
            //                         gsValues.map_min_zoom),
            //                     (iconClusters.className = "icon-clusters disabled"),
            //                     (gsValues.map_clusters = !1))
            //                 : ((mapLayers.realtime.options.disableClusteringAtZoom =
            //                     gsValues.map_max_zoom + 1),
            //                     (mapLayers.places_markers.options.disableClusteringAtZoom =
            //                         gsValues.map_max_zoom + 1),
            //                     (iconClusters.className = "icon-clusters"),
            //                     (gsValues.map_clusters = !0)),
            //                 objectAddAllToMap(),
            //                 placesMarkerAddAllToMap();
            //         }),
            //         settingsUserData.privileges_image_gallery)
            // ) {
            //     (linkCamera = L.DomUtil.create("a", "", t)),
            //         (linkCamera.id = "map_control_camera"),
            //         (linkCamera.href = "#"),
            //         (linkCamera.title = la.ENABLE_DISABLE_CAMERA),
            //         (linkCamera.className = ""),
            //         (iconCamera = L.DomUtil.create("span", "", linkCamera)),
            //         (iconCamera.className = "icon-gallery disabled");
            //     a = L.DomEvent.stopPropagation;
            //     L.DomEvent.on(linkCamera, "dblclick", a),
            //         L.DomEvent.on(linkCamera, "mousedown", a),
            //         L.DomEvent.on(linkCamera, "click", function (e) {
            //             if (1 == gsValues.map_camera)
            //                 (document.getElementById("camera_control").style.display = ""),
            //                     (iconCamera.className = "icon-gallery disabled"),
            //                     (gsValues.map_camera = !1);
            //             else
            //                 for (var t in ((document.getElementById(
            //                     "camera_control"
            //                 ).style.display = "block"),
            //                     (iconCamera.className = "icon-gallery"),
            //                     (gsValues.map_camera = !0),
            //                     objectsData))
            //                     1 == objectsData[t].selected && utilsCamera(t);
            //             1 == gsValues.map_street_view
            //                 ? (document.getElementById("camera_control").style.right =
            //                     "340px")
            //                 : (document.getElementById("camera_control").style.right =
            //                     "10px");
            //         });
            // }
            if (gsValues.map_google && gsValues.map_google_street_view) {
                (linkStreetView = L.DomUtil.create("a", "", t)),
                    (linkStreetView.id = "map_control_street_view"),
                    (linkStreetView.href = "#"),
                    (linkStreetView.title = la.ENABLE_DISABLE_STREET_VIEW),
                    (linkStreetView.className = ""),
                    (iconStreetView = L.DomUtil.create("span", "", linkStreetView)),
                    (iconStreetView.className = "icon-street disabled");
                a = L.DomEvent.stopPropagation;
                L.DomEvent.on(linkStreetView, "dblclick", a),
                    L.DomEvent.on(linkStreetView, "mousedown", a),
                    L.DomEvent.on(linkStreetView, "click", function (e) {
                        if (1 == gsValues.map_street_view)
                            (document.getElementById("street_view_control").style.display =
                                ""),
                                (iconStreetView.className = "icon-street disabled"),
                                (gsValues.map_street_view = !1);
                        else
                            for (var t in ((document.getElementById(
                                "street_view_control"
                            ).style.display = "block"),
                                (iconStreetView.className = "icon-street"),
                                (gsValues.map_street_view = !0),
                                objectsData)) {
                                if (1 == objectsData[t].selected)
                                    utilsStreetView(
                                        objectsData[t].data[0].lat,
                                        objectsData[t].data[0].lng,
                                        objectsData[t].data[0].angle
                                    );
                            }
                        1 == gsValues.map_street_view
                            ? (document.getElementById("camera_control").style.right =
                                "340px")
                            : (document.getElementById("camera_control").style.right =
                                "10px");
                    });
            }
            if (gsValues.map_google && gsValues.map_google_traffic) {
                (linkTraffic = L.DomUtil.create("a", "", t)),
                    (linkTraffic.id = "map_control_traffic"),
                    (linkTraffic.href = "#"),
                    (linkTraffic.title = la.ENABLE_DISABLE_LIVE_TRAFFIC),
                    (linkTraffic.className = ""),
                    (iconTraffic = L.DomUtil.create("span", "", linkTraffic)),
                    (iconTraffic.className = "icon-traffic disabled");
                a = L.DomEvent.stopPropagation;
                L.DomEvent.on(linkTraffic, "dblclick", a),
                    L.DomEvent.on(linkTraffic, "mousedown", a),
                    L.DomEvent.on(linkTraffic, "click", function (e) {
                        1 == gsValues.map_traffic
                            ? ((iconTraffic.className = "icon-traffic disabled"),
                                (gsValues.map_traffic = !1),
                                strMatches("gmap,ghyb,gter", gsValues.map_layer.toString()) &&
                                switchMapLayer(gsValues.map_layer))
                            : strMatches("gmap,ghyb,gter", gsValues.map_layer.toString())
                                ? ((iconTraffic.className = "icon-traffic"),
                                    (gsValues.map_traffic = !0),
                                    switchMapLayer(gsValues.map_layer))
                                : notifyBox(
                                    "error",
                                    la.LIVE_TRAFFIC,
                                    la.LIVE_TRAFFIC_FOR_THIS_MAP_IS_NOT_AVAILABLE
                                );
                    });
            }
            return t;
        },
    });
}
function mapToolControls() {
    return L.Control.extend({
        options: {
            position: "topleft",
        },
        onAdd: function (e) {
            var t = L.DomUtil.create("div", "leaflet-control leaflet-bar");
            (linkFitObjects = L.DomUtil.create("a", "", t)),
                (linkFitObjects.id = "map_fit_objects"),
                (linkFitObjects.href = "#"),
                (linkFitObjects.title = la.FIT_OBJECTS_ON_MAP),
                (linkFitObjects.className = ""),
                (iconFitObjects = L.DomUtil.create("span", "", linkFitObjects)),
                (iconFitObjects.className = "icon-fit-objects");
            var a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkFitObjects, "dblclick", a),
                L.DomEvent.on(linkFitObjects, "mousedown", a),
                L.DomEvent.on(linkFitObjects, "click", function (e) {
                    fitObjectsOnMap();
                }),
                (linkRuler = L.DomUtil.create("a", "", t)),
                (linkRuler.id = "map_ruler"),
                (linkRuler.href = "#"),
                (linkRuler.title = la.RULER),
                (linkRuler.className = ""),
                (iconRuler = L.DomUtil.create("span", "", linkRuler)),
                (iconRuler.className = "icon-ruler disabled");
            a = L.DomEvent.stopPropagation;
            L.DomEvent.on(linkRuler, "dblclick", a),
                L.DomEvent.on(linkRuler, "mousedown", a),
                L.DomEvent.on(linkRuler, "click", function (e) {
                    utilsRuler(),
                        1 == utilsRulerData.enabled
                            ? (iconRuler.className = "icon-ruler")
                            : (iconRuler.className = "icon-ruler disabled");
                }),
                (linkMeasure = L.DomUtil.create("a", "", t)),
                (linkMeasure.id = "map_measure"),
                (linkMeasure.href = "#"),
                (linkMeasure.title = la.MEASURE_AREA),
                (linkMeasure.className = ""),
                (iconMeasure = L.DomUtil.create("span", "", linkMeasure)),
                (iconMeasure.className = "icon-measure disabled");
            a = L.DomEvent.stopPropagation;
            return (
                L.DomEvent.on(linkMeasure, "dblclick", a),
                L.DomEvent.on(linkMeasure, "mousedown", a),
                L.DomEvent.on(linkMeasure, "click", function (e) {
                    utilsArea(),
                        1 == utilsAreaData.enabled
                            ? (iconMeasure.className = "icon-measure")
                            : (iconMeasure.className = "icon-measure disabled");
                }),
                t
            );
        },
    });
}

// #################################################
// END VARIOUS GUI FUNCTIONS
// #################################################

// #################################################
// COOKIES FUNCTIONS
// #################################################

function getCookie(c_name) {
    var i,
        x,
        y,
        ARRcookies = document.cookie.split(";");
    for (i = 0; i < ARRcookies.length; i++) {
        x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
        y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
        x = x.replace(/^\s+|\s+$/g, "");
        if (x == c_name) {
            return unescape(y);
        }
    }
}

function setCookie(c_name, value, exdays) {
    var domain = document.domain;

    var exdate = new Date();
    exdate.setDate(exdate.getDate() + exdays);

    var c_value =
        escape(value) + (exdays == null ? "" : "; expires=" + exdate.toUTCString());
    c_value += "; domain=." + domain + "; path=/";

    document.cookie = c_name + "=" + c_value;
}

// #################################################
// END COOKIES FUNCTIONS
// #################################################

// #################################################
// SENSOR FUNCTIONS
// #################################################

function getAllParamsArray() {
    var arr_params = new Array();

    for (var imei in settingsObjectData) {
        var params = settingsObjectData[imei]["params"];

        for (var i = 0; i < params.length; i++) {
            if (params[i] != "") {
                arr_params.push(params[i]);
            }
        }
    }

    return uniqueArray(arr_params).sort();
}
function getAllSensorsArray() {
    // // console.log('sensorsarray')
    var arr_sensors = new Array();

    for (var imei in settingsObjectData) {
        var sensors = settingsObjectData[imei]?.sensors;
        for (var key in sensors) {
            var sensor = sensors[key];

            if (sensor.name != "") {
                arr_sensors.push(sensor.name);
            }
        }
    }

    return uniqueArray(arr_sensors);
}
function getParamValue(params, param) {
    var param_value = 0;

    if (params != null) {
        if (params[param] != undefined) {
            param_value = params[param];
        }
    }

    return param_value;
}
function getSensorValueFuelLevelSumUp(imei, params, sensor) {
    var result = [];
    result["value"] = 0;
    result["value_full"] = "";

    var fuel_sensors = getSensorFromType(imei, "fuel");

    for (var i = 0; i < fuel_sensors.length; i++) {
        if (fuel_sensors[i].result_type == "value") {
            var sensor_data = getSensorValue(params, fuel_sensors[i]);
            result["value"] += parseFloat(sensor_data.value);
        }
    }

    result["value"] = Math.round(result["value"] * 100) / 100;

    result["value_full"] = result["value"];
    result["value_full"] += " " + sensor.units;

    return result;
}
function getSensorValue(params, sensor) {
    // // console.log('sensor value')
    var result = [];
    result["value"] = 0;
    result["value_full"] = "";

    var param_value = getParamValue(params, sensor.param);

    // formula
    if (
        sensor.result_type == "abs" ||
        sensor.result_type == "rel" ||
        sensor.result_type == "value"
    ) {
        param_value = parseFloat(param_value);

        if (!isNumber(param_value)) {
            param_value = 0;
        }

        if (sensor.formula != "") {
            var formula = sensor.formula.toLowerCase();
            formula = formula.replace("x", param_value);
            param_value = calcString(formula);
        }
    }

    if (sensor.result_type == "abs" || sensor.result_type == "rel") {
        param_value = Math.round(param_value * 1000) / 1000;

        result["value"] = param_value;
        result["value_full"] = param_value;
    } else if (sensor.result_type == "logic") {
        if (param_value == 1) {
            result["value"] = param_value;
            result["value_full"] = sensor.text_1;
        } else {
            result["value"] = param_value;
            result["value_full"] = sensor.text_0;
        }
    } else if (sensor.result_type == "value") {
        // calibration
        var out_of_cal = true;
        var calibration = sensor.calibration;

        // function to get calibration Y value
        var calGetY = function (x) {
            var result = 0;
            for (var j = 0; j < calibration.length; j++) {
                if (calibration[j]["x"] == x) {
                    result = parseFloat(calibration[j]["y"]);
                }
            }
            return result;
        };

        if (calibration.length >= 2) {
            // put all X values to separate array
            var x_arr = new Array();
            for (var i = 0; i < calibration.length; i++) {
                x_arr.push(parseFloat(calibration[i]["x"]));
            }

            x_arr.sort(sortNumber);

            // loop and check if in cal
            for (var i = 0; i < x_arr.length; i++) {
                var x_low = x_arr[i];
                var x_high = x_arr[i + 1];

                if (param_value >= x_low && param_value <= x_high) {
                    // get Y low and high
                    var y_low = calGetY(x_low);
                    var y_high = calGetY(x_high);

                    // get coeficient
                    var a = param_value - x_low;
                    var b = x_high - x_low;

                    var coef = a / b;

                    var c = y_high - y_low;
                    coef = c * coef;

                    param_value = y_low + coef;

                    out_of_cal = false;

                    break;
                }
            }

            if (out_of_cal) {
                // check if lower than cal
                var x_low = x_arr[0];

                if (param_value < x_low) {
                    param_value = calGetY(x_low);
                }

                // check if higher than cal
                var x_high = x_arr.slice(-1)[0];

                if (param_value > x_high) {
                    param_value = calGetY(x_high);
                }
            }
        }

        param_value = Math.round(param_value * 100) / 100;

        // dictionary
        var dictionary = sensor.dictionary;
        if (dictionary.length >= 1) {
            var param_text = param_value;

            for (var j = 0; j < dictionary.length; j++) {
                if (dictionary[j]["value"] == param_value) {
                    param_text = dictionary[j]["text"];
                }
            }

            result["value"] = param_value;
            result["value_full"] = param_text + " " + sensor.units;
        } else {
            result["value"] = param_value;
            result["value_full"] = param_value + " " + sensor.units;
        }
    } else if (sensor.result_type == "string") {
        result["value"] = param_value;
        result["value_full"] = param_value;
    } else if (sensor.result_type == "percentage") {
        param_value = parseFloat(param_value);
        sensor.lv = parseFloat(sensor.lv);
        sensor.hv = parseFloat(sensor.hv);

        if (param_value > sensor.lv && param_value < sensor.hv) {
            var a = param_value - sensor.lv;
            var b = sensor.hv - sensor.lv;

            result["value"] = Math.round((a / b) * 100);
        } else if (param_value <= sensor.lv) {
            result["value"] = 0;
        } else if (param_value >= sensor.hv) {
            result["value"] = 100;
        }

        result["value_full"] = result["value"] + " " + sensor.units;
    }

    return result;
}
function getSensorFromType(imei, type) {
    var result = new Array();

    var sensors = settingsObjectData[imei]?.sensors;

    for (var key in sensors) {
        var sensor = sensors[key];
        if (sensor.type == type) {
            result.push(sensor);
        }
    }

    if (result.length > 0) {
        return result;
    } else {
        return false;
    }
}
function getDriverFromSensor(imei, params) {
    var driver = false;

    var driver_assign_id = false;

    // blue id
    var sensor = getSensorFromType(imei, "blueid");

    if (sensor != false) {
        var sensor_ = sensor[0];

        var ble_array = [];

        for (var key in params) {
            if (key.substring(0, 3) == "ble" && key.substr(-3) == "sig") {
                ble_array.push({ key: key, value: parseFloat(params[key]) });
            }
        }

        ble_array.sort(function (a, b) {
            return b.value - a.value;
        });

        for (i = 0; i < ble_array.length; i += 1) {
            driver_assign_id = ble_array[i].key.substring(3, 11);

            driver_assign_id = driver_assign_id.toString().toUpperCase();

            var drivers = settingsObjectDriverData;
            for (var driver_id in drivers) {
                if (driver_assign_id == drivers[driver_id].assign_id.toUpperCase()) {
                    driver = drivers[driver_id];
                    // add id, because we will need it later
                    driver.driver_id = driver_id;

                    return driver;
                }
            }
        }
    }

    // rfid or ibutton
    var sensor = getSensorFromType(imei, "da");

    if (sensor != false) {
        var sensor_ = sensor[0];

        var sensor_data = getSensorValue(params, sensor_);
        driver_assign_id = sensor_data.value;

        if (driver_assign_id == "0") {
            return driver;
        } else {
            driver_assign_id = driver_assign_id.toString().toUpperCase();

            var drivers = settingsObjectDriverData;
            for (var driver_id in drivers) {
                if (driver_assign_id == drivers[driver_id].assign_id.toUpperCase()) {
                    driver = drivers[driver_id];
                    // add id, because we will need it later
                    driver.driver_id = driver_id;

                    return driver;
                }
            }
        }
    }

    return driver;
}
function getTrailerFromSensor(imei, params) {
    var trailer = false;

    var trailer_assign_id = false;

    // blue id
    var sensor = getSensorFromType(imei, "blueid");

    if (sensor != false) {
        var sensor_ = sensor[0];

        var ble_array = [];

        for (var key in params) {
            if (key.substring(0, 3) == "ble" && key.substr(-3) == "sig") {
                ble_array.push({ key: key, value: parseFloat(params[key]) });
            }
        }

        ble_array.sort(function (a, b) {
            return b.value - a.value;
        });

        for (i = 0; i < ble_array.length; i += 1) {
            trailer_assign_id = ble_array[i].key.substring(3, 11);

            trailer_assign_id = trailer_assign_id.toString().toUpperCase();

            var trailers = settingsObjectTrailerData;
            for (var trailer_id in trailers) {
                if (trailer_assign_id == trailers[trailer_id].assign_id.toUpperCase()) {
                    trailer = trailers[trailer_id];
                    // add id, because we will need it later
                    trailer.trailer_id = trailer_id;

                    return trailer;
                }
            }
        }
    }

    // rfid or ibutton
    var sensor = getSensorFromType(imei, "ta");

    if (sensor != false) {
        var sensor_ = sensor[0];

        var sensor_data = getSensorValue(params, sensor_);
        trailer_assign_id = sensor_data.value;

        if (trailer_assign_id == "0") {
            return trailer;
        } else {
            trailer_assign_id = trailer_assign_id.toString().toUpperCase();

            var trailers = settingsObjectTrailerData;
            for (var trailer_id in trailers) {
                if (trailer_assign_id == trailers[trailer_id].assign_id.toUpperCase()) {
                    trailer = trailers[trailer_id];
                    // add id, because we will need it later
                    trailer.trailer_id = trailer_id;

                    return trailer;
                }
            }
        }
    }

    return trailer;
}
function getDriver(imei, params) {
    var driver = false;

    var driver_id = settingsObjectData[imei]?.driver_id;

    if (driver_id == "-1") {
        return driver;
    }

    if (driver_id == "0") {
        return getDriverFromSensor(imei, params);
    }

    if (settingsObjectDriverData[driver_id]) {
        driver = settingsObjectDriverData[driver_id];
        // add id, because we will need it later
        driver.driver_id = driver_id;
    }

    return driver;
}
function getTrailer(imei, params) {
    var trailer = false;

    var trailer_id = settingsObjectData[imei]?.trailer_id;

    if (trailer_id == "-1") {
        return trailer;
    }

    if (trailer_id == "0") {
        return getTrailerFromSensor(imei, params);
    }

    if (settingsObjectTrailerData[trailer_id]) {
        trailer = settingsObjectTrailerData[trailer_id];
        // add id, because we will need it later
        trailer.trailer_id = trailer_id;
    }

    return trailer;
}

// #################################################
// END SENSOR FUNCTIONS
// #################################################

// #################################################
// GEOCODER FUNCTIONS
// #################################################

// #################################################
// OBJECTS
// #################################################

function transformsToSettingsObjectData(data) {
    // console.log(data)
    var settings = new Array();
    if (data != undefined) {
        for (var key in data) {
            settings[key] = {
                protocol: data[key][0],
                group_id: data[key][1],
                driver_id: data[key][2],
                trailer_id: data[key][3],
                name: data[key][4],
                icon: data[key][5],
                map_arrows: data[key][6],
                map_icon: data[key][7],
                tail_color: data[key][8],
                tail_points: data[key][9],
                device: data[key][10],
                sim_number: data[key][11],
                model: data[key][12],
                vin: data[key][13],
                plate_number: data[key][14],
                odometer_type: data[key][15],
                engine_hours_type: data[key][16],
                odometer: data[key][17],
                engine_hours: data[key][18],
                fcr: data[key][19],
                time_adj: data[key][20],
                accuracy: data[key][21],
                unassign_driver: data[key][22],
                accvirt: data[key][23],
                accvirt_cn: data[key][24],
                forward_loc_data: data[key][25],
                forward_loc_data_imei: data[key][26],
                sensors: data[key][27],
                service: data[key][28],
                custom_fields: data[key][29],
                params: data[key][30],
                active: data[key][31],
                object_expire: data[key][32],
                object_expire_dt: data[key][33],
                object_imei: data[key][34],
                corte_motor: data[key][35],
                rele_activo: data[key][36]
            };
        }
    }

    return settings;
}

function transformToObjectData(data) {
    var result = [];
    result["data"] = [];

    result["visible"] = data["v"];
    result["follow"] = data["f"];
    result["selected"] = data["s"];
    result["event"] = data["evt"];
    result["event_arrow_color"] = data["evtac"];
    result["event_ohc_color"] = data["evtohc"];
    result["address"] = data["a"];
    result["layers"] = data["l"];

    result["status"] = data["st"];
    result["status_string"] = data["ststr"];
    result["protocol"] = data["p"];
    result["connection"] = data["cn"];
    result["odometer"] = data["o"];
    result["engine_hours"] = data["eh"];
    result["service"] = data["sr"];
    result["last_img_file"] = data["lif"];

    if (data["d"] != "") {
        result["data"].push({
            dt_server: data["d"][0][0],
            dt_tracker: data["d"][0][1],
            lat: data["d"][0][2],
            lng: data["d"][0][3],
            altitude: data["d"][0][4],
            angle: data["d"][0][5],
            speed: data["d"][0][6],
            params: data["d"][0][7],
        });
    }

    return result;
}

function getObjectOdometer(imei, params = false) {
    // // console.log(settingsObjectData[imei]?.odometer_type)
    // // console.log(imei + ' ' + params)
    var result = -1;

    if (settingsObjectData[imei]?.odometer_type == "off") {
        return result;
    } else if (settingsObjectData[imei]?.odometer_type == "gps") {
        if (params == false) {
            result = objectsData[imei]["odometer"];
        }
    } else if (settingsObjectData[imei]?.odometer_type == "sen") {
        if (params == false) {
            result = objectsData[imei]["odometer"];
        } else {
            var sensor = getSensorFromType(imei, "odo");

            if (sensor != false) {
                var sensor_ = sensor[0];

                if (sensor_.result_type == "abs") {
                    var sensor_data = getSensorValue(params, sensor_);
                    result = sensor_data.value;
                }
            }
        }
    }

    return result;
}

function getObjectEngineHours(imei, params) {
    var result = -1;

    if (settingsObjectData[imei]?.["engine_hours_type"] == "off") {
        return result;
    } else if (settingsObjectData[imei]?.["engine_hours_type"] == "acc") {
        if (params == false) {
            result = objectsData[imei]["engine_hours"];
        }
    } else if (settingsObjectData[imei]?.["engine_hours_type"] == "sen") {
        if (params == false) {
            result = objectsData[imei]["engine_hours"];
        } else {
            var sensor = getSensorFromType(imei, "engh");

            if (sensor != false) {
                var sensor_ = sensor[0];

                if (sensor_.result_type == "abs") {
                    var sensor_data = getSensorValue(params, sensor_);
                    result = sensor_data.value;
                }
            }
        }
    }

    if (result > -1) {
        result = getTimeDetails(result, false);
    }

    return result;
}

function getObjectParamsArray(imei) {
    var arr_params = new Array();

    var params = settingsObjectData[imei]["params"];

    for (var i = 0; i < params.length; i++) {
        if (params[i] != "") {
            arr_params.push(params[i]);
        }
    }

    return uniqueArray(arr_params).sort();
}
var objectsData = new Array();

function objectReloadData() {
    (objectsData = []), objectLoadList(), objectLoadData();
}

function objectAddAllToMap() {
    var e = document.getElementById(
        "side_panel_objects_object_list_search"
    ).value;
    objectRemoveAllFromMap();
    for (var t in objectsData)
        "true" == settingsObjectData[t].active &&
            strMatches(settingsObjectData[t].name, e) &&
            (objectAddToMap(t), objectVisible(t));
}
function objectFollow() {
    var e = document.getElementById(
        "side_panel_objects_object_list_search"
    ).value,
        t = 0,
        a = new Array();
    for (var i in objectsData)
        if (
            strMatches(settingsObjectData[i].name, e) &&
            "" != objectsData[i].data &&
            1 == objectsData[i].follow
        ) {
            var o = objectsData[i].data[0].lat,
                s = objectsData[i].data[0].lng;
            a.push([o, s]), (t += 1);
        }
    t > 1
        ? map.fitBounds(a)
        : 1 == t &&
        map.panTo({
            lat: o,
            lng: s,
        });
}
function objectFollowAllToggle() {
    objectFollowAll(1 == gsValues.objects_follow ? false : true);
}
function objectFollowAll(e) {
    gsValues.objects_follow = e;
    for (var t in objectsData)
        (objectsData[t].follow = e),
            null != document.getElementById("object_follow_" + t) &&
            (document.getElementById("object_follow_" + t).checked = e);
    for (var a in settingsObjectGroupData)
        null != document.getElementById("object_group_follow_" + a) &&
            ((settingsObjectGroupData[a].follow = e),
                (document.getElementById("object_group_follow_" + a).checked = e));
    objectFollow();
}

function objectLoadList() {
    var e = $("#side_panel_objects_object_list_grid");
    e.clearGridData(true);
    for (var imei in settingsObjectData) {
        var car = settingsObjectData[imei];
        if ("true" == car.active) {
            const search = car.name.toLowerCase() + imei.toLowerCase();
            const nameSort = car.name.toLowerCase();
            const groupId = car.group_id;
            const show =
                '<input id="object_visible_' +
                imei +
                '" onClick="objectVisibleToggle(\'' +
                imei +
                '\');" class="checkbox" type="checkbox"/>';
            const follow =
                '<input id="object_follow_' +
                imei +
                '" onClick="objectFollowToggle(\'' +
                imei +
                '\');" class="checkbox" type="checkbox"/>';
            const icon =
                '<a href="#"><img src="' + car.icon + '" style="width: 26px;"/></a>';
            let name =
                '<div class="object-list-item"><div class="left"><div class="name">' +
                car.name +
                '</div><div class="status" id="object_status_' +
                imei +
                '">' +
                la.NO_DATA +
                "</div></div>";
            name +=
                '<div class="right"><div class="speed" id="object_speed_' +
                imei +
                '">0 ' +
                la.UNIT_SPEED +
                "</div>";
                console.log()
            if (
                tieneCorteMotor(car.corte_motor) &&
                [0, 1].includes(validarEstadoRele(car.rele_activo))
            ) {
                const svg = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100%" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve">
                    <g>
                        <path fill="${colorMap.get(
                    car.rele_activo
                )}" d="M350.814,0C261.689,0,189.63,72.059,189.63,161.185c0,18.963,3.792,37.926,9.481,56.889L0,417.186V512
                            h94.815v-56.889h56.889v-56.89h56.889l85.333-85.333c17.066,5.688,36.03,9.481,56.89,9.481C439.941,322.37,512,250.31,512,161.184
                            S439.94,0,350.814,0z M398.223,170.667c-32.237,0-56.89-24.651-56.89-56.889c0-32.238,24.651-56.889,56.89-56.889
                            c32.237,0,56.89,24.651,56.89,56.889C455.111,146.015,430.46,170.667,398.223,170.667z"/>
                    </g>
                </svg>`;
                name += `<div class="indicador-rele-side-panel indicador-rele-activo" id="object_rele_${imei}" style="position: relative; top: 50%; transform: translateY(-50%); font-size: 1rem;">${svg}</div>`;
            }
            name += '<div class="engine" id="object_engine_' + imei + '"></div>';
            name +=
                '<div class="connection" id="object_connection_' +
                imei +
                '">' +
                getConnectionIcon(0) +
                "</div></div></div>";
            const menu =
                '<div class="object-action-menu" id="object_action_menu_' +
                imei +
                '" tag="' +
                imei +
                '"><a href="#"><img src="theme/images/menu.svg" style="width: 4px;" title="' +
                la.ACTION +
                '"/></a></div>';
            e.jqGrid("addRowData", imei, {
                search: search,
                name_sort: nameSort,
                group_id: groupId,
                show: show,
                follow: follow,
                icon: icon,
                name: name,
                menu: menu,
            });
        }
    }
    e.setGridParam({
        sortname: "name_sort",
        sortorder: "asc",
    }).trigger("reloadGrid");
}
// #################################################
// END OBJECTS
// #################################################

// #################################################
// MAP FUNCTIONS
// #################################################
function defineMapLayers() {
    if (gsValues["map_osm"]) {
        mapLayers["osm"] = new L.TileLayer(
            "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
            {
                attribution:
                    '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors',
            }
        );
    }

    if (gsValues["map_bing"]) {
        mapLayers["broad"] = new L.BingLayer(gsValues["map_bing_key"], {
            type: "Road",
        });
        mapLayers["baer"] = new L.BingLayer(gsValues["map_bing_key"], {
            type: "Aerial",
        });
        mapLayers["bhyb"] = new L.BingLayer(gsValues["map_bing_key"], {
            type: "AerialWithLabels",
        });
    }

    if (gsValues["map_google"]) {
        mapLayers["gmap"] = new L.Google("ROADMAP");
        mapLayers["gsat"] = new L.Google("SATELLITE");
        mapLayers["ghyb"] = new L.Google("HYBRID");
        mapLayers["gter"] = new L.Google("TERRAIN");
    }

    if (gsValues["map_mapbox"]) {
        mapLayers["mbmap"] = L.tileLayer(
            "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=" +
            gsValues["map_mapbox_key"],
            {
                attribution:
                    '© <a href="https://www.mapbox.com/map-feedback/">Mapbox</a> © <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>',
                id: "mapbox/streets-v11",
            }
        );

        mapLayers["mbsat"] = L.tileLayer(
            "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=" +
            gsValues["map_mapbox_key"],
            {
                attribution:
                    '© <a href="https://www.mapbox.com/map-feedback/">Mapbox</a> © <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>',
                id: "mapbox/satellite-streets-v11",
            }
        );
    }

    if (gsValues["map_arcgis"]) {
        mapLayers["agtop"] = L.esri.basemapLayer("Topographic", {
            token: gsValues["map_arcgis_key"],
        });
        mapLayers["agstr"] = L.esri.basemapLayer("Streets", {
            token: gsValues["map_arcgis_key"],
        });
        mapLayers["agimg"] = L.esri.basemapLayer("Imagery", {
            token: gsValues["map_arcgis_key"],
        });
        mapLayers["agimgl"] = L.esri.basemapLayer("ImageryLabels", {
            token: gsValues["map_arcgis_key"],
        });

        mapLayers["agimg"].on("add", function (e) {
            map.addLayer(mapLayers["agimgl"]);
        });

        mapLayers["agimg"].on("remove", function (e) {
            map.removeLayer(mapLayers["agimgl"]);
        });
    }

    if (gsValues["map_yandex"]) {
        mapLayers["yandex"] = new L.Yandex();
    }

    for (var i = 0; i < gsValues["map_custom"].length; i++) {
        var layer_id = gsValues["map_custom"][i].layer_id;
        var name = gsValues["map_custom"][i].name;
        var type = gsValues["map_custom"][i].type;
        var url = gsValues["map_custom"][i].url;
        var layers = gsValues["map_custom"][i].layers;

        if (type == "tms") {
            mapLayers[layer_id] = L.tileLayer(url, { tms: true });
        } else {
            mapLayers[layer_id] = L.tileLayer.wms(url, { layers: layers });
        }
    }
}
function initMap() {
    (map = L.map("map", {
        minZoom: gsValues.map_min_zoom,
        maxZoom: gsValues.map_max_zoom,
        editable: !0,
        zoomControl: !1,
    })),
        initSelectList("map_layer_list"),
        defineMapLayers(),
        (mapLayers.utils = L.layerGroup()),
        mapLayers.utils.addTo(map),
        (mapLayers.realtime = createCluster("objects")),
        mapLayers.realtime.addTo(map),
        (mapLayers.history = L.layerGroup()),
        mapLayers.history.addTo(map),
        (mapLayers.places_markers = createCluster("markers")),
        mapLayers.places_markers.addTo(map),
        (mapLayers.places_zones = L.layerGroup()),
        mapLayers.places_zones.addTo(map),
        (mapLayers.places_routes = L.layerGroup()),
        mapLayers.places_routes.addTo(map),
        (mapLayers.kml = L.layerGroup()),
        mapLayers.kml.addTo(map),
        map.addControl(
            L.control.zoom({
                zoomInText: "",
                zoomOutText: "",
                zoomInTitle: la.ZOOM_IN,
                zoomOutTitle: la.ZOOM_OUT,
            })
        ),
        (L.MapViewControls = mapViewControls()),
        map.addControl(new L.MapViewControls()),
        (L.MapViewControls = mapToolControls()),
        map.addControl(new L.MapViewControls()),
        L.Control.BrowserPrint.Utils.registerLayer(
            L.BingLayer,
            "L.BingLayer",
            function (e) {
                return new L.BingLayer(e._key, e.options);
            }
        ),
        L.Control.BrowserPrint.Utils.registerLayer(
            L.Google,
            "L.Google",
            function (e) {
                return new L.Google(e._type);
            }
        ),
        L.Control.BrowserPrint.Utils.registerLayer(
            L.Yandex,
            "L.Yandex",
            function (e) {
                return new L.Yandex();
            }
        ),
        L.control
            .browserPrint({
                title: la.PRINT_MAP,
                printModes: [
                    L.control.browserPrint.mode.portrait(la.PORTRAIT, "A4"),
                    L.control.browserPrint.mode.landscape(la.LANDSCAPE, "A4"),
                    L.control.browserPrint.mode.custom(la.CUSTOM, "A4"),
                ],
            })
            .addTo(map),
        map.setView([gsValues.map_lat, gsValues.map_lng], gsValues.map_zoom),
        switchMapLayer(gsValues.map_layer),
        gsValues.map_objects ||
        document.getElementById("map_control_objects").click(),
        gsValues.map_object_labels ||
        (iconObjectLabels.className = "icon-text disabled"),
        gsValues.map_markers ||
        document.getElementById("map_control_markers").click(),
        gsValues.map_routes ||
        document.getElementById("map_control_routes").click(),
        gsValues.map_zones || document.getElementById("map_control_zones").click(),
        map.on("zoomend", function () {
            historyRouteDataPoints();
        });
    var e = settingsUserData.map_is,
        t = 28 * e,
        a = 28 * e,
        i = 14 * e,
        o = 14 * e;
    (t = 28 * e), (a = 28 * e), (i = 14 * e), (o = 14 * e);
    (mapMarkerIcons.arrow_black = L.icon({
        iconUrl: "img/markers/arrow-black.svg",
        iconSize: [t, a],
        iconAnchor: [i, o],
        popupAnchor: [0, 0],
    })),
        (mapMarkerIcons.arrow_blue = L.icon({
            iconUrl: "img/markers/arrow-blue.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_green = L.icon({
            iconUrl: "img/markers/arrow-green.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_grey = L.icon({
            iconUrl: "img/markers/arrow-grey.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_orange = L.icon({
            iconUrl: "img/markers/arrow-orange.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_purple = L.icon({
            iconUrl: "img/markers/arrow-purple.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_red = L.icon({
            iconUrl: "img/markers/arrow-red.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.arrow_yellow = L.icon({
            iconUrl: "img/markers/arrow-yellow.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (t = 28 * e),
        (a = 28 * e),
        (i = 14 * e),
        (o = 28 * e),
        (mapMarkerIcons.route_start = L.icon({
            iconUrl: "img/markers/route-start.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.route_end = L.icon({
            iconUrl: "img/markers/route-end.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.route_stop = L.icon({
            iconUrl: "img/markers/route-stop.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.route_event = L.icon({
            iconUrl: "img/markers/route-event.svg",
            iconSize: [t, a],
            iconAnchor: [i, o],
            popupAnchor: [0, 0],
        })),
        (mapMarkerIcons.route_data_point = L.icon({
            iconUrl: "img/markers/route-data-point.svg",
            iconSize: [8, 8],
            iconAnchor: [4, 4],
            popupAnchor: [0, 0],
        }));
}



function switchMapLayer(id) {
    gsValues["map_layer"] = id;

    var backup_layer = false;

    if (gsValues["map_osm"]) {
        if (map.hasLayer(mapLayers["osm"])) {
            map.removeLayer(mapLayers["osm"]);
        }

        if (backup_layer == false) {
            backup_layer = "osm";
        }
    }

    if (gsValues["map_bing"]) {
        if (map.hasLayer(mapLayers["broad"])) {
            map.removeLayer(mapLayers["broad"]);
        }

        if (map.hasLayer(mapLayers["baer"])) {
            map.removeLayer(mapLayers["baer"]);
        }

        if (map.hasLayer(mapLayers["bhyb"])) {
            map.removeLayer(mapLayers["bhyb"]);
        }

        if (backup_layer == false) {
            backup_layer = "broad";
        }
    }

    if (gsValues["map_google"]) {
        if (map.hasLayer(mapLayers["gmap"])) {
            map.removeLayer(mapLayers["gmap"]);
        }

        if (map.hasLayer(mapLayers["gsat"])) {
            map.removeLayer(mapLayers["gsat"]);
        }

        if (map.hasLayer(mapLayers["ghyb"])) {
            map.removeLayer(mapLayers["ghyb"]);
        }

        if (map.hasLayer(mapLayers["gter"])) {
            map.removeLayer(mapLayers["gter"]);
        }

        if (backup_layer == false) {
            backup_layer = "gmap";
        }
    }

    if (gsValues["map_mapbox"]) {
        if (map.hasLayer(mapLayers["mbmap"])) {
            map.removeLayer(mapLayers["mbmap"]);
        }

        if (map.hasLayer(mapLayers["mbsat"])) {
            map.removeLayer(mapLayers["mbsat"]);
        }

        if (backup_layer == false) {
            backup_layer = "mbmap";
        }
    }

    if (gsValues["map_arcgis"]) {
        if (map.hasLayer(mapLayers["agtop"])) {
            map.removeLayer(mapLayers["agtop"]);
        }

        if (map.hasLayer(mapLayers["agstr"])) {
            map.removeLayer(mapLayers["agstr"]);
        }

        if (map.hasLayer(mapLayers["agimg"])) {
            map.removeLayer(mapLayers["agimg"]);
        }

        if (backup_layer == false) {
            backup_layer = "agtop";
        }

        //L.esri.basemapLayer('Labels').addTo(map);
    }

    if (gsValues["map_yandex"]) {
        if (map.hasLayer(mapLayers["yandex"])) {
            map.removeLayer(mapLayers["yandex"]);
        }

        if (backup_layer == false) {
            backup_layer = "yandex";
        }
    }

    for (var i = 0; i < gsValues["map_custom"].length; i++) {
        var layer_id = gsValues["map_custom"][i].layer_id;

        if (map.hasLayer(mapLayers[layer_id])) {
            map.removeLayer(mapLayers[layer_id]);
        }
    }

    try {
        map.addLayer(mapLayers[gsValues["map_layer"]]);
    } catch (e) {
        gsValues["map_layer"] = backup_layer;

        if (backup_layer != false) {
            map.addLayer(mapLayers[gsValues["map_layer"]]);
        }
    }

    if (document.getElementById("map_layer").value != gsValues["map_layer"]) {
        document.getElementById("map_layer").value = gsValues["map_layer"];
    }
}

function fitObjectsOnMap() {
    var count = 0;
    var bounds = new Array();

    for (var imei in objectsData) {
        if (
            objectsData[imei]["data"] != "" &&
            objectsData[imei]["visible"] == true
        ) {
            var lat = objectsData[imei]["data"][0]["lat"];
            var lng = objectsData[imei]["data"][0]["lng"];

            bounds.push([lat, lng]);

            count += 1;
        }
    }

    if (count > 0) {
        map.fitBounds(bounds);
    }
}

var shareData = new Array();
function sharePositionOpen() {
    utilsCheckPrivileges("subuser") && $("#dialog_share_position").dialog("open");
}
function sharePositionGenerateSU() {
    var e = settingsUserData.email + moment();
    return CryptoJS.MD5(e).toString().toUpperCase();
}
function sharePositionCheck() {
    1 == document.getElementById("dialog_share_position_expire").checked
        ? (document.getElementById("dialog_share_position_expire_dt").disabled = !1)
        : (document.getElementById("dialog_share_position_expire_dt").disabled =
            !0);
}
function sharePositionDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_share_position",
                    share_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_share.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && $("#share_position_list_grid").trigger("reloadGrid");
                    },
                });
            }
        });
}
function sharePositionDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#share_position_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_share_positions",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_share.php",
                            data: a,
                            success: function (e) {
                                "OK" == e &&
                                    $("#share_position_list_grid").trigger("reloadGrid");
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function sharePositionProperties(e) {
    switch (e) {
        default:
            var t = e;
            shareData.edit_share_position_id = t;
            var a = {
                cmd: "load_share_position",
                share_id: shareData.edit_share_position_id,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_share.php",
                data: a,
                dataType: "json",
                cache: !1,
                success: function (e) {
                    (document.getElementById("dialog_share_position_active").checked =
                        strToBoolean(e.active)),
                        (document.getElementById("dialog_share_position_name").value =
                            e.name),
                        (document.getElementById("dialog_share_position_email").value =
                            e.email),
                        (document.getElementById("dialog_share_position_phone").value =
                            e.phone);
                    var t = document.getElementById("dialog_share_position_object_list"),
                        a = e.imei.split(",");
                    multiselectSetValues(t, a),
                        $("#dialog_share_position_object_list").multipleSelect("refresh");
                    var i = strToBoolean(e.expire);
                    (document.getElementById("dialog_share_position_expire").checked = i),
                        (document.getElementById("dialog_share_position_expire_dt").value =
                            1 == i ? e.expire_dt : ""),
                        (document.getElementById(
                            "dialog_share_position_delete_expired"
                        ).checked = strToBoolean(e.delete_expired)),
                        (document.getElementById(
                            "dialog_share_position_send_email"
                        ).checked = !1),
                        (document.getElementById("dialog_share_position_send_sms").checked =
                            !1),
                        (shareData.share_position_su = e.su),
                        "" == shareData.share_position_su &&
                        (shareData.share_position_su = sharePositionGenerateSU()),
                        (document.getElementById("dialog_share_position_su").value =
                            gsValues.url_root +
                            "/index.php?su=" +
                            shareData.share_position_su),
                        (document.getElementById("dialog_share_position_su_mobile").value =
                            gsValues.url_root +
                            "/index.php?su=" +
                            shareData.share_position_su +
                            "&m=true"),
                        sharePositionCheck();
                },
            }),
                $("#dialog_share_position_properties").dialog("open");
            break;
        case "add":
            (shareData.edit_share_position_id = !1),
                (document.getElementById("dialog_share_position_active").checked = !0),
                (document.getElementById("dialog_share_position_name").value = ""),
                (document.getElementById("dialog_share_position_email").value = ""),
                (document.getElementById("dialog_share_position_phone").value = ""),
                $("#dialog_share_position_object_list option:selected").removeAttr(
                    "selected"
                ),
                $("#dialog_share_position_object_list").multipleSelect("refresh"),
                (document.getElementById("dialog_share_position_expire").checked = !1),
                (document.getElementById("dialog_share_position_expire_dt").value = ""),
                (document.getElementById(
                    "dialog_share_position_delete_expired"
                ).checked = !1),
                (document.getElementById("dialog_share_position_send_email").checked =
                    !0),
                (document.getElementById("dialog_share_position_send_sms").checked =
                    !0),
                (shareData.share_position_su = sharePositionGenerateSU()),
                (document.getElementById("dialog_share_position_su").value =
                    gsValues.url_root + "/index.php?su=" + shareData.share_position_su),
                (document.getElementById("dialog_share_position_su_mobile").value =
                    gsValues.url_root +
                    "/index.php?su=" +
                    shareData.share_position_su +
                    "&m=true"),
                sharePositionCheck(),
                $("#dialog_share_position_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_share_position_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var i = document.getElementById("dialog_share_position_active").checked,
                o = document.getElementById("dialog_share_position_name").value,
                s = document.getElementById("dialog_share_position_email").value,
                n = document.getElementById("dialog_share_position_phone").value,
                l = multiselectGetValues(
                    document.getElementById("dialog_share_position_object_list")
                ),
                d = document.getElementById("dialog_share_position_expire").checked,
                r = document.getElementById("dialog_share_position_expire_dt").value,
                _ = document.getElementById(
                    "dialog_share_position_delete_expired"
                ).checked,
                c = document.getElementById("dialog_share_position_send_email").checked,
                g = document.getElementById("dialog_share_position_send_sms").checked;
            if ("" == o)
                return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
            if ("" == l)
                return void notifyBox(
                    "error",
                    la.ERROR,
                    la.AT_LEAST_ONE_OBJECT_SELECTED
                );
            if (c && !isEmailValid(s)) {
                notifyBox("error", la.ERROR, la.THIS_EMAIL_IS_NOT_VALID);
                break;
            }
            if (g && "" == n) {
                notifyBox("error", la.ERROR, la.PHONE_CANT_BE_EMPTY);
                break;
            }
            if (1 == d) {
                if ("" == r)
                    return void notifyBox("error", la.ERROR, la.DATE_CANT_BE_EMPTY, !0);
            } else r = "";
            a = {
                cmd: "save_share_position",
                share_id: shareData.edit_share_position_id,
                active: i,
                name: o,
                email: s,
                phone: n,
                imei: l,
                expire: d,
                expire_dt: r,
                delete_expired: _,
                send_email: c,
                send_sms: g,
                su: shareData.share_position_su,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_share.php",
                data: a,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        ($("#dialog_share_position_properties").dialog("close"),
                            $("#share_position_list_grid").trigger("reloadGrid"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function tachographOpen() {
    utilsCheckPrivileges("tachograph") && $("#dialog_tachograph").dialog("open");
}
shareData.edit_share_position_id = !1;

// #################################################
// END MAP FUNCTIONS
// #################################################

// #################################################
// GROUP LIST FUNCTIONS
// #################################################

function getGroupsObjectsArray(protocol) {
    var groups_arr = new Array();

    for (var group_id in settingsObjectGroupData) {
        var items_arr = new Array();

        for (var imei in settingsObjectData) {
            var object = settingsObjectData[imei];

            if (object.group_id == group_id) {
                if (object.active == "true") {
                    if (protocol == undefined || protocol == "") {
                        items_arr.push({ value: imei, name: object.name });
                    } else {
                        if (protocol == object.protocol) {
                            items_arr.push({ value: imei, name: object.name });
                        }
                    }
                }
            }
        }

        var group_name = settingsObjectGroupData[group_id].name;

        items_arr = sortArrayByElement(items_arr, "name");

        groups_arr.push({ name: group_name, id: group_id, items: items_arr });
    }

    groups_arr = sortArrayByElement(groups_arr, "name");

    // ungrouped goes to the top
    for (var key in groups_arr) {
        var group = groups_arr[key];

        if (group.id == 0) {
            arrayMove(groups_arr, key, 0);
        }
    }

    return groups_arr;
}

function getGroupsPlacesArray(places) {
    if (places == "markers") {
        var placesData = placesMarkerData["markers"];
    } else if (places == "routes") {
        var placesData = placesRouteData["routes"];
    } else if (places == "zones") {
        var placesData = placesZoneData["zones"];
    } else {
        return;
    }

    var groups_arr = new Array();

    for (var group_id in placesGroupData["groups"]) {
        var items_arr = new Array();

        for (var id in placesData) {
            var place = placesData[id];

            if (place.data.group_id == group_id) {
                items_arr.push({ value: id, name: place.data.name });
            }
        }

        var group_name = placesGroupData["groups"][group_id].name;

        items_arr = sortArrayByElement(items_arr, "name");

        groups_arr.push({ name: group_name, id: group_id, items: items_arr });
    }

    groups_arr = sortArrayByElement(groups_arr, "name");

    // ungrouped goes to the top
    for (var key in groups_arr) {
        var group = groups_arr[key];

        if (group.id == 0) {
            arrayMove(groups_arr, key, 0);
        }
    }

    return groups_arr;
}

// #################################################
// END GROUP LIST FUNCTIONS
// #################################################

// #################################################
// OTHER FUNCTIONS
// #################################################

// #################################################
// END OTHER FUNCTIONS
// #################################################

// #################################################
// DASHBOARD FUNCTIONS
// #################################################

var dashboardData = new Array(),
    timer_dashboardInit;
function dashboardOpen() {
    utilsCheckPrivileges("dashboard") && $("#dialog_dashboard").dialog("open"),
        dashboardInit(!1);
}
function dashboardResize() {
    var e = $(window).width() - 30,
        t = $(window).height() - 30;
    $("#dialog_dashboard").dialog("option", "width", e),
        $("#dialog_dashboard").dialog("option", "height", t),
        (e -= 30),
        (t -= 30),
        (dashboardData.container_height = (t - 36 - 10) / 2),
        (document.getElementById("dialog_dashboard_objects").style.height =
            dashboardData.container_height + "px"),
        (document.getElementById("dialog_dashboard_events").style.height =
            dashboardData.container_height + "px"),
        null != document.getElementById("dialog_dashboard_tasks") &&
        (document.getElementById("dialog_dashboard_tasks").style.height =
            dashboardData.container_height + "px"),
        null != document.getElementById("dialog_dashboard_maintenance") &&
        (document.getElementById("dialog_dashboard_maintenance").style.height =
            dashboardData.container_height + "px"),
        (document.getElementById("dialog_dashboard_odometer").style.height =
            dashboardData.container_height + "px"),
        (document.getElementById("dialog_dashboard_mileage").style.height =
            dashboardData.container_height + "px"),
        null != document.getElementById("dashboard_objects_graph_plot") &&
        (document.getElementById("dashboard_objects_graph_plot").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_objects_text") &&
        (document.getElementById("dashboard_objects_text").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_events_graph_plot") &&
        (document.getElementById("dashboard_events_graph_plot").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_events_text") &&
        (document.getElementById("dashboard_events_text").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_maintenance_graph_plot") &&
        (document.getElementById(
            "dashboard_maintenance_graph_plot"
        ).style.height = dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_maintenance_text") &&
        (document.getElementById("dashboard_maintenance_text").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_tasks_graph_plot") &&
        (document.getElementById("dashboard_tasks_graph_plot").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_tasks_text") &&
        (document.getElementById("dashboard_tasks_text").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_odometer_graph_plot") &&
        (document.getElementById("dashboard_odometer_graph_plot").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_odometer_text") &&
        (document.getElementById("dashboard_odometer_text").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_mileage_graph_plot") &&
        (document.getElementById("dashboard_mileage_graph_plot").style.height =
            dashboardData.container_height - 30 - 20 + "px"),
        null != document.getElementById("dashboard_mileage_text") &&
        (document.getElementById("dashboard_mileage_text").style.height =
            dashboardData.container_height - 30 - 20 + "px");
}
function dashboardInit(e) {
    1 == $("#dialog_dashboard").dialog("isOpen")
        ? (e
            ? (1 == settingsUserData.privileges_maintenance &&
                dashboardInitMaintenance(),
                1 == settingsUserData.privileges_tasks && dashboardInitTasks(),
                dashboardInitOdometer(),
                dashboardInitMileage())
            : (dashboardInitObjects(),
                dashboardInitEvents(),
                1 == settingsUserData.privileges_maintenance &&
                dashboardInitMaintenance(),
                1 == settingsUserData.privileges_tasks && dashboardInitTasks(),
                dashboardInitOdometer(),
                dashboardInitMileage()),
            clearTimeout(timer_dashboardInit),
            (timer_dashboardInit = setTimeout(
                "dashboardInit(true);",
                1e3 * gsValues.dashboard_refresh
            )))
        : clearTimeout(timer_dashboardInit);
}
function dashboardInitObjectsSetResult(e) {
    (dashboardData.objects_result = e), dashboardInitObjects();
}
function dashboardInitObjects() {
    if (Object.keys(objectsData).length > 0) {
        var e = [],
            t = 0,
            a = 0,
            i = 0,
            o = 0,
            s = 0;
        for (var n in objectsData) {
            var l = objectsData[n].status;
            0 == l
                ? (t += 1)
                : "off" == l
                    ? (a += 1)
                    : "s" == l
                        ? (i += 1)
                        : "m" == l
                            ? (o += 1)
                            : "i" == l && (s += 1);
        }
        e.push({
            label: la.NO_DATA,
            data: t,
        }),
            e.push({
                label: la.OFFLINE,
                data: a,
            }),
            e.push({
                label: la.STOPPED,
                data: i,
            }),
            e.push({
                label: la.MOVING,
                data: o,
            }),
            e.push({
                label: la.IDLE,
                data: s,
            });
        var d = '<div class="dashboard-container-header">';
        (d +=
            '<div class="dashboard-container-header-icon"><span class="icon-objects"></span></div>'),
            (d +=
                '<div class="dashboard-container-header-title">' +
                la.OBJECTS +
                "</div>"),
            (d +=
                '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_objects_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
            (d += '<div id="dashboard_objects_graph_plot"></div>'),
            (document.getElementById("dialog_dashboard_objects").innerHTML = d),
            (document.getElementById("dashboard_objects_graph_plot").style.height =
                dashboardData.container_height - 30 - 20 + "px");
        var r = $("#dashboard_objects_graph_plot");
        $.plot(r, e, {
            series: {
                pie: {
                    innerRadius: 0.5,
                    show: !0,
                    radius: 1,
                    label: {
                        show: !0,
                        radius: 0.75,
                        formatter: function (e, t) {
                            if ("percentage" == dashboardData.objects_result)
                                var a = Math.round(t.percent) + "%";
                            else a = t.data[0][1];
                            return (
                                "<div style='font-size:8pt; text-align:center; padding:2px; color:white;'>" +
                                e +
                                "<br/>" +
                                a +
                                "</div>"
                            );
                        },
                        background: {
                            opacity: 0.5,
                        },
                    },
                },
            },
            legend: {
                show: !1,
            },
        });
    } else {
        d = '<div class="dashboard-container-header">';
        (d +=
            '<div class="dashboard-container-header-icon"><span class="icon-objects"></span></div>'),
            (d +=
                '<div class="dashboard-container-header-title">' +
                la.OBJECTS +
                "</div>"),
            (d +=
                '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_objects_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
            (d +=
                '<div id="dashboard_objects_text" class="dashboard-container-text">' +
                la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                "</div>"),
            (document.getElementById("dialog_dashboard_objects").innerHTML = d),
            (document.getElementById("dashboard_objects_text").style.height =
                dashboardData.container_height - 30 - 20 + "px");
    }
    $("#dashboard_objects_action_menu_button").click(function () {
        return (
            $("#dashboard_events_action_menu").hide(),
            $("#dashboard_tasks_action_menu").hide(),
            $("#dashboard_objects_action_menu").toggle().position({
                my: "right top",
                at: "right-5 top+17",
                of: this,
            }),
            $(document).one("click", function () {
                $("#dashboard_objects_action_menu").hide();
            }),
            !1
        );
    });
}
function dashboardInitEventsSetPeriod(e) {
    (dashboardData.events_period = e), dashboardInitEvents();
}
function dashboardInitEvents() {
    if ("today" == dashboardData.events_period)
        var e = moment().format("YYYY-MM-DD") + " 00:00:00",
            t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00";
    else if ("this_week" == dashboardData.events_period)
        (e = moment().isoWeekday(1).format("YYYY-MM-DD") + " 00:00:00"),
            (t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00");
    else if ("this_month" == dashboardData.events_period)
        (e = moment().startOf("month").format("YYYY-MM-DD") + " 00:00:00"),
            (t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00");
    var a = {
        cmd: "load_events_data",
        period: dashboardData.events_period,
        dtf: e,
        dtt: t,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_dashboard.php",
        data: a,
        dataType: "json",
        cache: !1,
        success: function (e) {
            if (Object.keys(e).length > 0) {
                var t = [];
                for (var a in e) {
                    var i = e[a].name,
                        o = e[a].count;
                    t.push({
                        label: i,
                        data: o,
                    });
                }
                var s = la.EVENTS;
                "today" == dashboardData.events_period
                    ? (s += " (" + la.TODAY.toLowerCase() + ")")
                    : "this_week" == dashboardData.events_period
                        ? (s += " (" + la.THIS_WEEK.toLowerCase() + ")")
                        : "this_month" == dashboardData.events_period &&
                        (s += " (" + la.THIS_MONTH.toLowerCase() + ")");
                var n = '<div class="dashboard-container-header">';
                (n +=
                    '<div class="dashboard-container-header-icon"><span class="icon-route-event"></span></div>'),
                    (n +=
                        '<div class="dashboard-container-header-title">' + s + "</div>"),
                    (n +=
                        '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_events_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
                    (n += '<div id="dashboard_events_graph_plot"></div>'),
                    (document.getElementById("dialog_dashboard_events").innerHTML = n),
                    (document.getElementById("dashboard_events_graph_plot").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
                var l = $("#dashboard_events_graph_plot");
                $.plot(l, t, {
                    series: {
                        pie: {
                            innerRadius: 0.5,
                            show: !0,
                            radius: 1,
                            label: {
                                show: !0,
                                radius: 0.75,
                                formatter: function (e, t) {
                                    return (
                                        "<div style='font-size:8pt; text-align:center; padding:2px; color:white;'>" +
                                        e +
                                        "<br/>" +
                                        Math.round(t.percent) +
                                        "%</div>"
                                    );
                                },
                                background: {
                                    opacity: 0.5,
                                },
                            },
                        },
                    },
                    legend: {
                        show: !1,
                    },
                });
            } else {
                s = la.EVENTS;
                "today" == dashboardData.events_period
                    ? (s += " (" + la.TODAY.toLowerCase() + ")")
                    : "this_week" == dashboardData.events_period
                        ? (s += " (" + la.THIS_WEEK.toLowerCase() + ")")
                        : "this_month" == dashboardData.events_period &&
                        (s += " (" + la.THIS_MONTH.toLowerCase() + ")");
                n = '<div class="dashboard-container-header">';
                (n +=
                    '<div class="dashboard-container-header-icon"><span class="icon-route-event"></span></div>'),
                    (n +=
                        '<div class="dashboard-container-header-title">' + s + "</div>"),
                    (n +=
                        '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_events_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
                    (n +=
                        '<div id="dashboard_events_text" class="dashboard-container-text">' +
                        la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                        "</div>"),
                    (document.getElementById("dialog_dashboard_events").innerHTML = n),
                    (document.getElementById("dashboard_events_text").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
            }
            $("#dashboard_events_action_menu_button").click(function () {
                return (
                    $("#dashboard_objects_action_menu").hide(),
                    $("#dashboard_tasks_action_menu").hide(),
                    $("#dashboard_events_action_menu").toggle().position({
                        my: "right top",
                        at: "right-5 top+17",
                        of: this,
                    }),
                    $(document).one("click", function () {
                        $("#dashboard_events_action_menu").hide();
                    }),
                    !1
                );
            });
        },
    });
}
function dashboardInitMaintenance() {
    $.ajax({
        type: "POST",
        url: "func/fn_dashboard.php",
        data: {
            cmd: "load_maintenance_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            if (Object.keys(e).length > 0) {
                var t = [],
                    a = 0,
                    i = 0;
                for (var o in e) {
                    var s = e[o].odometer_left_val,
                        n = e[o].engine_hours_left_val,
                        l = e[o].days_left_val;
                    s < 0 || n < 0 || l < 0 ? (i += 1) : (a += 1);
                }
                t.push({
                    label: la.VALID,
                    data: a,
                    color: "#4DA74D",
                }),
                    t.push({
                        label: la.EXPIRED,
                        data: i,
                        color: "#CB4B4B",
                    });
                var d = '<div class="dashboard-container-header">';
                (d +=
                    '<a href="#" onclick="dashboardOpenMaintenance();"><div class="dashboard-container-header-icon"><span class="icon-maintenance"></span></div><div class="dashboard-container-header-title">' +
                    la.MAINTENANCE +
                    "</div></a></div>"),
                    (d += '<div id="dashboard_maintenance_graph_plot"></div>'),
                    (document.getElementById("dialog_dashboard_maintenance").innerHTML =
                        d),
                    (document.getElementById(
                        "dashboard_maintenance_graph_plot"
                    ).style.height = dashboardData.container_height - 30 - 20 + "px");
                var r = $("#dashboard_maintenance_graph_plot");
                $.plot(r, t, {
                    series: {
                        pie: {
                            innerRadius: 0.5,
                            show: !0,
                            radius: 1,
                            label: {
                                show: !0,
                                radius: 0.75,
                                formatter: function (e, t) {
                                    return (
                                        "<div style='font-size:8pt; text-align:center; padding:2px; color:white;'>" +
                                        e +
                                        "<br/>" +
                                        Math.round(t.percent) +
                                        "%</div>"
                                    );
                                },
                                background: {
                                    opacity: 0.5,
                                },
                            },
                        },
                    },
                    legend: {
                        show: !1,
                    },
                });
            } else {
                d = '<div class="dashboard-container-header">';
                (d +=
                    '<a href="#" onclick="dashboardOpenMaintenance();"><div class="dashboard-container-header-icon"><span class="icon-maintenance"></span></div><div class="dashboard-container-header-title">' +
                    la.MAINTENANCE +
                    "</div></a></div>"),
                    (d +=
                        '<div id="dashboard_maintenance_text" class="dashboard-container-text">' +
                        la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                        "</div>"),
                    (document.getElementById("dialog_dashboard_maintenance").innerHTML =
                        d),
                    (document.getElementById("dashboard_maintenance_text").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
            }
        },
    });
}
function dashboardInitTasksSetPeriod(e) {
    (dashboardData.tasks_period = e), dashboardInitTasks();
}
function dashboardInitTasks() {
    if ("today" == dashboardData.tasks_period)
        var e = moment().format("YYYY-MM-DD") + " 00:00:00",
            t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00";
    else if ("this_week" == dashboardData.tasks_period)
        (e = moment().isoWeekday(1).format("YYYY-MM-DD") + " 00:00:00"),
            (t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00");
    else if ("this_month" == dashboardData.tasks_period)
        (e = moment().startOf("month").format("YYYY-MM-DD") + " 00:00:00"),
            (t = moment().add("days", 1).format("YYYY-MM-DD") + " 00:00:00");
    var a = {
        cmd: "load_tasks_data",
        dtf: e,
        dtt: t,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_dashboard.php",
        data: a,
        dataType: "json",
        cache: !1,
        success: function (e) {
            if (Object.keys(e).length > 0) {
                var t = [];
                for (var a in e) {
                    var i = e[a].name,
                        o = e[a].count;
                    (color = ""),
                        0 == a
                            ? (color = "#AFD8F8")
                            : 1 == a
                                ? (color = "#EDC240")
                                : 2 == a
                                    ? (color = "#4DA74D")
                                    : 3 == a && (color = "#CB4B4B"),
                        t.push({
                            data: [[i, o]],
                            color: color,
                        });
                }
                var s = la.TASKS;
                "today" == dashboardData.tasks_period
                    ? (s += " (" + la.TODAY.toLowerCase() + ")")
                    : "this_week" == dashboardData.tasks_period
                        ? (s += " (" + la.THIS_WEEK.toLowerCase() + ")")
                        : "this_month" == dashboardData.tasks_period &&
                        (s += " (" + la.THIS_MONTH.toLowerCase() + ")");
                var n = '<div class="dashboard-container-header">';
                (n +=
                    '<a href="#" onclick="dashboardOpenTasks();"><div class="dashboard-container-header-icon"><span class="icon-tasks"></span></div>'),
                    (n +=
                        '<div class="dashboard-container-header-title">' +
                        s +
                        "</div></a>"),
                    (n +=
                        '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_tasks_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
                    (n +=
                        '<div id="dashboard_tasks_graph_plot" class="dashboard-container-graph-plot"></div>'),
                    (document.getElementById("dialog_dashboard_tasks").innerHTML = n),
                    (document.getElementById("dashboard_tasks_graph_plot").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
                var l = $("#dashboard_tasks_graph_plot");
                $.plot(l, t, {
                    series: {
                        bars: {
                            show: !0,
                            fill: !0,
                            barWidth: 0.5,
                            lineWidth: 0,
                            align: "center",
                            fillColor: {
                                colors: [
                                    {
                                        opacity: 1,
                                    },
                                    {
                                        opacity: 1,
                                    },
                                ],
                            },
                        },
                    },
                    xaxis: {
                        mode: "categories",
                        showTicks: !1,
                        gridLines: !1,
                    },
                });
            } else {
                s = la.TASKS;
                "today" == dashboardData.tasks_period
                    ? (s += " (" + la.TODAY.toLowerCase() + ")")
                    : "this_week" == dashboardData.tasks_period
                        ? (s += " (" + la.THIS_WEEK.toLowerCase() + ")")
                        : "this_month" == dashboardData.tasks_period &&
                        (s += " (" + la.THIS_MONTH.toLowerCase() + ")");
                n = '<div class="dashboard-container-header">';
                (n +=
                    '<a href="#" onclick="dashboardOpenTasks();"><div class="dashboard-container-header-icon"><span class="icon-tasks"></span></div>'),
                    (n +=
                        '<div class="dashboard-container-header-title">' +
                        s +
                        "</div></a>"),
                    (n +=
                        '<div class="dashboard-container-header-menu"><a href="#" id="dashboard_tasks_action_menu_button"><span class="icon-action2"></span></a></div></div>'),
                    (n +=
                        '<div id="dashboard_tasks_text" class="dashboard-container-text">' +
                        la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                        "</div>"),
                    (document.getElementById("dialog_dashboard_tasks").innerHTML = n),
                    (document.getElementById("dashboard_tasks_text").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
            }
            $("#dashboard_tasks_action_menu_button").click(function () {
                return (
                    $("#dashboard_objects_action_menu").hide(),
                    $("#dashboard_events_action_menu").hide(),
                    $("#dashboard_tasks_action_menu").toggle().position({
                        my: "right top",
                        at: "right-5 top+17",
                        of: this,
                    }),
                    $(document).one("click", function () {
                        $("#dashboard_tasks_action_menu").hide();
                    }),
                    !1
                );
            });
        },
    });
}
function dashboardInitOdometer() {
    $.ajax({
        type: "POST",
        url: "func/fn_dashboard.php",
        data: {
            cmd: "load_odometer_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            if (Object.keys(e).length > 0) {
                var t = [];
                for (var a in e)
                    t.push({
                        label: e[a].name,
                        data: [[e[a].name, e[a].odometer]],
                    });
                var i = '<div class="dashboard-container-header">';
                (i +=
                    '<div class="dashboard-container-header-icon"><span class="icon-odometer"></span></div><div class="dashboard-container-header-title">' +
                    la.ODOMETER_TOP_10 +
                    " (" +
                    la.UNIT_DISTANCE +
                    ")</div></div>"),
                    (i +=
                        '<div id="dashboard_odometer_graph_plot" class="dashboard-container-graph-plot"></div>'),
                    (document.getElementById("dialog_dashboard_odometer").innerHTML = i),
                    (document.getElementById(
                        "dashboard_odometer_graph_plot"
                    ).style.height = dashboardData.container_height - 30 - 20 + "px");
                var o = $("#dashboard_odometer_graph_plot");
                $.plot(o, t, {
                    legend: {
                        show: !0,
                        margin: 10,
                        backgroundOpacity: 0.5,
                        noColumns: 2,
                        position: "ne",
                        labelFormatter: function (e, t) {
                            return '<div style="color:#444444">' + e + "</div>";
                        },
                    },
                    series: {
                        bars: {
                            show: !0,
                            fill: !0,
                            barWidth: 0.5,
                            lineWidth: 0,
                            align: "center",
                            fillColor: {
                                colors: [
                                    {
                                        opacity: 1,
                                    },
                                    {
                                        opacity: 1,
                                    },
                                ],
                            },
                        },
                    },
                    yaxes: {
                        min: 0,
                    },
                    xaxis: {
                        show: !1,
                        mode: "categories",
                        showTicks: !1,
                        gridLines: !1,
                    },
                });
            } else {
                i = '<div class="dashboard-container-header">';
                (i +=
                    '<div class="dashboard-container-header-icon"><span class="icon-odometer"></span></div><div class="dashboard-container-header-title">' +
                    la.ODOMETER +
                    " (" +
                    la.UNIT_DISTANCE +
                    ")</div></div>"),
                    (i +=
                        '<div id="dashboard_odometer_text" class="dashboard-container-text">' +
                        la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                        "</div>"),
                    (document.getElementById("dialog_dashboard_odometer").innerHTML = i),
                    (document.getElementById("dashboard_odometer_text").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
            }
        },
    });
}
function dashboardInitMileage() {
    $.ajax({
        type: "POST",
        url: "func/fn_dashboard.php",
        data: {
            cmd: "load_mileage_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            if (Object.keys(e).length > 0) {
                var t = [];
                t.push([[e.mileage_dt_5, e.mileage_5]]),
                    t.push([[e.mileage_dt_4, e.mileage_4]]),
                    t.push([[e.mileage_dt_3, e.mileage_3]]),
                    t.push([[e.mileage_dt_2, e.mileage_2]]),
                    t.push([[e.mileage_dt_1, e.mileage_1]]);
                var a = '<div class="dashboard-container-header">';
                (a +=
                    '<div class="dashboard-container-header-icon"><span class="icon-odometer"></span></div><div class="dashboard-container-header-title">' +
                    la.MILEAGE +
                    " (" +
                    la.UNIT_DISTANCE +
                    ")</div></div>"),
                    (a +=
                        '<div id="dashboard_mileage_graph_plot" class="dashboard-container-graph-plot"></div>'),
                    (document.getElementById("dialog_dashboard_mileage").innerHTML = a),
                    (document.getElementById(
                        "dashboard_mileage_graph_plot"
                    ).style.height = dashboardData.container_height - 30 - 20 + "px");
                var i = $("#dashboard_mileage_graph_plot");
                $.plot(i, t, {
                    series: {
                        bars: {
                            show: !0,
                            fill: !0,
                            barWidth: 0.5,
                            lineWidth: 0,
                            align: "center",
                            fillColor: {
                                colors: [
                                    {
                                        opacity: 1,
                                    },
                                    {
                                        opacity: 1,
                                    },
                                ],
                            },
                        },
                    },
                    yaxes: {
                        min: 0,
                    },
                    xaxis: {
                        mode: "categories",
                        showTicks: !1,
                        gridLines: !1,
                    },
                });
            } else {
                a = '<div class="dashboard-container-header">';
                (a +=
                    '<div class="dashboard-container-header-icon"><span class="icon-odometer"></span></div><div class="dashboard-container-header-title">' +
                    la.MILEAGE +
                    " (" +
                    la.UNIT_DISTANCE +
                    ")</div></div>"),
                    (a +=
                        '<div id="dashboard_mileage_text" class="dashboard-container-text">' +
                        la.NO_DATA_HAS_BEEN_COLLECTED_YET +
                        "</div>"),
                    (document.getElementById("dialog_dashboard_mileage").innerHTML = a),
                    (document.getElementById("dashboard_mileage_text").style.height =
                        dashboardData.container_height - 30 - 20 + "px");
            }
        },
    });
}
function dashboardOpenMaintenance() {
    maintenanceOpen();
}
function dashboardOpenTasks() {
    tasksOpen();
}
(dashboardData.container_height = 0),
    (dashboardData.objects_result = "percentage"),
    (dashboardData.events_period = "today"),
    (dashboardData.tasks_period = "today");
var expensesData = new Array();

// #################################################
// END DASHBOARD FUNCTIONS
// #################################################

// #################################################
// DTC FUNCTIONS
// #################################################

function dtcOpen() {
    utilsCheckPrivileges("dtc") &&
        ($("#dialog_dtc")
            .bind("resize", function () {
                $("#dtc_list_grid").setGridHeight($("#dialog_dtc").height() - 133);
            })
            .trigger("resize"),
            $("#dialog_dtc")
                .bind("resize", function () {
                    $("#dtc_list_grid").setGridWidth($("#dialog_dtc").width());
                })
                .trigger("resize"),
            $("#dialog_dtc").dialog("open"));
}
function dtcClose() {
    $("#dialog_dtc").unbind("resize");
}
function dtcShow() {
    var e = "func/fn_dtc.php?cmd=load_dtc_list",
        t = document.getElementById("dialog_dtc_object_list").value,
        a =
            document.getElementById("dialog_dtc_date_from").value +
            " " +
            document.getElementById("dialog_dtc_hour_from").value +
            ":" +
            document.getElementById("dialog_dtc_minute_from").value +
            ":00",
        i =
            document.getElementById("dialog_dtc_date_to").value +
            " " +
            document.getElementById("dialog_dtc_hour_to").value +
            ":" +
            document.getElementById("dialog_dtc_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        a != i && (e += "&dtf=" + a + "&dtt=" + i),
        $("#dtc_list_grid")
            .jqGrid("setGridParam", {
                url: e,
            })
            .trigger("reloadGrid");
}
function dtcDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_record",
                    dtc_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_dtc.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && dtcShow();
                    },
                });
            }
        });
}
function dtcDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#dtc_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_records",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_dtc.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && dtcShow();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function dtcDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(
            la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_DTC_RECORDS,
            function (e) {
                if (e) {
                    $.ajax({
                        type: "POST",
                        url: "func/fn_dtc.php",
                        data: {
                            cmd: "delete_all_records",
                        },
                        success: function (e) {
                            "OK" == e && dtcShow();
                        },
                    });
                }
            }
        );
}
function dtcExportCSV() {
    var e = "func/fn_export.php?format=dtc_csv",
        t = document.getElementById("dialog_dtc_object_list").value,
        a =
            document.getElementById("dialog_dtc_date_from").value +
            " " +
            document.getElementById("dialog_dtc_hour_from").value +
            ":" +
            document.getElementById("dialog_dtc_minute_from").value +
            ":00",
        i =
            document.getElementById("dialog_dtc_date_to").value +
            " " +
            document.getElementById("dialog_dtc_hour_to").value +
            ":" +
            document.getElementById("dialog_dtc_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        a != i && (e += "&dtf=" + a + "&dtt=" + i),
        (window.location = e);
}

// #################################################
// DTC FUNCTIONS
// #################################################

// #################################################
// MAINTENANCE FUNCTIONS
// #################################################

function maintenanceOpen() {
    utilsCheckPrivileges("maintenance") &&
        ($("#dialog_maintenance")
            .bind("resize", function () {
                $("#maintenance_list_grid").setGridHeight(
                    $("#dialog_maintenance").height() - 81
                );
            })
            .trigger("resize"),
            $("#dialog_maintenance")
                .bind("resize", function () {
                    $("#maintenance_list_grid").setGridWidth(
                        $("#dialog_maintenance").width()
                    );
                })
                .trigger("resize"),
            $("#dialog_maintenance").dialog("open"),
            $("#maintenance_list_grid").trigger("reloadGrid"));
}
function maintenanceClose() {
    $("#dialog_maintenance").unbind("resize");
}
function maintenanceObjectServiceProperties(e, t) {
    (settingsEditData.object_imei = e), settingsObjectServiceProperties(t);
}
function maintenanceServiceProperties(e) {
    switch (e) {
        case "add":
            $("#dialog_maintenance_service_object_list option:selected").removeAttr(
                "selected"
            ),
                $("#dialog_maintenance_service_object_list").multipleSelect("refresh"),
                (document.getElementById("dialog_maintenance_service_name").value = ""),
                (document.getElementById(
                    "dialog_maintenance_service_data_list"
                ).checked = !1),
                (document.getElementById("dialog_maintenance_service_popup").checked =
                    !1),
                (document.getElementById("dialog_maintenance_service_odo").checked =
                    !1),
                (document.getElementById(
                    "dialog_maintenance_service_odo_interval"
                ).value = ""),
                (document.getElementById("dialog_maintenance_service_odo_last").value =
                    ""),
                (document.getElementById("dialog_maintenance_service_engh").checked =
                    !1),
                (document.getElementById(
                    "dialog_maintenance_service_engh_interval"
                ).value = ""),
                (document.getElementById("dialog_maintenance_service_engh_last").value =
                    ""),
                (document.getElementById("dialog_maintenance_service_days").checked =
                    !1),
                (document.getElementById(
                    "dialog_maintenance_service_days_interval"
                ).value = ""),
                (document.getElementById("dialog_maintenance_service_days_last").value =
                    ""),
                (document.getElementById(
                    "dialog_maintenance_service_odo_left"
                ).checked = !1),
                (document.getElementById(
                    "dialog_maintenance_service_odo_left_num"
                ).value = ""),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left"
                ).checked = !1),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left_num"
                ).value = ""),
                (document.getElementById(
                    "dialog_maintenance_service_days_left"
                ).checked = !1),
                (document.getElementById(
                    "dialog_maintenance_service_days_left_num"
                ).value = ""),
                (document.getElementById(
                    "dialog_maintenance_service_update_last"
                ).checked = !1),
                maintenanceServiceCheck(),
                $("#dialog_maintenance_service_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_maintenance_service_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var t = document.getElementById("dialog_maintenance_service_name").value,
                a = document.getElementById("dialog_maintenance_service_object_list"),
                i = document.getElementById(
                    "dialog_maintenance_service_data_list"
                ).checked,
                o = document.getElementById("dialog_maintenance_service_popup").checked,
                s = document.getElementById("dialog_maintenance_service_odo").checked,
                n = document.getElementById(
                    "dialog_maintenance_service_odo_interval"
                ).value,
                l = document.getElementById(
                    "dialog_maintenance_service_odo_last"
                ).value,
                d = document.getElementById("dialog_maintenance_service_engh").checked,
                r = document.getElementById(
                    "dialog_maintenance_service_engh_interval"
                ).value,
                _ = document.getElementById(
                    "dialog_maintenance_service_engh_last"
                ).value,
                c = document.getElementById("dialog_maintenance_service_days").checked,
                g = document.getElementById(
                    "dialog_maintenance_service_days_interval"
                ).value,
                m = document.getElementById(
                    "dialog_maintenance_service_days_last"
                ).value,
                u = document.getElementById(
                    "dialog_maintenance_service_odo_left"
                ).checked,
                p = document.getElementById(
                    "dialog_maintenance_service_odo_left_num"
                ).value,
                y = document.getElementById(
                    "dialog_maintenance_service_engh_left"
                ).checked,
                h = document.getElementById(
                    "dialog_maintenance_service_engh_left_num"
                ).value,
                v = document.getElementById(
                    "dialog_maintenance_service_days_left"
                ).checked,
                b = document.getElementById(
                    "dialog_maintenance_service_days_left_num"
                ).value,
                E = document.getElementById(
                    "dialog_maintenance_service_update_last"
                ).checked;
            if ("" == t) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.ALL_AVAILABLE_FIELDS_SHOULD_BE_FILLED_OUT
                );
                break;
            }
            if (!multiselectIsSelected(a))
                return void notifyBox(
                    "error",
                    la.ERROR,
                    la.AT_LEAST_ONE_OBJECT_SELECTED
                );
            if (1 == s && ("" == n || "" == l)) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.ALL_AVAILABLE_FIELDS_SHOULD_BE_FILLED_OUT
                );
                break;
            }
            if (1 == d && ("" == r || "" == _)) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.ALL_AVAILABLE_FIELDS_SHOULD_BE_FILLED_OUT
                );
                break;
            }
            if (1 == c && ("" == g || "" == m)) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.ALL_AVAILABLE_FIELDS_SHOULD_BE_FILLED_OUT
                );
                break;
            }
            if (parseFloat(n) <= parseFloat(p) && 1 == u) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.INTERVAL_VALUE_SHOULD_BE_GREATER_THAN_LEFT_VALUE
                );
                break;
            }
            if (parseFloat(r) <= parseFloat(h) && 1 == y) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.INTERVAL_VALUE_SHOULD_BE_GREATER_THAN_LEFT_VALUE
                );
                break;
            }
            if (parseFloat(g) <= parseFloat(b) && 1 == v) {
                notifyBox(
                    "error",
                    la.ERROR,
                    la.INTERVAL_VALUE_SHOULD_BE_GREATER_THAN_LEFT_VALUE
                );
                break;
            }
            var f = {
                cmd: "save_service",
                name: t,
                imei: multiselectGetValues(a),
                data_list: i,
                popup: o,
                odo: s,
                odo_interval: n,
                odo_last: l,
                engh: d,
                engh_interval: r,
                engh_last: _,
                days: c,
                days_interval: g,
                days_last: m,
                odo_left: u,
                odo_left_num: p,
                engh_left: y,
                engh_left_num: h,
                days_left: v,
                days_left_num: b,
                update_last: E,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_maintenance.php",
                data: f,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (settingsReloadObjects(),
                            $("#dialog_maintenance_service_properties").dialog("close"),
                            $("#maintenance_list_grid").trigger("reloadGrid"));
                },
            });
    }
}
function maintenanceServiceDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_service",
                    service_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_maintenance.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && $("#maintenance_list_grid").trigger("reloadGrid");
                    },
                });
            }
        });
}
function maintenanceServiceDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#maintenance_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_services",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_maintenance.php",
                            data: a,
                            success: function (e) {
                                "OK" == e &&
                                    $("#maintenance_list_grid").trigger("reloadGrid");
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function maintenanceServiceCheck() {
    1 == document.getElementById("dialog_maintenance_service_odo").checked
        ? ((document.getElementById(
            "dialog_maintenance_service_odo_interval"
        ).disabled = !1),
            (document.getElementById("dialog_maintenance_service_odo_last").disabled =
                !1),
            (document.getElementById("dialog_maintenance_service_odo_left").disabled =
                !1),
            (document.getElementById(
                "dialog_maintenance_service_odo_left_num"
            ).disabled = !1))
        : ((document.getElementById(
            "dialog_maintenance_service_odo_interval"
        ).disabled = !0),
            (document.getElementById("dialog_maintenance_service_odo_last").disabled =
                !0),
            (document.getElementById("dialog_maintenance_service_odo_left").disabled =
                !0),
            (document.getElementById(
                "dialog_maintenance_service_odo_left_num"
            ).disabled = !0)),
        1 == document.getElementById("dialog_maintenance_service_engh").checked
            ? ((document.getElementById(
                "dialog_maintenance_service_engh_interval"
            ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_engh_last"
                ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left"
                ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left_num"
                ).disabled = !1))
            : ((document.getElementById(
                "dialog_maintenance_service_engh_interval"
            ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_engh_last"
                ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left"
                ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_engh_left_num"
                ).disabled = !0)),
        1 == document.getElementById("dialog_maintenance_service_days").checked
            ? ((document.getElementById(
                "dialog_maintenance_service_days_interval"
            ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_days_last"
                ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_days_left"
                ).disabled = !1),
                (document.getElementById(
                    "dialog_maintenance_service_days_left_num"
                ).disabled = !1))
            : ((document.getElementById(
                "dialog_maintenance_service_days_interval"
            ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_days_last"
                ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_days_left"
                ).disabled = !0),
                (document.getElementById(
                    "dialog_maintenance_service_days_left_num"
                ).disabled = !0)),
        1 == document.getElementById("dialog_maintenance_service_odo").checked ||
            1 == document.getElementById("dialog_maintenance_service_engh").checked ||
            1 == document.getElementById("dialog_maintenance_service_days").checked
            ? (document.getElementById(
                "dialog_maintenance_service_update_last"
            ).disabled = !1)
            : (document.getElementById(
                "dialog_maintenance_service_update_last"
            ).disabled = !0);
}

// #################################################
// END MAINTENANCE FUNCTIONS
// #################################################

// #################################################
// EXPENSES FUNCTIONS
// #################################################

function expensesOpen() {
    utilsCheckPrivileges("expenses") &&
        ($("#dialog_expenses")
            .bind("resize", function () {
                $("#expenses_list_grid").setGridHeight(
                    $("#dialog_expenses").height() - 81
                );
            })
            .trigger("resize"),
            $("#dialog_expenses")
                .bind("resize", function () {
                    $("#expenses_list_grid").setGridWidth($("#dialog_expenses").width());
                })
                .trigger("resize"),
            $("#dialog_expenses").dialog("open"),
            $("#expenses_list_grid").trigger("reloadGrid"));
}
function expensesClose() {
    $("#dialog_expenses").unbind("resize");
}
function expensesObjectChange() {
    var e = document.getElementById("dialog_expense_object_list").value;
    void 0 !== settingsObjectData[e] &&
        ((document.getElementById("dialog_expense_odo").value =
            settingsObjectData[e].odometer),
            (document.getElementById("dialog_expense_engh").value =
                settingsObjectData[e].engine_hours));
}
function expensesDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_expense",
                    expense_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_expenses.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && $("#expenses_list_grid").trigger("reloadGrid");
                    },
                });
            }
        });
}
function expensesDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#expenses_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_expenses",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_expenses.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && $("#expenses_list_grid").trigger("reloadGrid");
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function expensesProperties(e) {
    switch (e) {
        default:
            var t = e;
            expensesData.edit_expense_id = t;
            var a = {
                cmd: "load_expense",
                expense_id: expensesData.edit_expense_id,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_expenses.php",
                data: a,
                dataType: "json",
                cache: !1,
                success: function (e) {
                    (document.getElementById("dialog_expense_name").value = e.name),
                        (document.getElementById("dialog_expense_object_list").value =
                            e.imei),
                        $("#dialog_expense_object_list").multipleSelect("refresh"),
                        (document.getElementById("dialog_expense_date").value =
                            e.dt_expense),
                        (document.getElementById("dialog_expense_quantity").value =
                            e.quantity),
                        (document.getElementById("dialog_expense_cost").value = e.cost),
                        (document.getElementById("dialog_expense_supplier").value =
                            e.supplier),
                        (document.getElementById("dialog_expense_buyer").value = e.buyer),
                        (document.getElementById("dialog_expense_odo").value = e.odometer),
                        (document.getElementById("dialog_expense_engh").value =
                            e.engine_hours),
                        (document.getElementById("dialog_expense_desc").value = e.desc);
                },
            }),
                $("#dialog_expense_properties").dialog("open");
            break;
        case "add":
            (expensesData.edit_expense_id = !1),
                (document.getElementById("dialog_expense_name").value = ""),
                $("#dialog_expense_object_list option:selected").removeAttr("selected"),
                $("#dialog_expense_object_list").multipleSelect("refresh"),
                (document.getElementById("dialog_expense_date").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById("dialog_expense_quantity").value = "0"),
                (document.getElementById("dialog_expense_cost").value = "0"),
                (document.getElementById("dialog_expense_supplier").value = ""),
                (document.getElementById("dialog_expense_buyer").value = ""),
                (document.getElementById("dialog_expense_odo").value = ""),
                (document.getElementById("dialog_expense_engh").value = ""),
                (document.getElementById("dialog_expense_desc").value = ""),
                expensesObjectChange(),
                $("#dialog_expense_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_expense_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var i = document.getElementById("dialog_expense_name").value,
                o = document.getElementById("dialog_expense_object_list").value,
                s = document.getElementById("dialog_expense_date").value,
                n = document.getElementById("dialog_expense_quantity").value,
                l = document.getElementById("dialog_expense_cost").value,
                d = document.getElementById("dialog_expense_supplier").value,
                r = document.getElementById("dialog_expense_buyer").value,
                _ = document.getElementById("dialog_expense_odo").value,
                c = document.getElementById("dialog_expense_engh").value,
                g = document.getElementById("dialog_expense_desc").value;
            if ("" == i)
                return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
            if ("" == o) {
                notifyBox("error", la.ERROR, la.NO_OBJECT_SELECTED);
                break;
            }
            if ("" == s)
                return void notifyBox("error", la.ERROR, la.DATE_CANT_BE_EMPTY);
            a = {
                cmd: "save_expense",
                expense_id: expensesData.edit_expense_id,
                name: i,
                imei: o,
                date: s,
                quantity: n,
                cost: l,
                supplier: d,
                buyer: r,
                odometer: _,
                engine_hours: c,
                desc: g,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_expenses.php",
                data: a,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        ($("#dialog_expense_properties").dialog("close"),
                            $("#expenses_list_grid").trigger("reloadGrid"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}

// #################################################
// END EXPENSES FUNCTIONS
// #################################################

function datalistBottomResize() {
    void 0 !== settingsUserData &&
        "bottom_panel" == settingsUserData.datalist &&
        ("none" == document.getElementById("side_panel").style.display
            ? ($("#bottom_panel_datalist_object_data_list").css(
                "width",
                $(window).width() - 24
            ),
                $("#bottom_panel_datalist_event_data_list").css(
                    "width",
                    $(window).width() - 24
                ),
                $("#bottom_panel_datalist_route_data_list").css(
                    "width",
                    $(window).width() - 24
                ))
            : ($("#bottom_panel_datalist_object_data_list").css(
                "width",
                $(window).width() - 384
            ),
                $("#bottom_panel_datalist_event_data_list").css(
                    "width",
                    $(window).width() - 384
                ),
                $("#bottom_panel_datalist_route_data_list").css(
                    "width",
                    $(window).width() - 384
                )),
            $("#bottom_panel_datalist_object_data_list").css(
                "height",
                guiDragbars.bottom_panel - 51
            ),
            $("#bottom_panel_datalist_event_data_list").css(
                "height",
                guiDragbars.bottom_panel - 51
            ),
            $("#bottom_panel_datalist_route_data_list").css(
                "height",
                guiDragbars.bottom_panel - 51
            ));
}

function datalistBottomAddItem(e, t, a, i) {
    var o = '<div class="datalist-item ' + e + '">';
    return (
        (o +=
            0 == t
                ? '<span class="datalist-item-icon"></span>'
                : '<span class="datalist-item-icon ' + t + '"></span>'),
        (o += '<div class="datalist-item-name">' + a + "</div>"),
        (o += '<div class="datalist-item-value">' + i + "</div>"),
        (o += "</div>")
    );
}
function datalistClear(e) {
    // // console.log("datalistClear", e)
    if ("bottom_panel" == settingsUserData.datalist)
        switch (e) {
            case "object":
                document.getElementById(
                    "bottom_panel_datalist_object_data_list"
                ).innerHTML =
                    '<div class="data-item-text">' + la.NO_OBJECT_SELECTED + "</div>";
                break;
            case "event":
                document.getElementById(
                    "bottom_panel_datalist_event_data_list"
                ).innerHTML =
                    '<div class="data-item-text">' + la.NO_EVENT_SELECTED + "</div>";
                break;
            case "route":
                document.getElementById(
                    "bottom_panel_datalist_route_data_list"
                ).innerHTML =
                    '<div class="data-item-text">' + la.NO_HISTORY_LOADED + "</div>";
        }
    else
        switch (e) {
            case "object":
                $("#side_panel_objects_object_data_list_grid").clearGridData(!0);
                break;
            case "event":
                $("#side_panel_events_event_datalist_grid").clearGridData(!0);
                break;
            case "route":
                $("#side_panel_history_route_datalist_grid").clearGridData(!0);
        }
}

function datalistShowData(e, t, a) {
    if ("bottom_panel" != settingsUserData.datalist) {
        var i = [],
            o = "",
            s = "",
            n = settingsUserData.datalist_items.split(",");
        switch (e) {
            case "object":
                (s = "side_panel_objects_object_data_list_grid"),
                    (o = $("#side_panel_objects_object_data_list_grid"));
                break;
            case "event":
                (s = "side_panel_events_event_datalist_grid"),
                    (o = $("#side_panel_events_event_datalist_grid"));
                break;
            case "route":
                (s = "side_panel_history_route_datalist_grid"),
                    (o = $("#side_panel_history_route_datalist_grid"));
        }

        for (var l = 0; l < 5; l++)
            null != document.getElementById(s + "ghead_0_" + l) &&
                ($("#" + s + "ghead_0_" + l)
                    .find("span")
                    .hasClass("ui-icon-circlesmall-minus")
                    ? (gsValues.datalist_groups_colapsed[e][l] = !1)
                    : (gsValues.datalist_groups_colapsed[e][l] = !0));
        var d = o.closest(".ui-jqgrid-bdiv").scrollTop();
        if ((o.clearGridData(!0), "" != a)) {
            var r = a.dt_server,
                _ = a.dt_tracker,
                c = a.lat,
                g = a.lng,
                m = a.speed,
                u = a.altitude,
                p = a.angle,
                y = ((m = a.speed), a.params);
            // // console.log(_, c, g, m, u, p, y);
            switch (e) {
                case "object":
                    if (-1 !== n.indexOf("odometer"))
                        -1 != (I = getObjectOdometer(t, !1)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ODOMETER,
                                value: I + " " + la.UNIT_DISTANCE,
                            });
                    if (-1 !== n.indexOf("engine_hours"))
                        -1 != (B = getObjectEngineHours(t, !1)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ENGINE_HOURS,
                                value: B,
                            });
                    if (-1 !== n.indexOf("status")) {
                        var h = objectsData[t].status_string;
                        "" != h &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.STATUS,
                                value: h,
                            });
                    }
                    -1 !== n.indexOf("time_position") &&
                        i.push({
                            group_name: la.LOCATION,
                            data: la.TIME_POSITION,
                            value: _,
                        }),
                        -1 !== n.indexOf("time_server") &&
                        i.push({
                            group_name: la.LOCATION,
                            data: la.TIME_SERVER,
                            value: r,
                        });
                    var v = objectsData[t].service;
                    for (var b in v)
                        "true" == v[b].data_list &&
                            i.push({
                                group_name: la.SERVICE,
                                data: v[b].name,
                                value: v[b].status,
                            });
                    var E = settingsObjectData[t]?.custom_fields;
                    for (var b in E) {
                        var f = E[b];
                        "true" == f.data_list &&
                            i.push({
                                group_name: la.GENERAL,
                                data: f.name,
                                value: textToLinks(f.value),
                            });
                    }
                    break;
                case "event":
                    if (-1 !== n.indexOf("odometer"))
                        -1 != (I = getObjectOdometer(t, a.params)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ODOMETER,
                                value: I + " " + la.UNIT_DISTANCE,
                            });
                    if (-1 !== n.indexOf("engine_hours"))
                        -1 != (B = getObjectEngineHours(t, a.params)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ENGINE_HOURS,
                                value: B,
                            });
                    -1 !== n.indexOf("time_position") &&
                        i.push({
                            group_name: la.LOCATION,
                            data: la.TIME_POSITION,
                            value: _,
                        }),
                        -1 !== n.indexOf("time_server") &&
                        i.push({
                            group_name: la.LOCATION,
                            data: la.TIME_SERVER,
                            value: r,
                        });
                    break;
                case "route":
                    var I, B;
                    if (-1 !== n.indexOf("odometer"))
                        -1 != (I = getObjectOdometer(t, a.params)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ODOMETER,
                                value: I + " " + la.UNIT_DISTANCE,
                            });
                    if (-1 !== n.indexOf("engine_hours"))
                        -1 != (B = getObjectEngineHours(t, a.params)) &&
                            i.push({
                                group_name: la.GENERAL,
                                data: la.ENGINE_HOURS,
                                value: B,
                            });
            }
            if (-1 !== n.indexOf("model")) {
                var D = settingsObjectData[t]?.model;
                "" != D &&
                    i.push({
                        group_name: la.GENERAL,
                        data: la.MODEL,
                        value: D,
                    });
            }
            if (-1 !== n.indexOf("vin")) {
                var O = settingsObjectData[t]?.vin;
                "" != O &&
                    i.push({
                        group_name: la.GENERAL,
                        data: la.VIN,
                        value: O,
                    });
            }
            if (-1 !== n.indexOf("plate_number")) {
                var k = settingsObjectData[t]?.plate_number;
                "" != k &&
                    i.push({
                        group_name: la.GENERAL,
                        data: la.PLATE,
                        value: k,
                    });
            }
            if (-1 !== n.indexOf("sim_number") && 1 == gsValues.sim_number) {
                var j = settingsObjectData[t].sim_number;
                "" != j &&
                    i.push({
                        group_name: la.GENERAL,
                        data: la.SIM_CARD_NUMBER,
                        value: j,
                    });
            }
            if (-1 !== n.indexOf("driver")) {
                var T = getDriver(t, a.params);
                if (0 != T) {
                    var R =
                        '<a href="#" onclick="utilsShowDriverInfo(\'' +
                        T.driver_id +
                        "');\">" +
                        T.name +
                        "</a>";
                    i.push({
                        group_name: la.GENERAL,
                        data: la.DRIVER,
                        value: R,
                    });
                }
            }
            if (-1 !== n.indexOf("trailer")) {
                var S = getTrailer(t, a.params);
                if (0 != S) {
                    var w =
                        '<a href="#" onclick="utilsShowTrailerInfo(\'' +
                        S.trailer_id +
                        "');\">" +
                        S.name +
                        "</a>";
                    i.push({
                        group_name: la.GENERAL,
                        data: la.TRAILER,
                        value: w,
                    });
                }
            }
            switch (e) {
                case "object":
                    if (
                        -1 !== n.indexOf("address") &&
                        1 == gsValues.address_display_object_data_list
                    ) {
                        // // console.log(c, g, e, t)
                        geocoderGetAddress(c, g, function (e) {
                            (document.getElementById(s + "_address").innerHTML = e),
                                (document.getElementById(s + "_address").title = e),
                                (objectsData[t].address = e);
                        });
                        var L =
                            '<span id="' +
                            s +
                            '_address">' +
                            objectsData[t].address +
                            "</span>";
                        i.push({
                            group_name: la.LOCATION,
                            data: la.ADDRESS,
                            value: L,
                        });
                    }
                    break;
                case "event":
                    if (
                        -1 !== n.indexOf("address") &&
                        1 == gsValues.address_display_event_data_list
                    ) {
                        geocoderGetAddress(c, g, function (e) {
                            // // console.log(c, g, e, t)
                            (document.getElementById(s + "_address").innerHTML = e),
                                (document.getElementById(s + "_address").title = e),
                                (objectsData[t].address = e);
                        });
                        L =
                            '<span id="' +
                            s +
                            '_address">' +
                            objectsData[t].address +
                            "</span>";
                        i.push({
                            group_name: la.LOCATION,
                            data: la.ADDRESS,
                            value: L,
                        });
                    }
                    break;
                case "route":
                    if (
                        -1 !== n.indexOf("address") &&
                        1 == gsValues.address_display_history_route_data_list
                    ) {
                        geocoderGetAddress(c, g, function (e) {
                            // // console.log(c, g, e, t)
                            (document.getElementById(s + "_address").innerHTML = e),
                                (document.getElementById(s + "_address").title = e),
                                (objectsData[t].address = e);
                        });
                        L =
                            '<span id="' +
                            s +
                            '_address">' +
                            objectsData[t].address +
                            "</span>";
                        i.push({
                            group_name: la.LOCATION,
                            data: la.ADDRESS,
                            value: L,
                        });
                    }
            }
            if (-1 !== n.indexOf("position")) {
                var A = urlPosition(c, g);
                // // console.log(c, g, A, t)
                i.push({
                    group_name: la.LOCATION,
                    data: la.POSITION,
                    value: A,
                });
            }
            if (
                (-1 !== n.indexOf("speed") &&
                    i.push({
                        group_name: la.LOCATION,
                        data: la.SPEED,
                        value: m + " " + la.UNIT_SPEED,
                    }),
                    -1 !== n.indexOf("altitude") &&
                    i.push({
                        group_name: la.LOCATION,
                        data: la.ALTITUDE,
                        value: u + " " + la.UNIT_HEIGHT,
                    }),
                    -1 !== n.indexOf("angle") &&
                    i.push({
                        group_name: la.LOCATION,
                        data: la.ANGLE,
                        value: p + " &deg;",
                    }),
                    -1 !== n.indexOf("nearest_zone"))
            ) {
                var x = getNearestZone(t, c, g);
                "" != x.name &&
                    i.push({
                        group_name: la.LOCATION,
                        data: la.NEAREST_ZONE,
                        value: x.name + " (" + x.distance + ")",
                    });
            }
            if (-1 !== n.indexOf("nearest_marker")) {
                var N = getNearestMarker(t, c, g);
                "" != N.name &&
                    i.push({
                        group_name: la.LOCATION,
                        data: la.NEAREST_MARKER,
                        value: N.name + " (" + N.distance + ")",
                    });
            }
            var C = settingsObjectData[t].sensors;
            for (var b in C) {
                var M = C[b];
                if ("true" == M.data_list)
                    if ("fuelsumup" == M.type) {
                        var P = getSensorValueFuelLevelSumUp(t, y, M);
                        i.push({
                            group_name: la.SENSORS,
                            data: M.name,
                            value: P.value_full,
                        });
                    } else {
                        P = getSensorValue(y, M);
                        i.push({
                            group_name: la.SENSORS,
                            data: M.name,
                            value: P.value_full,
                        });
                    }
            }
            for (l = 0; l < i.length; l++) o.jqGrid("addRowData", l, i[l]);
            o.setGridParam({
                sortname: "data",
                sortorder: "asc",
            }).trigger("reloadGrid");
            for (l = 0; l < gsValues.datalist_groups_colapsed[e].length; l++)
                null != document.getElementById(s + "ghead_0_" + l) &&
                    1 == gsValues.datalist_groups_colapsed[e][l] &&
                    o.jqGrid("groupingToggle", s + "ghead_0_" + l);
            o.closest(".ui-jqgrid-bdiv").scrollTop(d);
        }
    } else datalistBottomShowData(e, t, a);
}

// #################################################
// BILLING FUNCTIONS
// #################################################

var billingData = new Array(),
    timer_billingLoadData;
billingData.plan = new Array();
(expensesData.edit_expense_id = !1),
    $(window)
        .bind("resize", function () {
            datalistBottomResize();
        })
        .trigger("resize");
function billingOpen() {
    utilsCheckPrivileges("subuser") && $("#dialog_billing").dialog("open");
}
function billingClose() { }
function billingLoadData() {
    clearTimeout(timer_billingLoadData),
        (timer_billingLoadData = setTimeout(
            "billingLoadData();",
            1e3 * gsValues.billing_refresh
        )),
        billingUpdateCount(),
        1 == $("#dialog_billing").dialog("isOpen") && billingReload();
}
function billingReload() {
    $("#billing_plan_list_grid").trigger("reloadGrid");
}
function billingUpdateCount() {
    $.ajax({
        type: "POST",
        url: "func/fn_billing.php",
        data: {
            cmd: "get_billing_plan_total_objects",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            null != document.getElementById("billing_plan_count") &&
                (document.getElementById("billing_plan_count").innerHTML = e.objects);
        },
    });
}
function billingPlanPurchase() {
    if (utilsCheckPrivileges("viewer") && utilsCheckPrivileges("subuser")) {
        $.ajax({
            type: "POST",
            url: "func/fn_billing.php",
            data: {
                cmd: "load_billing_plan_purchase_list",
            },
            cache: !1,
            success: function (e) {
                "" == e
                    ? notifyBox("error", la.ERROR, la.NO_BILLING_PLANS_FOUND)
                    : ((document.getElementById("billing_plan_purchase_list").innerHTML =
                        e),
                        $("#dialog_billing_plan_purchase").dialog("open"));
            },
        });
    }
}
function billingPlanUse(e) {
    if (utilsCheckPrivileges("subuser")) {
        billingPlanUseObjectLoadList();
        var t = {
            cmd: "load_billing_plan",
            plan_id: e,
        };
        $.ajax({
            type: "POST",
            url: "func/fn_billing.php",
            data: t,
            dataType: "json",
            cache: !1,
            success: function (e) {
                if (
                    ((billingData.plan = e),
                        (document.getElementById(
                            "dialog_billing_plan_use_objects"
                        ).innerHTML = billingData.plan.objects),
                        1 == billingData.plan.period)
                )
                    var t = la[billingData.plan.period_type.slice(0, -1).toUpperCase()];
                else t = la[billingData.plan.period_type.toUpperCase()];
                var a = billingData.plan.period + " " + t.toLowerCase();
                (document.getElementById("dialog_billing_plan_use_period").innerHTML =
                    a),
                    (document.getElementById(
                        "dialog_billing_plan_use_selected"
                    ).innerHTML = 0),
                    $("#dialog_billing_plan_use").dialog(
                        "option",
                        "title",
                        la.BILLING_PLAN + " - " + billingData.plan.name
                    ),
                    $("#dialog_billing_plan_use").dialog("open");
            },
        });
    }
}
function billingPlanUseObjectLoadList() {
    var e = $("#billing_plan_object_list_grid");
    for (var t in (e.clearGridData(!0), settingsObjectData)) {
        var a = settingsObjectData[t],
            i = a.name.toLowerCase(),
            o = a.name,
            s = a.active,
            n = a.object_expire,
            l = a.object_expire_dt;
        (s =
            "true" == s
                ? '<img src="theme/images/tick-green.svg" />'
                : '<img src="theme/images/remove-red.svg" style="width:12px;" />'),
            "true" == n &&
            e.jqGrid("addRowData", t, {
                name_sort: i,
                name: o,
                imei: t,
                active: s,
                object_expire_dt: l,
            });
    }
    e.setGridParam({
        sortname: "name_sort",
        sortorder: "asc",
    }).trigger("reloadGrid");
}
function billingPlanUseUpdateSelection() {
    var e = $("#billing_plan_object_list_grid").jqGrid(
        "getGridParam",
        "selarrrow"
    ),
        t = e.length;
    t > billingData.plan.objects
        ? ((document.getElementById(
            "dialog_billing_plan_use_objects"
        ).innerHTML = 0),
            (document.getElementById("dialog_billing_plan_use_selected").innerHTML =
                e.length + ' <font color="red">(' + la.TOO_MANY + ")</font>"))
        : ((document.getElementById("dialog_billing_plan_use_objects").innerHTML =
            billingData.plan.objects - t),
            (document.getElementById("dialog_billing_plan_use_selected").innerHTML =
                e.length));
}
function billingPlanUseActivate() {
    if (utilsCheckPrivileges("viewer") && utilsCheckPrivileges("subuser")) {
        var e = $("#billing_plan_object_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        if ("" != e) {
            var t = e.length;
            if (t > billingData.plan.objects)
                notifyBox("error", la.ERROR, la.TOO_MANY_OBJECTS_SELECTED);
            else {
                var a = !1;
                for (i = 0; i < t; i++) {
                    var o = e[i];
                    if ("true" == settingsObjectData[o].active) {
                        a = !0;
                        break;
                    }
                }
                var s = la.ARE_YOU_SURE_YOU_WANT_TO_ACTIVATE_SELECTED_OBJECTS;
                a && (s = la.THERE_ARE_STILL_ACTIVE_OBJECTS + " " + s),
                    confirmDialog(s, function (a) {
                        if (a) {
                            var i = JSON.stringify(e),
                                o = {
                                    cmd: "use_billing_plan",
                                    plan: billingData.plan,
                                    imeis: i,
                                };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_billing.php",
                                data: o,
                                cache: !1,
                                success: function (e) {
                                    "OK" == e
                                        ? (loadSettings("objects", function () {
                                            objectReloadData(),
                                                billingReload(),
                                                billingPlanUseObjectLoadList(),
                                                billingUpdateCount(),
                                                (billingData.plan.objects -= t),
                                                billingPlanUseUpdateSelection();
                                        }),
                                            notifyBox(
                                                "info",
                                                la.INFORMATION,
                                                la.OBJECTS_ACTIVATED_SUCCESSFULLY
                                            ))
                                        : "ERROR_VERIFY" == e
                                            ? notifyBox("error", la.ERROR, la.PLAN_VERIFICATION_FAILED)
                                            : "ERROR_ACTIVATE" == e &&
                                            notifyBox("error", la.ERROR, la.OBJECT_ACTIVATION_FAILED);
                                },
                            });
                        }
                    });
            }
        } else notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function billingPlanDelete(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_billing_plan",
                    plan_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_billing.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && billingReload();
                    },
                });
            }
        });
}

// #################################################
// END BILLING FUNCTIONS
// #################################################

// #################################################
// CHAT FUNCTIONS
// #################################################

// var chatData = new Array, timer_chatLoadData, timer_chatMsgsDTHide;
// chatData.imei = !1,
//     chatData.first_msg_id = !1,
//     chatData.last_msg_id = !1,
//     chatData.msg_count = new Array;
var chatMsgsScrollHandler = function () {
    0 == $(this).scrollTop() &&
        0 != chatData.first_msg_id &&
        chatLoadMsgs("old"),
        $("#chat_msgs div").each(function () {
            if ($(this).position().top > 0) {
                var e = $(this).attr("title");
                if (null != e && e.length > 10)
                    return (
                        "none" == document.getElementById("chat_msgs_dt").style.display &&
                        (document.getElementById("chat_msgs_dt").style.display =
                            "block"),
                        clearTimeout(timer_chatMsgsDTHide),
                        (timer_chatMsgsDTHide = setTimeout(function () {
                            $("#chat_msgs_dt").fadeOut("slow");
                        }, 3e3)),
                        (document.getElementById("chat_msgs_dt").innerHTML = e.substring(
                            0,
                            10
                        )),
                        !1
                    );
            }
        });
},
    timer_imgLoadData;
function chatOpen() {
    utilsCheckPrivileges("chat") &&
        ($("#dialog_chat").bind("resize", function () {
            scrollToBottom("chat_msgs");
        }),
            $("#dialog_chat")
                .bind("resize", function () {
                    $("#chat_object_list_grid").setGridHeight(
                        $("#dialog_chat").height() - 84
                    );
                })
                .trigger("resize"),
            $("#dialog_chat").dialog("open"),
            $("#chat_msgs").scroll(chatMsgsScrollHandler),
            chatLoadObjectList());
}
function chatClose() {
    (chatData.imei = !1),
        (chatData.first_msg_id = !1),
        (chatData.last_msg_id = !1),
        (document.getElementById("chat_msg").disabled = !0),
        chatClear(),
        $("#dialog_chat").unbind("resize"),
        $("#chat_msgs").off("scroll", chatMsgsScrollHandler);
}
function chatClear() {
    (document.getElementById("chat_msgs_dt").style.display = "none"),
        (document.getElementById("chat_msgs_dt").innerHTML = ""),
        (document.getElementById("chat_msgs_text").innerHTML = ""),
        (document.getElementById("chat_msg_status").innerHTML = ""),
        (document.getElementById("chat_msg").value = "");
}
function chatLoadData() {
    clearTimeout(timer_chatLoadData);
    var e = {
        cmd: "load_chat_data",
        imei: chatData.imei,
        last_msg_id: chatData.last_msg_id,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_chat.php",
        data: e,
        dataType: "json",
        error: function (e, t) {
            timer_chatLoadData = setTimeout(
                "chatLoadData();",
                1e3 * gsValues.chat_refresh
            );
        },
        success: function (e) {
            (chatData.msg_count = e.msg_count),
                (chatData.msg_dt = e.msg_dt),
                chatUpdateMsgCount(),
                chatUpdateMsgDt(),
                0 != e.last_msg_status &&
                chatUpdateMsgDeliveryStatus(e.last_msg_status);
            var t = chatData.imei;
            null != chatData.msg_count[t] && chatLoadMsgs("new"),
                (timer_chatLoadData = setTimeout(
                    "chatLoadData();",
                    1e3 * gsValues.chat_refresh
                ));
        },
    });
}
function chatReloadData() {
    chatLoadObjectList(), chatLoadData();
}
function chatIsObjectCompatible(e) {
    return (
        null != objectsData[e] &&
        "" != objectsData[e].data &&
        null != objectsData[e].data[0].params &&
        null != objectsData[e].data[0].params.chat
    );
}
function chatLoadObjectList() {
    var e = $("#chat_object_list_grid");
    for (var t in (e.clearGridData(!0), settingsObjectData)) {
        var a = settingsObjectData[t];
        if ("true" == a.active && chatIsObjectCompatible(t)) {
            var i = '<img src="' + a.icon + '" style="width: 26px;"/>',
                o =
                    '<div class="object-list-item"><div class="left"><div class="name">' +
                    a.name +
                    '</div><div class="status" id="chat_object_msg_status_' +
                    t +
                    '">' +
                    la.NO_MESSAGES +
                    "</div></div>";
            (o +=
                '<div class="right" id="chat_object_msg_count_' + t + '"></div></div>'),
                e.jqGrid("addRowData", t, {
                    search: a.name.toLowerCase(),
                    icon: i,
                    name: o,
                });
        }
    }
    e.setGridParam({
        sortname: "search",
        sortorder: "asc",
    }).trigger("reloadGrid");
}
function chatUpdateMsgCount() {
    var e = 0;
    if (null != document.getElementById("chat_msg_count")) {
        for (var t in chatData.msg_count) {
            if (chatIsObjectCompatible(t)) e += chatData.msg_count[t];
        }
        if (e > 0 && "0" == document.getElementById("chat_msg_count").innerHTML)
            if ("" != settingsUserData.chat_notify)
                new Audio("snd/" + settingsUserData.chat_notify).play();
        for (var t in ((document.getElementById("chat_msg_count").innerHTML = e),
            (document.title = e > 0 ? gsValues.title + " (" + e + ")" : gsValues.title),
            settingsObjectData))
            null != document.getElementById("chat_object_msg_count_" + t) &&
                (null != chatData.msg_count[t]
                    ? (document.getElementById("chat_object_msg_count_" + t).innerHTML =
                        '<div class="messages">' + chatData.msg_count[t] + "</div>")
                    : (document.getElementById("chat_object_msg_count_" + t).innerHTML =
                        ""));
    }
}
function chatUpdateMsgDt() {
    for (var e in chatData.msg_dt)
        if (null != document.getElementById("chat_object_msg_count_" + e)) {
            var t = chatData.msg_dt[e];
            document.getElementById("chat_object_msg_status_" + e).innerHTML =
                "" == t ? la.NO_MESSAGES : t;
        }
}
function chatDeleteAllMsgs() {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(
            la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_SELECTED_OBJECT_MESSAGES,
            function (e) {
                if (e) {
                    var t = {
                        cmd: "delete_all_msgs",
                        imei: chatData.imei,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_chat.php",
                        data: t,
                        success: function (e) {
                            if ("OK" == e) {
                                chatClear();
                                var t = chatData.imei;
                                (chatData.msg_dt[t] = ""), chatUpdateMsgDt();
                            }
                        },
                    });
                }
            }
        );
}
function chatSend() {
    var e = document.getElementById("chat_msg").value;
    if (0 != chatData.imei && "" != e) {
        (e = stripHTML(e)), (e = strLink(e));
        var t = {
            cmd: "send_msg",
            imei: chatData.imei,
            msg: e,
        };
        $.ajax({
            type: "POST",
            url: "func/fn_chat.php",
            data: t,
            cache: !1,
            success: function (e) {
                "OK" == e &&
                    ((document.getElementById("chat_msg").value = ""),
                        chatLoadMsgs("new"));
            },
            error: function (e, t) { },
        });
    }
}
function chatLoadMsgs(e) {
    if ("old" == e) var t = 10;
    else t = 40;
    var a = {
        cmd: "load_msgs",
        type: e,
        imei: chatData.imei,
        msg_limit: t,
        first_msg_id: chatData.first_msg_id,
        last_msg_id: chatData.last_msg_id,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_chat.php",
        data: a,
        dataType: "json",
        cache: !1,
        success: function (t) {
            if ("" != t) {
                "old" == e && (document.getElementById("chat_msgs").scrollTop = 1);
                var a = "";
                for (var i in t) {
                    var o = t[(i = parseInt(i))].dt,
                        s = t[i].s,
                        n = t[i].m,
                        l = t[i].st;
                    (a += chatFormatMsg(i, o, s, n)),
                        (chatData.first_msg_id > i || 0 == chatData.first_msg_id) &&
                        (chatData.first_msg_id = i),
                        (chatData.last_msg_id < i || 0 == chatData.last_msg_id) &&
                        (chatData.last_msg_id = i);
                }
                if ("old" != e) {
                    (document.getElementById("chat_msgs_text").innerHTML =
                        document.getElementById("chat_msgs_text").innerHTML + a),
                        scrollToBottom("chat_msgs");
                    var d = chatData.imei;
                    (s = t[(i = chatData.last_msg_id)].s), (l = t[i].st);
                    chatUpdateMsgDeliveryStatus("S" == s ? l : 0),
                        delete chatData.msg_count[d],
                        chatUpdateMsgCount();
                    o = t[i].dt;
                    (chatData.msg_dt[d] = o), chatUpdateMsgDt();
                } else
                    document.getElementById("chat_msgs_text").innerHTML =
                        a + document.getElementById("chat_msgs_text").innerHTML;
            }
        },
        error: function (e, t) { },
    });
}
function chatFormatMsg(e, t, a, i) {
    if ("S" == a)
        var o = "chat-msg-server",
            s = "chat-msg-dt-server";
    else (o = "chat-msg-client"), (s = "chat-msg-dt-client");
    return (
        t.substring(0, 10) == moment().format("YYYY-MM-DD") &&
        (t = t.substring(11, 19)),
        '<div class="chat-msg-container"><div title="' +
        t +
        '" class="' +
        o +
        '">' +
        i +
        '<div class="' +
        s +
        '">' +
        t +
        "</div></div></div>"
    );
}
function chatUpdateMsgDeliveryStatus(e) {
    var t = !1;
    0 == e
        ? (document.getElementById("chat_msg_status").innerHTML = "")
        : 1 == e
            ? ("" == document.getElementById("chat_msg_status").innerHTML && (t = !0),
                (document.getElementById("chat_msg_status").innerHTML = la.DELIVERED))
            : 2 == e &&
            ("" == document.getElementById("chat_msg_status").innerHTML && (t = !0),
                (document.getElementById("chat_msg_status").innerHTML = la.SEEN)),
        t && scrollToBottom("chat_msgs");
}
function chatSelectObject(e) {
    chatData.imei != e &&
        (chatClear(),
            (document.getElementById("chat_msg").disabled = !1),
            (chatData.imei = e),
            (chatData.first_msg_id = !1),
            (chatData.last_msg_id = !1),
            chatLoadMsgs("select"));
}

// #################################################
// END CHAT FUNCTIONS
// #################################################

// #################################################
// CMD FUNCTIONS
// #################################################

var cmdData = new Array(),
    timer_cmdLoadData;
function cmdOpen() {
    utilsCheckPrivileges("object_control") &&
        ($("#dialog_cmd").dialog("open"),
            cmdStatusLoadData(),
            cmdGPRSTemplateList(),
            // cmdSMSTemplateList(),
            cmdScheduleTemplateList());
}
function cmdStatusLoadData() {
    clearTimeout(timer_cmdLoadData),
        (timer_cmdLoadData = setTimeout(
            "cmdStatusLoadData();",
            1e3 * gsValues.cmd_status_refresh
        )),
        1 == $("#dialog_cmd").dialog("isOpen")
            ? ($("#cmd_gprs_status_list_grid").trigger("reloadGrid"))
            : clearTimeout(timer_cmdLoadData);
}
function cmdGPRSTemplateList() {
    for (
        var e = document.getElementById("cmd_gprs_template_list"),
        t = e.getElementsByTagName("optgroup"),
        a = t.length - 1;
        a >= 0;
        a--
    )
        e.removeChild(t[a]);
    e.options.length = 0;
    var i = document.getElementById("cmd_gprs_object_list");
    if (multiselectIsSelected(i)) {
        var o = "",
            s = (i = multiselectGetValues(i)).split(",");
        for (a = 0; a < s.length; a += 1)
            if (
                null != settingsObjectData[s[0]] &&
                null != settingsObjectData[s[a]] &&
                (o = settingsObjectData[s[0]].protocol) !=
                settingsObjectData[s[a]].protocol
            ) {
                o = "";
                break;
            }
        if ("" != o && 1 == gsValues.object_control_default_templates)
            for (var n in gsValues.protocol_list)
                if (
                    gsValues.protocol_list[n].name == o &&
                    null != gsValues.protocol_list[n].cmd &&
                    "" != gsValues.protocol_list[n].cmd
                ) {
                    var l = gsValues.protocol_list[n].cmd.split(",");
                    if (l.length > 0)
                        (r = $('<optgroup label="' + la.DEFAULT + '" />')).appendTo(e);
                    for (l.sort(), a = 0; a < l.length; a += 1)
                        e.options.add(new Option(la[l[a].toUpperCase()], l[a]));
                    break;
                }
        var d = new Array(),
            r = $('<optgroup label="' + la.CUSTOM + '" />');
        for (var n in (r.appendTo(e),
            e.options.add(new Option(la.CUSTOM, "")),
            cmdData.cmd_templates)) {
            var _ = cmdData.cmd_templates[n];
            "gprs" == _.gateway &&
                (_.protocol.toLowerCase() == o.toLowerCase()
                    ? d.push({
                        name: _.name,
                        key: n,
                    })
                    : "" == _.protocol.toLowerCase() &&
                    d.push({
                        name: _.name,
                        key: n,
                    }));
        }
        for (d = sortArrayByElement(d, "name"), a = 0; a < d.length; a += 1)
            e.options.add(new Option(d[a].name, d[a].key));
        cmdGPRSReset();
    }
}
function cmdGPRSTemplateSwitch() {
    var e = document.getElementById("cmd_gprs_template_list").value,
        t = "",
        a = "";
    for (var i in gsValues.cmd_default) {
        var foo = gsValues.cmd_default[i].name ? gsValues.cmd_default[i].name : gsValues.cmd_default[i];
        var o = gsValues.cmd_default[i];
        if (e == o.name) {
            (t = o.name), null != o.params && (a = o.params);
            break;
        }
    }
    "" != t
        ? ((document.getElementById("cmd_gprs_cmd_type").disabled = !0),
            (document.getElementById("cmd_gprs_cmd_type").value = "ascii"),
            "" != a && (t = t + "," + a),
            (document.getElementById("cmd_gprs_cmd").value = t))
        : "" != e
            ? ((document.getElementById("cmd_gprs_cmd_type").disabled = !1),
                (document.getElementById("cmd_gprs_cmd_type").value =
                    cmdData.cmd_templates[e].type),
                (document.getElementById("cmd_gprs_cmd").value =
                    cmdData.cmd_templates[e].cmd))
            : ((document.getElementById("cmd_gprs_cmd_type").disabled = !1),
                (document.getElementById("cmd_gprs_cmd_type").value = "ascii"),
                (document.getElementById("cmd_gprs_cmd").value = "")),
        $("#cmd_gprs_cmd_type").multipleSelect("refresh");
}
function cmdGPRSSend() {
    var e = document.getElementById("cmd_gprs_object_list"),
        t = $("#cmd_gprs_template_list :selected").text(),
        a = document.getElementById("cmd_gprs_cmd_type").value,
        i = document.getElementById("cmd_gprs_cmd").value;
    multiselectIsSelected(e)
        ? ((e = multiselectGetValues(e)),
            "" != i
                ? "hex" != a ||
                    ((i = i.toUpperCase()), isHexValid(i.replace("%IMEI%", "")))
                    ? e.split(",").length > 1
                        ? confirmDialog(
                            la.ARE_YOU_SURE_YOU_WANT_TO_SEND_COMMAND_SELECTED_OBJECTS,
                            function (o) {
                                o && cmdGPRSExec(e, t, a, i);
                            }
                        )
                        : cmdGPRSExec(e, t, a, i)
                    : notifyBox("error", la.ERROR, la.COMMAND_HEX_NOT_VALID, !0)
                : notifyBox("error", la.ERROR, la.COMMAND_CANT_BE_EMPTY, !0))
        : notifyBox("error", la.ERROR, la.AT_LEAST_ONE_OBJECT_SELECTED);
}
function cmdGPRSExec(e, t, a, i) {
    console.log('e: '+e + ' t: '+t + ' a: '+a + ' i: '+i)
    if (utilsCheckPrivileges("viewer")) {
        loadingData(!0);
        var o = {
            cmd: "exec_cmd_gprs",
            imei: e,
            name: t,
            type: a,
            cmd_: i,
        };
        $.ajax({
            type: "POST",
            url: "func/fn_cmd.php",
            data: o,
            success: function (e) {
                console.log(e)
                loadingData(!1),
                    "OK" == e
                        ? (cmdGPRSReset(),
                            $("#cmd_gprs_status_list_grid").trigger("reloadGrid"),
                            notifyBox(
                                "info",
                                la.INFORMATION,
                                la.COMMAND_SENT_FOR_EXECUTION,
                                !0
                            ))
                        : "ERROR_NOT_SENT" == e &&
                        ($("#cmd_gprs_status_list_grid").trigger("reloadGrid"),
                            notifyBox("error", la.ERROR, la.UNABLE_TO_SEND_SMS_MESSAGE, !0));
            },
            error: function (e, t) {
                loadingData(!1);
            },
        });
    }
}
function cmdGPRSReset() {
    (document.getElementById("cmd_gprs_cmd_type").disabled = !1),
        (document.getElementById("cmd_gprs_template_list").value = ""),
        $("#cmd_gprs_template_list").multipleSelect("refresh"),
        (document.getElementById("cmd_gprs_cmd_type").value = "ascii"),
        $("#cmd_gprs_cmd_type").multipleSelect("refresh"),
        (document.getElementById("cmd_gprs_cmd").value = "");
}
function cmdGPRSExecDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_cmd_exec",
                    cmd_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_cmd.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && $("#cmd_gprs_status_list_grid").trigger("reloadGrid");
                    },
                });
            }
        });
}
function cmdGPRSExecDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#cmd_gprs_status_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_cmd_execs",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_cmd.php",
                            data: a,
                            success: function (e) {
                                "OK" == e &&
                                    $("#cmd_gprs_status_list_grid").trigger("reloadGrid");
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function cmdScheduleProtocolList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
        t = document.getElementById("dialog_cmd_schedule_protocol");
    t.options.length = 0;
    for (var a = getAllProtocolsArray(), i = 0; i < a.length; i++)
        "" != a[i] && t.options.add(new Option(a[i], a[i]));
    sortSelectList(t),
        t.options.add(new Option(la.ALL_PROTOCOLS, ""), 0),
        (document.getElementById("dialog_cmd_schedule_protocol").value = e),
        $("#dialog_cmd_schedule_protocol").multipleSelect("refresh");
}
function cmdScheduleObjectList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
        t = document.getElementById("dialog_cmd_schedule_object_list");
    multiselectClear(t);
    var a = getGroupsObjectsArray(e);
    multiselectSetGroups(t, a);
}
function cmdScheduleTemplateList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
        t = document.getElementById("dialog_cmd_schedule_template_list");
    for (var a in ((t.options.length = 0), cmdData.cmd_templates)) {
        var i = cmdData.cmd_templates[a];
        "" == e
            ? t.options.add(new Option(i.name, a))
            : i.protocol.toLowerCase() == e.toLowerCase() &&
            t.options.add(new Option(i.name, a));
    }
    sortSelectList(t),
        t.options.add(new Option(la.CUSTOM, ""), 0),
        (document.getElementById("dialog_cmd_schedule_template_list").value = ""),
        $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_cmd_gateway").value = "gprs"),
        $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_cmd_type").value = "ascii"),
        $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = "");
}
function cmdScheduleExactTimeSwitch() {
    1 == document.getElementById("dialog_cmd_schedule_exact_time").checked
        ? ((document.getElementById(
            "dialog_cmd_schedule_exact_time_date"
        ).disabled = !1),
            (document.getElementById("dialog_cmd_schedule_exact_time_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_mon").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_mon_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_tue").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_tue_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_wed").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_wed_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_thu").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_thu_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_fri").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_fri_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_sat").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_sat_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_sun").disabled = !0),
            (document.getElementById("dialog_cmd_schedule_daily_sun_time").disabled =
                !0))
        : ((document.getElementById(
            "dialog_cmd_schedule_exact_time_date"
        ).disabled = !0),
            (document.getElementById("dialog_cmd_schedule_exact_time_time").disabled =
                !0),
            (document.getElementById("dialog_cmd_schedule_daily_mon").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_mon_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_tue").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_tue_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_wed").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_wed_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_thu").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_thu_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_fri").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_fri_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_sat").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_sat_time").disabled =
                !1),
            (document.getElementById("dialog_cmd_schedule_daily_sun").disabled = !1),
            (document.getElementById("dialog_cmd_schedule_daily_sun_time").disabled =
                !1));
}
function cmdScheduleProtocolSwitch() {
    cmdScheduleObjectList(), cmdScheduleTemplateList();
}
function cmdScheduleTemplateSwitch() {
    var e = document.getElementById("dialog_cmd_schedule_template_list").value;
    "" != e
        ? ((document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
            cmdData.cmd_templates[e].gateway),
            (document.getElementById("dialog_cmd_schedule_cmd_type").value =
                cmdData.cmd_templates[e].type),
            (document.getElementById("dialog_cmd_schedule_cmd_cmd").value =
                cmdData.cmd_templates[e].cmd))
        : ((document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
            "gprs"),
            (document.getElementById("dialog_cmd_schedule_cmd_type").value = "ascii"),
            (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = "")),
        $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
        $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh");
}
function cmdScheduleResetDailyTime() {
    (document.getElementById("dialog_cmd_schedule_daily_mon").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_mon_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_mon_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_tue").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_tue_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_tue_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_wed").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_wed_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_wed_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_thu").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_thu_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_thu_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_fri").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_fri_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_fri_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_sat").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_sat_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_sat_time").multipleSelect("refresh"),
        (document.getElementById("dialog_cmd_schedule_daily_sun").checked = !1),
        (document.getElementById("dialog_cmd_schedule_daily_sun_time").value =
            "00:00"),
        $("#dialog_cmd_schedule_daily_sun_time").multipleSelect("refresh");
}
function cmdScheduleProperties(e) {
    switch (e) {
        default:
            var t = e;
            cmdData.edit_cmd_schedule_id = t;
            var a = {
                cmd: "load_cmd_schedule",
                cmd_id: cmdData.edit_cmd_schedule_id,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_cmd.php",
                data: a,
                dataType: "json",
                cache: !1,
                success: function (e) {
                    (document.getElementById("dialog_cmd_schedule_active").checked =
                        strToBoolean(e.active)),
                        (document.getElementById("dialog_cmd_schedule_name").value =
                            e.name);
                    var t = strToBoolean(e.exact_time);
                    (document.getElementById("dialog_cmd_schedule_exact_time").checked =
                        t),
                        cmdScheduleExactTimeSwitch(),
                        1 == t
                            ? ((document.getElementById(
                                "dialog_cmd_schedule_exact_time_date"
                            ).value = e.exact_time_dt.substring(0, 10)),
                                (document.getElementById(
                                    "dialog_cmd_schedule_exact_time_time"
                                ).value = e.exact_time_dt.substring(11, 16)))
                            : ((document.getElementById(
                                "dialog_cmd_schedule_exact_time_date"
                            ).value = ""),
                                (document.getElementById(
                                    "dialog_cmd_schedule_exact_time_time"
                                ).value = "00:00")),
                        $("#dialog_cmd_schedule_exact_time_time").multipleSelect("refresh");
                    var a = e.day_time;
                    null != a
                        ? ((document.getElementById(
                            "dialog_cmd_schedule_daily_mon"
                        ).checked = a.mon),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_mon_time"
                            ).value = a.mon_time),
                            $("#dialog_cmd_schedule_daily_mon_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_tue"
                            ).checked = a.tue),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_tue_time"
                            ).value = a.tue_time),
                            $("#dialog_cmd_schedule_daily_tue_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_wed"
                            ).checked = a.wed),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_wed_time"
                            ).value = a.wed_time),
                            $("#dialog_cmd_schedule_daily_wed_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_thu"
                            ).checked = a.thu),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_thu_time"
                            ).value = a.thu_time),
                            $("#dialog_cmd_schedule_daily_thu_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_fri"
                            ).checked = a.fri),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_fri_time"
                            ).value = a.fri_time),
                            $("#dialog_cmd_schedule_daily_fri_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_sat"
                            ).checked = a.sat),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_sat_time"
                            ).value = a.sat_time),
                            $("#dialog_cmd_schedule_daily_sat_time").multipleSelect(
                                "refresh"
                            ),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_sun"
                            ).checked = a.sun),
                            (document.getElementById(
                                "dialog_cmd_schedule_daily_sun_time"
                            ).value = a.sun_time),
                            $("#dialog_cmd_schedule_daily_sun_time").multipleSelect(
                                "refresh"
                            ))
                        : cmdScheduleResetDailyTime(),
                        cmdScheduleProtocolList(),
                        (document.getElementById("dialog_cmd_schedule_protocol").value =
                            e.protocol),
                        $("#dialog_cmd_schedule_protocol").multipleSelect("refresh"),
                        cmdScheduleProtocolSwitch();
                    var i = document.getElementById("dialog_cmd_schedule_object_list"),
                        o = e.imei.split(",");
                    multiselectSetValues(i, o),
                        $("#dialog_cmd_schedule_object_list").multipleSelect("refresh"),
                        (document.getElementById(
                            "dialog_cmd_schedule_template_list"
                        ).value = ""),
                        $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
                        (document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
                            e.gateway),
                        $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
                        (document.getElementById("dialog_cmd_schedule_cmd_type").value =
                            e.type),
                        $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
                        (document.getElementById("dialog_cmd_schedule_cmd_cmd").value =
                            e.cmd);
                },
            }),
                $("#dialog_cmd_schedule_properties").dialog("open");
            break;
        case "add":
            (cmdData.edit_cmd_schedule_id = !1),
                (document.getElementById("dialog_cmd_schedule_active").checked = !0),
                (document.getElementById("dialog_cmd_schedule_name").value = ""),
                (document.getElementById("dialog_cmd_schedule_exact_time").checked =
                    !1),
                cmdScheduleExactTimeSwitch(),
                (document.getElementById("dialog_cmd_schedule_exact_time_date").value =
                    ""),
                (document.getElementById("dialog_cmd_schedule_exact_time_time").value =
                    "00:00"),
                $("#dialog_cmd_schedule_exact_time_time").multipleSelect("refresh"),
                cmdScheduleResetDailyTime(),
                cmdScheduleProtocolList(),
                (document.getElementById("dialog_cmd_schedule_protocol").value = ""),
                $("#dialog_cmd_schedule_protocol").multipleSelect("refresh"),
                cmdScheduleProtocolSwitch(),
                (document.getElementById("dialog_cmd_schedule_template_list").value =
                    ""),
                $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
                    "gprs"),
                $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_schedule_cmd_type").value =
                    "ascii"),
                $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = ""),
                $("#dialog_cmd_schedule_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_cmd_schedule_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var i = document.getElementById("dialog_cmd_schedule_name").value;
            if ("" == i)
                return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY, !0);
            var o = document.getElementById("dialog_cmd_schedule_active").checked,
                s = document.getElementById("dialog_cmd_schedule_exact_time").checked,
                n = document.getElementById(
                    "dialog_cmd_schedule_exact_time_date"
                ).value,
                l = document.getElementById(
                    "dialog_cmd_schedule_exact_time_time"
                ).value;
            if (1 == s) {
                if ("" == n)
                    return void notifyBox("error", la.ERROR, la.DATE_CANT_BE_EMPTY, !0);
                var d = n + " " + l + ":00";
            } else d = "";
            var r = {
                mon: document.getElementById("dialog_cmd_schedule_daily_mon").checked,
                mon_time: document.getElementById("dialog_cmd_schedule_daily_mon_time")
                    .value,
                tue: document.getElementById("dialog_cmd_schedule_daily_tue").checked,
                tue_time: document.getElementById("dialog_cmd_schedule_daily_tue_time")
                    .value,
                wed: document.getElementById("dialog_cmd_schedule_daily_wed").checked,
                wed_time: document.getElementById("dialog_cmd_schedule_daily_wed_time")
                    .value,
                thu: document.getElementById("dialog_cmd_schedule_daily_thu").checked,
                thu_time: document.getElementById("dialog_cmd_schedule_daily_thu_time")
                    .value,
                fri: document.getElementById("dialog_cmd_schedule_daily_fri").checked,
                fri_time: document.getElementById("dialog_cmd_schedule_daily_fri_time")
                    .value,
                sat: document.getElementById("dialog_cmd_schedule_daily_sat").checked,
                sat_time: document.getElementById("dialog_cmd_schedule_daily_sat_time")
                    .value,
                sun: document.getElementById("dialog_cmd_schedule_daily_sun").checked,
                sun_time: document.getElementById("dialog_cmd_schedule_daily_sun_time")
                    .value,
            };
            r = JSON.stringify(r);
            var _ = document.getElementById("dialog_cmd_schedule_protocol").value,
                c = document.getElementById("dialog_cmd_schedule_object_list");
            if (!multiselectIsSelected(c))
                return void notifyBox(
                    "error",
                    la.ERROR,
                    la.AT_LEAST_ONE_OBJECT_SELECTED
                );
            c = multiselectGetValues(c);
            var g = document.getElementById("dialog_cmd_schedule_cmd_gateway").value,
                m = document.getElementById("dialog_cmd_schedule_cmd_type").value,
                u = document.getElementById("dialog_cmd_schedule_cmd_cmd").value;
            if ("" == u)
                return void notifyBox("error", la.ERROR, la.COMMAND_CANT_BE_EMPTY, !0);
            if (
                "hex" == m &&
                ((u = u.toUpperCase()), !isHexValid(u.replace("%IMEI%", "")))
            )
                return void notifyBox("error", la.ERROR, la.COMMAND_HEX_NOT_VALID, !0);
            a = {
                cmd: "save_cmd_schedule",
                cmd_id: cmdData.edit_cmd_schedule_id,
                name: i,
                active: o,
                exact_time: s,
                exact_time_dt: d,
                day_time: r,
                protocol: _,
                imei: c,
                gateway: g,
                type: m,
                cmd_: u,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_cmd.php",
                data: a,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        ($("#cmd_gprs_schedule_list_grid").trigger("reloadGrid"),
                            $("#dialog_cmd_schedule_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function cmdScheduleDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_cmd_schedule",
                    cmd_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_cmd.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && $("#cmd_gprs_schedule_list_grid").trigger("reloadGrid");
                    },
                });
            }
        });
}
function cmdScheduleDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#cmd_gprs_schedule_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
                if (t) {
                    var a = {
                        cmd: "delete_selected_cmd_schedules",
                        items: e,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_cmd.php",
                        data: a,
                        success: function (e) {
                            "OK" == e && $("#cmd_gprs_schedule_list_grid").trigger("reloadGrid");
                        },
                    });
                }
            })
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function cmdTemplateReload() {
    cmdTemplateLoadData(), $("#cmd_gprs_template_list_grid").trigger("reloadGrid");
}
function cmdTemplateLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_cmd.php",
        data: {
            cmd: "load_cmd_template_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            (cmdData.cmd_templates = e),
                cmdGPRSTemplateList(),
                // cmdSMSTemplateList(),
                cmdScheduleTemplateList(),
                settingsEventCmdTemplateList();
        },
    });
}
function cmdTemplateImport() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", cmdTemplateImportCTEFile, !1),
            document.getElementById("load_file").click());
}
function cmdTemplateExport() {
    if (utilsCheckPrivileges("viewer")) {
        window.location = "func/fn_export.php?format=cte";
    }
}
function cmdTemplateImportCTEFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.cte) {
                var a = t.templates.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.TEMPLATES_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "cte",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1), "OK" == e && cmdTemplateReload();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", cmdTemplateImportCTEFile, !1);
}
function cmdTemplateProtocolList() {
    var e = document.getElementById("dialog_cmd_template_protocol").value,
        t = document.getElementById(
            "dialog_cmd_template_hide_unsed_protocols"
        ).checked,
        a = document.getElementById("dialog_cmd_template_protocol");
    if (((a.options.length = 0), 1 == t))
        for (var i = getAllProtocolsArray(), o = 0; o < i.length; o++)
            "" != i[o] && a.options.add(new Option(i[o], i[o]));
    else
        for (var s in gsValues.protocol_list) {
            var n = gsValues.protocol_list[s];
            a.options.add(new Option(n.name, n.name));
        }
    sortSelectList(a),
        a.options.add(new Option(la.ALL_PROTOCOLS, ""), 0),
        (document.getElementById("dialog_cmd_template_protocol").value = e),
        $("#dialog_cmd_template_protocol").multipleSelect("refresh");
}
function cmdTemplateProperties(e) {
    switch (e) {
        default:
            var t = e;
            (cmdData.edit_cmd_template_id = t),
                (document.getElementById(
                    "dialog_cmd_template_hide_unsed_protocols"
                ).checked = !1),
                cmdTemplateProtocolList(),
                (document.getElementById("dialog_cmd_template_name").value =
                    cmdData.cmd_templates[t].name),
                (document.getElementById("dialog_cmd_template_protocol").value =
                    cmdData.cmd_templates[t].protocol),
                $("#dialog_cmd_template_protocol").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_gateway").value =
                    cmdData.cmd_templates[t].gateway),
                $("#dialog_cmd_template_gateway").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_type").value =
                    cmdData.cmd_templates[t].type),
                $("#dialog_cmd_template_type").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_cmd").value =
                    cmdData.cmd_templates[t].cmd),
                $("#dialog_cmd_template_properties").dialog("open");
            break;
        case "add":
            (cmdData.edit_cmd_template_id = !1),
                (document.getElementById(
                    "dialog_cmd_template_hide_unsed_protocols"
                ).checked = !1),
                cmdTemplateProtocolList(),
                (document.getElementById("dialog_cmd_template_name").value = ""),
                (document.getElementById("dialog_cmd_template_protocol").value = ""),
                $("#dialog_cmd_template_protocol").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_gateway").value = "gprs"),
                $("#dialog_cmd_template_gateway").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_type").value = "ascii"),
                $("#dialog_cmd_template_type").multipleSelect("refresh"),
                (document.getElementById("dialog_cmd_template_cmd").value = ""),
                $("#dialog_cmd_template_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_cmd_template_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var a = document.getElementById("dialog_cmd_template_name").value,
                i = document.getElementById("dialog_cmd_template_protocol").value,
                o = document.getElementById("dialog_cmd_template_gateway").value,
                s = document.getElementById("dialog_cmd_template_type").value,
                n = document.getElementById("dialog_cmd_template_cmd").value;
            if ("" == a)
                return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY, !0);
            if ("" == n)
                return void notifyBox("error", la.ERROR, la.COMMAND_CANT_BE_EMPTY, !0);
            if (
                "hex" == s &&
                ((n = n.toUpperCase()), !isHexValid(n.replace("%IMEI%", "")))
            )
                return void notifyBox("error", la.ERROR, la.COMMAND_HEX_NOT_VALID, !0);
            var l = {
                cmd: "save_cmd_template",
                cmd_id: cmdData.edit_cmd_template_id,
                name: a,
                protocol: i,
                gateway: o,
                type: s,
                cmd_: n,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_cmd.php",
                data: l,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (cmdTemplateReload(),
                            $("#dialog_cmd_template_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function cmdTemplateDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_cmd_template",
                    cmd_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_cmd.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && cmdTemplateReload();
                    },
                });
            }
        });
}
function cmdTemplateDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#cmd_gprs_template_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
                if (t) {
                    var a = {
                        cmd: "delete_selected_cmd_templates",
                        items: e,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_cmd.php",
                        data: a,
                        success: function (e) {
                            "OK" == e && cmdTemplateReload();
                        },
                    });
                }
            })
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
(cmdData.cmd_templates = new Array()),
    (cmdData.edit_cmd_schedule_id = !1),
    (cmdData.edit_cmd_template_id = !1);
var eventsData = new Array(),
    timer_eventsLoadData;

// #################################################
// END CMD FUNCTIONS
// #################################################

// #################################################
// EVENTS FUNCTIONS
// #################################################

(eventsData.last_id = -1),
    (eventsData.push_notification = !1),
    (eventsData.events_loaded = !1);

function eventsReloadData() {
    eventsCheckForNew();
}
function eventsLoadData() {
    // // console.log('load data..')
    clearTimeout(timer_eventsLoadData),
        (timer_eventsLoadData = setTimeout(
            "eventsLoadData();",
            1e3 * gsValues.event_refresh
        )),
        eventsCheckForNew();
}

// rdante: funcion central en eventos, display lateral y logica de render 
function eventsCheckForNew() {
    // // console.log('events check for new')
    var e = {
        cmd: "load_last_event",
        last_id: eventsData.last_id,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_events.php",
        data: e,
        dataType: "json",
        success: function (e) {
            if (0 != e) {
                eventsData.push_notification = !1;
                for (var t = 0; t < e.length; t++) {
                    if (
                        eventsData.last_id < e[t].event_id &&
                        1 == eventsData.events_loaded &&
                        null != settingsObjectData[e[t].imei] &&
                        "true" == settingsObjectData[e[t].imei].active
                    ) {
                        var a = !1,
                            i = !1;
                        "true" == e[t].notify_arrow && (a = e[t].notify_arrow_color),
                            "true" == e[t].notify_ohc && (i = e[t].notify_ohc_color),
                            objectSetStatusEvent(e[t].imei, a, i);
                        var o = e[t].notify_system.split(",");
                        if ("true" == o[0]) {
                            "true" == settingsUserData.push_notify_desktop &&
                                "true" == e[t].notify_push &&
                                (eventsData.push_notification = !0);
                            var s = e[t].lat,
                                n = e[t].lng,
                                l = urlPosition(s, n),
                                d = '<div class="row">';
                            (d +=
                                '<div class="row2"><div class="width40"><strong>' +
                                la.OBJECT +
                                ':</strong></div><div class="width60">' +
                                e[t].name +
                                "</div></div>"),
                                (d +=
                                    '<div class="row2"><div class="width40"><strong>' +
                                    la.EVENT +
                                    ':</strong></div><div class="width60">' +
                                    e[t].event_desc +
                                    "</div></div>"),
                                (d +=
                                    '<div class="row2"><div class="width40"><strong>' +
                                    la.POSITION +
                                    ':</strong></div><div class="width60">' +
                                    l +
                                    "</div></div>"),
                                (d +=
                                    '<div class="row2"><div class="width40"><strong>' +
                                    la.TIME +
                                    ':</strong></div><div class="width60">' +
                                    e[t].dt_tracker +
                                    "</div></div>"),
                                (d += "</div>"),
                                (d += '<div class="row">'),
                                (d +=
                                    '<center><a href="#" onclick="eventsShowEvent(' +
                                    e[t].event_id +
                                    ');">' +
                                    la.SHOW_EVENT +
                                    "</a></center>"),
                                (d += "</div>");
                            var r = !1;
                            if (
                                ("true" == o[1] && (r = !0),
                                    notifyBox("error", la.NEW_EVENT, d, r),
                                    "true" == o[2])
                            )
                                null == o[3] && (o[3] = "alarm1.mp3"),
                                    new Audio("snd/" + o[3]).play();
                        }
                    }
                    t == e.length - 1 &&
                        ((eventsData.last_id = e[t].event_id),
                            $("#side_panel_events_event_list_grid").trigger("reloadGrid"));
                }
                1 == eventsData.push_notification &&
                    Push.create(la.NEW_EVENT, {
                        body: la.NEW_EVENT_WAS_RECEIVED,
                        timeout: 5e3,
                        onClick: function () {
                            window.focus(), this.close();
                        },
                    }),
                    1 == $("#dialog_dashboard").dialog("isOpen") && dashboardInitEvents();
            }
            eventsData.events_loaded = !0;
        },
    });
}
function eventsExport() {
    window.location = "func/fn_export.php?format=events_csv";
}
function eventsDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        utilsCheckPrivileges("obj_history_clear") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_EVENTS, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_events.php",
                    data: {
                        cmd: "delete_all_events",
                    },
                    success: function (e) {
                        "OK" == e &&
                            (datalistClear("event"),
                                $("#side_panel_events_event_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}

// #################################################
// END EVENTS FUNCTIONS
// #################################################

// #################################################
// HISTORY FUNCTIONS
// #################################################

function historyLoadGSR() {
    utilsCheckPrivileges("history") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", historyLoadGSRFile, !1),
            document.getElementById("load_file").click());
}
function historyLoadGSRFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        loadingData(!0);
        try {
            var t = $.parseJSON(e.target.result);
            "0.2v" == t.gsr
                ? null != settingsObjectData[t.imei]
                    ? historyShowRoute(transformToHistoryRoute(t.route), t.imei, t.name)
                    : notifyBox(
                        "error",
                        la.ERROR,
                        la.THERE_IS_NO_SUCH_OBJECT_IN_YOUR_ACCOUNT
                    )
                : notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        loadingData(!1), (document.getElementById("load_file").value = "");
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", historyLoadGSRFile, !1);
}
function historyExportGSR() {
    if (utilsCheckPrivileges("history")) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t = document.getElementById("side_panel_history_object_list").options[
                document.getElementById("side_panel_history_object_list").selectedIndex
            ].text,
            a =
                document.getElementById("side_panel_history_date_from").value +
                " " +
                document.getElementById("side_panel_history_hour_from").value +
                ":" +
                document.getElementById("side_panel_history_minute_from").value +
                ":00",
            i =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00",
            o = document.getElementById("side_panel_history_stop_duration").value;
        if ("" != e) {
            var s =
                "func/fn_export.php?format=gsr&imei=" +
                e +
                "&name=" +
                t +
                "&dtf=" +
                a +
                "&dtt=" +
                i +
                "&min_stop_duration=" +
                o;
            window.location = s;
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}
function historyExportKML() {
    if (utilsCheckPrivileges("history")) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t = document.getElementById("side_panel_history_object_list").options[
                document.getElementById("side_panel_history_object_list").selectedIndex
            ].text,
            a =
                document.getElementById("side_panel_history_date_from").value +
                " " +
                document.getElementById("side_panel_history_hour_from").value +
                ":" +
                document.getElementById("side_panel_history_minute_from").value +
                ":00",
            i =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00";
        if ("" != e) {
            var o =
                "func/fn_export.php?format=kml&imei=" +
                e +
                "&name=" +
                t +
                "&dtf=" +
                a +
                "&dtt=" +
                i;
            window.location = o;
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}
function historyExportGPX() {
    if (utilsCheckPrivileges("history")) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t = document.getElementById("side_panel_history_object_list").options[
                document.getElementById("side_panel_history_object_list").selectedIndex
            ].text,
            a =
                document.getElementById("side_panel_history_date_from").value +
                " " +
                document.getElementById("side_panel_history_hour_from").value +
                ":" +
                document.getElementById("side_panel_history_minute_from").value +
                ":00",
            i =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00";
        if ("" != e) {
            var o =
                "func/fn_export.php?format=gpx&imei=" +
                e +
                "&name=" +
                t +
                "&dtf=" +
                a +
                "&dtt=" +
                i;
            window.location = o;
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}
function historyExportCSV() {
    if (utilsCheckPrivileges("history")) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t = document.getElementById("side_panel_history_object_list").options[
                document.getElementById("side_panel_history_object_list").selectedIndex
            ].text,
            a =
                document.getElementById("side_panel_history_date_from").value +
                " " +
                document.getElementById("side_panel_history_hour_from").value +
                ":" +
                document.getElementById("side_panel_history_minute_from").value +
                ":00",
            i =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00";
        if ("" != e) {
            var o =
                "func/fn_export.php?format=history_csv&imei=" +
                e +
                "&name=" +
                t +
                "&dtf=" +
                a +
                "&dtt=" +
                i;
            window.location = o;
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}
function historySaveAsRoute() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        utilsCheckPrivileges("history") &&
        1 != gsValues.map_bussy
    ) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t =
                (document.getElementById("side_panel_history_object_list").options[
                    document.getElementById("side_panel_history_object_list")
                        .selectedIndex
                ].text,
                    document.getElementById("side_panel_history_date_from").value +
                    " " +
                    document.getElementById("side_panel_history_hour_from").value +
                    ":" +
                    document.getElementById("side_panel_history_minute_from").value +
                    ":00"),
            a =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00",
            o = document.getElementById("side_panel_history_stop_duration").value;
        if ("" != e) {
            loadingData(!0);
            var s = {
                cmd: "load_route_data",
                imei: e,
                dtf: t,
                dtt: a,
                min_stop_duration: o,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_history.php",
                data: s,
                dataType: "json",
                cache: !1,
                success: function (e) {
                    var t = transformToHistoryRoute(e);
                    if ("" == t.route || t.route.length < 2)
                        return (
                            notifyBox(
                                "info",
                                la.INFORMATION,
                                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
                            ),
                            void loadingData(!1)
                        );
                    var a = Math.ceil(t.route.length / 200),
                        o = new Array();
                    for (i = 0; i < t.route.length; i += a) {
                        var s = t.route[i].lat,
                            n = t.route[i].lng;
                        o.push(L.latLng(s, n));
                    }
                    loadingData(!1), placesRouteSave(o);
                },
                error: function (e, t) {
                    notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
                    ),
                        loadingData(!1);
                },
            });
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}
var historyRouteData = new Array(),
    historyGraphPlot,
    historyRouteToggle = new Array(),
    timer_historyRoutePlay;

    
function historyLoadRoute() {
    if (utilsCheckPrivileges("history")) {
        var e = document.getElementById("side_panel_history_object_list").value,
            t = document.getElementById("side_panel_history_object_list").options[
                document.getElementById("side_panel_history_object_list").selectedIndex
            ].text,
            a =
                document.getElementById("side_panel_history_date_from").value +
                " " +
                document.getElementById("side_panel_history_hour_from").value +
                ":" +
                document.getElementById("side_panel_history_minute_from").value +
                ":00",
            i =
                document.getElementById("side_panel_history_date_to").value +
                " " +
                document.getElementById("side_panel_history_hour_to").value +
                ":" +
                document.getElementById("side_panel_history_minute_to").value +
                ":00",
            o = document.getElementById("side_panel_history_stop_duration").value;
        if ("" != e) {
            loadingData(!0);
            var s = {
                cmd: "load_route_data",
                imei: e,
                dtf: a,
                dtt: i,
                min_stop_duration: o,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_history.php",
                data: s,
                dataType: "json",
                cache: !1,
                success: function (o) {
                    // console.log(o)
                    historyShowRoute(transformToHistoryRoute(o), e, t),
                        $("#bottom_panel_msg_list_grid").setGridParam({
                            url:
                                "func/fn_history.php?cmd=load_msg_list&imei=" +
                                e +
                                "&dtf=" +
                                a +
                                "&dtt=" +
                                i,
                        }),
                        $("#bottom_panel_msg_list_grid").trigger("reloadGrid");
                },
                error: function (e, t) {
                    notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
                    ),
                        loadingData(!1);
                },
            });
        } else
            notifyBox(
                "info",
                la.INFORMATION,
                la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST
            );
    }
}

function initGrids() {
    // console.log('acá')
    function e(e, t, a) {
      return (
        "gr" == e ? (e = ">") : "eq" == e ? (e = "=") : "lw" == e && (e = "<"), e
      );
    }
  
    function t(e, t, a) {
      return (e =
        e.substring(0, 10) == moment().format("YYYY-MM-DD")
          ? e.substring(11, 19)
          : e.substring(2, 10));
    }
    $("#settings_main_object_list_grid").jqGrid({
        url: "func/fn_settings.objects.php?cmd=load_object_list",
        datatype: "json",
        colNames: [la.NAME, la.IMEI, la.GROUP, la.ACTIVE, la.EXPIRES_ON, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 218,
          },
          {
            name: "imei",
            index: "imei",
            width: 160,
          },
          {
            name: "active",
            index: "active",
            width: 90,
            align: "center",
          },
          {
            name: "object_expire_dt",
            index: "object_expire_dt",
            width: 110,
            align: "center",
          },
          {
            name: "modify",
            index: "modify",
            width: 75,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_object_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "351px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_object_list_grid").jqGrid(
        "navGrid",
        "#settings_main_object_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectAdd("open");
          },
        }
      ),
      $("#settings_main_object_list_grid").navButtonAdd(
        "#settings_main_object_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_object_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_object_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_object_list_grid_action_menu").hide(),
      $("#settings_main_object_list_grid_action_menu_button").click(function () {
        return (
          $("#settings_main_object_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#settings_main_object_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      
      $("#settings_object_sensor_list_grid").jqGrid({
        url: "func/fn_settings.sensors.php",
        datatype: "json",
        colNames: [la.NAME, la.TYPE, la.PARAMETER, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 220,
            sortable: true,
          },
          {
            name: "type",
            index: "type",
            width: 205,
            align: "center",
            sortable: false,
          },
          {
            name: "param",
            index: "param",
            width: 158,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 512,
        pager: "#settings_object_sensor_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "690",
        height: "347",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_object_sensor_list_grid").jqGrid(
        "navGrid",
        "#settings_object_sensor_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectSensorProperties("add");
          },
        }
      ),
      $("#settings_object_sensor_list_grid").navButtonAdd(
        "#settings_object_sensor_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_object_sensor_list_grid_action_menu_button",
        }
      ),
      $("#settings_object_sensor_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_object_sensor_list_grid_action_menu").hide(),
      $("#settings_object_sensor_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_object_sensor_list_grid_action_menu").toggle().position({
              my: "left bottom",
              at: "right-5 top-5",
              of: this,
            }),
            $(document).one("click", function () {
              $("#settings_object_sensor_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_object_sensor_calibration_list_grid").jqGrid({
        datatype: "local",
        colNames: ["X", "Y", ""],
        colModel: [
          {
            name: "x",
            index: "x",
            width: 111,
            sortable: true,
            sorttype: "int",
          },
          {
            name: "y",
            index: "y",
            width: 110,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
        ],
        width: "285",
        height: "306",
        rowNum: 100,
        shrinkToFit: false,
      }),
      $("#settings_object_service_list_grid").jqGrid({
        url: "func/fn_settings.service.php",
        datatype: "json",
        colNames: [la.NAME, la.STATUS, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 220,
          },
          {
            name: "status",
            index: "status",
            width: 368,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 512,
        pager: "#settings_object_service_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "690",
        height: "347",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_object_service_list_grid").jqGrid(
        "navGrid",
        "#settings_object_service_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectServiceProperties("add");
          },
        }
      ),
      $("#settings_object_service_list_grid").navButtonAdd(
        "#settings_object_service_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_object_service_list_grid_action_menu_button",
        }
      ),
      $("#settings_object_service_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_object_service_list_grid_action_menu").hide(),
      $("#settings_object_service_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_object_service_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_object_service_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_object_custom_fields_list_grid").jqGrid({
        url: "func/fn_settings.customfields.php",
        datatype: "json",
        colNames: [la.NAME, la.VALUE, la.DATA_LIST, la.POPUP, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 220,
            sortable: true,
          },
          {
            name: "value",
            index: "value",
            width: 178,
            align: "center",
            sortable: true,
          },
          {
            name: "data_list",
            index: "data_list",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "popup",
            index: "popup",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 512,
        pager: "#settings_object_custom_fields_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "690",
        height: "347",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_object_custom_fields_list_grid").jqGrid(
        "navGrid",
        "#settings_object_custom_fields_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectCustomFieldProperties("add");
          },
        }
      ),
      $("#settings_object_custom_fields_list_grid").navButtonAdd(
        "#settings_object_custom_fields_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_object_custom_fields_list_grid_action_menu_button",
        }
      ),
      $("#settings_object_custom_fields_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_object_custom_fields_list_grid_action_menu").hide(),
      $("#settings_object_custom_fields_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_object_custom_fields_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_object_custom_fields_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_object_info_list_grid").jqGrid({
        url: "func/fn_settings.objects.php",
        datatype: "json",
        colNames: [la.DATA, la.VALUE],
        colModel: [
          {
            name: "data",
            index: "data",
            width: 170,
            sortable: false,
          },
          {
            name: "value",
            index: "value",
            width: 493,
            sortable: false,
          },
        ],
        rowNum: 512,
        pager: "#settings_object_info_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "data",
        sortorder: "asc",
        viewrecords: true,
        width: "690",
        height: "347",
        shrinkToFit: false,
      }),
      $("#settings_object_info_list_grid").jqGrid(
        "navGrid",
        "#settings_object_info_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#settings_main_object_group_list_grid").jqGrid({
        url: "func/fn_settings.groups.php?cmd=load_object_group_list",
        datatype: "json",
        colNames: [la.NAME, la.OBJECTS, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "group_name",
            index: "group_name",
            width: 218,
            sortable: true,
          },
          {
            name: "objects",
            index: "objects",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "description",
            index: "description",
            width: 305,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_object_group_list_grid_pager",
        sortname: "group_name",
        sortorder: "asc",
        viewrecords: true,
        height: "351px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_object_group_list_grid").jqGrid(
        "navGrid",
        "#settings_main_object_group_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectGroupProperties("add");
          },
        }
      ),
      $("#settings_main_object_group_list_grid").navButtonAdd(
        "#settings_main_object_group_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_object_group_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_object_group_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_object_group_list_grid_action_menu").hide(),
      $("#settings_main_object_group_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_object_group_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_object_group_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_main_object_driver_list_grid").jqGrid({
        url: "func/fn_settings.drivers.php?cmd=load_object_driver_list",
        datatype: "json",
        colNames: [la.NAME, la.ID_NUMBER, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "driver_name",
            index: "driver_name",
            width: 218,
            sortable: true,
          },
          {
            name: "idn",
            index: "idn",
            width: 135,
            sortable: false,
          },
          {
            name: "description",
            index: "description",
            width: 260,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_object_driver_list_grid_pager",
        sortname: "driver_name",
        sortorder: "asc",
        viewrecords: true,
        height: "351px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_object_driver_list_grid").jqGrid(
        "navGrid",
        "#settings_main_object_driver_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectDriverProperties("add");
          },
        }
      ),
      $("#settings_main_object_driver_list_grid").navButtonAdd(
        "#settings_main_object_driver_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_object_driver_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_object_driver_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_object_driver_list_grid_action_menu").hide(),
      $("#settings_main_object_driver_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_object_driver_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_object_driver_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_main_object_passenger_list_grid").jqGrid({
        url: "func/fn_settings.passengers.php?cmd=load_object_passenger_list",
        datatype: "json",
        colNames: [la.NAME, la.ID_NUMBER, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "passenger_name",
            index: "passenger_name",
            width: 218,
            sortable: true,
          },
          {
            name: "idn",
            index: "idn",
            width: 135,
            sortable: false,
          },
          {
            name: "description",
            index: "description",
            width: 260,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_object_passenger_list_grid_pager",
        sortname: "passenger_name",
        sortorder: "asc",
        viewrecords: true,
        height: "351px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_object_passenger_list_grid").jqGrid(
        "navGrid",
        "#settings_main_object_passenger_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectPassengerProperties("add");
          },
        }
      ),
      $("#settings_main_object_passenger_list_grid").navButtonAdd(
        "#settings_main_object_passenger_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_object_passenger_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_object_passenger_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_object_passenger_list_grid_action_menu").hide(),
      $("#settings_main_object_passenger_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_object_passenger_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_object_passenger_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_main_object_trailer_list_grid").jqGrid({
        url: "func/fn_settings.trailers.php?cmd=load_object_trailer_list",
        datatype: "json",
        colNames: [la.NAME, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "trailer_name",
            index: "trailer_name",
            width: 218,
            sortable: true,
          },
          {
            name: "description",
            index: "description",
            width: 400,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_object_trailer_list_grid_pager",
        sortname: "trailer_name",
        sortorder: "asc",
        viewrecords: true,
        height: "351px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_object_trailer_list_grid").jqGrid(
        "navGrid",
        "#settings_main_object_trailer_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsObjectTrailerProperties("add");
          },
        }
      ),
      $("#settings_main_object_trailer_list_grid").navButtonAdd(
        "#settings_main_object_trailer_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_object_trailer_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_object_trailer_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_object_trailer_list_grid_action_menu").hide(),
      $("#settings_main_object_trailer_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_object_trailer_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_object_trailer_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_main_events_event_list_grid").jqGrid({
        url: "func/fn_settings.events.php?cmd=load_event_list",
        datatype: "json",
        colNames: [la.NAME, la.ACTIVE, la.SYSTEM, la.PUSH_NOTIFICATION, la.EMAIL, la.SMS, ""],
        colModel: [{
            name: "name",
            index: "name",
            width: 248,
            sortable: !0
        }, {
            name: "active",
            index: "active",
            width: 90,
            align: "center",
            sortable: !0
        }, {
            name: "notify_system",
            index: "notify_system",
            width: 90,
            align: "center",
            sortable: !0
        }, {
            name: "notify_push",
            index: "notify_push",
            width: 90,
            align: "center",
            sortable: !0
        }, {
            name: "notify_email",
            index: "notify_email",
            width: 90,
            align: "center",
            sortable: !0
        }, {
            name: "notify_sms",
            index: "notify_sms",
            width: 90,
            align: "center",
            sortable: !0
        }, {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: !1
        }],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_events_event_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: !0,
        height: "409px",
        width: "820",
        shrinkToFit: !1,
        multiselect: !0,
        beforeSelectRow: function (e, t) {
            return "input" === t.target.tagName.toLowerCase()
        }
    }),
      $("#settings_main_events_event_list_grid").jqGrid(
        "navGrid",
        "#settings_main_events_event_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsEventProperties("add");
          },
        }
      ),
      $("#settings_main_events_event_list_grid").navButtonAdd(
        "#settings_main_events_event_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_events_event_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_events_event_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_events_event_list_grid_action_menu").hide(),
      $("#settings_main_events_event_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_events_event_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_events_event_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_event_param_sensor_condition_list_grid").jqGrid({
        datatype: "local",
        colNames: [la.SOURCE, "", la.VALUE, ""],
        colModel: [
          {
            name: "src",
            index: "src",
            width: 94,
            sortable: true,
            sorttype: "text",
          },
          {
            name: "cn",
            index: "cn",
            width: 35,
            align: "center",
            sortable: false,
            formatter: e,
          },
          {
            name: "val",
            index: "val",
            width: 80,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
        ],
        width: "276",
        height: "209",
        rowNum: 15,
        shrinkToFit: false,
      }),
      $("#settings_main_templates_template_list_grid").jqGrid({
        url: "func/fn_settings.templates.php?cmd=load_template_list",
        datatype: "json",
        colNames: [la.NAME, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 243,
            sortable: true,
          },
          {
            name: "description",
            index: "description",
            width: 375,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_templates_template_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "447px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_templates_template_list_grid").jqGrid(
        "navGrid",
        "#settings_main_templates_template_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsTemplateProperties("add");
          },
        }
      ),
      $("#settings_main_templates_template_list_grid").navButtonAdd(
        "#settings_main_templates_template_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_templates_template_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_templates_template_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_templates_template_list_grid_action_menu").hide(),
      $("#settings_main_templates_template_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_templates_template_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_templates_template_list_grid_action_menu").hide();
            }),
            false
          );
        }
      ),
      $("#settings_main_subaccount_list_grid").jqGrid({
        url: "func/fn_settings.subaccounts.php?cmd=load_subaccount_list",
        datatype: "json",
        colNames: [la.EMAIL, la.ACTIVE, la.OBJECTS, la.PLACES, ""],
        colModel: [
          {
            name: "email",
            index: "email",
            width: 288,
            sortable: true,
          },
          {
            name: "active",
            index: "active",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "objects",
            index: "objects",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "places",
            index: "places",
            width: 140,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#settings_main_subaccount_list_grid_pager",
        sortname: "email",
        sortorder: "asc",
        viewrecords: true,
        height: "397px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#settings_main_subaccount_list_grid").jqGrid(
        "navGrid",
        "#settings_main_subaccount_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            settingsSubaccountProperties("add");
          },
        }
      ),
      $("#settings_main_subaccount_list_grid").navButtonAdd(
        "#settings_main_subaccount_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "settings_main_subaccount_list_grid_action_menu_button",
        }
      ),
      $("#settings_main_subaccount_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#settings_main_subaccount_list_grid_action_menu").hide(),
      $("#settings_main_subaccount_list_grid_action_menu_button").click(
        function () {
          return (
            $("#settings_main_subaccount_list_grid_action_menu")
              .toggle()
              .position({
                my: "left bottom",
                at: "right-5 top-5",
                of: this,
              }),
            $(document).one("click", function () {
              $("#settings_main_subaccount_list_grid_action_menu").hide();
            }),
            false
          );
        }
      );
    a = '<div style="float: left; margin-top: 2px; width: 25px;">';
    (a +=
      '<center><input id="object_group_visible_{0}" type="checkbox" onClick="objectGroupVisibleToggle({0});"></center>'),
      (a += "</div>"),
      (a += '<div style="float: left; margin-top: 2px; width: 25px;">'),
      (a +=
        '<center><input id="object_group_follow_{0}" type="checkbox" onClick="objectGroupFollowToggle({0});"></center>'),
      (a += "</div>"),
      (a +=
        '<div style="float: right;"><span id="object_group_name_{0}"></span> ({1})</div>');
    $("#side_panel_objects_object_list_grid").jqGrid({
      datatype: "local",
      colNames: [
        "",
        "",
        "",
        '<a href="#" onclick="objectVisibleAllToggle();"><img title="' +
          la.SHOW_HIDE_ALL +
          '" src="theme/images/eye.svg" width="14px" /></a>',
        '<a href="#" onclick="objectFollowAllToggle();"><img title="' +
          la.FOLLOW_UNFOLLOW_ALL +
          '" src="theme/images/follow.svg" width="14px" /></a>',
        "",
        la.OBJECT,
        "",
      ],
      colModel: [
        {
          name: "search",
          index: "search",
          hidden: true,
        },
        {
          name: "name_sort",
          index: "name_sort",
          hidden: true,
        },
        {
          name: "group_id",
          index: "group_id",
          sorttype: function (e) {
            return 0 == e
              ? String.fromCharCode(0)
              : settingsObjectGroupData[e].name;
          },
        },
        {
          name: "show",
          index: "show",
          width: 20,
          sortable: false,
          align: "center",
        },
        {
          name: "follow",
          index: "follow",
          width: 20,
          sortable: false,
          align: "center",
        },
        {
          name: "icon",
          index: "icon",
          width: 28,
          sortable: false,
        },
        {
          name: "name",
          index: "name_sort",
          width: 215,
          title: false,
        },
        {
          name: "menu",
          index: "menu",
          width: 15,
          sortable: false,
          align: "center",
        },
      ],
      rowNum: 12288,
      viewrecords: true,
      grouping: true,
      groupingView: {
        groupField: ["group_id"],
        groupColumnShow: [false],
        groupText: [a],
        groupCollapse: settingsUserData.groups_collapsed.objects,
        groupOrder: ["asc"],
        groupDataSorted: [true],
      },
      width: "340",
      shrinkToFit: false,
      loadComplete: function (e) {
        for (var key in settingsObjectGroupData) {
          if (document.getElementById("object_group_name_" + key) != null) {
            document.getElementById("object_group_name_" + key).innerHTML =
              settingsObjectGroupData[key].name;
          }
        }
        "" != objectsData && (objectAddAllToMap(), objectUpdateList());
        for (var a = $(this).getDataIDs(), o = 0; o < a.length; o++) {
          var i = a[o];
          $("#object_action_menu_" + i).click(function () {
            $("#side_panel_objects_action_menu").toggle().position({
              my: "left top",
              at: "right bottom",
              of: this,
            });
  
            menuOnItem = $(this).attr("tag");
  
            $(document).one("click", function () {
              $("#side_panel_objects_action_menu").hide();
            });
  
            refrescarIndicadorRele(settingsObjectData[menuOnItem].rele_activo);
  
            if (!tieneCorteMotor(settingsObjectData[menuOnItem].corte_motor)) {
              $("#toggle_engine").parents("li").hide();
            } else {
              $("#toggle_engine").parents("li").show();
            }
  
            return false;
          });
        }
      },
      onCellSelect: function (e, t, a, o) {
        objectSelect(e), 5 == t ? objectPanToZoom(e) : objectPanTo(e);
      },
    }),
      $("#side_panel_objects_object_list_grid").setCaption(
        '<div class="row4">\t\t\t\t\t\t\t\t\t<div class="width80">\t\t\t\t\t\t\t\t\t\t<input id="side_panel_objects_object_list_search" class="inputbox-search" type="text" value="" placeholder="' +
          la.SEARCH +
          '" maxlength="25">\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t<div class="float-right">\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="objectReloadData();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.RELOAD +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/refresh-color.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="settingsObjectAdd(\'open\');">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.ADD_OBJECT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/object-add.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t</div>'
      ),
      $("#side_panel_objects_object_list_search").bind("keyup", function (e) {
        var t = $("#side_panel_objects_object_list_grid"),
          a = t.jqGrid("getGridParam", "postData");
        jQuery.extend(a, {
          filters: "",
          searchField: "search",
          searchOper: "cn",
          searchString: this.value.toLowerCase(),
        }),
          t.jqGrid("setGridParam", {
            search: true,
            postData: a,
          }),
          t.trigger("reloadGrid");
      }),
      $("#side_panel_objects_object_data_list_grid").jqGrid({
        datatype: "local",
        colNames: [la.DATA, la.VALUE],
        colModel: [
          {
            name: "data",
            index: "data",
            width: 110,
            sortable: false,
          },
          {
            name: "value",
            index: "value",
            width: 203,
            sortable: false,
          },
        ],
        width: "340",
        height: "155",
        rowNum: 512,
        shrinkToFit: false,
      }),
      $("#side_panel_events_event_list_grid").jqGrid({
        url: "func/fn_events.php?cmd=load_event_list",
        datatype: "json",
        colNames: [la.TIME, la.OBJECT, la.EVENT],
        colModel: [
          {
            name: "dt_tracker",
            index: "dt_tracker",
            width: 50,
            sorttype: "datetime",
            formatter: t,
            align: "left",
          },
          {
            name: "object",
            index: "object",
            width: 105,
            sortable: false,
            align: "left",
          },
          {
            name: "event",
            index: "event",
            width: 153,
            sortable: false,
            align: "left",
          },
        ],
        recordtext: "",
        emptyrecords: "",
        rowNum: 25,
        rowList: [25, 50, 75, 100, 200],
        pager: "#side_panel_events_event_list_grid_pager",
        sortname: "dt_tracker",
        sortorder: "desc",
        viewrecords: true,
        width: "340",
        shrinkToFit: false,
        onSelectRow: function (e) {
            // console.log('selected..')
          eventsShowEvent(e);
        },
      }),
      $("#side_panel_events_event_list_grid").setCaption(
        '<div class="row4">\t\t\t\t\t\t\t\t\t<div class="width80">\t\t\t\t\t\t\t\t\t\t<input id="side_panel_events_event_list_search" class="inputbox-search" type="text" value="" placeholder="' +
          la.SEARCH +
          '" maxlength="25">\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t<div class="float-right">\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="eventsReloadData();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.RELOAD +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/refresh-color.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="eventsDeleteAll();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.DELETE_ALL_EVENTS +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/remove2.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t</div>'
      ),
      $("#side_panel_events_event_list_search").bind("keyup", function (e) {
        $("#side_panel_events_event_list_grid").setGridParam({
          url: "func/fn_events.php?cmd=load_event_list&s=" + this.value,
        }),
          $("#side_panel_events_event_list_grid").trigger("reloadGrid");
      }),
      $("#side_panel_events_event_data_list_grid").jqGrid({
        datatype: "local",
        colNames: [la.DATA, la.VALUE],
        colModel: [
          {
            name: "data",
            index: "data",
            width: 110,
            sortable: false,
          },
          {
            name: "value",
            index: "value",
            width: 203,
            sortable: false,
          },
        ],
        width: "340",
        height: "155",
        rowNum: 512,
        shrinkToFit: false,
      }),
      $("#places_group_list_grid").jqGrid({
        url: "func/fn_places.php?cmd=load_places_group_list",
        datatype: "json",
        colNames: [la.NAME, la.PLACES, la.DESCRIPTION, ""],
        colModel: [
          {
            name: "group_name",
            index: "group_name",
            width: 228,
            sortable: true,
          },
          {
            name: "places",
            index: "places",
            width: 90,
            align: "center",
            sortable: false,
          },
          {
            name: "description",
            index: "description",
            width: 295,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#places_group_list_grid_pager",
        sortname: "group_name",
        sortorder: "asc",
        viewrecords: true,
        height: "311px",
        width: "720",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#places_group_list_grid").jqGrid(
        "navGrid",
        "#places_group_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            placesGroupProperties("add");
          },
        }
      ),
      $("#places_group_list_grid").navButtonAdd("#places_group_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "places_group_list_grid_action_menu_button",
      }),
      $("#places_group_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#places_group_list_grid_action_menu").hide(),
      $("#places_group_list_grid_action_menu_button").click(function () {
        return (
          $("#places_group_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#places_group_list_grid_action_menu").hide();
          }),
          false
        );
      });
    a = '<div style="float: left; margin-top: 2px; width: 25px;">';
    (a +=
      '<center><input id="marker_group_visible_{0}" type="checkbox" onClick="markerGroupVisibleToggle({0});"></center>'),
      (a += "</div>"),
      (a +=
        '<div style="float: right;"><span id="marker_group_name_{0}"></span> ({1})</div>'),
      $("#side_panel_places_marker_list_grid").jqGrid({
        url: "func/fn_places.php?cmd=load_marker_list",
        datatype: "json",
        colNames: [
          "",
          "",
          '<a href="#" onclick="placesMarkerVisibleAllToggle();"><img title="' +
            la.SHOW_HIDE_ALL +
            '" src="theme/images/eye.svg" width="14px"/></a>',
          "",
          la.NAME,
          "",
        ],
        colModel: [
          {
            name: "marker_id",
            index: "marker_id",
            hidden: true,
          },
          {
            name: "group_id",
            index: "group_id",
          },
          {
            name: "show",
            index: "show",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "icon",
            index: "icon",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "name",
            index: "name",
            width: 218,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        recordtext: "",
        emptyrecords: "",
        rowNum: 50,
        rowList: [25, 50, 100, 200],
        pager: "#side_panel_places_marker_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "340",
        shrinkToFit: false,
        grouping: true,
        groupingView: {
          groupField: ["group_id"],
          groupColumnShow: [false],
          groupText: [a],
          groupCollapse: settingsUserData.groups_collapsed.markers,
          groupOrder: ["asc"],
          groupDataSorted: [true],
        },
        onSelectRow: function (e) {
          placesMarkerPanTo($(this).jqGrid("getCell", e, "marker_id"));
        },
        loadComplete: function (e) {
          for (var t in placesGroupData.groups)
            null != document.getElementById("marker_group_name_" + t) &&
              (document.getElementById("marker_group_name_" + t).innerHTML =
                placesGroupData.groups[t].name);
          placesMarkerSetListCheckbox();
        },
      }),
      $("#side_panel_places_marker_list_grid").setCaption(
        '<div class="row4">\t\t\t\t\t\t\t\t\t<div class="width44">\t\t\t\t\t\t\t\t\t\t<input id="side_panel_places_marker_list_search" class="inputbox-search" type="text" value="" placeholder="' +
          la.SEARCH +
          '" maxlength="25">\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t<div class="float-right">\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesMarkerReload();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.RELOAD +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/refresh-color.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesMarkerNew();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.ADD_MARKER +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/marker-add.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesGroupOpen();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.GROUPS +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/groups.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesImport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.IMPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/import.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesExport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.EXPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/export.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesMarkerDeleteAll();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.DELETE_ALL_MARKERS +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/remove2.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t</div>'
      ),
      $("#side_panel_places_marker_list_search").bind("keyup", function (e) {
        $("#side_panel_places_marker_list_grid").setGridParam({
          url: "func/fn_places.php?cmd=load_marker_list&s=" + this.value,
        }),
          $("#side_panel_places_marker_list_grid").trigger("reloadGrid"),
          placesMarkerSearchMap(this.value);
      }),
      $(window)
        .bind("resize", function () {
          $("#side_panel_places_marker_list_grid").setGridHeight(
            $(window).height() - 208
          );
        })
        .trigger("resize");
    a = '<div style="float: left; margin-top: 2px; width: 25px;">';
    (a +=
      '<center><input id="route_group_visible_{0}" type="checkbox" onClick="routeGroupVisibleToggle({0});"></center>'),
      (a += "</div>"),
      (a +=
        '<div style="float: right;"><span id="route_group_name_{0}"></span> ({1})</div>'),
      $("#side_panel_places_route_list_grid").jqGrid({
        url: "func/fn_places.php?cmd=load_route_list",
        datatype: "json",
        colNames: [
          "",
          "",
          '<a href="#" onclick="placesRouteVisibleAllToggle();"><img title="' +
            la.SHOW_HIDE_ALL +
            '" src="theme/images/eye.svg" width="14px"/></a>',
          "",
          la.NAME,
          "",
        ],
        colModel: [
          {
            name: "route_id",
            index: "route_id",
            hidden: true,
          },
          {
            name: "group_id",
            index: "group_id",
          },
          {
            name: "show",
            index: "show",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "icon",
            index: "icon",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "name",
            index: "name",
            width: 218,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        recordtext: "",
        emptyrecords: "",
        rowNum: 50,
        rowList: [25, 50, 100, 200],
        pager: "#side_panel_places_route_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "340",
        shrinkToFit: false,
        grouping: true,
        groupingView: {
          groupField: ["group_id"],
          groupColumnShow: [false],
          groupText: [a],
          groupCollapse: settingsUserData.groups_collapsed.routes,
          groupOrder: ["asc"],
          groupDataSorted: [true],
        },
        onSelectRow: function (e) {
          placesRoutePanTo($(this).jqGrid("getCell", e, "route_id"));
        },
        loadComplete: function (e) {
          for (var t in placesGroupData.groups)
            null != document.getElementById("route_group_name_" + t) &&
              (document.getElementById("route_group_name_" + t).innerHTML =
                placesGroupData.groups[t].name);
          placesRouteSetListCheckbox();
        },
      }),
      $("#side_panel_places_route_list_grid").setCaption(
        '<div class="row4">\t\t\t\t\t\t\t\t\t<div class="width44">\t\t\t\t\t\t\t\t\t\t<input id="side_panel_places_route_list_search" class="inputbox-search" type="text" value="" placeholder="' +
          la.SEARCH +
          '" maxlength="25">\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t<div class="float-right">\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesRouteReload();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.RELOAD +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/refresh-color.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesRouteNew();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.ADD_ROUTE +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/route-add.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesGroupOpen();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.GROUPS +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/groups.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesImport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.IMPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/import.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesExport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.EXPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/export.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesRouteDeleteAll();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.DELETE_ALL_ROUTES +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/remove2.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t</div>'
      ),
      $("#side_panel_places_route_list_search").bind("keyup", function (e) {
        $("#side_panel_places_route_list_grid").setGridParam({
          url: "func/fn_places.php?cmd=load_route_list&s=" + this.value,
        }),
          $("#side_panel_places_route_list_grid").trigger("reloadGrid"),
          placesRouteSearchMap(this.value);
      }),
      $(window)
        .bind("resize", function () {
          $("#side_panel_places_route_list_grid").setGridHeight(
            $(window).height() - 208
          );
        })
        .trigger("resize");
    var a = '<div style="float: left; margin-top: 2px; width: 25px;">';
    (a +=
      '<center><input id="zone_group_visible_{0}" type="checkbox" onClick="zoneGroupVisibleToggle({0});"></center>'),
      (a += "</div>"),
      (a +=
        '<div style="float: right;"><span id="zone_group_name_{0}"></span> ({1})</div>'),
      $("#side_panel_places_zone_list_grid").jqGrid({
        url: "func/fn_places.php?cmd=load_zone_list",
        datatype: "json",
        colNames: [
          "",
          "",
          '<a href="#" onclick="placesZoneVisibleAllToggle();"><img title="' +
            la.SHOW_HIDE_ALL +
            '" src="theme/images/eye.svg" width="14px"/></a>',
          "",
          la.NAME,
          "",
        ],
        colModel: [
          {
            name: "zone_id",
            index: "zone_id",
            hidden: true,
          },
          {
            name: "group_id",
            index: "group_id",
          },
          {
            name: "show",
            index: "show",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "icon",
            index: "icon",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "name",
            index: "name",
            width: 218,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        recordtext: "",
        emptyrecords: "",
        rowNum: 50,
        rowList: [25, 50, 100, 200],
        pager: "#side_panel_places_zone_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "340",
        shrinkToFit: false,
        grouping: true,
        groupingView: {
          groupField: ["group_id"],
          groupColumnShow: [false],
          groupText: [a],
          groupCollapse: settingsUserData.groups_collapsed.zones,
          groupOrder: ["asc"],
          groupDataSorted: [true],
        },
        onSelectRow: function (e) {
          placesZonePanTo($(this).jqGrid("getCell", e, "zone_id"));
        },
        loadComplete: function (e) {
          for (var t in placesGroupData.groups)
            null != document.getElementById("zone_group_name_" + t) &&
              (document.getElementById("zone_group_name_" + t).innerHTML =
                placesGroupData.groups[t].name);
          placesZoneSetListCheckbox();
        },
      }),
      $("#side_panel_places_zone_list_grid").setCaption(
        '<div class="row4">\t\t\t\t\t\t\t\t\t<div class="width44">\t\t\t\t\t\t\t\t\t\t<input id="side_panel_places_zone_list_search" class="inputbox-search" type="text" value="" placeholder="' +
          la.SEARCH +
          '" maxlength="25">\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t<div class="float-right">\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesZoneReload();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.RELOAD +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/refresh-color.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesZoneNew();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.ADD_ZONE +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/zone-add.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesGroupOpen();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.GROUPS +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/groups.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesImport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.IMPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/import.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesExport();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.EXPORT +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/export.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t\t<a href="#" onclick="placesZoneDeleteAll();">\t\t\t\t\t\t\t\t\t\t<div class="panel-button" title="' +
          la.DELETE_ALL_ZONES +
          '">\t\t\t\t\t\t\t\t\t\t\t<img src="theme/images/remove2.svg" width="16px" border="0"/>\t\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t\t\t</a>\t\t\t\t\t\t\t\t\t</div>\t\t\t\t\t\t\t\t</div>'
      ),
      $("#side_panel_places_zone_list_search").bind("keyup", function (e) {
        $("#side_panel_places_zone_list_grid").setGridParam({
          url: "func/fn_places.php?cmd=load_zone_list&s=" + this.value,
        }),
          $("#side_panel_places_zone_list_grid").trigger("reloadGrid"),
          placesZoneSearchMap(this.value);
      }),
      $(window)
        .bind("resize", function () {
          $("#side_panel_places_zone_list_grid").setGridHeight(
            $(window).height() - 208
          );
        })
        .trigger("resize"),
      $("#side_panel_history_route_detail_list_grid").jqGrid({
        datatype: "local",
        colNames: ["", "", "", la.TIME, la.INFORMATION],
        colModel: [
          {
            name: "el_type",
            index: "el_type",
            hidden: true,
          },
          {
            name: "el_id",
            index: "el_id",
            hidden: true,
          },
          {
            name: "icon",
            index: "icon",
            width: 20,
            sortable: false,
            align: "center",
          },
          {
            name: "datetime",
            index: "datetime",
            width: 110,
            sortable: false,
            datefmt: "Y-m-d H:i:s",
            align: "center",
          },
          {
            name: "info",
            index: "info",
            width: 178,
            sortable: false,
          },
        ],
        width: "340",
        height: "100%",
        rowNum: 12288,
        shrinkToFit: false,
        loadComplete: function (e) {
          for (
            var t = $(this).getDataIDs(), a = historyRouteData.imei, o = 0;
            o < t.length;
            o++
          ) {
            var i = t[o],
              s = $(this).jqGrid("getCell", i, "el_type"),
              n = $(this).jqGrid("getCell", i, "el_id");
            if ("point" == s) {
              l = "<table>";
              (l +=
                "<tr><td>" +
                la.ROUTE_LENGTH +
                ":</td><td>" +
                historyRouteData.route_length +
                " " +
                la.UNIT_DISTANCE +
                "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.MOVE_DURATION +
                  ":</td><td>" +
                  historyRouteData.drives_duration +
                  "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.STOP_DURATION +
                  ":</td><td>" +
                  historyRouteData.stops_duration +
                  "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.TOP_SPEED +
                  ":</td><td>" +
                  historyRouteData.top_speed +
                  " " +
                  la.UNIT_SPEED +
                  "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.AVG_SPEED +
                  ":</td><td>" +
                  historyRouteData.avg_speed +
                  " " +
                  la.UNIT_SPEED +
                  "</td></tr>"),
                0 != (r = historyRouteData.fuel_consumption) &&
                  (l +=
                    "<tr><td>" +
                    la.FUEL_CONSUMPTION +
                    ":</td><td>" +
                    r +
                    " " +
                    la.UNIT_CAPACITY +
                    "</td></tr>"),
                0 != (d = historyRouteData.fuel_cost) &&
                  (l +=
                    "<tr><td>" +
                    la.FUEL_COST +
                    ":</td><td>" +
                    d +
                    " " +
                    settingsUserData.currency +
                    "</td></tr>"),
                0 != getSensorFromType(a, "acc") &&
                  ((l +=
                    "<tr><td>" +
                    la.ENGINE_WORK +
                    ":</td><td>" +
                    historyRouteData.engine_work +
                    "</td></tr>"),
                  (l +=
                    "<tr><td>" +
                    la.ENGINE_IDLE +
                    ":</td><td>" +
                    historyRouteData.engine_idle +
                    "</td></tr>")),
                (l += "</table>");
            } else if ("drive" == s) {
              l = "<table>";
              (l +=
                "<tr><td>" +
                la.ROUTE_LENGTH +
                ":</td><td>" +
                historyRouteData.drives[n].route_length +
                " " +
                la.UNIT_DISTANCE +
                "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.TOP_SPEED +
                  ":</td><td>" +
                  historyRouteData.drives[n].top_speed +
                  " " +
                  la.UNIT_SPEED +
                  "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.AVG_SPEED +
                  ":</td><td>" +
                  historyRouteData.drives[n].avg_speed +
                  " " +
                  la.UNIT_SPEED +
                  "</td></tr>"),
                0 != (r = historyRouteData.drives[n].fuel_consumption) &&
                  (l +=
                    "<tr><td>" +
                    la.FUEL_CONSUMPTION +
                    ":</td><td>" +
                    r +
                    " " +
                    la.UNIT_CAPACITY +
                    "</td></tr>"),
                0 != (d = historyRouteData.drives[n].fuel_cost) &&
                  (l +=
                    "<tr><td>" +
                    la.FUEL_COST +
                    ":</td><td>" +
                    d +
                    " " +
                    settingsUserData.currency +
                    "</td></tr>"),
                (l += "</table>");
            } else if ("stop" == s) {
              var l = "<table>";
              (l +=
                "<tr><td>" +
                la.CAME +
                ":</td><td>" +
                historyRouteData.stops[n].dt_start +
                "</td></tr>"),
                (l +=
                  "<tr><td>" +
                  la.LEFT +
                  ":</td><td>" +
                  historyRouteData.stops[n].dt_end +
                  "</td></tr>");
              var r = historyRouteData.stops[n].fuel_consumption;
              0 != r &&
                (l +=
                  "<tr><td>" +
                  la.FUEL_CONSUMPTION +
                  ":</td><td>" +
                  r +
                  " " +
                  la.UNIT_CAPACITY +
                  "</td></tr>");
              var d = historyRouteData.stops[n].fuel_cost;
              0 != d &&
                (l +=
                  "<tr><td>" +
                  la.FUEL_COST +
                  ":</td><td>" +
                  d +
                  " " +
                  settingsUserData.currency +
                  "</td></tr>"),
                0 != getSensorFromType(a, "acc") &&
                  (l +=
                    "<tr><td>" +
                    la.ENGINE_IDLE +
                    ":</td><td>" +
                    historyRouteData.stops[n].engine_idle +
                    "</td></tr>"),
                (l += "</table>");
            }
            ("point" != s && "drive" != s && "stop" != s) ||
              $("#side_panel_history_route_detail_list_grid #" + i).qtip({
                content: l,
                position: {
                  my: "left bottom",
                  adjust: {
                    x: 0,
                    y: -9,
                  },
                },
              });
          }
        },
        onSelectRow: function (e) {
          var t = $(this).jqGrid("getCell", e, "el_type"),
            a = $(this).jqGrid("getCell", e, "el_id");
          "point" == t
            ? (0 == historyRouteData.play.status && historyRoutePanToPoint(a),
              historyRouteShowPoint(a))
            : "stop" == t
            ? (0 == historyRouteData.play.status && historyRoutePanToStop(a),
              historyRouteShowStop(a))
            : "event" == t
            ? (0 == historyRouteData.play.status && historyRoutePanToEvent(a),
              historyRouteShowEvent(a))
            : "drive" == t &&
              (0 == historyRouteData.play.status &&
                historyRouteRemovePointMarker(),
              destroyMapPopup(),
              historyRouteShowDrive(a));
        },
      }),
      $("#side_panel_history_route_data_list_grid").jqGrid({
        datatype: "local",
        colNames: [la.DATA, la.VALUE],
        colModel: [
          {
            name: "data",
            index: "data",
            width: 110,
            sortable: false,
          },
          {
            name: "value",
            index: "value",
            width: 203,
            sortable: false,
          },
        ],
        width: "340",
        height: "155",
        rowNum: 512,
        shrinkToFit: false,
      }),
      $("#bottom_panel_msg_list_grid").jqGrid({
        url: "func/fn_history.php?cmd=load_msg_list_empty",
        datatype: "json",
        colNames: [
          la.TIME_POSITION,
          la.TIME_SERVER,
          la.LATITUDE,
          la.LONGITUDE,
          la.ALTITUDE,
          la.ANGLE,
          la.SPEED,
          la.PARAMETERS,
        ],
        colModel: [
          {
            name: "dt_tracker",
            index: "dt_tracker",
            width: 120,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "dt_server",
            index: "dt_server",
            width: 120,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "lat",
            index: "lat",
            width: 100,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "lng",
            index: "lng",
            width: 100,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "altitude",
            index: "altitude",
            width: 90,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "angle",
            index: "angle",
            width: 80,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "speed",
            index: "speed",
            width: 80,
            fixed: true,
            align: "center",
            sortable: true,
          },
          {
            name: "params",
            index: "params",
            align: "left",
            sortable: true,
          },
        ],
        sortname: "dt_tracker",
        sortorder: "desc",
        rowNum: 50,
        rowList: [25, 50, 100, 200, 300, 400, 500],
        pager: "#bottom_panel_msg_list_grid_pager",
        height: "111",
        beforeSelectRow: function (e, t) {
          if ("input" === t.target.tagName.toLowerCase()) return true;
          var a = $(this).jqGrid("getCell", e, "lat"),
            o = $(this).jqGrid("getCell", e, "lng");
          return 0 != a && 0 != o && utilsPointOnMap(a, o), false;
        },
        shrinkToFit: true,
        multiselect: true,
      }),
      $("#bottom_panel_msg_list_grid").jqGrid(
        "navGrid",
        "#bottom_panel_msg_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#bottom_panel_msg_list_grid").navButtonAdd(
        "#bottom_panel_msg_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "bottom_panel_msg_list_grid_action_menu_button",
        }
      ),
      $("#bottom_panel_msg_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#bottom_panel_msg_list_grid_action_menu").hide(),
      $("#bottom_panel_msg_list_grid_action_menu_button").click(function () {
        return (
          $("#bottom_panel_msg_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#bottom_panel_msg_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $(window)
        .bind("resize", function () {
          "none" == document.getElementById("side_panel").style.display
            ? $("#bottom_panel_msg_list_grid").setGridWidth(
                $(window).width() - 23
              )
            : $("#bottom_panel_msg_list_grid").setGridWidth(
                $(window).width() - 384
              );
        })
        .trigger("resize"),
      $("#cmd_gprs_schedule_list_grid").jqGrid({
        url: "func/fn_cmd.php?cmd=load_cmd_schedule_list",
        datatype: "json",
        colNames: [
          la.NAME,
          la.ACTIVE,
          la.SCHEDULE,
          la.GATEWAY,
          la.TYPE,
          la.COMMAND,
          "",
        ],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 150,
            sortable: true,
          },
          {
            name: "active",
            index: "active",
            width: 60,
            align: "center",
            sortable: true,
          },
          {
            name: "exact_time",
            index: "exact_time",
            width: 90,
            align: "center",
            sortable: true,
          },
          {
            name: "gateway",
            index: "gateway",
            width: 60,
            align: "center",
            sortable: true,
          },
          {
            name: "type",
            index: "type",
            width: 60,
            align: "center",
            sortable: true,
          },
          {
            name: "cmd",
            index: "cmd",
            width: 308,
            sortable: true,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        sortname: "name",
        sortorder: "asc",
        rowNum: 50,
        rowList: [25, 50, 100, 200],
        pager: "#cmd_gprs_schedule_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "450px",
        width: "850",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#cmd_gprs_schedule_list_grid").jqGrid(
        "navGrid",
        "#cmd_gprs_schedule_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            cmdScheduleProperties("add");
          },
        }
      ),
      $("#cmd_gprs_schedule_list_grid").navButtonAdd("#cmd_gprs_schedule_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "cmd_gprs_schedule_list_grid_action_menu_button",
      }),
      $("#cmd_gprs_schedule_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#cmd_gprs_schedule_list_grid_action_menu").hide(),
      $("#cmd_gprs_schedule_list_grid_action_menu_button").click(function () {
        return (
          $("#cmd_gprs_schedule_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#cmd_gprs_schedule_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#cmd_gprs_template_list_grid").jqGrid({
        url: "func/fn_cmd.php?cmd=load_cmd_gprs_template_list",
        datatype: "json",
        colNames: [la.NAME, la.PROTOCOL, la.GATEWAY, la.TYPE, la.COMMAND, ""],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 150,
            sortable: true,
          },
          {
            name: "protocol",
            index: "protocol",
            width: 150,
            align: "center",
            sortable: true,
          },
          {
            name: "gateway",
            index: "gateway",
            width: 60,
            align: "center",
            sortable: true,
          },
          {
            name: "type",
            index: "type",
            width: 60,
            align: "center",
            sortable: true,
          },
          {
            name: "cmd",
            index: "cmd",
            width: 313,
            sortable: true,
          },
          {
            name: "modify",
            index: "modify",
            width: 45,
            align: "center",
            sortable: false,
          },
        ],
        sortname: "name",
        sortorder: "asc",
        rowNum: 50,
        rowList: [25, 50, 100, 200],
        pager: "#cmd_gprs_template_list_grid_pager",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "450px",
        width: "850",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#cmd_gprs_template_list_grid").jqGrid(
        "navGrid",
        "#cmd_gprs_template_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            cmdTemplateProperties("add");
          },
        }
      ),
      $("#cmd_gprs_template_list_grid").navButtonAdd("#cmd_gprs_template_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "cmd_gprs_template_list_grid_action_menu_button",
      }),
      $("#cmd_gprs_template_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#cmd_gprs_template_list_grid_action_menu").hide(),
      $("#cmd_gprs_template_list_grid_action_menu_button").click(function () {
        return (
          $("#cmd_gprs_template_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#cmd_gprs_template_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#cmd_gprs_status_list_grid").jqGrid({
        url: "func/fn_cmd.php?cmd=load_cmd_exec_list",
        datatype: "json",
        colNames: [
          la.TIME,
          la.OBJECT,
          la.NAME,
          la.GATEWAY,
          la.TYPE,
          la.COMMAND,
          la.STATUS,
          "",
          "",
        ],
        colModel: [
          {
            name: "dt_cmd",
            index: "dt_cmd",
            width: 110,
            sortable: true,
          },
          {
            name: "object",
            index: "object",
            width: 111,
            sortable: false,
          },
          {
            name: "name",
            index: "name",
            width: 100,
            sortable: false,
          },
          {
            name: "gateway",
            index: "gateway",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "type",
            index: "type",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "cmd",
            index: "cmd",
            width: 222,
            sortable: false,
          },
          {
            name: "status",
            index: "status",
            width: 50,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
          {
            name: "re_hex",
            index: "re_hex",
            hidden: true,
          },
        ],
        rowNum: 12288,
        pager: "#cmd_status_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "dt_cmd",
        sortorder: "desc",
        viewrecords: true,
        height: "359px",
        width: "850",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
        subGrid: true,
        subGridRowExpanded: function (e, t) {
          var a = $("#cmd_gprs_status_list_grid").getRowData(t).re_hex,
            o = hexToAscii(a),
            i = "";
          "" == o && "" == a
            ? (i = la.NO_DATA)
            : ((i = '<table style="table-layout: fixed; width: 100%">'),
              (i +=
                '<tr><td style="width: 40px;">ASCII:</td><td style="word-wrap: break-word;">' +
                o +
                "</td></tr>"),
              (i +=
                '<tr><td>HEX:</td><td style="word-wrap:break-word;">' +
                a +
                "</td></tr>"),
              (i += "</table>")),
            $("#" + e).html(i);
        },
      }),
      $("#cmd_gprs_status_list_grid").jqGrid(
        "navGrid",
        "#cmd_status_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#cmd_gprs_status_list_grid").navButtonAdd("#cmd_status_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "cmd_status_list_grid_action_menu_button",
      }),
      $("#cmd_status_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#cmd_status_list_grid_action_menu").hide(),
      $("#cmd_status_list_grid_action_menu_button").click(function () {
        return (
          $("#cmd_status_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#cmd_status_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#report_list_grid").jqGrid({
        url: "func/fn_reports.php?cmd=load_report_list",
        datatype: "json",
        colNames: [
          la.NAME,
          la.TYPE,
          la.FORMAT,
          la.OBJECTS,
          la.ZONES,
          la.SENSORS,
          la.DAILY,
          la.WEEKLY,
          "",
        ],
        colModel: [
          {
            name: "name",
            index: "name",
            width: 240,
            sortable: true,
          },
          {
            name: "type",
            index: "type",
            width: 215,
            align: "center",
            sortable: false,
          },
          {
            name: "format",
            index: "format",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "objects",
            index: "objects",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "zones",
            index: "zones",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "sensors",
            index: "sensors",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "daily",
            index: "daily",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "weekly",
            index: "weekly",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 60,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 12288,
        pager: "#report_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "450px",
        width: "962",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
        loadComplete: function (e) {
          for (var t = $(this).getDataIDs(), a = 0; a < t.length; a++) {
            var o = t[a];
            $("#report_action_menu_" + o).click(function () {
              return (
                $("#report_action_menu").toggle().position({
                  my: "left top",
                  at: "right bottom",
                  of: this,
                }),
                (menuOnItem = $(this).attr("tag")),
                $(document).one("click", function () {
                  $("#report_action_menu").hide();
                }),
                false
              );
            });
          }
        },
      }),
      $("#report_list_grid").jqGrid("navGrid", "#report_list_grid_pager", {
        add: true,
        edit: false,
        del: false,
        search: false,
        addfunc: function (e) {
          reportProperties("add");
        },
      }),
      $("#report_list_grid").navButtonAdd("#report_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "report_list_grid_action_menu_button",
      }),
      $("#report_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#report_list_grid_action_menu").hide(),
      $("#report_list_grid_action_menu_button").click(function () {
        return (
          $("#report_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#report_list_grid_action_menu").hide();
          }),
          false
        );
      }),
  
      $("#reports_generated_list_grid").jqGrid({
        url: "func/fn_reports.php?cmd=load_reports_generated_list",
        datatype: "json",
        colNames: [
          la.TIME,
          la.NAME,
          la.TYPE,
          la.FORMAT,
          la.OBJECTS,
          la.ZONES,
          la.SENSORS,
          la.SCHEDULE,
          "",
        ],
        colModel: [
          {
            name: "dt_report",
            index: "dt_report",
            width: 110,
            fixed: true,
            align: "center",
          },
          {
            name: "name",
            index: "name",
            width: 215,
            sortable: true,
          },
          {
            name: "type",
            index: "type",
            width: 190,
            align: "center",
            sortable: false,
          },
          {
            name: "format",
            index: "format",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "objects",
            index: "objects",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "zones",
            index: "zones",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "sensors",
            index: "sensors",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "schedule",
            index: "schedule",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 60,
            align: "center",
            sortable: false,
          },
        ],
        sortname: "dt_report",
        sortorder: "desc",
        rowNum: 50,
        rowList: [50, 100, 200, 300, 400, 500],
        pager: "#reports_generated_list_grid_pager",
        viewrecords: true,
        height: "450px",
        width: "962",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#reports_generated_list_grid").jqGrid(
        "navGrid",
        "#reports_generated_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#reports_generated_list_grid").navButtonAdd(
        "#reports_generated_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "reports_generated_list_grid_action_menu_button",
        }
      ),
      $("#reports_generated_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#reports_generated_list_grid_action_menu").hide(),
      $("#reports_generated_list_grid_action_menu_button").click(function () {
        return (
          $("#reports_generated_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#reports_generated_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#rilogbook_logbook_grid").jqGrid({
        url: "",
        datatype: "json",
        colNames: [la.TIME, la.OBJECT, la.GROUP, la.NAME, la.POSITION, ""],
        colModel: [
          {
            name: "dt_tracker",
            index: "dt_tracker",
            width: 60,
            sortable: true,
          },
          {
            name: "imei",
            index: "imei",
            width: 80,
            align: "left",
            sortable: false,
          },
          {
            name: "group",
            index: "group",
            width: 60,
            align: "center",
            sortable: false,
          },
          {
            name: "name",
            index: "name",
            width: 80,
            align: "left",
            sortable: false,
          },
          {
            name: "position",
            index: "position",
            width: 175,
            align: "left",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
        ],
        sortname: "dt_tracker",
        sortorder: "desc",
        rowNum: 50,
        rowList: [50, 100, 200, 300, 400, 500],
        pager: "#rilogbook_logbook_grid_pager",
        viewrecords: true,
        height: "150px",
        width: "750",
        shrinkToFit: true,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#rilogbook_logbook_grid").jqGrid(
        "navGrid",
        "#rilogbook_logbook_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#rilogbook_logbook_grid").navButtonAdd("#rilogbook_logbook_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "rilogbook_logbook_grid_action_menu_button",
      }),
      $("#rilogbook_logbook_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#rilogbook_logbook_grid_action_menu").hide(),
      $("#rilogbook_logbook_grid_action_menu_button").click(function () {
        return (
          $("#rilogbook_logbook_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#rilogbook_logbook_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#dtc_list_grid").jqGrid({
        url: "",
        datatype: "json",
        colNames: [la.TIME, la.OBJECT, la.CODE, la.POSITION, ""],
        colModel: [
          {
            name: "dt_tracker",
            index: "dt_tracker",
            width: 60,
            sortable: true,
          },
          {
            name: "imei",
            index: "imei",
            width: 80,
            align: "left",
            sortable: false,
          },
          {
            name: "code",
            index: "code",
            width: 60,
            align: "left",
            sortable: false,
          },
          {
            name: "position",
            index: "position",
            width: 215,
            align: "left",
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
        ],
        sortname: "dt_tracker",
        sortorder: "desc",
        rowNum: 50,
        rowList: [50, 100, 200, 300, 400, 500],
        pager: "#dtc_list_grid_pager",
        viewrecords: true,
        height: "150px",
        width: "750",
        shrinkToFit: true,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          return "input" === t.target.tagName.toLowerCase();
        },
      }),
      $("#dtc_list_grid").jqGrid("navGrid", "#dtc_list_grid_pager", {
        add: false,
        edit: false,
        del: false,
        search: false,
      }),
      $("#dtc_list_grid").navButtonAdd("#dtc_list_grid_pager", {
        caption: "",
        title: la.ACTION,
        buttonicon: "ui-icon-action",
        onClickButton: function () {},
        position: "last",
        id: "dtc_list_grid_action_menu_button",
      }),
      $("#dtc_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#dtc_list_grid_action_menu").hide(),
      $("#dtc_list_grid_action_menu_button").click(function () {
        return (
          $("#dtc_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#dtc_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#image_gallery_list_grid").jqGrid({
        url: "func/fn_img.php?cmd=load_img_list",
        datatype: "json",
        colNames: [la.TIME, la.OBJECT, "", "", "", "", ""],
        colModel: [
          {
            name: "dt_tracker",
            index: "dt_tracker",
            width: 110,
            sortable: true,
          },
          {
            name: "object",
            index: "object",
            width: 111,
            sortable: false,
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
          {
            name: "img_file",
            index: "img_file",
            hidden: true,
          },
          {
            name: "lat",
            index: "lat",
            hidden: true,
          },
          {
            name: "lng",
            index: "lng",
            hidden: true,
          },
          {
            name: "speed",
            index: "speed",
            hidden: true,
          },
        ],
        rowNum: 25,
        recordtext: "",
        emptyrecords: "",
        rowList: [25, 50, 75, 100],
        pager: "#image_gallery_list_grid_pager",
        sortname: "dt_server",
        sortorder: "desc",
        viewrecords: true,
        height: "302px",
        width: "308",
        shrinkToFit: false,
        multiselect: true,
        beforeSelectRow: function (e, t) {
          if ("input" === t.target.tagName.toLowerCase()) return true;
          var a = "data/img/" + $(this).jqGrid("getCell", e, "img_file"),
            o = $(this).jqGrid("getCell", e, "lat"),
            i = $(this).jqGrid("getCell", e, "lng");
          $(this).jqGrid("getCell", e, "speed");
          fileExist(a)
            ? (document.getElementById("image_gallery_img").innerHTML =
                '<img style="image-orientation: from-image; height: 480px;" src="' +
                a +
                '">')
            : (document.getElementById("image_gallery_img").innerHTML =
                '<img src="img/no-image.svg">');
          var s = '<span id="image_gallery_img_data_address"></span>',
            n =
              '<table border="0" cellspacing="0" height="100%"><tr><td style="white-space:nowrap;">' +
              urlPosition(o, i) +
              s +
              "</td></tr></table>";
          return (
            (document.getElementById("image_gallery_img_data").innerHTML = n),
            geocoderGetAddress(o, i, function (e) {
              "" != e &&
                (document.getElementById(
                  "image_gallery_img_data_address"
                ).innerHTML = " - " + e);
            }),
            false
          );
        },
      }),
      $("#image_gallery_list_grid").jqGrid(
        "navGrid",
        "#image_gallery_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
        }
      ),
      $("#image_gallery_list_grid").navButtonAdd(
        "#image_gallery_list_grid_pager",
        {
          caption: "",
          title: la.ACTION,
          buttonicon: "ui-icon-action",
          onClickButton: function () {},
          position: "last",
          id: "image_gallery_list_grid_action_menu_button",
        }
      ),
      $("#image_gallery_list_grid_action_menu").menu({
        role: "listbox",
      }),
      $("#image_gallery_list_grid_action_menu").hide(),
      $("#image_gallery_list_grid_action_menu_button").click(function () {
        return (
          $("#image_gallery_list_grid_action_menu").toggle().position({
            my: "left bottom",
            at: "right-5 top-5",
            of: this,
          }),
          $(document).one("click", function () {
            $("#image_gallery_list_grid_action_menu").hide();
          }),
          false
        );
      }),
      $("#chat_object_list_grid").jqGrid({
        datatype: "local",
        colNames: ["", "", la.OBJECT],
        colModel: [
          {
            name: "search",
            index: "search",
            hidden: true,
          },
          {
            name: "icon",
            index: "icon",
            width: 28,
            sortable: false,
          },
          {
            name: "name",
            index: "search",
            width: 170,
          },
        ],
        rowNum: 4096,
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        width: "225",
        shrinkToFit: false,
        loadComplete: function (e) {
          chatUpdateMsgCount(), chatUpdateMsgDt();
        },
        onSelectRow: function (e) {
          chatSelectObject(e);
        },
      }),
      $("#chat_object_list_search").bind("keyup", function (e) {
        var t = $("#chat_object_list_grid"),
          a = t.jqGrid("getGridParam", "postData");
        jQuery.extend(a, {
          filters: "",
          searchField: "search",
          searchOper: "cn",
          searchString: this.value.toLowerCase(),
        }),
          t.jqGrid("setGridParam", {
            search: true,
            postData: a,
          }),
          t.trigger("reloadGrid");
      }),
      $("#billing_plan_list_grid").jqGrid({
        url: "func/fn_billing.php?cmd=load_billing_plan_list",
        datatype: "json",
        colNames: [la.TIME, la.NAME, la.OBJECTS, la.PERIOD, la.PRICE, ""],
        colModel: [
          {
            name: "dt_purchase",
            index: "dt_purchase",
            width: 110,
            fixed: true,
            align: "center",
          },
          {
            name: "name",
            index: "name",
            width: 248,
          },
          {
            name: "objects",
            index: "objects",
            width: 95,
            fixed: true,
            align: "center",
          },
          {
            name: "period",
            index: "period",
            width: 95,
            fixed: true,
            align: "center",
          },
          {
            name: "price",
            index: "price",
            width: 95,
            fixed: true,
            align: "center",
          },
          {
            name: "modify",
            index: "modify",
            width: 30,
            align: "center",
            sortable: false,
          },
        ],
        rowNum: 50,
        rowList: [25, 50, 75, 100, 200],
        pager: "#billing_plan_list_grid_pager",
        sortname: "dt_purchase",
        sortorder: "desc",
        viewrecords: true,
        height: "388px",
        width: "720",
        shrinkToFit: false,
      }),
      $("#billing_plan_list_grid").jqGrid(
        "navGrid",
        "#billing_plan_list_grid_pager",
        {
          add: true,
          edit: false,
          del: false,
          search: false,
          addfunc: function (e) {
            billingPlanPurchase();
          },
          addtitle: la.PURCHASE_PLAN,
        }
      ),
      $("#billing_plan_object_list_grid").jqGrid({
        datatype: "local",
        colNames: ["", la.NAME, la.IMEI, la.ACTIVE, la.EXPIRES_ON],
        colModel: [
          {
            name: "name_sort",
            index: "name_sort",
            hidden: true,
          },
          {
            name: "name",
            index: "name_sort",
            width: 244,
          },
          {
            name: "imei",
            index: "imei",
            width: 160,
          },
          {
            name: "active",
            index: "active",
            width: 90,
            align: "center",
          },
          {
            name: "object_expire_dt",
            index: "object_expire_dt",
            width: 110,
            align: "center",
          },
        ],
        rowNum: 4096,
        pager: "#billing_plan_object_list_grid_pager",
        pgbuttons: false,
        pgtext: "",
        recordtext: "",
        emptyrecords: "",
        sortname: "name",
        sortorder: "asc",
        viewrecords: true,
        height: "270",
        width: "665",
        shrinkToFit: false,
        multiselect: true,
        onSelectRow: function (e) {
          billingPlanUseUpdateSelection();
        },
        onSelectAll: function (e) {
          billingPlanUseUpdateSelection();
        },
      }),
      $("#billing_plan_object_list_grid").jqGrid(
        "navGrid",
        "#billing_plan_object_list_grid_pager",
        {
          add: false,
          edit: false,
          del: false,
          search: false,
          refresh: false,
        }
      ),
      $(".ui-jqgrid-titlebar-close").hide(),
      $(".ui-pg-selbox").multipleSelect({
        single: true,
        width: "50px",
      }),
      $(window)
        .bind("resize", function () {
          resizeGrids();
        })
        .trigger("resize");
  }
  

  function historyShowRoute(e, t, a) {
    // console.log('gs common')
    if (historyHideRoute(),
        objectFollowAll(!1),
        "" == (historyRouteData = e).route || historyRouteData.route.length < 2)
        return notifyBox("info", la.INFORMATION, la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST),
            loadingData(!1),
            void (historyRouteData = []);
    historyRouteData.name = a,
        historyRouteData.imei = t,
        historyRouteData.layers = new Array,
        historyRouteData.layers.route = !1,
        historyRouteData.layers.route_snap = !1,
        historyRouteData.layers.arrows = !1,
        historyRouteData.layers.arrows_snap = !1,
        historyRouteData.layers.stops = new Array,
        historyRouteData.layers.events = new Array,
        historyRouteData.layers.data_points = new Array,
        historyRouteData.play = new Array,
        historyRouteData.play.status = !1,
        historyRouteData.play.position = 0;
    var i = new Array;
    for (n = 0; n < historyRouteData.route.length; n++) {
        var o = historyRouteData.route[n].lat
            , s = historyRouteData.route[n].lng;
        i.push(L.latLng(o, s)),
            historyRouteAddDataPointMarkerToMap(n)
    }
    for (historyRouteData.layers.route = L.polyline(i, {
        color: settingsUserData.map_rc,
        opacity: .8,
        weight: 3
    }),
        mapLayers.history.addLayer(historyRouteData.layers.route),
        historyRouteData.layers.arrows = L.polylineDecorator(historyRouteData.layers.route, {
            patterns: [{
                offset: 25,
                repeat: 250,
                symbol: L.Symbol.arrowHead({
                    pixelSize: 14,
                    headAngle: 40,
                    pathOptions: {
                        fillOpacity: 1,
                        weight: 0
                    }
                })
            }]
        }),
        mapLayers.history.addLayer(historyRouteData.layers.arrows),
        historyRouteAddStartMarkerToMap(),
        historyRouteAddEndMarkerToMap(),
        n = 0; n < historyRouteData.stops.length; n++)
        historyRouteAddStopMarkerToMap(n);
    for (n = 0; n < historyRouteData.events.length; n++)
        historyRouteAddEventMarkerToMap(n);
    for ((e = []).push({
        el_type: "point",
        el_id: 0,
        icon: '<img src="img/markers/route-start.svg"/>',
        datetime: historyRouteData.route[0].dt_tracker,
        info: ""
    }),
        e.push({
            el_type: "point",
            el_id: historyRouteData.route.length - 1,
            icon: '<img src="img/markers/route-end.svg"/>',
            datetime: historyRouteData.route[historyRouteData.route.length - 1].dt_tracker,
            info: ""
        }),
        n = 0; n < historyRouteData.stops.length; n++)
        e.push({
            el_type: "stop",
            el_id: n,
            icon: '<img src="img/markers/route-stop.svg"/>',
            datetime: historyRouteData.stops[n].dt_start,
            info: historyRouteData.stops[n].duration
        });
    for (n = 0; n < historyRouteData.events.length; n++)
        e.push({
            el_type: "event",
            el_id: n,
            icon: '<img src="img/markers/route-event.svg"/>',
            datetime: historyRouteData.events[n].dt_tracker,
            info: historyRouteData.events[n].event_desc
        });
    for (n = 0; n < historyRouteData.drives.length; n++)
        e.push({
            el_type: "drive",
            el_id: n,
            icon: '<img src="img/markers/route-drive.svg"/>',
            datetime: historyRouteData.drives[n].dt_start,
            info: historyRouteData.drives[n].duration
        });
    for (var n = 0; n <= e.length; n++)
        $("#side_panel_history_route_detail_list_grid").jqGrid("addRowData", n, e[n]);
    $("#side_panel_history_route_detail_list_grid").setGridParam({
        sortname: "datetime",
        sortorder: "asc"
    }).trigger("reloadGrid"),
        historyRouteRoute(),
        historyRouteSnap(),
        historyRouteDataPoints(),
        historyRouteStops(),
        historyRouteEvents();
    var l = historyRouteData.layers.route.getBounds();
    map.fitBounds(l),
        $("#side_panel").tabs("option", "active", 3),
        showBottomPanel(),
        $("#bottom_panel_tabs").tabs("option", "active", 1),
        "bottom_panel" == settingsUserData.datalist && datalistBottomSwitch("route"),
        historyRouteShowPoint(0, !1),
        historyRouteCreateGraphSourceList(),
        historyRouteCreateGraph("speed"),
        document.getElementById("history_view_control").style.display = "block",
        loadingData(!1)
}
function historyHideRoute() {
    null != historyRouteData.route &&
        ((document.getElementById("history_view_control").style.display = "none"),
            (document.getElementById("bottom_panel_graph_label").innerHTML = ""),
            datalistClear("route"),
            initGraph(),
            $("#bottom_panel_msg_list_grid").clearGridData(!0),
            $("#side_panel_history_route_detail_list_grid").clearGridData(!0),
            mapLayers.history.clearLayers(),
            historyRouteStop(),
            $(".qtip").each(function () {
                $(this).data("qtip").destroy();
            }),
            (historyRouteData = []));
}
function historyRouteRouteToggle() {
    historyRouteToggle.route
        ? ((historyRouteToggle.route = !1),
            (document.getElementById("history_view_control_route").className =
                "icon-route-route disabled"))
        : ((historyRouteToggle.route = !0),
            (document.getElementById("history_view_control_route").className =
                "icon-route-route")),
        historyRouteRoute();
}
function historyRouteRoute() {
    null != historyRouteData.layers &&
        (mapLayers.history.removeLayer(historyRouteData.layers.route),
            0 != historyRouteData.layers.route_snap &&
            mapLayers.history.removeLayer(historyRouteData.layers.route_snap),
            historyRouteToggle.route &&
            (0 != historyRouteData.layers.route_snap && historyRouteToggle.snap
                ? mapLayers.history.addLayer(historyRouteData.layers.route_snap)
                : mapLayers.history.addLayer(historyRouteData.layers.route)));
}
function historyRouteSnapToggle() {
    historyRouteToggle.snap
        ? ((historyRouteToggle.snap = !1),
            (document.getElementById("history_view_control_snap").className =
                "icon-route-snap disabled"))
        : ((historyRouteToggle.snap = !0),
            (document.getElementById("history_view_control_snap").className =
                "icon-route-snap")),
        historyRouteSnap();
}
function historyRouteSnap() {
    if (null != historyRouteData.route)
        if (historyRouteToggle.snap)
            if (
                0 == historyRouteData.layers.route_snap &&
                0 == historyRouteData.layers.arrows_snap
            ) {
                var e = new Array(),
                    t = Math.floor(historyRouteData.route.length / 99);
                for (t < 1 && (t = 1), i = 0; i < historyRouteData.route.length; i += t)
                    (lat = historyRouteData.route[i].lat),
                        (lng = historyRouteData.route[i].lng),
                        e.push(L.latLng(lat, lng));
                if (
                    ((lat =
                        historyRouteData.route[historyRouteData.route.length - 1].lat),
                        (lng = historyRouteData.route[historyRouteData.route.length - 1].lng),
                        e.push(L.latLng(lat, lng)),
                        "" == gsValues.routing_osmr_service_url)
                )
                    var a = L.Routing.control({
                        waypoints: e,
                        show: !1,
                        showAlternatives: !1,
                        waypointMode: "snap",
                        createMarker: function () { },
                    }).addTo(map);
                else
                    a = L.Routing.control({
                        waypoints: e,
                        show: !1,
                        showAlternatives: !1,
                        waypointMode: "snap",
                        createMarker: function () { },
                        router: new L.Routing.OSRMv1({
                            serviceUrl: gsValues.routing_osmr_service_url,
                        }),
                    }).addTo(map);
                a.on("routeselected", function (t) {
                    (e = t.route.coordinates),
                        mapLayers.history.removeLayer(historyRouteData.layers.route),
                        mapLayers.history.removeLayer(historyRouteData.layers.arrows),
                        (historyRouteData.layers.route_snap = L.polyline(e, {
                            color: settingsUserData.map_rc,
                            opacity: 0.8,
                            weight: 3,
                        })),
                        mapLayers.history.addLayer(historyRouteData.layers.route_snap),
                        (historyRouteData.layers.arrows_snap = L.polylineDecorator(
                            historyRouteData.layers.route_snap,
                            {
                                patterns: [
                                    {
                                        offset: 25,
                                        repeat: 250,
                                        symbol: L.Symbol.arrowHead({
                                            pixelSize: 14,
                                            headAngle: 40,
                                            pathOptions: {
                                                fillOpacity: 1,
                                                weight: 0,
                                            },
                                        }),
                                    },
                                ],
                            }
                        )),
                        mapLayers.history.addLayer(historyRouteData.layers.arrows_snap),
                        map.removeControl(a),
                        historyRouteArrows();
                });
            } else historyRouteRoute(), historyRouteArrows();
        else historyRouteRoute(), historyRouteArrows();
}
// function historyRouteArrowsToggle() {
//     historyRouteToggle.arrows
//         ? ((historyRouteToggle.arrows = !1),
//             (document.getElementById("history_view_control_arrows").className =
//                 "icon-route-arrow disabled"))
//         : ((historyRouteToggle.arrows = !0),
//             (document.getElementById("history_view_control_arrows").className =
//                 "icon-route-arrow")),
//         historyRouteArrows();
// }
function historyRouteArrows() {
    null != historyRouteData.layers &&
        (mapLayers.history.removeLayer(historyRouteData.layers.arrows),
            0 != historyRouteData.layers.arrows_snap &&
            mapLayers.history.removeLayer(historyRouteData.layers.arrows_snap),
            historyRouteToggle.arrows &&
            (0 != historyRouteData.layers.arrows_snap && historyRouteToggle.snap
                ? mapLayers.history.addLayer(historyRouteData.layers.arrows_snap)
                : mapLayers.history.addLayer(historyRouteData.layers.arrows)));
}
function historyRouteDataPointsToggle() {
    historyRouteToggle.data_points
        ? ((historyRouteToggle.data_points = !1),
            (document.getElementById("history_view_control_data_points").className =
                "icon-route-data-point disabled"))
        : ((historyRouteToggle.data_points = !0),
            (document.getElementById("history_view_control_data_points").className =
                "icon-route-data-point")),
        historyRouteDataPoints();
}
function historyRouteDataPoints() {
    if (null != historyRouteData.layers)
        if (map.getZoom() >= 14)
            for (i = 0; i < historyRouteData.layers.data_points.length; i++) {
                var e = historyRouteData.layers.data_points[i];
                historyRouteToggle.data_points
                    ? 0 == mapLayers.history.hasLayer(e) && mapLayers.history.addLayer(e)
                    : mapLayers.history.removeLayer(e);
            }
        else
            for (i = 0; i < historyRouteData.layers.data_points.length; i++) {
                e = historyRouteData.layers.data_points[i];
                mapLayers.history.removeLayer(e);
            }
}
function historyRouteStopsToggle() {
    historyRouteToggle.stops
        ? ((historyRouteToggle.stops = !1),
            (document.getElementById("history_view_control_stops").className =
                "icon-route-stop disabled"))
        : ((historyRouteToggle.stops = !0),
            (document.getElementById("history_view_control_stops").className =
                "icon-route-stop")),
        historyRouteStops();
}
function historyRouteStops() {
    if (null != historyRouteData.layers) {
        for (i = 0; i < historyRouteData.layers.stops.length; i++) {
            var e = historyRouteData.layers.stops[i];
            historyRouteToggle.stops
                ? mapLayers.history.addLayer(e)
                : mapLayers.history.removeLayer(e);
        }
        historyRouteToggle.stops
            ? gridElementTypeToggle(
                "#side_panel_history_route_detail_list_grid",
                "stop",
                ""
            )
            : gridElementTypeToggle(
                "#side_panel_history_route_detail_list_grid",
                "stop",
                "none"
            );
    }
}
function historyRouteEventsToggle() {
    historyRouteToggle.events
        ? ((historyRouteToggle.events = !1),
            (document.getElementById("history_view_control_events").className =
                "icon-route-event disabled"))
        : ((historyRouteToggle.events = !0),
            (document.getElementById("history_view_control_events").className =
                "icon-route-event")),
        historyRouteEvents();
}
function historyRouteEvents() {
    if (null != historyRouteData.layers) {
        for (i = 0; i < historyRouteData.layers.events.length; i++) {
            var e = historyRouteData.layers.events[i];
            historyRouteToggle.events
                ? mapLayers.history.addLayer(e)
                : mapLayers.history.removeLayer(e);
        }
        historyRouteToggle.events
            ? gridElementTypeToggle(
                "#side_panel_history_route_detail_list_grid",
                "event",
                ""
            )
            : gridElementTypeToggle(
                "#side_panel_history_route_detail_list_grid",
                "event",
                "none"
            );
    }
}
function historyRouteCreateGraphSourceList() {
    var e = historyRouteData.imei,
        t = document.getElementById("bottom_panel_graph_data_source");
    (t.options.length = 0),
        t.options.add(new Option(la.SPEED, "speed")),
        t.options.add(new Option(la.ALTITUDE, "altitude"));
    var a = new Array();
    for (var i in settingsObjectData[e].sensors) {
        ((s = settingsObjectData[e].sensors[i]).id = i), a.push(s);
    }
    var o = sortArrayByElement(a, "name");
    for (var i in o) {
        var s;
        "string" != (s = o[i]).result_type &&
            "rel" != s.result_type &&
            t.options.add(new Option(s.name, s.id));
    }
}


function historyRouteChangeGraphSource() {
    historyRouteCreateGraph(
        document.getElementById("bottom_panel_graph_data_source").value
    );
}
function historyRouteCreateGraph(e) {
    document.getElementById("bottom_panel_graph_label").innerHTML = "";
    var t = historyRouteData.imei;
    if (
        ((historyRouteData.graph = []),
            (historyRouteData.graph.data = []),
            (historyRouteData.graph.data_index = []),
            "speed" != e && "altitude" != e)
    )
        var a = settingsObjectData[t].sensors[e];
    for (var i = 0; i < historyRouteData.route.length; i++) {
        var o = historyRouteData.route[i].dt_tracker,
            s = getTimestampFromDate(o.replace(/-/g, "/") + " UTC");
        if ("speed" == e) var n = historyRouteData.route[i].speed;
        else if ("altitude" == e) n = historyRouteData.route[i].altitude;
        else {
            if ("fuelsumup" == a.type)
                n = getSensorValueFuelLevelSumUp(
                    t,
                    historyRouteData.route[i].params,
                    a
                ).value;
            else n = getSensorValue(historyRouteData.route[i].params, a).value;
            "engh" == a.type && ((n = n / 60 / 60), (n = Math.round(100 * n) / 100));
        }
        historyRouteData.graph.data.push([s, n]),
            (historyRouteData.graph.data_index[s] = i);
    }
    "speed" == e
        ? ((historyRouteData.graph.units = la.UNIT_SPEED),
            (historyRouteData.graph.result_type = ""))
        : "altitude" == e
            ? ((historyRouteData.graph.units = la.UNIT_HEIGHT),
                (historyRouteData.graph.result_type = ""))
            : "odo" == a.type
                ? ((historyRouteData.graph.units = la.UNIT_DISTANCE),
                    (historyRouteData.graph.result_type = a.result_type))
                : "engh" == a.type
                    ? ((historyRouteData.graph.units = la.UNIT_H),
                        (historyRouteData.graph.result_type = a.result_type))
                    : ((historyRouteData.graph.units = a.units),
                        (historyRouteData.graph.result_type = a.result_type)),
        initGraph(historyRouteData.graph);
}
function historyRoutePlay() {
    if (
        (clearTimeout(timer_historyRoutePlay),
            0 == historyRouteData.play.status && destroyMapPopup(),
            historyRouteData.route.length > 0 &&
            historyRouteData.play.position < historyRouteData.route.length)
    ) {
        var e = historyRouteData.route[historyRouteData.play.position].dt_tracker;
        graphSetCrosshair(getTimestampFromDate(e.replace(/-/g, "/") + " UTC"));
        var t = historyRouteData.graph.data,
            a = historyRouteData.graph.units;
        document.getElementById("bottom_panel_graph_label").innerHTML =
            t[historyRouteData.play.position][1] + " " + a + " - " + e;
        var i = historyRouteData.route[historyRouteData.play.position];
        if (
            (datalistShowData("route", historyRouteData.imei, i),
                historyRoutePanToPoint(historyRouteData.play.position),
                historyRouteAddPointMarkerToMap(historyRouteData.play.position),
                (historyRouteData.play.status = !0),
                historyRouteData.play.position == historyRouteData.route.length - 1)
        )
            return (
                clearTimeout(timer_historyRoutePlay),
                (historyRouteData.play.status = !1),
                void (historyRouteData.play.position = 0)
            );
        1 == document.getElementById("bottom_panel_graph_play_speed").value
            ? (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 2e3))
            : 2 == document.getElementById("bottom_panel_graph_play_speed").value
                ? (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 1e3))
                : 3 == document.getElementById("bottom_panel_graph_play_speed").value
                    ? (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 500))
                    : 4 == document.getElementById("bottom_panel_graph_play_speed").value
                        ? (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 250))
                        : 5 == document.getElementById("bottom_panel_graph_play_speed").value
                            ? (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 125))
                            : 6 == document.getElementById("bottom_panel_graph_play_speed").value &&
                            (timer_historyRoutePlay = setTimeout("historyRoutePlay()", 65)),
            historyRouteData.play.position++;
    }
}
function historyRoutePause() {
    clearTimeout(timer_historyRoutePlay);
}
function historyRouteStop() {
    clearTimeout(timer_historyRoutePlay),
        (historyRouteData.play.status = !1),
        (historyRouteData.play.position = 0);
}
function historyRouteAddStartMarkerToMap() {
    var e = historyRouteData.route[0].lng,
        t = historyRouteData.route[0].lat,
        a = L.marker([t, e], {
            icon: mapMarkerIcons.route_start,
        });
    a.on("click", function (e) {
        historyRouteShowPoint(0, !0);
    }),
        mapLayers.history.addLayer(a);
}
function historyRouteAddEndMarkerToMap() {
    var e = historyRouteData.route[historyRouteData.route.length - 1].lng,
        t = historyRouteData.route[historyRouteData.route.length - 1].lat,
        a = L.marker([t, e], {
            icon: mapMarkerIcons.route_end,
        });
    a.on("click", function (e) {
        historyRouteShowPoint(historyRouteData.route.length - 1, !0);
    }),
        mapLayers.history.addLayer(a);
}
function historyRouteAddStopMarkerToMap(e) {
    var t = historyRouteData.stops[e].lng,
        a = historyRouteData.stops[e].lat,
        i = L.marker([a, t], {
            icon: mapMarkerIcons.route_stop,
        });
    i.on("click", function (t) {
        historyRouteShowStop(e);
    }),
        mapLayers.history.addLayer(i),
        historyRouteData.layers.stops.push(i);
}
function historyRouteAddEventMarkerToMap(e) {
    var t = historyRouteData.events[e].lng,
        a = historyRouteData.events[e].lat,
        i = L.marker([a, t], {
            icon: mapMarkerIcons.route_event,
        });
    i.on("click", function (t) {
        historyRouteShowEvent(e);
    }),
        mapLayers.history.addLayer(i),
        historyRouteData.layers.events.push(i);
}

function historyRouteAddDataPointMarkerToMap(e) {
    historyRouteData.imei;
    var t = historyRouteData.route[e].lng,
        a = historyRouteData.route[e].lat,
        i = L.marker([a, t], {
            icon: mapMarkerIcons.route_data_point,
            iconAngle: 0,
        }),
        o = e;
    i.on("click", function (e) {
        historyRouteShowPoint(o, !0);
    }),
        historyRouteData.layers.data_points.push(i);
}
function historyRouteAddPointMarkerToMap(e) {
    historyRouteRemovePointMarker();
    var t = historyRouteData.imei,
        a = historyRouteData.route[e].lng,
        i = historyRouteData.route[e].lat,
        o = historyRouteData.route[e].angle,
        s = historyRouteData.route[e].speed,
        n = historyRouteData.route[e].dt_tracker,
        l = (historyRouteData.route[e].params, settingsUserData.map_is),
        d = o;
    "arrow" != settingsObjectData[t].map_icon && (d = 0);
    var r = getMarkerIcon(t, s, !1, !1),
        _ = L.marker([i, a], {
            icon: r,
            iconAngle: d,
        }),
        c = s + " " + la.UNIT_SPEED + " - " + n;
    _.bindTooltip(c, {
        permanent: !0,
        offset: [20 * l, 0],
        direction: "right",
    }).openTooltip(),
        _.on("click", function (t) {
            historyRouteShowPoint(e.true);
        }),
        mapLayers.history.addLayer(_),
        (historyRouteData.layers.point_marker = _);
}
function historyRouteRemovePointMarker() {
    historyRouteData.layers.point_marker &&
        mapLayers.history.removeLayer(historyRouteData.layers.point_marker);
}
function historyRoutePanToPoint(e) {
    var t = historyRouteData.route[e].lng,
        a = historyRouteData.route[e].lat;
    map.panTo({
        lat: a,
        lng: t,
    });
}
function historyRouteShowPoint(e, t) {
    historyRouteRemoveDrive();
    var a = historyRouteData.name,
        i = historyRouteData.imei,
        o = historyRouteData.route[e].lng,
        s = historyRouteData.route[e].lat,
        n = historyRouteData.route[e].altitude,
        l = historyRouteData.route[e].angle,
        d = historyRouteData.route[e].speed,
        r = historyRouteData.route[e].dt_tracker,
        _ = historyRouteData.route[e].params,
        c = historyRouteData.route[e];
    if ((datalistShowData("route", i, c), t)) {
        var g = settingsUserData.map_is;
        geocoderGetAddress(s, o, function (t) {
            var c = t,
                m = urlPosition(s, o),
                u = "",
                p = new Array();
            for (var y in settingsObjectData[i].sensors)
                p.push(settingsObjectData[i].sensors[y]);
            var h = sortArrayByElement(p, "name");
            for (var y in h) {
                var v = h[y];
                if ("true" == v.popup)
                    if ("fuelsumup" == v.type) {
                        var b = getSensorValueFuelLevelSumUp(i, _, v);
                        u +=
                            "<tr><td><strong>" +
                            v.name +
                            ":</strong></td><td>" +
                            b.value_full +
                            "</td></tr>";
                    } else {
                        b = getSensorValue(_, v);
                        u +=
                            "<tr><td><strong>" +
                            v.name +
                            ":</strong></td><td>" +
                            b.value_full +
                            "</td></tr>";
                    }
            }
            var E =
                "<table>\t\t\t<tr><td><strong>" +
                la.OBJECT +
                ":</strong></td><td>" +
                a +
                "</td></tr>\t\t\t<tr><td><strong>" +
                la.ADDRESS +
                ":</strong></td><td>" +
                c +
                "</td></tr>\t\t\t<tr><td><strong>" +
                la.POSITION +
                ":</strong></td><td>" +
                m +
                "</td></tr>\t\t\t<tr><td><strong>" +
                la.ALTITUDE +
                ":</strong></td><td>" +
                n +
                " " +
                la.UNIT_HEIGHT +
                "</td></tr>\t\t\t<tr><td><strong>" +
                la.ANGLE +
                ":</strong></td><td>" +
                l +
                " &deg;</td></tr>\t\t\t<tr><td><strong>" +
                la.SPEED +
                ":</strong></td><td>" +
                d +
                " " +
                la.UNIT_SPEED +
                "</td></tr>\t\t\t<tr><td><strong>" +
                la.TIME +
                ":</strong></td><td>" +
                r +
                "</td></tr>",
                f = getObjectOdometer(i, _);
            -1 != f &&
                (E +=
                    "<tr><td><strong>" +
                    la.ODOMETER +
                    ":</strong></td><td>" +
                    f +
                    " " +
                    la.UNIT_DISTANCE +
                    "</td></tr>");
            var I = getObjectEngineHours(i, _);
            -1 != I &&
                (E +=
                    "<tr><td><strong>" +
                    la.ENGINE_HOURS +
                    ":</strong></td><td>" +
                    I +
                    "</td></tr>");
            var B = E + u;
            (E += "</table>"),
                (B += "</table>"),
                0 == e || historyRouteData.route.length - 1 == e
                    ? addPopupToMap(s, o, [0, -28 * g], E, B)
                    : addPopupToMap(s, o, [0, -14 * g], E, B),
                1 == gsValues.map_street_view &&
                (objectUnSelectAll(), utilsStreetView(s, o, l));
        });
    }
}
function historyRoutePanToStop(e) {
    var t = historyRouteData.stops[e].lng,
        a = historyRouteData.stops[e].lat;
    map.panTo({
        lat: a,
        lng: t,
    });
}
function historyRouteShowStop(e) {
    historyRouteRemoveDrive();
    var t = historyRouteData.name,
        a = historyRouteData.imei,
        i = historyRouteData.stops[e].lng,
        o = historyRouteData.stops[e].lat,
        s = historyRouteData.stops[e].altitude,
        n = historyRouteData.stops[e].angle,
        l = historyRouteData.stops[e].dt_start,
        d = historyRouteData.stops[e].dt_end,
        r = historyRouteData.stops[e].duration,
        _ = historyRouteData.stops[e].params,
        c = historyRouteData.stops[e];
    datalistShowData("route", a, c);
    var g = settingsUserData.map_is;
    geocoderGetAddress(o, i, function (e) {
        var c = e,
            m = urlPosition(o, i),
            u = "",
            p = new Array();
        for (var y in settingsObjectData[a].sensors)
            p.push(settingsObjectData[a].sensors[y]);
        var h = sortArrayByElement(p, "name");
        for (var y in h) {
            var v = h[y];
            if ("true" == v.popup)
                if ("fuelsumup" == v.type) {
                    var b = getSensorValueFuelLevelSumUp(a, _, v);
                    u +=
                        "<tr><td><strong>" +
                        v.name +
                        ":</strong></td><td>" +
                        b.value_full +
                        "</td></tr>";
                } else {
                    b = getSensorValue(_, v);
                    u +=
                        "<tr><td><strong>" +
                        v.name +
                        ":</strong></td><td>" +
                        b.value_full +
                        "</td></tr>";
                }
        }
        var E =
            "<table>\t\t\t<tr><td><strong>" +
            la.OBJECT +
            ":</strong></td><td>" +
            t +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ADDRESS +
            ":</strong></td><td>" +
            c +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.POSITION +
            ":</strong></td><td>" +
            m +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ALTITUDE +
            ":</strong></td><td>" +
            s +
            " " +
            la.UNIT_HEIGHT +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ANGLE +
            ":</strong></td><td>" +
            n +
            " &deg;</td></tr>\t\t\t<tr><td><strong>" +
            la.ARRIVED +
            ":</strong></td><td>" +
            l +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.DEPARTED +
            ":</strong></td><td>" +
            d +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.DURATION +
            ":</strong></td><td>" +
            r +
            "</td></tr>",
            f = getObjectOdometer(a, _);
        -1 != f &&
            (E +=
                "<tr><td><strong>" +
                la.ODOMETER +
                ":</strong></td><td>" +
                f +
                " " +
                la.UNIT_DISTANCE +
                "</td></tr>");
        var I = getObjectEngineHours(a, _);
        -1 != I &&
            (E +=
                "<tr><td><strong>" +
                la.ENGINE_HOURS +
                ":</strong></td><td>" +
                I +
                "</td></tr>");
        var B = E + u;
        addPopupToMap(o, i, [0, -28 * g], (E += "</table>"), (B += "</table>")),
            1 == gsValues.map_street_view &&
            (objectUnSelectAll(), utilsStreetView(o, i, n));
    });
}
function historyRoutePanToEvent(e) {
    var t = historyRouteData.events[e].lng,
        a = historyRouteData.events[e].lat;
    map.panTo({
        lat: a,
        lng: t,
    });
}
function historyRouteShowEvent(e) {
    historyRouteRemoveDrive();
    var t = historyRouteData.name,
        a = historyRouteData.imei,
        i = historyRouteData.events[e].event_desc,
        o = historyRouteData.events[e].dt_tracker,
        s = historyRouteData.events[e].lng,
        n = historyRouteData.events[e].lat,
        l = historyRouteData.events[e].altitude,
        d = historyRouteData.events[e].angle,
        r = historyRouteData.events[e].speed,
        _ = historyRouteData.events[e].params,
        c = historyRouteData.events[e];
    datalistShowData("route", a, c);
    var g = settingsUserData.map_is;
    geocoderGetAddress(n, s, function (e) {
        var c = e,
            m = urlPosition(n, s),
            u = "",
            p = new Array();
        for (var y in settingsObjectData[a].sensors)
            p.push(settingsObjectData[a].sensors[y]);
        var h = sortArrayByElement(p, "name");
        for (var y in h) {
            var v = h[y];
            if ("true" == v.popup)
                if ("fuelsumup" == v.type) {
                    var b = getSensorValueFuelLevelSumUp(a, _, v);
                    u +=
                        "<tr><td><strong>" +
                        v.name +
                        ":</strong></td><td>" +
                        b.value_full +
                        "</td></tr>";
                } else {
                    b = getSensorValue(_, v);
                    u +=
                        "<tr><td><strong>" +
                        v.name +
                        ":</strong></td><td>" +
                        b.value_full +
                        "</td></tr>";
                }
        }
        var E =
            "<table>\t\t\t<tr><td><strong>" +
            la.OBJECT +
            ":</strong></td><td>" +
            t +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.EVENT +
            ":</strong></td><td>" +
            i +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ADDRESS +
            ":</strong></td><td>" +
            c +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.POSITION +
            ":</strong></td><td>" +
            m +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ALTITUDE +
            ":</strong></td><td>" +
            l +
            " " +
            la.UNIT_HEIGHT +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.ANGLE +
            ":</strong></td><td>" +
            d +
            " &deg;</td></tr>\t\t\t<tr><td><strong>" +
            la.SPEED +
            ":</strong></td><td>" +
            r +
            " " +
            la.UNIT_SPEED +
            "</td></tr>\t\t\t<tr><td><strong>" +
            la.TIME +
            ":</strong></td><td>" +
            o +
            "</td></tr>",
            f = getObjectOdometer(a, _);
        -1 != f &&
            (E +=
                "<tr><td><strong>" +
                la.ODOMETER +
                ":</strong></td><td>" +
                f +
                " " +
                la.UNIT_DISTANCE +
                "</td></tr>");
        var I = getObjectEngineHours(a, _);
        -1 != I &&
            (E +=
                "<tr><td><strong>" +
                la.ENGINE_HOURS +
                ":</strong></td><td>" +
                I +
                "</td></tr>");
        var B = E + u;
        addPopupToMap(n, s, [0, -28 * g], (E += "</table>"), (B += "</table>")),
            1 == gsValues.map_street_view &&
            (objectUnSelectAll(), utilsStreetView(n, s, d));
    });
}
function historyRouteRemoveDrive() {
    historyRouteData.layers.route_drive &&
        mapLayers.history.removeLayer(historyRouteData.layers.route_drive);
}
function historyRouteShowDrive(e) {
    historyRouteRemoveDrive();
    var t = historyRouteData.drives[e].id_start_s,
        a = historyRouteData.drives[e].id_end,
        o = new Array();
    for (i = 0; i <= a - t; i++) {
        var s = historyRouteData.route[t + i].lat,
            n = historyRouteData.route[t + i].lng;
        o.push(L.latLng(s, n));
    }
    var l = L.polyline(o, {
        color: settingsUserData.map_rhc,
        opacity: 0.8,
        weight: 3,
    });
    if ((mapLayers.history.addLayer(l), 0 == historyRouteData.play.status)) {
        var d = l.getBounds();
        map.fitBounds(d);
    }
    historyRouteData.layers.route_drive = l;
}
function historyRouteMsgDeleteSelected() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        utilsCheckPrivileges("obj_history_clear")
    ) {
        var e = $("#bottom_panel_msg_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_msgs",
                            imei: historyRouteData.imei,
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_history.php",
                            data: a,
                            success: function (e) {
                                "OK" == e &&
                                    $("#bottom_panel_msg_list_grid").trigger("reloadGrid");
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
(historyRouteToggle.route = !0),
    (historyRouteToggle.snap = !1),
    (historyRouteToggle.arrows = !1),
    (historyRouteToggle.data_points = !1),
    (historyRouteToggle.stops = !0),
    (historyRouteToggle.events = !0);
var reportsData = new Array();

// #################################################
// END HISTORY FUNCTIONS
// #################################################

// #################################################
// REPORTS FUNCTIONS
// #################################################

function reportsOpen() {
    utilsCheckPrivileges("reports") && $("#dialog_reports").dialog("open");
}
function reportsReload() {
    reportsLoadData(), $("#report_list_grid").trigger("reloadGrid");
}
function reportsLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_reports.php",
        data: {
            cmd: "load_report_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            reportsData.reports = e;
        },
    });
}

// function reportProperties(e) {
//     // console.log(reportsData.reports[t].name)
//     switch (e) {
//         default:
//             var t = e;
//             (reportsData.edit_report_id = t),
//                 (document.getElementById("dialog_report_name").value =
//                     reportsData.reports[t].name),
//                 (document.getElementById("dialog_report_type").value =
//                     reportsData.reports[t].type),
//                 $("#dialog_report_type").multipleSelect("refresh"),
//                 reportsSwitchType(),
//                 (document.getElementById("dialog_report_ignore_empty_reports").checked =
//                     strToBoolean(reportsData.reports[t].ignore_empty_reports)),
//                 (document.getElementById("dialog_report_format").value =
//                     reportsData.reports[t].format),
//                 $("#dialog_report_format").multipleSelect("refresh"),
//                 (document.getElementById("dialog_report_show_coordinates").checked =
//                     strToBoolean(reportsData.reports[t].show_coordinates)),
//                 (document.getElementById("dialog_report_show_addresses").checked =
//                     strToBoolean(reportsData.reports[t].show_addresses)),
//                 (document.getElementById("dialog_report_markers_addresses").checked =
//                     strToBoolean(reportsData.reports[t].markers_addresses)),
//                 (document.getElementById("dialog_report_zones_addresses").checked =
//                     strToBoolean(reportsData.reports[t].zones_addresses)),
//                 (document.getElementById("dialog_report_stop_duration").value =
//                     reportsData.reports[t].stop_duration),
//                 $("#dialog_report_stop_duration").multipleSelect("refresh"),
//                 (document.getElementById("dialog_report_speed_limit").value =
//                     reportsData.reports[t].speed_limit);
//             var a = document.getElementById("dialog_report_object_list"),
//                 i = reportsData.reports[t].imei.split(",");
//             multiselectSetValues(a, i),
//                 $("#dialog_report_object_list").multipleSelect("refresh");
//             var o = document.getElementById(""),
//                 s = reportsData.reports[t].marker_ids.split(",");
//             multiselectSetValues(o, s),
//                 $("#").multipleSelect("refresh");
//             var n = document.getElementById("dialog_report_zone_list"),
//                 l = reportsData.reports[t].zone_ids.split(",");
//             multiselectSetValues(n, l),
//                 $("#dialog_report_zone_list").multipleSelect("refresh"),
//                 reportsListSensors();
//             var d = document.getElementById("dialog_report_sensor_list"),
//                 r = reportsData.reports[t].sensor_names.split(",");
//             multiselectSetValues(d, r),
//                 $("#dialog_report_sensor_list").multipleSelect("refresh"),
//                 reportsListDataItems();
//             var rep_data_items = document.getElementById("dialog_report_data_item_list"),
//                 c = reportsData.reports[t].data_items.split(",");
//             multiselectSetValues(rep_data_items, c),
//                 $("#dialog_report_data_item_list").multipleSelect("refresh"),
//                 "travel_sheet_dn" == reportsData.reports[t].type
//                     ? ((document.getElementById(
//                         "dialog_report_other_dn_starts_hour"
//                     ).value = reportsData.reports[t].other.dn_starts_hour),
//                         $("#dialog_report_other_dn_starts_hour").multipleSelect("refresh"),
//                         (document.getElementById(
//                             "dialog_report_other_dn_starts_minute"
//                         ).value = reportsData.reports[t].other.dn_starts_minute),
//                         $("#dialog_report_other_dn_starts_minute").multipleSelect(
//                             "refresh"
//                         ),
//                         (document.getElementById("dialog_report_other_dn_ends_hour").value =
//                             reportsData.reports[t].other.dn_ends_hour),
//                         $("#dialog_report_other_dn_ends_hour").multipleSelect("refresh"),
//                         (document.getElementById(
//                             "dialog_report_other_dn_ends_minute"
//                         ).value = reportsData.reports[t].other.dn_ends_minute),
//                         $("#dialog_report_other_dn_ends_minute").multipleSelect("refresh"))
//                     : "rag" == reportsData.reports[t].type ||
//                         "rag_driver" == reportsData.reports[t].type
//                         ? ((document.getElementById(
//                             "dialog_report_other_rag_low_score"
//                         ).value = reportsData.reports[t].other.low_score),
//                             (document.getElementById(
//                                 "dialog_report_other_rag_high_score"
//                             ).value = reportsData.reports[t].other.high_score))
//                         : ((document.getElementById(
//                             "dialog_report_other_dn_starts_hour"
//                         ).value = ""),
//                             (document.getElementById(
//                                 "dialog_report_other_dn_starts_minute"
//                             ).value = ""),
//                             (document.getElementById("dialog_report_other_dn_ends_hour").value =
//                                 ""),
//                             (document.getElementById(
//                                 "dialog_report_other_dn_ends_minute"
//                             ).value = ""),
//                             (document.getElementById(
//                                 "dialog_report_other_rag_low_score"
//                             ).value = ""),
//                             (document.getElementById(
//                                 "dialog_report_other_rag_high_score"
//                             ).value = "")),
//                 "d" == (S = reportsData.reports[t].schedule_period)
//                     ? ((document.getElementById(
//                         "dialog_report_schedule_period_daily"
//                     ).checked = !0),
//                         (document.getElementById(
//                             "dialog_report_schedule_period_weekly"
//                         ).checked = !1))
//                     : "w" == S
//                         ? ((document.getElementById(
//                             "dialog_report_schedule_period_daily"
//                         ).checked = !1),
//                             (document.getElementById(
//                                 "dialog_report_schedule_period_weekly"
//                             ).checked = !0))
//                         : "dw" == S
//                             ? ((document.getElementById(
//                                 "dialog_report_schedule_period_daily"
//                             ).checked = !0),
//                                 (document.getElementById(
//                                     "dialog_report_schedule_period_weekly"
//                                 ).checked = !0))
//                             : ((document.getElementById(
//                                 "dialog_report_schedule_period_daily"
//                             ).checked = !1),
//                                 (document.getElementById(
//                                     "dialog_report_schedule_period_weekly"
//                                 ).checked = !1)),
//                 (document.getElementById("dialog_report_schedule_email_address").value =
//                     reportsData.reports[t].schedule_email_address),
//                 (document.getElementById("dialog_report_filter").value = 2),
//                 $("#dialog_report_filter").multipleSelect("refresh"),
//                 switchDateFilter("report"),
//                 $("#dialog_report_properties").dialog("open");
//             break;
//         case "add":
//             (reportsData.edit_report_id = !1),
//                 (document.getElementById("dialog_report_name").value = ""),
//                 (document.getElementById("dialog_report_type").value = "general"),
//                 $("#dialog_report_type").multipleSelect("refresh"),
//                 reportsSwitchType(),
//                 (document.getElementById("dialog_report_ignore_empty_reports").checked =
//                     !1),
//                 (document.getElementById("dialog_report_format").value = "html"),
//                 $("#dialog_report_format").multipleSelect("refresh"),
//                 (document.getElementById("dialog_report_show_coordinates").checked =
//                     !0),
//                 (document.getElementById("dialog_report_show_addresses").checked = !1),
//                 (document.getElementById("dialog_report_markers_addresses").checked =
//                     !1),
//                 (document.getElementById("dialog_report_zones_addresses").checked = !1),
//                 (document.getElementById("dialog_report_stop_duration").value = 1),
//                 $("#dialog_report_stop_duration").multipleSelect("refresh"),
//                 (document.getElementById("dialog_report_speed_limit").value = ""),
//                 $("#dialog_report_object_list option:selected").removeAttr("selected"),
//                 $("#dialog_report_object_list").multipleSelect("refresh"),
//                 $("#dialog_report_zone_list option:selected").removeAttr("selected"),
//                 $("#dialog_report_zone_list").multipleSelect("refresh"),
//                 reportsListSensors(),
//                 $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
//                 $("#dialog_report_sensor_list").multipleSelect("refresh"),
//                 reportsListDataItems(),
//                 $("#dialog_report_data_items_list option:selected").removeAttr(
//                     "selected"
//                 ),
//                 $("#dialog_report_data_items_list").multipleSelect("refresh"),
//                 (document.getElementById(
//                     "dialog_report_schedule_period_daily"
//                 ).checked = !1),
//                 (document.getElementById(
//                     "dialog_report_schedule_period_weekly"
//                 ).checked = !1),
//                 (document.getElementById("dialog_report_schedule_email_address").value =
//                     ""),
//                 (document.getElementById("dialog_report_filter").value = 2),
//                 $("#dialog_report_filter").multipleSelect("refresh"),
//                 switchDateFilter("report"),
//                 $("#dialog_report_properties").dialog("open");
//             break;
//         case "cancel":
//             $("#dialog_report_properties").dialog("close");
//             break;
//         case "save":
//             if (!utilsCheckPrivileges("viewer")) return;
//             var rep_name = document.getElementById("dialog_report_name").value,
//                 rep_type = document.getElementById("dialog_report_type").value,
//                 rep_ignore = document.getElementById(
//                     "dialog_report_ignore_empty_reports"
//                 ).checked,
//                 rep_format = document.getElementById("dialog_report_format").value,
//                 rep_showcoords = document.getElementById("dialog_report_show_coordinates").checked,
//                 rep_showaddr = document.getElementById("dialog_report_show_addresses").checked,
//                 rep_markr = document.getElementById("dialog_report_markers_addresses").checked,
//                 rep_zone_addr = document.getElementById("dialog_report_zones_addresses").checked,
//                 rep_stop_duration = document.getElementById("dialog_report_stop_duration").value,
//                 rep_stop_limit = document.getElementById("dialog_report_speed_limit").value,
//                 rep_imei = multiselectGetValues(
//                     document.getElementById("dialog_report_object_list")
//                 ),
//                 rep_marker_id = multiselectGetValues(
//                     document.getElementById("")
//                 ),
//                 rep_zone_id = multiselectGetValues(
//                     document.getElementById("dialog_report_zone_list")
//                 ),
//                 rep_sensor_name = multiselectGetValues(
//                     document.getElementById("dialog_report_sensor_list")
//                 );
//             rep_data_items = multiselectGetValues(
//                 document.getElementById("dialog_report_data_item_list")
//             );
//             if ("" == rep_name)
//                 return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
//             if (
//                 ("overspeed" == rep_type ||
//                     "overspeed_count" == rep_type ||
//                     "underspeed" == rep_type ||
//                     "underspeed_count" == rep_type) &&
//                 "" == rep_stop_limit
//             )
//                 return void notifyBox("error", la.ERROR, la.SPEED_LIMIT_CANT_BE_EMPTY);
//             if ("" == rep_imei)
//                 return void notifyBox(
//                     "error",
//                     la.ERROR,
//                     la.AT_LEAST_ONE_OBJECT_SELECTED
//                 );
//             if (("marker_in_out" == rep_type || "marker_in_out_gen" == rep_type) && "" == rep_marker_id)
//                 return void notifyBox(
//                     "error",
//                     la.ERROR,
//                     la.AT_LEAST_ONE_MARKER_SELECTED
//                 );
//             if (("zone_in_out" == rep_type || "zone_in_out_general" == rep_type) && "" == rep_zone_id)
//                 return void notifyBox("error", la.ERROR, la.AT_LEAST_ONE_ZONE_SELECTED);
//             if (
//                 ("drives_stops_sensors" == rep_type ||
//                     "drives_stops_logic" == rep_type ||
//                     "logic_sensors" == rep_type ||
//                     "sensor_graph" == rep_type) &&
//                 "" == rep_sensor_name
//             )
//                 return void notifyBox(
//                     "error",
//                     la.ERROR,
//                     la.AT_LEAST_ONE_SENSOR_SELECTED
//                 );
//             if ("travel_sheet_dn" == rep_type) {
//                 var rep_others = {
//                     dn_starts_hour: document.getElementById(
//                         "dialog_report_other_dn_starts_hour"
//                     ).value,
//                     dn_starts_minute: document.getElementById(
//                         "dialog_report_other_dn_starts_minute"
//                     ).value,
//                     dn_ends_hour: document.getElementById(
//                         "dialog_report_other_dn_ends_hour"
//                     ).value,
//                     dn_ends_minute: document.getElementById(
//                         "dialog_report_other_dn_ends_minute"
//                     ).value,
//                 };
//                 rep_others = JSON.stringify(rep_others);
//             } else if ("rag" == rep_type || "rag_driver" == rep_type) {
//                 rep_others = {
//                     low_score: document.getElementById(
//                         "dialog_report_other_rag_low_score"
//                     ).value,
//                     high_score: document.getElementById(
//                         "dialog_report_other_rag_high_score"
//                     ).value,
//                 };
//                 rep_others = JSON.stringify(rep_others);
//             } else rep_others = "";
//             var j = document.getElementById(
//                 "dialog_report_schedule_period_daily"
//             ).checked,
//                 T = document.getElementById(
//                     "dialog_report_schedule_period_weekly"
//                 ).checked,
//                 R = document.getElementById(
//                     "dialog_report_schedule_email_address"
//                 ).value,
//                 S = "";
//             if ((1 == j && (S = "d"), 1 == T && (S += "w"), "" != S))
//                 for (var w = R.split(","), L = 0; L < w.length; L++)
//                     if (((w[L] = w[L].trim()), !isEmailValid(w[L])))
//                         return void notifyBox(
//                             "error",
//                             la.ERROR,
//                             la.THIS_EMAIL_IS_NOT_VALID
//                         );
//             var A = {
//                 cmd: "save_report",
//                 report_id: reportsData.edit_report_id,
//                 name: rep_name,
//                 type: rep_type,
//                 ignore_empty_reports: rep_ignore,
//                 format: rep_format,
//                 show_coordinates: rep_showcoords,
//                 show_addresses: rep_showaddr,
//                 markers_addresses: rep_markr,
//                 zones_addresses: rep_zone_addr,
//                 stop_duration: rep_stop_duration,
//                 speed_limit: rep_stop_limit,
//                 imei: rep_imei,
//                 marker_ids: rep_marker_id,
//                 zone_ids: rep_zone_id,
//                 sensor_names: rep_sensor_name,
//                 data_items: rep_data_items,
//                 other: rep_others,
//                 schedule_period: S,
//                 schedule_email_address: R,
//             };
//             // console.log(A)
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_reports.php",
//                 data: A,
//                 cache: !1,
//                 success: function (e) {
//                     "OK" == e &&
//                         (reportsReload(),
//                             $("#dialog_report_properties").dialog("close"),
//                             notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
//                 },
//             });
//             break;
//         case "generate":
//             (rep_name = document.getElementById("dialog_report_name").value),
//                 (rep_type = document.getElementById("dialog_report_type").value),
//                 (rep_ignore = document.getElementById(
//                     "dialog_report_ignore_empty_reports"
//                 ).checked),
//                 (rep_format = document.getElementById("dialog_report_format").value),
//                 (rep_showcoords = document.getElementById("dialog_report_show_coordinates").checked),
//                 (rep_showaddr = document.getElementById("dialog_report_show_addresses").checked),
//                 (rep_markr = document.getElementById(
//                     "dialog_report_markers_addresses"
//                 ).checked),
//                 (rep_zone_addr = document.getElementById("dialog_report_zones_addresses").checked),
//                 (rep_stop_duration = document.getElementById("dialog_report_stop_duration").value),
//                 (rep_stop_limit = document.getElementById("dialog_report_speed_limit").value),
//                 (rep_imei = multiselectGetValues(
//                     document.getElementById("dialog_report_object_list")
//                 )),
//                 (rep_marker_id = multiselectGetValues(
//                     document.getElementById("")
//                 )),
//                 (rep_zone_id = multiselectGetValues(
//                     document.getElementById("dialog_report_zone_list")
//                 )),
//                 (rep_sensor_name = multiselectGetValues(
//                     document.getElementById("dialog_report_sensor_list")
//                 )),
//                 (rep_data_items = multiselectGetValues(
//                     document.getElementById("dialog_report_data_item_list")
//                 ));
//             if ("travel_sheet_dn" == rep_type) {
//                 rep_others = {
//                     dn_starts_hour: document.getElementById(
//                         "dialog_report_other_dn_starts_hour"
//                     ).value,
//                     dn_starts_minute: document.getElementById(
//                         "dialog_report_other_dn_starts_minute"
//                     ).value,
//                     dn_ends_hour: document.getElementById(
//                         "dialog_report_other_dn_ends_hour"
//                     ).value,
//                     dn_ends_minute: document.getElementById(
//                         "dialog_report_other_dn_ends_minute"
//                     ).value,
//                 };
//                 rep_others = JSON.stringify(rep_others);
//             } else if ("rag" == rep_type || "rag_driver" == rep_type) {
//                 rep_others = {
//                     low_score: document.getElementById(
//                         "dialog_report_other_rag_low_score"
//                     ).value,
//                     high_score: document.getElementById(
//                         "dialog_report_other_rag_high_score"
//                     ).value,
//                 };
//                 rep_others = JSON.stringify(rep_others);
//             } else rep_others = "";
//             var rep_dtf =
//                 $("#dialog_report_date_from").val() +
//                 " " +
//                 $("#dialog_report_hour_from").val() +
//                 ":" +
//                 $("#dialog_report_minute_from").val() +
//                 ":00",
//                 rep_dtt =
//                     $("#dialog_report_date_to").val() +
//                     " " +
//                     $("#dialog_report_hour_to").val() +
//                     ":" +
//                     $("#dialog_report_minute_to").val() +
//                     ":00";
//             "" == rep_name &&
//                 (rep_name =
//                     document.getElementById("dialog_report_type").options[
//                         document.getElementById("dialog_report_type").selectedIndex
//                     ].text),
//                 reportGenerate(
//                     (A = {
//                         cmd: "report",
//                         name: rep_name,
//                         type: rep_type,
//                         ignore_empty_reports: rep_ignore,
//                         format: rep_format,
//                         show_coordinates: rep_showcoords,
//                         show_addresses: rep_showaddr,
//                         markers_addresses: rep_markr,
//                         zones_addresses: rep_zone_addr,
//                         stop_duration: rep_stop_duration,
//                         speed_limit: rep_stop_limit,
//                         imei: rep_imei,
//                         marker_ids: rep_marker_id,
//                         zone_ids: rep_zone_id,
//                         sensor_names: rep_sensor_name,
//                         data_items: rep_data_items,
//                         other: rep_others,
//                         dtf: rep_dtf,
//                         dtt: rep_dtt,
//                     })
//                 );
//                 // console.log(A)
//     }
// }
function reportsDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_report",
                    report_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_reports.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && reportsReload();
                    },
                });
            }
        });
}
function reportsDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#report_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_reports",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_reports.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && reportsReload();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
// function reportGenerate(e) {
//     ("overspeed" != e.type &&
//         "overspeed_count" != e.type &&
//         "underspeed" != e.type &&
//         "underspeed_count" != e.type &&
//         "rag" != e.type &&
//         "rag_driver" != e.type) ||
//         "" != e.speed_limit
//         ? "" != e.imei
//             ? ("marker_in_out" != e.type && "marker_in_out_gen" != e.type) ||
//                 "" != e.marker_ids
//                 ? ("zone_in_out" != e.type && "zone_in_out_general" != e.type) ||
//                     "" != e.zone_ids
//                     ? ("drives_stops_sensors" != e.type &&
//                         "drives_stops_logic" != e.type &&
//                         "logic_sensors" != e.type &&
//                         "sensor_graph" != e.type) ||
//                         "" != e.sensor_names
//                         ? (loadingData(!0),
//                             $.ajax({
//                                 type: "POST",
//                                 url: "func/fn_reports.gen.php",
//                                 data: e,
//                                 cache: !1,
//                                 success: function (t) {
//                                     loadingData(!1),
//                                         $.generateFile({
//                                             filename:
//                                                 e.name.toLowerCase() + "_" + e.dtf + "_" + e.dtt,
//                                             content: t,
//                                             script: "func/fn_saveas.php?format=" + e.format,
//                                         }),
//                                         reportsGeneratedReload();
//                                 },
//                                 error: function (e, t) {
//                                     loadingData(!1);
//                                 },
//                             }))
//                         : notifyBox("error", la.ERROR, la.AT_LEAST_ONE_SENSOR_SELECTED)
//                     : notifyBox("error", la.ERROR, la.AT_LEAST_ONE_ZONE_SELECTED)
//                 : notifyBox("error", la.ERROR, la.AT_LEAST_ONE_MARKER_SELECTED)
//             : notifyBox("error", la.ERROR, la.AT_LEAST_ONE_OBJECT_SELECTED)
//         : notifyBox("error", la.ERROR, la.SPEED_LIMIT_CANT_BE_EMPTY);
// }
function reportsSelectObject() {
    reportsListSensors();
}
function reportsListDataItems() {
    var e = document.getElementById("dialog_report_type").value;
    if (null != reportsData.data_items[e]) {
        var t = reportsData.data_items[e],
            a = document.getElementById("dialog_report_data_item_list");
        a.options.length = 0;
        for (var i = 0; i < t.length; i++) {
            var o = t[i].toUpperCase();
            o = la[o];
            var s = t[i];
            a.options.add(new Option(o, s));
        }
    }
    $("#dialog_report_data_item_list option").prop("selected", !0),
        $("#dialog_report_data_item_list").multipleSelect("refresh");
}
function reportsListSensors() {
    var e = document.getElementById("dialog_report_sensor_list");
    e.options.length = 0;
    var t = document.getElementById("dialog_report_type").value;
    if (
        "route_data_sensors" == t ||
        "drives_stops_sensors" == t ||
        "drives_stops_logic" == t ||
        "logic_sensors" == t ||
        "sensor_graph" == t
    ) {
        for (
            var a = document.getElementById("dialog_report_object_list"),
            i = new Array(),
            o = 0;
            o < a.options.length;
            o++
        )
            if (a.options[o].selected) {
                var s = a.options[o].value,
                    n = settingsObjectData[s].sensors;
                for (var l in n) {
                    var d = n[l];
                    "string" != d.result_type &&
                        ("drives_stops_logic" == t || "logic_sensors" == t
                            ? "logic" == d.result_type && i.push(d.name)
                            : ("route_data_sensors" != t &&
                                "drives_stops_sensors" != t &&
                                "sensor_graph" != t) ||
                            i.push(d.name));
                }
            }
        i = uniqueArray(i);
        for (o = 0; o < i.length; o++) e.options.add(new Option(i[o], i[o]));
        sortSelectList(e);
    }
    $("#dialog_report_sensor_list").multipleSelect("refresh");
}
function reportsSwitchType() {
    var e = document.getElementById("dialog_report_type").value,
        t = document.getElementById("dialog_report_format");
    switch (
    ((t.options.length = 0),
        "speed_graph" != e &&
            "altitude_graph" != e &&
            "acc_graph" != e &&
            "fuellevel_graph" != e &&
            "temperature_graph" != e &&
            "sensor_graph" != e &&
            "routes" != e &&
            "routes_stops" != e &&
            "image_gallery" != e
            ? (t.options.add(new Option("HTML", "html")),
                t.options.add(new Option("PDF", "pdf")),
                t.options.add(new Option("XLS", "xls")))
            : t.options.add(new Option("HTML", "html")),
        $("#dialog_report_format").multipleSelect("refresh"),
        e)
    ) {
        case "general":
        case "general_merged":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "object_info":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "current_position":
        case "current_position_off":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "route_data_sensors":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !1),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "drives_stops":
        case "drives_stops3":
            // console.log('ajam')
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "drives_stops_sensors":
        case "drives_stops_logic":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !1),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "travel_sheet":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "mileage_daily":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "overspeed":
        case "exceso_vel_personalizado_en_geocercas1m_excel":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "overspeed_count":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "underspeed":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "underspeed_count":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "marker_in_out":
            (document.getElementById("").disabled = !1),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "marker_in_out_gen":
            (document.getElementById("").disabled = !1),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "zone_in_out":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !1),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "zone_in_out_general":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !1),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "events":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "service":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "rag":
        case "rag_driver":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "tasks":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "rilogbook":
        case "dtc":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "expenses":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "fuelfillings":
        case "fuelthefts":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "logic_sensors":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !1),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
            break;
        case "speed_graph":
        case "altitude_graph":
        case "acc_graph":
        case "fuellevel_graph":
        case "temperature_graph":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "sensor_graph":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !1),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_speed_limit").value = ""),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "routes":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "routes_stops":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !1),
                (document.getElementById("dialog_report_stop_duration").disabled = !1),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !0),
                (document.getElementById("dialog_report_show_addresses").disabled = !0),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !0);
            break;
        case "image_gallery":
            (document.getElementById("").disabled = !0),
                $("# option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_zone_list").disabled = !0),
                $("#dialog_report_zone_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_sensor_list").disabled = !0),
                $("#dialog_report_sensor_list option:selected").removeAttr("selected"),
                (document.getElementById("dialog_report_speed_limit").disabled = !0),
                (document.getElementById("dialog_report_stop_duration").disabled = !0),
                (document.getElementById("dialog_report_show_coordinates").disabled =
                    !1),
                (document.getElementById("dialog_report_show_addresses").disabled = !1),
                (document.getElementById("dialog_report_markers_addresses").disabled =
                    !1),
                (document.getElementById("dialog_report_zones_addresses").disabled =
                    !1);
    }
    $("#dialog_report_zone_list").multipleSelect("refresh"),
        $("#dialog_report_sensor_list").multipleSelect("refresh"),
        "travel_sheet_dn" == e
            ? ((document.getElementById("dialog_report_other_dn_starts_hour").value =
                "22"),
                $("#dialog_report_other_dn_starts_hour").multipleSelect("refresh"),
                (document.getElementById("dialog_report_other_dn_starts_minute").value =
                    "00"),
                $("#dialog_report_other_dn_starts_minute").multipleSelect("refresh"),
                (document.getElementById("dialog_report_other_dn_ends_hour").value =
                    "06"),
                $("#dialog_report_other_dn_ends_hour").multipleSelect("refresh"),
                (document.getElementById("dialog_report_other_dn_ends_minute").value =
                    "00"),
                $("#dialog_report_other_dn_ends_minute").multipleSelect("refresh"),
                (document.getElementById("dialog_report_other_dn").style.display = ""),
                (document.getElementById("dialog_report_other_rag").style.display =
                    "none"))
            : "rag" == e || "rag_driver" == e
                ? ((document.getElementById(
                    "dialog_report_other_rag_low_score"
                ).value = 0),
                    (document.getElementById(
                        "dialog_report_other_rag_high_score"
                    ).value = 5),
                    (document.getElementById("dialog_report_other_dn").style.display =
                        "none"),
                    (document.getElementById("dialog_report_other_rag").style.display = ""))
                : ((document.getElementById("dialog_report_other_dn_starts_hour").value =
                    ""),
                    (document.getElementById("dialog_report_other_dn_starts_minute").value =
                        ""),
                    (document.getElementById("dialog_report_other_dn_ends_hour").value =
                        ""),
                    (document.getElementById("dialog_report_other_dn_ends_minute").value =
                        ""),
                    (document.getElementById("dialog_report_other_rag_low_score").value =
                        ""),
                    (document.getElementById("dialog_report_other_rag_high_score").value =
                        ""),
                    (document.getElementById("dialog_report_other_dn").style.display =
                        "none"),
                    (document.getElementById("dialog_report_other_rag").style.display =
                        "none"));
}
function reportsGeneratedReload() {
    $("#reports_generated_list_grid").trigger("reloadGrid");
}
function reportsGeneratedOpen(e) {
    loadingData(!0);
    var t = {
        cmd: "open_generated",
        report_id: e,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_reports.php",
        data: t,
        dataType: "json",
        cache: !1,
        success: function (e) {
            loadingData(!1),
                $.generateFile({
                    filename: e.filename,
                    content: e.content,
                    script: "func/fn_saveas.php?format=" + e.format,
                });
        },
        error: function (e, t) {
            loadingData(!1);
        },
    });
}
function reportsGeneratedDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_report_generated",
                    report_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_reports.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && reportsGeneratedReload();
                    },
                });
            }
        });
}
function reportsGeneratedDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#reports_generated_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_reports_generated",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_reports.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && reportsGeneratedReload();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}

(reportsData.reports = new Array()),
    (reportsData.edit_report_id = !1),
    (reportsData.data_items = new Array()),
    (reportsData.data_items.general = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "stop_duration",
        "stop_count",
        "top_speed",
        "avg_speed",
        "overspeed_count",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
        "custom_fields",
    ]),
    (reportsData.data_items.general_merged = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "stop_duration",
        "stop_count",
        "top_speed",
        "avg_speed",
        "overspeed_count",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.object_info = [
        "imei",
        "group",
        "transport_model",
        "vin",
        "plate_number",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
        "gps_device",
        "sim_card_number",
    ]),
    (reportsData.data_items.current_position = [
        "time",
        "position",
        "speed",
        "altitude",
        "angle",
        "status",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.current_position_off = [
        "time",
        "position",
        "speed",
        "altitude",
        "angle",
        "status",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.route_data_sensors = [
        "time",
        "position",
        "speed",
        "altitude",
        "angle",
    ]),
    (reportsData.data_items.drives_stops = [
        "status",
        "start",
        "end",
        "duration",
        "move_duration",
        "stop_duration",
        "route_length",
        "top_speed",
        "avg_speed",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.drives_stops_sensors = [
        "status",
        "start",
        "end",
        "duration",
        "move_duration",
        "stop_duration",
        "route_length",
        "top_speed",
        "avg_speed",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.drives_stops_logic = [
        "status",
        "start",
        "end",
        "duration",
        "move_duration",
        "stop_duration",
        "route_length",
        "top_speed",
        "avg_speed",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.travel_sheet = [
        "time_a",
        "position_a",
        "time_b",
        "position_b",
        "duration",
        "route_length",
        "fuel_consumption",
        "fuel_cost",
        "total",
      ]),
    (reportsData.data_items.travel_sheet_dn = [
        "time_a",
        "position_a",
        "odometer_a",
        "time_b",
        "position_b",
        "odometer_b",
        "duration",
        "route_length",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.mileage_daily = [
        "time",
        "start",
        "end",
        "move_duration",
        "route_length",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_hours",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.overspeed = [
        "start",
        "end",
        "duration",
        "top_speed",
        "avg_speed",
        "overspeed_position",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.overspeed_count = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "top_speed",
        "avg_speed",
        "overspeed_count",
    ]),
    (reportsData.data_items.underspeed = [
        "start",
        "end",
        "duration",
        "top_speed",
        "avg_speed",
        "underspeed_position",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.underspeed_count = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "top_speed",
        "avg_speed",
        "underspeed_count",
    ]),
    (reportsData.data_items.marker_in_out = [
        "marker_in",
        "marker_out",
        "duration",
        "route_length",
        "engine_hours",
        "marker_name",
        "marker_position",
        "total",
    ]),
    (reportsData.data_items.marker_in_out_gen = [
        "marker_in",
        "marker_out",
        "duration",
        "route_length",
        "engine_hours",
        "marker_name",
        "marker_position",
        "total",
    ]),
    (reportsData.data_items.zone_in_out = [
        "zone_in",
        "zone_out",
        "duration",
        "route_length",
        "engine_hours",
        "zone_name",
        "zone_position",
        "total",
    ]),
    (reportsData.data_items.zone_in_out_general = [
        "zone_in",
        "zone_out",
        "duration",
        "route_length",
        "engine_hours",
        "zone_name",
        "zone_position",
        "total",
    ]),
    (reportsData.data_items.events = [
        "time",
        "event",
        "event_position",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.service = ["service", "last_service", "status"]),
    (reportsData.data_items.rag = [
        "overspeed_score",
        "harsh_acceleration_score",
        "harsh_braking_score",
        "harsh_cornering_score",
    ]),
    (reportsData.data_items.rag_driver = [
        "overspeed_score",
        "harsh_acceleration_score",
        "harsh_braking_score",
        "harsh_cornering_score",
    ]),
    (reportsData.data_items.tasks = [
        "name",
        "description",
        "from",
        "start_time",
        "to",
        "end_time",
        "priority",
        "status",
    ]),
    (reportsData.data_items.rilogbook = ["group", "name", "position"]),
    (reportsData.data_items.dtc = ["code", "position"]),
    (reportsData.data_items.expenses = [
        "date",
        "name",
        "object",
        "quantity",
        "cost",
        "supplier",
        "buyer",
        "odometer",
        "engine_hours",
        "description",
        "total",
    ]),
    (reportsData.data_items.logic_sensors = [
        "sensor",
        "activation_time",
        "deactivation_time",
        "duration",
        "activation_position",
        "deactivation_position",
    ]),
    (reportsData.data_items.acc_graph = []),
    (reportsData.data_items.apeed_graph = []),
    (reportsData.data_items.altitude_graph = []),
    (reportsData.data_items.fuellevel_graph = []),
    (reportsData.data_items.fuelfillings = [
        "time",
        "position",
        "before",
        "after",
        "filled",
        "sensor",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.fuelthefts = [
        "time",
        "position",
        "before",
        "after",
        "stolen",
        "sensor",
        "driver",
        "trailer",
        "total",
    ]),
    (reportsData.data_items.temperature_graph = []),
    (reportsData.data_items.sensor_graph = []),
    (reportsData.data_items.routes = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "stop_duration",
        "stop_count",
        "top_speed",
        "avg_speed",
        "overspeed_count",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.routes_stops = [
        "route_start",
        "route_end",
        "route_length",
        "move_duration",
        "stop_duration",
        "stop_count",
        "top_speed",
        "avg_speed",
        "overspeed_count",
        "fuel_consumption",
        "avg_fuel_consumption",
        "fuel_cost",
        "engine_work",
        "engine_idle",
        "odometer",
        "engine_hours",
        "driver",
        "trailer",
    ]),
    (reportsData.data_items.image_gallery = ["time", "position"]);
var tasksData = new Array(),
    timer_sessionCheck;

// #################################################
// END REPORTS FUNCTIONS
// #################################################

// #################################################
// TASKS FUNCTIONS
// #################################################

function tasksOpen() {
    utilsCheckPrivileges("tasks") &&
        ($("#dialog_tasks")
            .bind("resize", function () {
                $("#tasks_list_grid").setGridHeight($("#dialog_tasks").height() - 133);
            })
            .trigger("resize"),
            $("#dialog_tasks")
                .bind("resize", function () {
                    $("#tasks_list_grid").setGridWidth($("#dialog_tasks").width());
                })
                .trigger("resize"),
            $("#dialog_tasks").dialog("open"));
}
function tasksClose() {
    $("#dialog_tasks").unbind("resize");
}
function tasksShow() {
    var e = "func/fn_tasks.php?cmd=load_task_list",
        t = document.getElementById("dialog_tasks_object_list").value,
        a =
            document.getElementById("dialog_tasks_date_from").value +
            " " +
            document.getElementById("dialog_tasks_hour_from").value +
            ":" +
            document.getElementById("dialog_tasks_minute_from").value +
            ":00",
        i =
            document.getElementById("dialog_tasks_date_to").value +
            " " +
            document.getElementById("dialog_tasks_hour_to").value +
            ":" +
            document.getElementById("dialog_tasks_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        a != i && (e += "&dtf=" + a + "&dtt=" + i),
        $("#tasks_list_grid")
            .jqGrid("setGridParam", {
                url: e,
            })
            .trigger("reloadGrid");
}
function tasksDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_task",
                    task_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_tasks.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && tasksShow();
                    },
                });
            }
        });
}
function tasksDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#tasks_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_tasks",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_tasks.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && tasksShow();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function tasksDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_TASKS, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_tasks.php",
                    data: {
                        cmd: "delete_all_tasks",
                    },
                    success: function (e) {
                        "OK" == e && tasksShow();
                    },
                });
            }
        });
}
function tasksExportCSV() {
    var e = "func/fn_export.php?format=tasks_csv",
        t = document.getElementById("dialog_tasks_object_list").value,
        a =
            document.getElementById("dialog_tasks_date_from").value +
            " " +
            document.getElementById("dialog_tasks_hour_from").value +
            ":" +
            document.getElementById("dialog_tasks_minute_from").value +
            ":00",
        i =
            document.getElementById("dialog_tasks_date_to").value +
            " " +
            document.getElementById("dialog_tasks_hour_to").value +
            ":" +
            document.getElementById("dialog_tasks_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        a != i && (e += "&dtf=" + a + "&dtt=" + i),
        (window.location = e);
}
function tasksNew(e) {
    if (1 != gsValues.map_bussy) {
        gsValues.map_bussy = !0;
        var t = map.editTools.startPolyline(e);
        map.doubleClickZoom.disable(),
            map.on("editable:drawing:clicked", function (e) {
                var a = t.getLatLngs();
                map.editTools.stopDrawing(),
                    1 == map.hasLayer(t) && map.removeLayer(t),
                    map.doubleClickZoom.enable(),
                    map.off("editable:drawing:clicked"),
                    taskProperties("add"),
                    geocoderGetAddress(a[0].lat, a[0].lng, function (e) {
                        (document.getElementById("dialog_task_start_address").value = e),
                            (document.getElementById("dialog_task_start_lat").value =
                                a[0].lat),
                            (document.getElementById("dialog_task_start_lng").value =
                                a[0].lng);
                    }),
                    geocoderGetAddress(a[1].lat, a[1].lng, function (e) {
                        (document.getElementById("dialog_task_end_address").value = e),
                            (document.getElementById("dialog_task_end_lat").value = a[1].lat),
                            (document.getElementById("dialog_task_end_lng").value = a[1].lng);
                    }),
                    (gsValues.map_bussy = !1);
            });
    }
}
function tasksPickAddress(e) {
    1 != gsValues.map_bussy &&
        (map.doubleClickZoom.disable(),
            (gsValues.map_bussy = !0),
            (document.getElementById("map").style.cursor = "crosshair"),
            $("#dialog_tasks").dialog("close"),
            $("#dialog_task_properties").dialog("close"),
            map.on("click", function (t) {
                "start" == e
                    ? geocoderGetAddress(t.latlng.lat, t.latlng.lng, function (e) {
                        (document.getElementById("dialog_task_start_address").value = e),
                            (document.getElementById("dialog_task_start_lat").value =
                                t.latlng.lat),
                            (document.getElementById("dialog_task_start_lng").value =
                                t.latlng.lng);
                    })
                    : geocoderGetAddress(t.latlng.lat, t.latlng.lng, function (e) {
                        (document.getElementById("dialog_task_end_address").value = e),
                            (document.getElementById("dialog_task_end_lat").value =
                                t.latlng.lat),
                            (document.getElementById("dialog_task_end_lng").value =
                                t.latlng.lng);
                    }),
                    map.off("click"),
                    map.doubleClickZoom.enable(),
                    (gsValues.map_bussy = !1),
                    (document.getElementById("map").style.cursor = ""),
                    tasksOpen(),
                    $("#dialog_task_properties").dialog("open");
            }));
}
function taskProperties(e) {
    switch (e) {
        default:
            var t = e;
            tasksData.edit_task_id = t;
            var a = {
                cmd: "load_task",
                task_id: tasksData.edit_task_id,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_tasks.php",
                data: a,
                dataType: "json",
                cache: !1,
                success: function (e) {
                    (document.getElementById("dialog_task_name").value = e.name),
                        (document.getElementById("dialog_task_object_list").value = e.imei),
                        $("#dialog_task_object_list").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_priority").value =
                            e.priority),
                        $("#dialog_task_priority").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_status").value = e.status),
                        $("#dialog_task_status").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_desc").value = e.desc);
                    var t = e.start_from_dt.split(" "),
                        a = e.start_to_dt.split(" "),
                        i = e.end_from_dt.split(" "),
                        o = e.end_to_dt.split(" ");
                    (document.getElementById("dialog_task_start_address").value =
                        e.start_address),
                        (document.getElementById("dialog_task_start_lat").value =
                            e.start_lat),
                        (document.getElementById("dialog_task_start_lng").value =
                            e.start_lng),
                        (document.getElementById("dialog_task_start_from_date").value =
                            t[0]),
                        (document.getElementById("dialog_task_start_from_time").value =
                            t[1].substring(0, 5)),
                        $("#dialog_task_start_from_time").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_start_to_date").value = a[0]),
                        (document.getElementById("dialog_task_start_to_time").value =
                            a[1].substring(0, 5)),
                        $("#dialog_task_start_to_time").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_end_address").value =
                            e.end_address),
                        (document.getElementById("dialog_task_end_lat").value = e.end_lat),
                        (document.getElementById("dialog_task_end_lng").value = e.end_lng),
                        (document.getElementById("dialog_task_end_from_date").value = i[0]),
                        (document.getElementById("dialog_task_end_from_time").value =
                            i[1].substring(0, 5)),
                        $("#dialog_task_end_from_time").multipleSelect("refresh"),
                        (document.getElementById("dialog_task_end_to_date").value = o[0]),
                        (document.getElementById("dialog_task_end_to_time").value =
                            o[1].substring(0, 5)),
                        $("#dialog_task_end_to_time").multipleSelect("refresh");
                },
            }),
                $("#dialog_task_properties").dialog("open");
            break;
        case "add":
            (tasksData.edit_task_id = !1),
                (document.getElementById("dialog_task_name").value = ""),
                (document.getElementById("dialog_task_priority").value = "low"),
                $("#dialog_task_priority").multipleSelect("refresh"),
                (document.getElementById("dialog_task_status").value = 0),
                $("#dialog_task_status").multipleSelect("refresh"),
                (document.getElementById("dialog_task_desc").value = ""),
                (document.getElementById("dialog_task_start_address").value = ""),
                (document.getElementById("dialog_task_start_lat").value = 0),
                (document.getElementById("dialog_task_start_lng").value = 0),
                (document.getElementById("dialog_task_start_from_date").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById("dialog_task_start_from_time").value =
                    "00:00"),
                $("#dialog_task_start_from_time").multipleSelect("refresh"),
                (document.getElementById("dialog_task_start_to_date").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById("dialog_task_start_to_time").value = "00:00"),
                $("#dialog_task_start_to_time").multipleSelect("refresh"),
                (document.getElementById("dialog_task_end_address").value = ""),
                (document.getElementById("dialog_task_end_lat").value = 0),
                (document.getElementById("dialog_task_end_lng").value = 0),
                (document.getElementById("dialog_task_end_from_date").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById("dialog_task_end_from_time").value = "00:00"),
                $("#dialog_task_end_from_time").multipleSelect("refresh"),
                (document.getElementById("dialog_task_end_to_date").value =
                    moment().format("YYYY-MM-DD")),
                (document.getElementById("dialog_task_end_to_time").value = "00:00"),
                $("#dialog_task_end_to_time").multipleSelect("refresh"),
                $("#dialog_task_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_task_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var i = document.getElementById("dialog_task_name").value,
                o = document.getElementById("dialog_task_object_list").value,
                s = document.getElementById("dialog_task_priority").value,
                n = document.getElementById("dialog_task_status").value,
                l = document.getElementById("dialog_task_desc").value,
                d = document.getElementById("dialog_task_start_address").value,
                r = document.getElementById("dialog_task_start_lat").value,
                _ = document.getElementById("dialog_task_start_lng").value,
                c =
                    document.getElementById("dialog_task_start_from_date").value +
                    " " +
                    document.getElementById("dialog_task_start_from_time").value +
                    ":00",
                g =
                    document.getElementById("dialog_task_start_to_date").value +
                    " " +
                    document.getElementById("dialog_task_start_to_time").value +
                    ":00",
                m = document.getElementById("dialog_task_end_address").value,
                u = document.getElementById("dialog_task_end_lat").value,
                p = document.getElementById("dialog_task_end_lng").value,
                y =
                    document.getElementById("dialog_task_end_from_date").value +
                    " " +
                    document.getElementById("dialog_task_end_from_time").value +
                    ":00",
                h =
                    document.getElementById("dialog_task_end_to_date").value +
                    " " +
                    document.getElementById("dialog_task_end_to_time").value +
                    ":00";
            if ("" == i)
                return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
            if ("" == o) {
                notifyBox("error", la.ERROR, la.NO_OBJECT_SELECTED);
                break;
            }
            if ("" == d || "" == m)
                return void notifyBox("error", la.ERROR, la.ADDRESS_CANT_BE_EMPTY);
            a = {
                cmd: "save_task",
                task_id: tasksData.edit_task_id,
                name: i,
                imei: o,
                priority: s,
                status: n,
                desc: l,
                start_address: d,
                start_lat: r,
                start_lng: _,
                start_from_dt: c,
                start_to_dt: g,
                end_address: m,
                end_lat: u,
                end_lng: p,
                end_from_dt: y,
                end_to_dt: h,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_tasks.php",
                data: a,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (tasksShow(),
                            $("#dialog_task_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
tasksData.edit_task_id = !1;
// #################################################
// END TASKS FUNCTIONS
// #################################################

// #################################################
// RILOGBOOK FUNCTIONS
// #################################################

function rilogbookOpen() {
    utilsCheckPrivileges("rilogbook") &&
        ($("#dialog_rilogbook")
            .bind("resize", function () {
                $("#rilogbook_logbook_grid").setGridHeight(
                    $("#dialog_rilogbook").height() - 133
                );
            })
            .trigger("resize"),
            $("#dialog_rilogbook")
                .bind("resize", function () {
                    $("#rilogbook_logbook_grid").setGridWidth(
                        $("#dialog_rilogbook").width()
                    );
                })
                .trigger("resize"),
            $("#dialog_rilogbook").dialog("open"));
}
function rilogbookClose() {
    $("#dialog_rilogbook").unbind("resize");
}
function rilogbookShow() {
    var e = "func/fn_rilogbook.php?cmd=load_rilogbook_list",
        t = document.getElementById("dialog_rilogbook_object_list").value,
        a = document.getElementById("dialog_rilogbook_drivers").checked,
        i = document.getElementById("dialog_rilogbook_passengers").checked,
        o = document.getElementById("dialog_rilogbook_trailers").checked,
        s =
            document.getElementById("dialog_rilogbook_date_from").value +
            " " +
            document.getElementById("dialog_rilogbook_hour_from").value +
            ":" +
            document.getElementById("dialog_rilogbook_minute_from").value +
            ":00",
        n =
            document.getElementById("dialog_rilogbook_date_to").value +
            " " +
            document.getElementById("dialog_rilogbook_hour_to").value +
            ":" +
            document.getElementById("dialog_rilogbook_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        (e += "&drivers=" + a),
        (e += "&passengers=" + i),
        (e += "&trailers=" + o),
        s != n && (e += "&dtf=" + s + "&dtt=" + n),
        $("#rilogbook_logbook_grid")
            .jqGrid("setGridParam", {
                url: e,
            })
            .trigger("reloadGrid");
}
function rilogbookDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_record",
                    rilogbook_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_rilogbook.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && rilogbookShow();
                    },
                });
            }
        });
}
function rilogbookDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#rilogbook_logbook_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_records",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_rilogbook.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && rilogbookShow();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function rilogbookDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(
            la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_LOGBOOK_RECORDS,
            function (e) {
                if (e) {
                    $.ajax({
                        type: "POST",
                        url: "func/fn_rilogbook.php",
                        data: {
                            cmd: "delete_all_records",
                        },
                        success: function (e) {
                            "OK" == e && rilogbookShow();
                        },
                    });
                }
            }
        );
}
function rilogbookExportCSV() {
    var e = "func/fn_export.php?format=rilogbook_csv",
        t = document.getElementById("dialog_rilogbook_object_list").value,
        a = document.getElementById("dialog_rilogbook_drivers").checked,
        i = document.getElementById("dialog_rilogbook_passengers").checked,
        o = document.getElementById("dialog_rilogbook_trailers").checked,
        s =
            document.getElementById("dialog_rilogbook_date_from").value +
            " " +
            document.getElementById("dialog_rilogbook_hour_from").value +
            ":" +
            document.getElementById("dialog_rilogbook_minute_from").value +
            ":00",
        n =
            document.getElementById("dialog_rilogbook_date_to").value +
            " " +
            document.getElementById("dialog_rilogbook_hour_to").value +
            ":" +
            document.getElementById("dialog_rilogbook_minute_to").value +
            ":00";
    "" != t && (e += "&imei=" + t),
        (e += "&drivers=" + a),
        (e += "&passengers=" + i),
        (e += "&trailers=" + o),
        s != n && (e += "&dtf=" + s + "&dtt=" + n),
        (window.location = e);
}
function notifyCheck(e) {
    switch (e) {
        case "expiring_objects":
            if (1 == gsValues.notify_obj_expire)
                for (var t in settingsObjectData) {
                    if (
                        "true" == (a = settingsObjectData[t]).active &&
                        "true" == a.object_expire &&
                        getDateDifference(new Date(a.object_expire_dt), new Date()) <=
                        gsValues.notify_obj_expire_period
                    ) {
                        notifyBox(
                            "error",
                            la.EXPIRING_OBJECTS,
                            la.SOME_OF_YOUR_OBJECTS_ACTIVATION_WILL_EXPIRE_SOON
                        );
                        break;
                    }
                }
            break;
        case "inactive_objects":
            if (1 == gsValues.notify_obj_expire)
                for (var t in settingsObjectData) {
                    var a;
                    if ("false" == (a = settingsObjectData[t]).active) {
                        notifyBox(
                            "error",
                            la.INACTIVE_OBJECTS,
                            la.THERE_ARE_INACTIVE_OBJECTS_IN_YOUR_ACCOUNT
                        );
                        break;
                    }
                }
            break;
        case "session_check":
            if (0 == gsValues.session_check) break;
            clearTimeout(timer_sessionCheck);
            $.ajax({
                type: "POST",
                url: "func/fn_connect.php",
                data: {
                    cmd: "session_check",
                },
                cache: !1,
                error: function (e, t) {
                    timer_sessionCheck = setTimeout(
                        "notifyCheck('session_check');",
                        1e3 * gsValues.session_check
                    );
                },
                success: function (e) {
                    "false" == e
                        ? $("#blocking_panel").show()
                        : (timer_sessionCheck = setTimeout(
                            "notifyCheck('session_check');",
                            1e3 * gsValues.session_check
                        ));
                },
            });
    }
}

// #################################################
// END RILOGBOOK FUNCTIONS
// #################################################

// #################################################
// PLACES FUNCTIONS
// #################################################

var placesGroupData = new Array();
function placesSetListCheckbox(e, t) {
    null != document.getElementById(e) &&
        (document.getElementById(e).checked = t);
}
function placesGroupOpen() {
    utilsCheckPrivileges("subuser") &&
        ($("#places_group_list_grid").trigger("reloadGrid"),
            $("#dialog_places_groups").dialog("open"));
}
function placesGroupClose() {
    placesMarkerReload(), placesRouteReload(), placesZoneReload();
}
function placesGroupReload() {
    placesGroupLoadData(), $("#places_group_list_grid").trigger("reloadGrid");
}
function placesGroupLoadData(e) {
    $.ajax({
        type: "POST",
        url: "func/fn_places.php",
        data: {
            cmd: "load_place_group_data",
        },
        dataType: "json",
        cache: !1,
        success: function (t) {
            for (var a in ((placesGroupData.groups = t),
                (placesGroupData.edit_group_id = !1),
                initSelectList("places_group_list"),
                placesGroupData.groups))
                null != document.getElementById("marker_group_name_" + a) &&
                    (document.getElementById("marker_group_name_" + a).innerHTML =
                        placesGroupData.groups[a].name),
                    null != document.getElementById("route_group_name_" + a) &&
                    (document.getElementById("route_group_name_" + a).innerHTML =
                        placesGroupData.groups[a].name),
                    null != document.getElementById("zone_group_name_" + a) &&
                    (document.getElementById("zone_group_name_" + a).innerHTML =
                        placesGroupData.groups[a].name);
            void 0 !== e && e(!0);
        },
    });
}
function placesGroupDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_place_group",
                    group_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && placesGroupReload();
                    },
                });
            }
        });
}
function placesGroupDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#places_group_list_grid").jqGrid("getGridParam", "selarrrow");
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_place_groups",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_places.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && placesGroupReload();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function placesGroupProperties(e) {
    switch (e) {
        default:
            var t = e;
            (placesGroupData.edit_group_id = t),
                (document.getElementById("dialog_places_group_name").value =
                    placesGroupData.groups[t].name),
                (document.getElementById("dialog_places_group_desc").value =
                    placesGroupData.groups[t].desc),
                $("#dialog_places_group_properties").dialog("open");
            break;
        case "add":
            (placesGroupData.edit_group_id = !1),
                (document.getElementById("dialog_places_group_name").value = ""),
                (document.getElementById("dialog_places_group_desc").value = ""),
                $("#dialog_places_group_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_places_group_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var a = document.getElementById("dialog_places_group_name").value,
                i = document.getElementById("dialog_places_group_desc").value;
            if ("" == a) {
                notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                break;
            }
            var o = {
                cmd: "save_place_group",
                group_id: placesGroupData.edit_group_id,
                group_name: a,
                group_desc: i,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_places.php",
                data: o,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (placesGroupReload(),
                            $("#dialog_places_group_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function placesGroupImport() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (document
            .getElementById("load_file")
            .addEventListener("change", placesGroupImportPGRFile, !1),
            document.getElementById("load_file").click());
}
function placesGroupImportPGRFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.pgr) {
                var a = t.groups.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.GROUPS_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "pgr",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1), "OK" == e && placesGroupReload();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", settingsObjectGroupImportOGRFile, !1);
}
function placesGroupExport() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy
    ) {
        window.location = "func/fn_export.php?format=pgr";
    }
}
function placesImport() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (document
            .getElementById("load_file")
            .addEventListener("change", placesImportPLCFile, !1),
            document.getElementById("load_file").click());
}
function placesImportPLCFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            if ("kml" == t[0].name.split(".").pop().toLowerCase())
                var a = placesKMLToPLC(new X2JS().xml_str2json(e.target.result)),
                    i = JSON.stringify(a);
            else if ("csv" == t[0].name.split(".").pop().toLowerCase())
                (a = placesCSVToPLC(csv2json(e.target.result))),
                    (i = JSON.stringify(a));
            else (a = $.parseJSON(e.target.result)), (i = e.target.result);
            if ("0.1v" == a.plc) {
                var o = a.markers.length,
                    s = a.routes.length,
                    n = a.zones.length;
                if (0 == o && 0 == s && 0 == n)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.MARKERS_ROUTES_ZONES_FOUND, o, s, n) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (e) {
                        if (e) {
                            loadingData(!0);
                            var t = {
                                format: "plc",
                                data: i,
                                markers: !0,
                                routes: !0,
                                zones: !0,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: t,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1),
                                        "OK" == e
                                            ? (placesMarkerLoadData(),
                                                placesRouteLoadData(),
                                                placesZoneLoadData(),
                                                $("#side_panel_places_marker_list_grid").trigger(
                                                    "reloadGrid"
                                                ),
                                                $("#side_panel_places_route_list_grid").trigger(
                                                    "reloadGrid"
                                                ),
                                                $("#side_panel_places_zone_list_grid").trigger(
                                                    "reloadGrid"
                                                ))
                                            : "ERROR_MARKER_LIMIT" == e
                                                ? notifyBox("error", la.ERROR, la.MARKER_LIMIT_IS_REACHED)
                                                : "ERROR_ROUTE_LIMIT" == e
                                                    ? notifyBox("error", la.ERROR, la.ROUTE_LIMIT_IS_REACHED)
                                                    : "ERROR_ZONE_LIMIT" == e &&
                                                    notifyBox("error", la.ERROR, la.ZONE_LIMIT_IS_REACHED);
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", placesImportPLCFile, !1);
}
function placesExport() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy
    ) {
        window.location = "func/fn_export.php?format=plc";
    }
}
function placesCSVToPLC(e) {
    for (
        var t = !1,
        a = {
            plc: "0.1v",
            markers: new Array(),
            routes: new Array(),
            zones: new Array(),
        },
        i = 0;
        i < e.length;
        i++
    ) {
        var o = e[i];
        if (
            (0 == t &&
                (null != o.name &&
                    null != o.desc &&
                    null != o.icon &&
                    null != o.visible &&
                    null != o.lat &&
                    null != o.lng
                    ? (t = "marker")
                    : null != o.name &&
                        null != o.color &&
                        null != o.visible &&
                        null != o.name_visible &&
                        null != o.deviation &&
                        null != o.points
                        ? (t = "route")
                        : null != o.name &&
                        null != o.color &&
                        null != o.visible &&
                        null != o.name_visible &&
                        null != o.area &&
                        null != o.vertices &&
                        (t = "zone")),
                "marker" == t)
        )
            a.markers.push({
                name: o.name,
                desc: o.desc,
                icon: "img/markers/places/" + o.icon,
                visible: o.visible,
                lat: o.lat,
                lng: o.lng,
            });
        else if ("route" == t)
            a.routes.push({
                name: o.name,
                color: o.color,
                visible: o.visible,
                name_visible: o.name_visible,
                deviation: o.deviation,
                points: o.points,
            });
        else {
            if ("zone" != t) return a;
            a.zones.push({
                name: o.name,
                color: o.color,
                visible: o.visible,
                name_visible: o.name_visible,
                area: o.area,
                vertices: o.vertices,
            });
        }
    }
    return a;
}
function placesKMLToPLC(e) {
    for (
        var t = 1,
        a = 1,
        i = {
            plc: "0.1v",
            markers: new Array(),
            routes: new Array(),
            zones: new Array(),
        },
        o = e.kml.Document.Placemark,
        s = 0;
        s < o.length - 1;
        s++
    ) {
        var n = o[s];
        if (null != n.Point) {
            if (null != n.name) var l = n.name;
            else {
                l = "Marker " + t;
                t += 1;
            }
            if (null != n.description.__text) var d = n.description.toString();
            else d = "";
            var r = (p = n.Point.coordinates.split(","))[0],
                _ = p[1];
            i.markers.push({
                name: l,
                desc: d,
                icon: "img/markers/places/pin-1.svg",
                visible: "true",
                lat: _,
                lng: r,
            });
        }
        if (null != n.Polygon) {
            if (null != n.name) l = n.name;
            else {
                l = "Zone " + a;
                a += 1;
            }
            if (null != n.Style.PolyStyle.color)
                var c = "#" + n.Style.PolyStyle.color.slice(0, -2);
            else c = "#FF0000";
            var g = n.Polygon.outerBoundaryIs.LinearRing.coordinates.split(" ");
            if (g.length <= 80) {
                for (var m = [], u = 0; u < g.length; u++) {
                    var p;
                    (r = (p = g[u].split(","))[0]), (_ = p[1]);
                    m.push(parseFloat(_).toFixed(6) + "," + parseFloat(r).toFixed(6));
                }
                (m = m.toString()),
                    i.zones.push({
                        name: l,
                        color: c,
                        visible: "true",
                        name_visible: "true",
                        area: "0",
                        vertices: m,
                    });
            }
        }
    }
    return i;
}
(placesGroupData.groups = new Array()), (placesGroupData.edit_group_id = !1);
var placesMarkerData = new Array();
function placesMarkerReload() {
    placesGroupLoadData(),
        placesMarkerLoadData(),
        $("#side_panel_places_marker_list_grid").trigger("reloadGrid");
}
function placesMarkerLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_places.php",
        data: {
            cmd: "load_marker_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            (placesMarkerData.markers = e),
                placesMarkerInitLists(),
                placesMarkerSetListCheckbox(),
                placesMarkerSetListNumber(),
                "" != placesMarkerData.markers
                    ? placesMarkerAddAllToMap()
                    : placesMarkerRemoveAllFromMap();
        },
    });
}
function placesMarkerInitLists() {
    
        initSelectList("subaccounts_marker_list");
}
function placesMarkerSetListNumber() {
    document.getElementById("side_panel_places_markers_num").innerHTML =
        "(" + Object.keys(placesMarkerData.markers).length + ")";
}
function placesMarkerSetListCheckbox() {
    for (var e in placesGroupData.groups)
        placesSetListCheckbox(
            "marker_group_visible_" + e,
            placesGroupData.groups[e].marker_visible
        );
    for (var e in placesMarkerData.markers)
        placesSetListCheckbox(
            "marker_visible_" + e,
            placesMarkerData.markers[e].visible
        );
}
function placesMarkerAddAllToMap() {
    var e = document.getElementById("side_panel_places_marker_list_search").value;
    for (var t in (placesMarkerRemoveAllFromMap(), placesMarkerData.markers)) {
        var a = placesMarkerData.markers[t];
        if (strMatches(a.data.name, e)) {
            var i = a.data.name,
                o = a.data.desc,
                s = a.data.icon,
                n = a.data.visible,
                l = a.data.lat,
                d = a.data.lng;
            try {
                placesMarkerAddMarkerToMap(t, i, o, s, n, l, d);
            } catch (e) { }
        }
    }
}
function placesMarkerAddMarkerToMap(e, t, a, i, o, s, n) {
    var l = settingsUserData.map_is,
        d = L.icon({
            iconUrl: i,
            iconSize: [28 * l, 28 * l],
            iconAnchor: [14 * l, 28 * l],
            popupAnchor: [0, 0],
        }),
        r = L.marker([s, n], {
            icon: d,
        }),
        _ = "<table><tr><td><strong>" + t + "</strong></td></tr>";
    "" != a && (_ += "<tr><td>" + textToLinks(a) + "</td></tr>"),
        (_ += "</table>"),
        r.on("click", function (e) {
            addPopupToMap(s, n, [0, -28 * l], _, "");
        }),
        "false" != o && mapLayers.places_markers.addLayer(r),
        (placesMarkerData.markers[e].marker_layer = r);
}
function placesMarkerRemoveAllFromMap() {
    mapLayers.places_markers.clearLayers();
}
function placesMarkerSearchMap(e) {
    for (var t in placesMarkerData.markers) {
        var a = placesMarkerData.markers[t];
        strMatches(a.data.name, e)
            ? 1 == a.visible && placesMarkerVisible(t, !0)
            : placesMarkerVisible(t, !1);
    }
}
function placesMarkerDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_MARKERS, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: {
                        cmd: "delete_all_markers",
                    },
                    success: function (e) {
                        "OK" == e &&
                            (placesMarkerLoadData(),
                                $("#side_panel_places_marker_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}
function placesMarkerDelete(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (placesMarkerPanTo(e),
            confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
                if (t) {
                    var a = {
                        cmd: "delete_marker",
                        marker_id: e,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_places.php",
                        data: a,
                        success: function (t) {
                            "OK" == t &&
                                (placesMarkerVisible(e, !1),
                                    delete placesMarkerData.markers[e],
                                    placesMarkerSetListNumber(),
                                    placesMarkerInitLists(),
                                    $("#side_panel_places_marker_list_grid").trigger("reloadGrid"));
                        },
                    });
                }
            }));
}
function placesMarkerNew(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (map.doubleClickZoom.disable(),
            (gsValues.map_bussy = !0),
            (document.getElementById("map").style.cursor = "crosshair"),
            (document.getElementById("dialog_places_marker_name").value =
                la.NEW_MARKER + " " + placesMarkerData.new_marker_id),
            (document.getElementById("dialog_places_marker_desc").value = ""),
            (document.getElementById("dialog_places_marker_group").value = 0),
            (document.getElementById("dialog_places_marker_radius").value = 0.1),
            $("#dialog_places_marker_group").multipleSelect("refresh"),
            (document.getElementById("dialog_places_marker_visible").checked = !0),
            $("#dialog_places_marker_properties").dialog("open"),
            placesMarkerLoadDefaultIconList(),
            placesMarkerLoadCustomIconList(),
            null != e &&
            (map.hasLayer(placesMarkerData.edit_marker_layer) &&
                map.removeLayer(placesMarkerData.edit_marker_layer),
                placesMarkerAddToMap(e.lat, e.lng, placesMarkerData.marker_icon)),
            map.on("click", placesMarkerAddToMapByClick));
}
function placesMarkerAddToMapByClick(e) {
    map.hasLayer(placesMarkerData.edit_marker_layer) &&
        map.removeLayer(placesMarkerData.edit_marker_layer),
        placesMarkerAddToMap(
            e.latlng.lat,
            e.latlng.lng,
            placesMarkerData.marker_icon
        );
}
function placesMarkerAddToMap(e, t, a) {
    var i = settingsUserData.map_is,
        o = L.icon({
            iconUrl: a,
            iconSize: [28 * i, 28 * i],
            iconAnchor: [14 * i, 28 * i],
            popupAnchor: [0, 0],
        });
    (placesMarkerData.edit_marker_layer = L.marker([e, t], {
        icon: o,
    })),
        placesMarkerData.edit_marker_layer.addTo(map);
}
function placesMarkerProperties(e) {
    if (utilsCheckPrivileges("viewer") && utilsCheckPrivileges("subuser"))
        switch (e) {
            default:
                if (1 == gsValues.map_bussy) return;
                map.doubleClickZoom.disable(), (gsValues.map_bussy = !0);
                var t = e;
                (placesMarkerData.edit_marker_id = t),
                    (document.getElementById("dialog_places_marker_name").value =
                        placesMarkerData.markers[t].data.name),
                    (document.getElementById("dialog_places_marker_desc").value =
                        placesMarkerData.markers[t].data.desc),
                    (document.getElementById("dialog_places_marker_group").value =
                        placesMarkerData.markers[t].data.group_id),
                    (document.getElementById("dialog_places_marker_radius").value =
                        placesMarkerData.markers[t].data.radius),
                    $("#dialog_places_marker_group").multipleSelect("refresh"),
                    "true" == placesMarkerData.markers[t].data.visible
                        ? (document.getElementById("dialog_places_marker_visible").checked =
                            !0)
                        : (document.getElementById("dialog_places_marker_visible").checked =
                            !1),
                    (placesMarkerData.marker_icon =
                        placesMarkerData.markers[t].data.icon),
                    $("#dialog_places_marker_properties").dialog("open"),
                    placesMarkerLoadDefaultIconList(),
                    placesMarkerLoadCustomIconList(),
                    mapLayers.places_markers.removeLayer(
                        placesMarkerData.markers[t].marker_layer
                    ),
                    placesMarkerAddToMap(
                        (d = placesMarkerData.markers[t].marker_layer.getLatLng()).lat,
                        d.lng,
                        placesMarkerData.marker_icon
                    ),
                    map.on("click", placesMarkerAddToMapByClick);
                break;
            case "cancel":
                if (
                    (map.hasLayer(placesMarkerData.edit_marker_layer) &&
                        map.removeLayer(placesMarkerData.edit_marker_layer),
                        map.off("click"),
                        0 != placesMarkerData.edit_marker_id)
                ) {
                    t = placesMarkerData.edit_marker_id;
                    "false" == placesMarkerData.markers[t].data.visible
                        ? mapLayers.places_markers.removeLayer(
                            placesMarkerData.markers[t].marker_layer
                        )
                        : mapLayers.places_markers.addLayer(
                            placesMarkerData.markers[t].marker_layer
                        );
                }
                (placesMarkerData.edit_marker_id = !1),
                    (placesMarkerData.edit_marker_layer = !1),
                    map.doubleClickZoom.enable(),
                    (gsValues.map_bussy = !1),
                    (document.getElementById("map").style.cursor = ""),
                    $("#dialog_places_marker_properties").dialog("close");
                break;
            case "save":
                var a = document.getElementById("dialog_places_marker_name").value,
                    i = document.getElementById("dialog_places_marker_desc").value,
                    o = document.getElementById("dialog_places_marker_group").value,
                    s = document.getElementById("dialog_places_marker_visible").checked,
                    n = placesMarkerData.marker_icon,
                    l = document.getElementById("dialog_places_marker_radius").value;
                if ("" == a) {
                    notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                    break;
                }
                if (0 == placesMarkerData.edit_marker_layer) {
                    notifyBox("error", la.ERROR, la.PLACE_MARKER_ON_MAP_BEFORE_SAVING);
                    break;
                }
                var d = placesMarkerData.edit_marker_layer.getLatLng();
                map.off("click"),
                    map.hasLayer(placesMarkerData.edit_marker_layer) &&
                    map.removeLayer(placesMarkerData.edit_marker_layer),
                    0 == placesMarkerData.edit_marker_id &&
                    (placesMarkerData.new_marker_id += 1);
                var r = {
                    cmd: "save_marker",
                    marker_id: placesMarkerData.edit_marker_id,
                    group_id: o,
                    marker_name: a,
                    marker_desc: i,
                    marker_icon: n,
                    marker_visible: s,
                    marker_lat: d.lat.toFixed(6),
                    marker_lng: d.lng.toFixed(6),
                    marker_radius: l,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: r,
                    success: function (e) {
                        (placesMarkerData.edit_marker_layer = !1),
                            (placesMarkerData.edit_marker_id = !1),
                            map.doubleClickZoom.enable(),
                            (gsValues.map_bussy = !1),
                            (document.getElementById("map").style.cursor = ""),
                            $("#dialog_places_marker_properties").dialog("close"),
                            "OK" == e
                                ? (placesMarkerLoadData(),
                                    $("#side_panel_places_marker_list_grid").trigger(
                                        "reloadGrid"
                                    ))
                                : "ERROR_MARKER_LIMIT" == e &&
                                notifyBox("error", la.ERROR, la.MARKER_LIMIT_IS_REACHED);
                    },
                });
        }
}
function placesMarkerLoadDefaultIconList() {
    0 == placesMarkerData.default_icons_loaded &&
        $.ajax({
            type: "POST",
            url: "func/fn_files.php",
            data: {
                path: "img/markers/places",
            },
            dataType: "json",
            success: function (e) {
                var t = '<div class="row2">';
                for (
                    document.getElementById("places_marker_icon_default_list").innerHTML =
                    "",
                    i = 0;
                    i < e.length;
                    i++
                ) {
                    var a = "img/markers/places/" + e[i];
                    (t += '<div class="icon-places-marker">'),
                        (t +=
                            '<a href="#" onclick="placesMarkerSelectIcon(\'' + a + "');\">"),
                        (t +=
                            '<img src="' +
                            a +
                            '" style="padding:5px; width: 32px; height: 32px;"/>'),
                        (t += "</a>"),
                        (t += "</div>");
                }
                (t += "</div>"),
                    (document.getElementById(
                        "places_marker_icon_default_list"
                    ).innerHTML = t),
                    (placesMarkerData.default_icons_loaded = !0);
            },
        });
}
function placesMarkerLoadCustomIconList() {
    0 == placesMarkerData.custom_icons_loaded &&
        $.ajax({
            type: "POST",
            url: "func/fn_files.php",
            data: {
                path: "data/user/places",
            },
            dataType: "json",
            success: function (e) {
                var t = '<div class="row2">';
                for (
                    document.getElementById("places_marker_icon_custom_list").innerHTML =
                    "",
                    i = 0;
                    i < e.length;
                    i++
                ) {
                    var a = "data/user/places/" + e[i];
                    (t += '<div class="icon-places-marker">'),
                        (t +=
                            '<a href="#" onclick="placesMarkerSelectIcon(\'' + a + "');\">"),
                        (t +=
                            '<img src="' +
                            a +
                            '" style="padding:5px; width: 32px; height: 32px;"/>'),
                        (t += "</a>"),
                        (t += '<div class="icon-custom-delete">'),
                        (t +=
                            '<a href="#" onclick="placesMarkerDeleteCustomIcon(\'' +
                            a +
                            "');\">"),
                        (t += '<img border="0" src="theme/images/remove.svg" width="8px">'),
                        (t += "</a>"),
                        (t += "</div>"),
                        (t += "</div>");
                }
                (t += "</div>"),
                    (document.getElementById("places_marker_icon_custom_list").innerHTML =
                        t),
                    (placesMarkerData.custom_icons_loaded = !0);
            },
        });
}
function placesMarkerUploadCustomIcon() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", placesMarkerUploadCustomIconFile, !1),
            document.getElementById("load_file").click());
}
function placesMarkerUploadCustomIconFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onloadend = function (e) {
        var a = e.target.result;
        if ("image/png" == t[0].type || "image/svg+xml" == t[0].type) {
            var i = new Image();
            (i.src = a),
                (i.onload = function () {
                    if (i.src.includes("image/png")) {
                        if (32 != i.width || 32 != i.height)
                            return void notifyBox(
                                "error",
                                la.ERROR,
                                la.ICON_SIZE_SHOULD_BE_32_32
                            );
                        var e = "func/fn_upload.php?file=places_icon_png";
                    } else e = "func/fn_upload.php?file=places_icon_svg";
                    $.ajax({
                        url: e,
                        type: "POST",
                        data: a,
                        processData: !1,
                        contentType: !1,
                        success: function (e) {
                            (placesMarkerData.custom_icons_loaded = !1),
                                placesMarkerLoadCustomIconList();
                        },
                    });
                }),
                (document.getElementById("load_file").value = "");
        } else notifyBox("error", la.ERROR, la.FILE_TYPE_MUST_BE_PNG_OR_SVG);
    }),
        a.readAsDataURL(t[0]),
        this.removeEventListener("change", placesMarkerUploadCustomIconFile, !1);
}
function placesMarkerDeleteCustomIcon(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS_ICON, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_custom_icon",
                    file: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: a,
                    success: function (e) {
                        "OK" == e &&
                            ((placesMarkerData.custom_icons_loaded = !1),
                                placesMarkerLoadCustomIconList());
                    },
                });
            }
        });
}
function placesMarkerDeleteAllCustomIcon() {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(
            la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_CUSTOM_ICONS,
            function (e) {
                if (e) {
                    $.ajax({
                        type: "POST",
                        url: "func/fn_places.php",
                        data: {
                            cmd: "delete_all_custom_icons",
                        },
                        success: function (e) {
                            "OK" == e &&
                                ((placesMarkerData.custom_icons_loaded = !1),
                                    placesMarkerLoadCustomIconList());
                        },
                    });
                }
            }
        );
}
function placesMarkerSelectIcon(e) {
    if (
        ((placesMarkerData.marker_icon = e),
            0 != placesMarkerData.edit_marker_layer)
    ) {
        map.hasLayer(placesMarkerData.edit_marker_layer) &&
            map.removeLayer(placesMarkerData.edit_marker_layer);
        var t = placesMarkerData.edit_marker_layer.getLatLng();
        placesMarkerAddToMap(t.lat, t.lng, placesMarkerData.marker_icon);
    }
}
function placesMarkerPanTo(e) {
    try {
        var t = placesMarkerData.markers[e].data.lng,
            a = placesMarkerData.markers[e].data.lat;
        map.panTo({
            lat: a,
            lng: t,
        });
    } catch (e) { }
}
function placesMarkerVisibleToggle(e) {
    var t = document.getElementById("marker_visible_" + e).checked;
    (placesMarkerData.markers[e].visible = t), placesMarkerVisible(e, t);
}
function placesMarkerVisible(e, t) {
    var a = placesMarkerData.markers[e].marker_layer;
    1 == t
        ? "true" == placesMarkerData.markers[e].data.visible &&
        mapLayers.places_markers.addLayer(a)
        : mapLayers.places_markers.removeLayer(a);
}
function markerGroupVisibleToggle(e) {
    var t = document.getElementById("marker_group_visible_" + e).checked;
    for (var a in placesMarkerData.markers)
        placesMarkerData.markers[a].data.group_id == e &&
            ((placesGroupData.groups[e].marker_visible = t),
                (placesMarkerData.markers[a].visible = t),
                placesSetListCheckbox("marker_visible_" + a, t),
                placesMarkerVisible(a, t));
}
function placesMarkerVisibleAllToggle() {
    1 == gsValues.map_markers
        ? placesMarkerVisibleAll(!1)
        : placesMarkerVisibleAll(!0);
}
function placesMarkerVisibleAll(e) {
    if (((gsValues.map_markers = e), 1 == e)) {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].marker_visible = !0),
                placesSetListCheckbox("marker_group_visible_" + t, !0);
        for (var t in placesMarkerData.markers)
            (placesMarkerData.markers[t].visible = !0),
                placesSetListCheckbox("marker_visible_" + t, !0),
                placesMarkerVisible(t, !0);
    } else {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].marker_visible = !1),
                placesSetListCheckbox("marker_group_visible_" + t, !1);
        for (var t in placesMarkerData.markers)
            (placesMarkerData.markers[t].visible = !1),
                placesSetListCheckbox("marker_visible_" + t, !1);
        placesMarkerRemoveAllFromMap();
    }
}
(placesMarkerData.markers = new Array()),
    (placesMarkerData.default_icons_loaded = !1),
    (placesMarkerData.custom_icons_loaded = !1),
    (placesMarkerData.marker_icon = "img/markers/places/pin-1.svg"),
    (placesMarkerData.new_marker_id = 1),
    (placesMarkerData.edit_marker_id = !1),
    (placesMarkerData.edit_marker_layer = !1);
var placesZoneData = new Array();
function placesZoneReload() {
    placesGroupLoadData(),
        placesZoneLoadData(),
        $("#side_panel_places_zone_list_grid").trigger("reloadGrid");
}
function placesZoneLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_places.php",
        data: {
            cmd: "load_zone_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            (placesZoneData.zones = e),
                placesZoneInitLists(),
                placesZoneSetListCheckbox(),
                placesZoneSetListNumber(),
                "" != placesZoneData.zones
                    ? placesZoneAddAllToMap()
                    : placesZoneRemoveAllFromMap();
        },
    });
}
function placesZoneInitLists() {
    initSelectList("report_zone_list"),
        initSelectList("events_zone_list"),
        initSelectList("subaccounts_zone_list");
}
function placesZoneSetListNumber() {
    document.getElementById("side_panel_places_zones_num").innerHTML =
        "(" + Object.keys(placesZoneData.zones).length + ")";
}
function placesZoneSetListCheckbox() {
    for (var e in placesGroupData.groups)
        placesSetListCheckbox(
            "zone_group_visible_" + e,
            placesGroupData.groups[e].zone_visible
        );
    for (var e in placesZoneData.zones)
        placesSetListCheckbox("zone_visible_" + e, placesZoneData.zones[e].visible);
}
function placesZoneAddAllToMap() {
    var e = document.getElementById("side_panel_places_zone_list_search").value;
    for (var t in (placesZoneRemoveAllFromMap(), placesZoneData.zones)) {
        var a = placesZoneData.zones[t];
        if (strMatches(a.data.name, e)) {
            var i = a.data.name,
                o = a.data.color,
                s = a.data.visible,
                n = a.data.name_visible,
                l = a.data.area,
                d = a.data.vertices;
            try {
                placesZoneAddZoneToMap(t, i, o, s, n, l, d);
            } catch (e) { }
        }
    }
}
function placesZoneAddZoneToMap(e, t, a, i, o, s, n) {
    var l = placesZoneVerticesStringToLatLngs(n),
        d = L.polygon(l, {
            color: a,
            fill: !0,
            fillColor: a,
            fillOpacity: 0.4,
            opacity: 0.8,
            weight: 3,
        });
    "false" == o && (t = ""),
        "0" != s &&
        ((measure_area = getAreaFromLatLngs(d.getLatLngs()[0])),
            "1" == s &&
            ((measure_area *= 247105e-9),
                (measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_ACRE)),
            "2" == s &&
            ((measure_area *= 1e-4),
                (measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_HECTARES)),
            "3" == s &&
            ((measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_SQ_M)),
            "4" == s &&
            ((measure_area *= 1e-6),
                (measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_SQ_KM)),
            "5" == s &&
            ((measure_area *= 10.7639),
                (measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_SQ_FT)),
            "6" == s &&
            ((measure_area = 1e-6 * measure_area * 0.386102),
                (measure_area = Math.round(100 * measure_area) / 100),
                (measure_area = measure_area + " " + la.UNIT_SQ_MI)),
            (t = t + " (" + measure_area + ")"));
    var r = d.getBounds().getCenter(),
        _ = L.tooltip({
            permanent: !0,
            direction: "center",
        });
    _.setLatLng(r),
        _.setContent(t),
        "false" != i && mapLayers.places_zones.addLayer(d),
        ("false" == o && "0" == s) || mapLayers.places_zones.addLayer(_),
        (placesZoneData.zones[e].zone_layer = d),
        (placesZoneData.zones[e].label_layer = _);
}
function placesZoneRemoveAllFromMap() {
    mapLayers.places_zones.clearLayers();
}
function placesZoneSearchMap(e) {
    for (var t in placesZoneData.zones) {
        var a = placesZoneData.zones[t];
        strMatches(a.data.name, e)
            ? 1 == a.visible && placesZoneVisible(t, !0)
            : placesZoneVisible(t, !1);
    }
}
function placesZoneDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: {
                        cmd: "delete_all_zones",
                    },
                    success: function (e) {
                        "OK" == e &&
                            (placesZoneLoadData(),
                                $("#side_panel_places_zone_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}
function placesZoneDelete(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (placesZonePanTo(e),
            confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
                if (t) {
                    var a = {
                        cmd: "delete_zone",
                        zone_id: e,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_places.php",
                        data: a,
                        success: function (t) {
                            "OK" == t &&
                                (placesZoneVisible(e, !1),
                                    delete placesZoneData.zones[e],
                                    placesZoneSetListNumber(),
                                    placesZoneInitLists(),
                                    $("#side_panel_places_zone_list_grid").trigger("reloadGrid"));
                        },
                    });
                }
            }));
}
function placesRouteLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_places.php",
        data: {
            cmd: "load_route_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            (placesRouteData.routes = e),
                placesRouteInitLists(),
                placesRouteSetListCheckbox(),
                placesRouteSetListNumber(),
                "" != placesRouteData.routes
                    ? placesRouteAddAllToMap()
                    : placesRouteRemoveAllFromMap();
        },
    });
}
function placesRouteInitLists() {
    initSelectList("events_route_list"), initSelectList("subaccounts_route_list");
}
function placesRouteSetListNumber() {
    document.getElementById("side_panel_places_routes_num").innerHTML =
        "(" + Object.keys(placesRouteData.routes).length + ")";
}
function placesRouteSetListCheckbox() {
    for (var e in placesGroupData.groups)
        placesSetListCheckbox(
            "route_group_visible_" + e,
            placesGroupData.groups[e].route_visible
        );
    for (var e in placesRouteData.routes)
        placesSetListCheckbox(
            "route_visible_" + e,
            placesRouteData.routes[e].visible
        );
}
function placesRouteAddAllToMap() {
    var e = document.getElementById("side_panel_places_route_list_search").value;
    for (var t in (placesRouteRemoveAllFromMap(), placesRouteData.routes)) {
        var a = placesRouteData.routes[t];
        if (strMatches(a.data.name, e)) {
            var i = a.data.name,
                o = a.data.color,
                s = a.data.visible,
                n = a.data.name_visible,
                l = a.data.points;
            try {
                placesRouteAddRouteToMap(t, i, o, s, n, l);
            } catch (e) { }
        }
    }
}

// #################################################
// END PLACES FUNCTIONS
// #################################################

// #################################################
// SETTINGS FUNCTIONS
// #################################################

function settingsEventPlaySound() {
    var e = document.getElementById(
        "dialog_settings_event_notify_system_sound_file"
    ).value;
    new Audio("snd/" + e).play();
}
function settingsEventImport() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", settingsEventImportEVTFile, !1),
            document.getElementById("load_file").click());
}
function settingsEventExport() {
    if (utilsCheckPrivileges("viewer")) {
        window.location = "func/fn_export.php?format=evt";
    }
}
function settingsEventImportEVTFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.evt) {
                var a = t.events.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.EVENTS_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "evt",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1), "OK" == e && settingsReloadEvents();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", settingsEventImportEVTFile, !1);
}

function settingsEventDelete(e) {
    utilsCheckPrivileges("viewer") && confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
        if (t) {
            var a = {
                cmd: "delete_event",
                event_id: e
            };
            $.ajax({
                type: "POST",
                url: "func/fn_settings.events.php",
                data: a,
                success: function (e) {
                    "OK" == e && settingsReloadEvents()
                }
            })
        }
    })
}
function settingsEventDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#settings_main_events_event_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_events",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.events.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadEvents();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsEventConditionList() {
    var e = settingsEditData.event_condition,
        t = [],
        a = $("#settings_event_param_sensor_condition_list_grid");
    if ((a.clearGridData(!0), 0 != e.length)) {
        for (var i = 0; i < e.length; i++) {
            var o =
                '<a href="#" onclick="settingsEventConditionDel(' +
                i +
                ');" title="' +
                la.DELETE +
                '"><img src="theme/images/remove3.svg" /></a>';
            t.push({
                src: e[i].src,
                cn: e[i].cn,
                val: e[i].val,
                modify: o,
            });
        }
        for (i = 0; i < t.length; i++) a.jqGrid("addRowData", i, t[i]);
        a.setGridParam({
            sortname: "src",
            sortorder: "asc",
        }).trigger("reloadGrid");
    }
}
function settingsEventConditionAdd() {
    var e = document.getElementById(
        "dialog_settings_event_param_sensor_condition_src"
    ).value,
        t = document.getElementById(
            "dialog_settings_event_param_sensor_condition_cn"
        ).value,
        a = document.getElementById(
            "dialog_settings_event_param_sensor_condition_val"
        ).value;
    if ("" != e && "" != t && "" != a) {
        for (var i = 0; i < settingsEditData.event_condition.length; i++)
            if (settingsEditData.event_condition[i].src == e)
                return void notifyBox("error", la.ERROR, la.SAME_SOURCE_ITEM_AVAILABLE);
        settingsEditData.event_condition.push({
            src: e,
            cn: t,
            val: a,
        }),
            (document.getElementById(
                "dialog_settings_event_param_sensor_condition_src"
            ).value = ""),
            $("#dialog_settings_event_param_sensor_condition_src").multipleSelect(
                "refresh"
            ),
            (document.getElementById(
                "dialog_settings_event_param_sensor_condition_cn"
            ).value = ""),
            $("#dialog_settings_event_param_sensor_condition_cn").multipleSelect(
                "refresh"
            ),
            (document.getElementById(
                "dialog_settings_event_param_sensor_condition_val"
            ).value = ""),
            settingsEventConditionList();
    } else
        notifyBox("error", la.ERROR, la.ALL_AVAILABLE_FIELDS_SHOULD_BE_FILLED_OUT);
}
function settingsEventConditionDel(e) {
    settingsEditData.event_condition.splice(e, 1), settingsEventConditionList();
}
function settingsEventParamList() {
    var e = document.getElementById(
        "dialog_settings_event_param_sensor_condition_src"
    );
    (e.options.length = 0),
        e.options.add(new Option("", "")),
        e.options.add(new Option(la.SPEED.toLowerCase(), "speed"));
    for (var t = getAllParamsArray(), a = 0; a < t.length; a++)
        e.options.add(new Option(t[a], t[a]));
    sortSelectList(e);
}
function settingsEventSensorList() {
    var e = document.getElementById(
        "dialog_settings_event_param_sensor_condition_src"
    );
    e.options.length = 0;
    var t = getAllSensorsArray();
    e.options.add(new Option("", "")),
        e.options.add(new Option(la.SPEED, "speed"));
    for (var a = 0; a < t.length; a++) e.options.add(new Option(t[a], t[a]));
    sortSelectList(e);
}

// function settingsEventSwitchType() {
//     switch (
//     ((document.getElementById("dialog_settings_event_time_period").value = ""),
//         (document.getElementById("dialog_settings_event_speed_limit").value = ""),
//         (document.getElementById("dialog_settings_event_distance").value = ""),
//         $("#dialog_settings_event_routes option:selected").removeAttr("selected"),
//         $("#dialog_settings_event_routes").multipleSelect("refresh"),
//         $("#dialog_settings_event_zones option:selected").removeAttr("selected"),
//         $("#dialog_settings_event_zones").multipleSelect("refresh"),
//         (document.getElementById("dialog_settings_event_route_trigger").value =
//             "off"),
//         $("#dialog_settings_event_route_trigger").multipleSelect("refresh"),
//         (document.getElementById("dialog_settings_event_zone_trigger").value =
//             "off"),
//         $("#dialog_settings_event_zone_trigger").multipleSelect("refresh"),
//         (settingsEditData.event_condition = []),
//         $("#settings_event_param_sensor_condition_list_grid").clearGridData(!0),
//         document.getElementById("dialog_settings_event_type").value)
//     ) {
//         case "sos":
//         case "bracon":
//         case "bracoff":
//         case "dismount":
//         case "disassem":
//         case "door":
//         case "mandown":
//         case "shock":
//         case "tow":
//         case "pwrcut":
//         case "gpsantcut":
//         case "jamming":
//         case "lowdc":
//         case "lowbat":
//         case "connyes":
//         case "gpsyes":
//         case "haccel":
//         case "hbrake":
//         case "hcorn":
//         case "driverch":
//         case "trailerch":
//         case "service":
//         case "dtc":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "connno":
//         case "gpsno":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !1),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 "" ==
//                 document.getElementById("dialog_settings_event_time_period").value &&
//                 (document.getElementById(
//                     "dialog_settings_event_time_period"
//                 ).value = 60),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "stopped":
//         case "moving":
//         case "engidle":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !1),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 "" ==
//                 document.getElementById("dialog_settings_event_time_period").value &&
//                 (document.getElementById(
//                     "dialog_settings_event_time_period"
//                 ).value = 5),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "overspeed":
//         case "underspeed":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !1),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 "" ==
//                 document.getElementById("dialog_settings_event_speed_limit").value &&
//                 (document.getElementById(
//                     "dialog_settings_event_speed_limit"
//                 ).value = 60),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "param":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .unblock(),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !1),
//                 settingsEventParamList(),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "sensor":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .unblock(),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !1),
//                 settingsEventSensorList(),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "proximity":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !1),
//                 "" == document.getElementById("dialog_settings_event_distance").value &&
//                 (document.getElementById(
//                     "dialog_settings_event_distance"
//                 ).value = 0.1),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !1),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !1),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//             break;
//         case "route_in":
//         case "route_out":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !0),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !1),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !0);
//             break;
//         case "zone_in":
//         case "zone_out":
//             (document.getElementById("dialog_settings_event_time_period").disabled =
//                 !0),
//                 (document.getElementById("dialog_settings_event_speed_limit").disabled =
//                     !0),
//                 (document.getElementById("dialog_settings_event_distance").disabled =
//                     !0),
//                 $("#settings_event_param_sensor_condition_list_grid")
//                     .closest(".ui-jqgrid")
//                     .block({
//                         message: "",
//                     }),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_src"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_cn"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_val"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_param_sensor_condition_add"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_route_trigger"
//                 ).disabled = !0),
//                 (document.getElementById(
//                     "dialog_settings_event_zone_trigger"
//                 ).disabled = !0),
//                 (document.getElementById("dialog_settings_event_routes").disabled = !0),
//                 (document.getElementById("dialog_settings_event_zones").disabled = !1);
//     }
// }
function settingsEventResetDayTime() {
    (document.getElementById("dialog_settings_event_dt").checked = !1),
        (document.getElementById("dialog_settings_event_dt_mon").checked = !1),
        (document.getElementById("dialog_settings_event_dt_mon_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_mon_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_mon_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_mon_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_tue").checked = !1),
        (document.getElementById("dialog_settings_event_dt_tue_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_tue_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_tue_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_tue_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_wed").checked = !1),
        (document.getElementById("dialog_settings_event_dt_wed_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_wed_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_wed_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_wed_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_thu").checked = !1),
        (document.getElementById("dialog_settings_event_dt_thu_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_thu_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_thu_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_thu_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_fri").checked = !1),
        (document.getElementById("dialog_settings_event_dt_fri_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_fri_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_fri_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_fri_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_sat").checked = !1),
        (document.getElementById("dialog_settings_event_dt_sat_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_sat_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_sat_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_sat_to").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_sun").checked = !1),
        (document.getElementById("dialog_settings_event_dt_sun_from").value =
            "00:00"),
        $("#dialog_settings_event_dt_sun_from").multipleSelect("refresh"),
        (document.getElementById("dialog_settings_event_dt_sun_to").value =
            "24:00"),
        $("#dialog_settings_event_dt_sun_to").multipleSelect("refresh");
}
function settingsEventSwitchDayTime() {
    0 == document.getElementById("dialog_settings_event_dt").checked
        ? ((document.getElementById("dialog_settings_event_dt_mon").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_mon_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_mon_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_tue").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_tue_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_tue_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_wed").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_wed_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_wed_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_thu").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_thu_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_thu_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_fri").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_fri_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_fri_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_sat").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_sat_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_sat_to").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_sun").disabled = !0),
            (document.getElementById("dialog_settings_event_dt_sun_from").disabled =
                !0),
            (document.getElementById("dialog_settings_event_dt_sun_to").disabled =
                !0))
        : ((document.getElementById("dialog_settings_event_dt_mon").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_mon_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_mon_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_tue").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_tue_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_tue_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_wed").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_wed_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_wed_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_thu").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_thu_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_thu_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_fri").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_fri_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_fri_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_sat").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_sat_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_sat_to").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_sun").disabled = !1),
            (document.getElementById("dialog_settings_event_dt_sun_from").disabled =
                !1),
            (document.getElementById("dialog_settings_event_dt_sun_to").disabled =
                !1));
}
function settingsEventCmdTemplateList() {
    for (
        var e = document.getElementById("dialog_settings_event_cmd_gprs_template_list"),
        t = e.getElementsByTagName("optgroup"),
        a = t.length - 1;
        a >= 0;
        a--
    )
        e.removeChild(t[a]);
    e.options.length = 0;
    var i = new Array();
    for (var o in gsValues.cmd_default) i.push(gsValues.cmd_default[o].name);
    i.length > 0 &&
        (n = $('<optgroup label="' + la.DEFAULT + '" />')).appendTo(e);
    for (i.sort(), a = 0; a < i.length; a += 1)
        e.options.add(new Option(la[i[a].toUpperCase()], i[a]));
    var s = new Array(),
        n = $('<optgroup label="' + la.CUSTOM + '" />');
    for (var o in (n.appendTo(e),
        e.options.add(new Option(la.CUSTOM, "")),
        cmdData.cmd_templates)) {
        var l = cmdData.cmd_templates[o];
        s.push({
            name: l.name,
            key: o,
        });
    }
    for (s = sortArrayByElement(s, "name"), a = 0; a < s.length; a += 1)
        e.options.add(new Option(s[a].name, s[a].key));
}
function settingsEventCmdTemplateSwitch() {
    var e = document.getElementById("dialog_settings_event_type").value,
      t = "",
      a = "";
    for (var i in gsValues.cmd_default) {
      // console.log(gsValues.cmd_default[i]);
      var o = gsValues.cmd_default[i].name ? gsValues.cmd_default[i].name : e;
      // console.log(o)
      // console.log(o.cmd_default[i])
      if (e == o.name) {
        (t = o.name), null != o.params && (a = o.params);
        break;
      }
    }
    "" != t
      ? ((document.getElementById("dialog_settings_event_cmd_gateway").disabled =
          !0),
        (document.getElementById("dialog_settings_event_cmd_type").disabled = !0),
        (document.getElementById("dialog_settings_event_cmd_gateway").value =
          "gprs"),
        (document.getElementById("dialog_settings_event_cmd_type").value =
          "ascii"),
        "" != a && (t = t + "," + a),
        (document.getElementById("dialog_settings_event_cmd_string").value = t))
      : "" != e
      ? ((document.getElementById("dialog_settings_event_cmd_gateway").disabled =
          !1),
        (document.getElementById("dialog_settings_event_cmd_type").disabled = !1),
        (document.getElementById("dialog_settings_event_cmd_gateway").value =
          cmdData.cmd_templates[e].gateway),
        (document.getElementById("dialog_settings_event_cmd_type").value =
          cmdData.cmd_templates[e].type),
        (document.getElementById("dialog_settings_event_cmd_string").value =
          cmdData.cmd_templates[e].cmd))
      : ((document.getElementById("dialog_settings_event_cmd_gateway").disabled =
          !1),
        (document.getElementById("dialog_settings_event_cmd_type").disabled = !1),
        (document.getElementById("dialog_settings_event_cmd_gateway").value =
          "gprs"),
        (document.getElementById("dialog_settings_event_cmd_type").value =
          "ascii"),
        (document.getElementById("dialog_settings_event_cmd_string").value = "")),
      $("#dialog_settings_event_cmd_gateway").multipleSelect("refresh"),
      $("#dialog_settings_event_cmd_type").multipleSelect("refresh");
  }
function settingsObjectGroupImport() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", settingsObjectGroupImportOGRFile, !1),
            document.getElementById("load_file").click());
}
function settingsObjectGroupExport() {
    if (utilsCheckPrivileges("viewer")) {
        window.location = "func/fn_export.php?format=ogr";
    }
}
function settingsObjectGroupImportOGRFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.ogr) {
                var a = t.groups.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.GROUPS_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "ogr",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1), "OK" == e && settingsReloadObjectGroups();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", settingsObjectGroupImportOGRFile, !1);
}
function settingsObjectGroupDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_object_group",
                    group_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_settings.groups.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && settingsReloadObjectGroups();
                    },
                });
            }
        });
}
function settingsObjectGroupDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#settings_main_object_group_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_object_groups",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.groups.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjectGroups();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsObjectGroupProperties(e) {
    switch (e) {
        default:
            var t = e;
            (settingsEditData.group_id = t),
                (document.getElementById("dialog_settings_object_group_name").value =
                    settingsObjectGroupData[t].name),
                (document.getElementById("dialog_settings_object_group_desc").value =
                    settingsObjectGroupData[t].desc);
            var a = document.getElementById("dialog_settings_object_group_objects"),
                i = new Array();
            for (var o in settingsObjectData)
                settingsObjectData[o].group_id == t && i.push(o);
            multiselectSetValues(a, i),
                $("#dialog_settings_object_group_objects").multipleSelect("refresh"),
                $("#dialog_settings_object_group_properties").dialog("open");
            break;
        case "add":
            (settingsEditData.group_id = !1),
                (document.getElementById("dialog_settings_object_group_name").value =
                    ""),
                (document.getElementById("dialog_settings_object_group_desc").value =
                    ""),
                $("#dialog_settings_object_group_objects option:selected").removeAttr(
                    "selected"
                ),
                $("#dialog_settings_object_group_objects").multipleSelect("refresh"),
                $("#dialog_settings_object_group_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_settings_object_group_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var s = document.getElementById(
                "dialog_settings_object_group_name"
            ).value,
                n = document.getElementById("dialog_settings_object_group_desc").value,
                l = multiselectGetValues(
                    document.getElementById("dialog_settings_object_group_objects")
                );
            if ("" == s) {
                notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                break;
            }
            for (var o in settingsObjectData)
                settingsObjectData[o].group_id == settingsEditData.group_id &&
                    (settingsObjectData[o].group_id = 0);
            var d = l.split(",");
            for (var o in settingsObjectData)
                for (var r = 0; r < d.length; r++)
                    o == d[r] &&
                        (settingsObjectData[o].group_id = settingsEditData.group_id);
            var _ = {
                cmd: "save_object_group",
                group_id: settingsEditData.group_id,
                group_name: s,
                group_desc: n,
                group_imei: l,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_settings.groups.php",
                data: _,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (settingsReloadObjects(),
                            settingsReloadObjectGroups(),
                            $("#dialog_settings_object_group_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function settingsObjectDriverImport() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", settingsObjectDriverImportODRFile, !1),
            document.getElementById("load_file").click());
}
function settingsObjectDriverExport() {
    if (utilsCheckPrivileges("viewer")) {
        window.location = "func/fn_export.php?format=odr";
    }
}
function settingsObjectDriverImportODRFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.odr) {
                var a = t.drivers.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.DRIVERS_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "odr",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1), "OK" == e && settingsReloadObjectDrivers();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener("change", settingsObjectDriverImportODRFile, !1);
}
function settingsObjectDriverDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_object_driver",
                    driver_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_settings.drivers.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && settingsReloadObjectDrivers();
                    },
                });
            }
        });
}
function settingsObjectDriverDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#settings_main_object_driver_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_object_drivers",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.drivers.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjectDrivers();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsObjectDriverProperties(e) {
    switch (e) {
        default:
            var t = e;
            (settingsEditData.driver_id = t), (settingsEditData.driver_img_file = !1);
            var a = document.getElementById("dialog_settings_object_driver_photo");
            "" == settingsObjectDriverData[t].img
                ? (a.src = "img/user-blank.svg")
                : (a.src = "data/user/drivers/" + settingsObjectDriverData[t].img),
                (document.getElementById("dialog_settings_object_driver_name").value =
                    settingsObjectDriverData[t].name),
                (document.getElementById(
                    "dialog_settings_object_driver_assign_id"
                ).value = settingsObjectDriverData[t].assign_id),
                (document.getElementById("dialog_settings_object_driver_idn").value =
                    settingsObjectDriverData[t].idn),
                (document.getElementById(
                    "dialog_settings_object_driver_address"
                ).value = settingsObjectDriverData[t].address),
                (document.getElementById("dialog_settings_object_driver_phone").value =
                    settingsObjectDriverData[t].phone),
                (document.getElementById("dialog_settings_object_driver_email").value =
                    settingsObjectDriverData[t].email),
                (document.getElementById("dialog_settings_object_driver_desc").value =
                    settingsObjectDriverData[t].desc),
                $("#dialog_settings_object_driver_properties").dialog("open");
            break;
        case "add":
            (settingsEditData.driver_id = !1),
                (settingsEditData.driver_img_file = !1),
                ((a = document.getElementById(
                    "dialog_settings_object_driver_photo"
                )).src = "img/user-blank.svg"),
                (document.getElementById("dialog_settings_object_driver_name").value =
                    ""),
                (document.getElementById(
                    "dialog_settings_object_driver_assign_id"
                ).value = ""),
                (document.getElementById("dialog_settings_object_driver_idn").value =
                    ""),
                (document.getElementById(
                    "dialog_settings_object_driver_address"
                ).value = ""),
                (document.getElementById("dialog_settings_object_driver_phone").value =
                    ""),
                (document.getElementById("dialog_settings_object_driver_email").value =
                    ""),
                (document.getElementById("dialog_settings_object_driver_desc").value =
                    ""),
                $("#dialog_settings_object_driver_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_settings_object_driver_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var i = document.getElementById(
                "dialog_settings_object_driver_name"
            ).value,
                o = document.getElementById(
                    "dialog_settings_object_driver_assign_id"
                ).value,
                s = document.getElementById("dialog_settings_object_driver_idn").value,
                n = document.getElementById(
                    "dialog_settings_object_driver_address"
                ).value,
                l = document.getElementById(
                    "dialog_settings_object_driver_phone"
                ).value,
                d = document.getElementById(
                    "dialog_settings_object_driver_email"
                ).value,
                r = document.getElementById("dialog_settings_object_driver_desc").value;
            if ("" == i) {
                notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                break;
            }
            var _ = {
                cmd: "save_object_driver",
                driver_id: settingsEditData.driver_id,
                driver_name: i,
                driver_assign_id: o,
                driver_idn: s,
                driver_address: n,
                driver_phone: l,
                driver_email: d,
                driver_desc: r,
                driver_img_file: settingsEditData.driver_img_file,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_settings.drivers.php",
                data: _,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (settingsReloadObjectDrivers(),
                            $("#dialog_settings_object_driver_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}
function settingsObjectDriverPhotoDelete() {
    utilsCheckPrivileges("viewer") &&
        ((settingsEditData.driver_img_file = "delete"),
            (document.getElementById("dialog_settings_object_driver_photo").src =
                "img/user-blank.svg"));
}
function settingsObjectDriverPhotoUpload() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", settingsObjectDriverPhotoUploadFile, !1),
            document.getElementById("load_file").click());
}
function settingsObjectDriverPhotoUploadFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onloadend = function (e) {
        var a = e.target.result;
        if (t[0].type.match("image/png") || t[0].type.match("image/jpeg")) {
            var i = new Image();
            (i.src = a),
                (i.onload = function () {
                    i.width > 640 || i.height > 480
                        ? notifyBox(
                            "error",
                            la.ERROR,
                            la.IMAGE_SIZE_SHOULD_NOT_BE_BIGGER_THAN_640_480
                        )
                        : $.ajax({
                            url: "func/fn_upload.php?file=driver_photo",
                            type: "POST",
                            data: a,
                            processData: !1,
                            contentType: !1,
                            success: function (e) {
                                (document.getElementById(
                                    "dialog_settings_object_driver_photo"
                                ).src = e + "?t=" + new Date().getTime()),
                                    (settingsEditData.driver_img_file = !0);
                            },
                        });
                }),
                (document.getElementById("load_file").value = "");
        } else notifyBox("error", la.ERROR, la.FILE_TYPE_MUST_BE_PNG_OR_JPG);
    }),
        a.readAsDataURL(t[0]),
        this.removeEventListener("change", settingsObjectDriverPhotoUploadFile, !1);
}
function settingsObjectPassengerImport() {
    utilsCheckPrivileges("viewer") &&
        (document
            .getElementById("load_file")
            .addEventListener("change", settingsObjectPassengerImportOPAFile, !1),
            document.getElementById("load_file").click());
}
function settingsObjectPassengerExport() {
    if (utilsCheckPrivileges("viewer")) {
        window.location = "func/fn_export.php?format=opa";
    }
}
function settingsObjectPassengerImportOPAFile(e) {
    var t = e.target.files,
        a = new FileReader();
    (a.onload = function (e) {
        try {
            var t = $.parseJSON(e.target.result);
            if ("0.1v" == t.opa) {
                var a = t.passengers.length;
                if (0 == a)
                    return void notifyBox(
                        "info",
                        la.INFORMATION,
                        la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
                    );
                confirmDialog(
                    sprintf(la.PASSENGERS_FOUND, a) +
                    " " +
                    la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
                    function (t) {
                        if (t) {
                            loadingData(!0);
                            var a = {
                                format: "opa",
                                data: e.target.result,
                            };
                            $.ajax({
                                type: "POST",
                                url: "func/fn_import.php",
                                data: a,
                                cache: !1,
                                success: function (e) {
                                    loadingData(!1),
                                        "OK" == e && settingsReloadObjectPassengers();
                                },
                                error: function (e, t) {
                                    loadingData(!1);
                                },
                            });
                        }
                    }
                );
            } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        } catch (e) {
            notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
        }
        document.getElementById("load_file").value = "";
    }),
        a.readAsText(t[0], "UTF-8"),
        this.removeEventListener(
            "change",
            settingsObjectPassengerImportOPAFile,
            !1
        );
}
function settingsObjectPassengerDelete(e) {
    utilsCheckPrivileges("viewer") &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
                var a = {
                    cmd: "delete_object_passenger",
                    passenger_id: e,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_settings.passengers.php",
                    data: a,
                    success: function (e) {
                        "OK" == e && settingsReloadObjectPassengers();
                    },
                });
            }
        });
}
function settingsObjectPassengerDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#settings_main_object_passenger_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_object_passengers",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.passengers.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjectPassengers();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsObjectTrailerDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
        var e = $("#settings_main_object_trailer_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_object_trailers",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.trailers.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjectTrailers();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsOpenUser() {
    settingsOpen(),
        document.getElementById("settings_main_my_account_tab").click();
}
function settingsReloadUser() {
    setTimeout(function () {
        window.location.reload();
    }, 2e3);
}
function settingsReloadObjectGroups() {
    loadSettings("object_groups", function () { }),
        $("#settings_main_object_group_list_grid").trigger("reloadGrid");
}
function settingsReloadObjectDrivers() {
    loadSettings("object_drivers", function () { }),
        $("#settings_main_object_driver_list_grid").trigger("reloadGrid");
}
function settingsReloadObjectPassengers() {
    $("#settings_main_object_passenger_list_grid").trigger("reloadGrid");
}
function settingsReloadObjectTrailers() {
    loadSettings("object_trailers", function () { }),
        $("#settings_main_object_trailer_list_grid").trigger("reloadGrid");
}
function settingsReloadEvents() {
    loadSettings("events", function () { }),
        $("#settings_main_events_event_list_grid").trigger("reloadGrid");
}
function settingsReloadTemplates() {
    loadSettings("templates", function () { }),
        $("#settings_main_templates_template_list_grid").trigger("reloadGrid");
}

function settingsReloadSubaccounts() {
    loadSettings("subaccounts", function () { }),
        $("#settings_main_subaccount_list_grid").trigger("reloadGrid");
}

function utilsStreetView(e, t, a) {
    // // console.log(e, t, a)
    if (e != utilsStreetViewData.prev_lat && t != utilsStreetViewData.prev_lng) {
        var i = {
            lat: e,
            lng: t,
            angle: a,
        };
        $.ajax({
            type: "POST",
            url: "func/fn_streetview.php",
            data: i,
            cache: !1,
            success: function (a) {
                if ("" == a)
                    document.getElementById("street_view_control").innerHTML =
                        la.STREET_VIEW;
                else {
                    var i = "data:image/jpg;base64," + a;
                    document.getElementById("street_view_control").innerHTML =
                        '<a href="#" onClick="utilsStreetViewPoint(' +
                        e +
                        ", " +
                        t +
                        ', true);"><img src="' +
                        i +
                        '"/></a>';
                }
            },
        }),
            (utilsStreetViewData.prev_lat = e),
            (utilsStreetViewData.prev_lng = t);
    }
}
// #################################################
// END SETTINGS FUNCTIONS
// #################################################

// var la = [],
//     map, mapMarkerIcons = new Array,
//     mapLayers = new Array,
//     objectsData = new Array,
//     guiDragbars = new Array;
// guiDragbars.objects = 180, guiDragbars.events = 180, guiDragbars.history = 180, guiDragbars.bottom_panel = 178;
// var menuOnItem, timer_objectLoadData, isIE = eval("/*@cc_on!@*/false"),
//     utilsRulerData = new Array;
// utilsRulerData.enabled = false, utilsRulerData.line_layer, utilsRulerData.label_layer;
// var utilsAreaData = new Array;
// utilsAreaData.enabled = false, utilsAreaData.area_layer;
// var utilsRouteToPointData = new Array;
// utilsRouteToPointData.route_points = false;
// var utilsFollowObjectData = new Array,
//     utilsStreetViewData = new Array;
// utilsStreetViewData.prev_lat = false, utilsStreetViewData.prev_lng = false;



function utilsArea() {
    0 == utilsAreaData.enabled
        ? 1 != gsValues.map_bussy &&
        ((utilsAreaData.area_layer = map.editTools.startPolygon()),
            map.on("editable:drawing:end", function (e) {
                if (!(utilsAreaData.area_layer.getLatLngs()[0].length < 3)) {
                    var t = getAreaFromLatLngs(utilsAreaData.area_layer.getLatLngs()[0]);
                    if ("km" == settingsUserData.unit_distance) {
                        var a = 1e-6 * t;
                        a = (a = Math.round(100 * a) / 100) + " " + la.UNIT_SQ_KM;
                    } else {
                        a = 1e-6 * t * 0.386102;
                        a = (a = Math.round(100 * a) / 100) + " " + la.UNIT_SQ_MI;
                    }
                    var i = 1e-4 * t,
                        o =
                            a +
                            "</br>" +
                            (i = (i = Math.round(100 * i) / 100) + " " + la.UNIT_HECTARES);
                    utilsAreaData.area_layer
                        .bindTooltip(o, {
                            permanent: !0,
                            direction: "center",
                        })
                        .openTooltip(),
                        map.on("editable:editing editable:drag", function (e) {
                            var t = getAreaFromLatLngs(
                                utilsAreaData.area_layer.getLatLngs()[0]
                            );
                            if ("km" == settingsUserData.unit_distance) {
                                var a = 1e-6 * t;
                                a = (a = Math.round(100 * a) / 100) + " " + la.UNIT_SQ_KM;
                            } else {
                                a = 1e-6 * t * 0.386102;
                                a = (a = Math.round(100 * a) / 100) + " " + la.UNIT_SQ_MI;
                            }
                            var i = 1e-4 * t,
                                o =
                                    a +
                                    "</br>" +
                                    (i =
                                        (i = Math.round(100 * i) / 100) + " " + la.UNIT_HECTARES);
                            utilsAreaData.area_layer.setTooltipContent(o),
                                utilsAreaData.area_layer.openTooltip();
                        }),
                        map.off("editable:drawing:end");
                }
            }),
            (utilsAreaData.enabled = !0),
            (gsValues.map_bussy = !0),
            map.doubleClickZoom.disable())
        : (map.editTools.stopDrawing(),
            1 == map.hasLayer(utilsAreaData.area_layer) &&
            map.removeLayer(utilsAreaData.area_layer),
            map.off("editable:editing editable:drag"),
            (utilsAreaData.enabled = !1),
            (gsValues.map_bussy = !1),
            map.doubleClickZoom.enable());
}
function utilsRuler() {
    0 == utilsRulerData.enabled
        ? 1 != gsValues.map_bussy &&
        ((utilsRulerData.line_layer = map.editTools.startPolyline()),
            map.on("editable:editing editable:drag", function (e) {
                var t = utilsRulerData.line_layer.getLatLngs(),
                    a = t[t.length - 1];
                if (map.hasLayer(utilsRulerData.label_layer)) {
                    var i = getLengthFromLatLngs(t);
                    (i = (i = convDistanceUnits(
                        i,
                        "km",
                        settingsUserData.unit_distance
                    )).toFixed(2)),
                        (i += " " + la.UNIT_DISTANCE),
                        utilsRulerData.label_layer.setLatLng(a),
                        utilsRulerData.label_layer.setContent(i);
                } else
                    (utilsRulerData.label_layer = L.tooltip({
                        permanent: !0,
                        offset: [10, 0],
                        direction: "right",
                    })),
                        utilsRulerData.label_layer.setLatLng(a),
                        utilsRulerData.label_layer.setContent("0 " + la.UNIT_DISTANCE),
                        map.addLayer(utilsRulerData.label_layer);
            }),
            (utilsRulerData.enabled = !0),
            (gsValues.map_bussy = !0),
            map.doubleClickZoom.disable())
        : (map.editTools.stopDrawing(),
            1 == map.hasLayer(utilsRulerData.line_layer) &&
            map.removeLayer(utilsRulerData.line_layer),
            1 == map.hasLayer(utilsRulerData.label_layer) &&
            map.removeLayer(utilsRulerData.label_layer),
            map.off("editable:editing editable:drag"),
            (utilsRulerData.enabled = !1),
            (gsValues.map_bussy = !1),
            map.doubleClickZoom.enable());
}
function utilsShowDriverInfo(e) {
    var t = settingsObjectDriverData[e].name,
        a = settingsObjectDriverData[e].idn,
        i = settingsObjectDriverData[e].address,
        o = settingsObjectDriverData[e].phone,
        s = settingsObjectDriverData[e].email,
        n = settingsObjectDriverData[e].desc,
        l = settingsObjectDriverData[e].img;
    (l =
        '<center><img style="border:0px; width: 80px;" src="' +
        (l = "" == l ? "img/user-blank.svg" : "data/user/drivers/" + l) +
        '" /></center>'),
        (text = '<div class="row">'),
        (text +=
            '<div class="row2"><div class="width40">' +
            l +
            '</div><div class="width60">' +
            t +
            "</div></div>"),
        "" != a &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.ID_NUMBER +
            ':</strong></div><div class="width60">' +
            a +
            "</div></div>"),
        "" != i &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.ADDRESS +
            ':</strong></div><div class="width60">' +
            i +
            "</div></div>"),
        "" != o &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.PHONE +
            ':</strong></div><div class="width60">' +
            o +
            "</div></div>"),
        "" != s &&
        ((s = '<a href="mailto:' + s + '">' + s + "</a>"),
            (text +=
                '<div class="row2"><div class="width40"><strong>' +
                la.EMAIL +
                ':</strong></div><div class="width60">' +
                s +
                "</div></div>")),
        "" != n &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.DESCRIPTION +
            ':</strong></div><div class="width60">' +
            n +
            "</div></div>"),
        (text += "</div>"),
        notifyBox("info", la.DRIVER_INFO, text);
}
function utilsShowTrailerInfo(e) {
    var t = settingsObjectTrailerData[e].name,
        a = settingsObjectTrailerData[e]?.model,
        i = settingsObjectTrailerData[e]?.vin,
        o = settingsObjectTrailerData[e]?.plate_number,
        s = settingsObjectTrailerData[e].desc;
    (text = '<div class="row">'),
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.NAME +
            ':</strong></div><div class="width60">' +
            t +
            "</div></div>"),
        "" != a &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.MODEL +
            ':</strong></div><div class="width60">' +
            a +
            "</div></div>"),
        "" != i &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.VIN +
            ':</strong></div><div class="width60">' +
            i +
            "</div></div>"),
        "" != o &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.PLATE_NUMBER +
            ':</strong></div><div class="width60">' +
            o +
            "</div></div>"),
        "" != s &&
        (text +=
            '<div class="row2"><div class="width40"><strong>' +
            la.DESCRIPTION +
            ':</strong></div><div class="width60">' +
            s +
            "</div></div>"),
        (text += "</div>"),
        notifyBox("info", la.TRAILER_INFO, text);
}
function utilsShowPassengerInfo(e) {
    var t = {
        cmd: "load_object_passenger_data",
        passenger_id: e,
    };
    $.ajax({
        type: "POST",
        url: "func/fn_settings.passengers.php",
        data: t,
        dataType: "json",
        cache: !1,
        success: function (e) {
            var t = e.name,
                a = e.idn,
                i = e.address,
                o = e.phone,
                s = e.email,
                n = e.desc;
            (text = '<div class="row">'),
                (text +=
                    '<div class="row2"><div class="width40"><strong>' +
                    la.NAME +
                    ':</strong></div><div class="width60">' +
                    t +
                    "</div></div>"),
                "" != a &&
                (text +=
                    '<div class="row2"><div class="width40"><strong>' +
                    la.ID_NUMBER +
                    ':</strong></div><div class="width60">' +
                    a +
                    "</div></div>"),
                "" != i &&
                (text +=
                    '<div class="row2"><div class="width40"><strong>' +
                    la.ADDRESS +
                    ':</strong></div><div class="width60">' +
                    i +
                    "</div></div>"),
                "" != o &&
                (text +=
                    '<div class="row2"><div class="width40"><strong>' +
                    la.PHONE +
                    ':</strong></div><div class="width60">' +
                    o +
                    "</div></div>"),
                "" != s &&
                ((s = '<a href="mailto:' + s + '">' + s + "</a>"),
                    (text +=
                        '<div class="row2"><div class="width40"><strong>' +
                        la.EMAIL +
                        ':</strong></div><div class="width60">' +
                        s +
                        "</div></div>")),
                "" != n &&
                (text +=
                    '<div class="row2"><div class="width40"><strong>' +
                    la.DESCRIPTION +
                    ':</strong></div><div class="width60">' +
                    n +
                    "</div></div>"),
                (text += "</div>"),
                notifyBox("info", la.PASSENGER_INFO, text);
        },
    });
}
function utilsShowPoint() {
    utilsPointOnMap(
        document.getElementById("dialog_show_point_lat").value,
        document.getElementById("dialog_show_point_lng").value
    );
}
function utilsPointOnMap(e, t) {
    "" == e && (e = 0),
        "" == t && (t = 0),
        geocoderGetAddress(e, t, function (a) {
            var i = a,
                o = urlPosition(e, t),
                s =
                    "<table>\t\t\t\t\t<tr><td><strong>" +
                    la.ADDRESS +
                    ":</strong></td><td>" +
                    i +
                    "&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>\t\t\t\t\t<tr><td><strong>" +
                    la.POSITION +
                    ":</strong></td><td>" +
                    o +
                    "</td></tr>\t\t\t\t\t</table>";
            addPopupToMap(e, t, [0, 0], s, ""),
                map.panTo({
                    lat: e,
                    lng: t,
                }),
                1 == gsValues.map_street_view &&
                (objectUnSelectAll(), utilsStreetView(e, t, 0));
        });
}
function utilsSearchAddress() {
    var e = document.getElementById("dialog_address_search_addr").value;
    geocoderGetLocation(e, function (t) {
        if (null != t[0]) {
            e = t[0].address;
            var a = t[0].lat,
                i = t[0].lng,
                o = urlPosition(a, i);
            addPopupToMap(
                a,
                i,
                [0, 0],
                "<table>\t\t\t\t\t<tr><td><strong>" +
                la.ADDRESS +
                ":</strong></td><td>" +
                e +
                "&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>\t\t\t\t\t<tr><td><strong>" +
                la.POSITION +
                ":</strong></td><td>" +
                o +
                "</td></tr>\t\t\t\t\t</table>",
                ""
            ),
                map.panTo({
                    lat: a,
                    lng: i,
                }),
                1 == gsValues.map_street_view &&
                (objectUnSelectAll(), utilsStreetView(a, i, 0));
        } else notifyBox("info", la.INFORMATION, la.NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST);
    });
}
function utilsFollowObject(e, t) {
    if ("" != objectsData[e].data) {
        var a = document.getElementById("map_layer").value,
            i = "func/fn_object.follow.php?imei=" + e + "&map_layer=" + a;
        if (1 == t) window.open(i, "_blank");
        else if (null == utilsFollowObjectData[e]) {
            var o =
                '<div style="position:absolute; top: 0px; bottom: 0px; left: 0px; right: 0px;">';
            (o +=
                '<iframe src="' +
                i +
                '" style="border: 0px; width: 100%; height: 100%;"></iframe>'),
                (o += "</div>");
            var s = settingsObjectData[e].name,
                n = $(document.createElement("div"));
            n.attr("title", la.FOLLOW + " (" + s + ")"),
                n.html(o),
                $(n).dialog({
                    autoOpen: !1,
                    width: 500,
                    height: 400,
                    minWidth: 350,
                    minHeight: 250,
                    resizable: !0,
                    close: function (t, a) {
                        utilsFollowObjectData[e] = void 0;
                    },
                }),
                $(n).dialog("open"),
                (utilsFollowObjectData[e] = new Array()),
                (utilsFollowObjectData[e].dialog = n);
        } else utilsFollowObjectData[e].dialog.dialog("moveToTop");
    } else notifyBox("info", la.INFORMATION, la.NO_DATA_HAS_BEEN_RECEIVED_YET);
}
function utilsRouteToPoint(e) {
    if (1 != gsValues.map_bussy) {
        utilsRouteBetweenPointsHide();
        var t = !1;
        for (var a in objectsData)
            if (1 == objectsData[a].selected) {
                t = a;
                break;
            }
        if (0 == t) notifyBox("info", la.INFORMATION, la.NO_OBJECT_SELECTED);
        else {
            new Array();
            if ("" != objectsData[t].data) {
                var i = objectsData[t].data[0].lat,
                    o = objectsData[t].data[0].lng;
                utilsRouteBetweenPointsGet(e, L.latLng(i, o));
            }
        }
    }
}
function utilsRouteBetweenPoints(e) {
    if (1 != gsValues.map_bussy) {
        (gsValues.map_bussy = !0), utilsRouteBetweenPointsHide();
        var t = map.editTools.startPolyline(e);
        map.doubleClickZoom.disable(),
            map.on("editable:drawing:clicked", function (a) {
                var i = t.getLatLngs(),
                    o = i[i.length - 1];
                map.editTools.stopDrawing(),
                    1 == map.hasLayer(t) && map.removeLayer(t),
                    map.doubleClickZoom.enable(),
                    map.off("editable:drawing:clicked"),
                    utilsRouteBetweenPointsGet(e, o),
                    (gsValues.map_bussy = !1);
            });
    }
}
function utilsRouteBetweenPointsGet(e, t) {
    var a = settingsUserData.map_is,
        i = new Array();
    i.push(e), i.push(t);
    var o = L.Routing.control({
        waypoints: i,
        show: !1,
        showAlternatives: !1,
        waypointMode: "snap",
        createMarker: function () { },
    }).addTo(map);
    o.on("routeselected", function (e) {
        utilsRouteBetweenPointsData.route_points = e.route.coordinates;
        var t = L.polyline(utilsRouteBetweenPointsData.route_points, {
            color: settingsUserData.map_rc,
            opacity: 0.8,
            weight: 3,
        });
        mapLayers.utils.addLayer(t), map.removeControl(o);
        var i = getLengthFromLatLngs(utilsRouteBetweenPointsData.route_points);
        (i = (i = convDistanceUnits(
            i,
            "km",
            settingsUserData.unit_distance
        )).toFixed(2)),
            (i += " " + la.UNIT_DISTANCE);
        var s = getTimeDetails(Math.floor(e.route.summary.totalTime), !0),
            n = utilsRouteBetweenPointsData.route_points[0].lat,
            l = utilsRouteBetweenPointsData.route_points[0].lng,
            d = L.marker([n, l], {
                icon: mapMarkerIcons.route_start,
            });
        d.on("click", function (e) {
            geocoderGetAddress(n, l, function (e) {
                var t = e,
                    o = urlPosition(n, l),
                    d =
                        "<table>\t\t\t\t\t\t<tr><td><strong>" +
                        la.ADDRESS +
                        ":</strong></td><td>" +
                        t +
                        "&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.POSITION +
                        ":</strong></td><td>" +
                        o +
                        "</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.LENGTH +
                        ":</strong></td><td>" +
                        i +
                        "</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.DURATION +
                        ":</strong></td><td>" +
                        s +
                        "</td></tr>\t\t\t\t\t\t</table>";
                (d +=
                    '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="utilsRouteBetweenPointsSave();">' +
                    la.SAVE_AS_ROUTE +
                    "</a> " +
                    la.OR),
                    (d +=
                        ' <a href="#" class="" onClick="utilsRouteBetweenPointsHide();">' +
                        la.HIDE.toLowerCase() +
                        "</a></div>"),
                    addPopupToMap(n, l, [0, -28 * a], d, "");
            });
        }),
            mapLayers.utils.addLayer(d);
        var r =
            utilsRouteBetweenPointsData.route_points[
                utilsRouteBetweenPointsData.route_points.length - 1
            ].lat,
            _ =
                utilsRouteBetweenPointsData.route_points[
                    utilsRouteBetweenPointsData.route_points.length - 1
                ].lng;
        (d = L.marker([r, _], {
            icon: mapMarkerIcons.route_end,
        })).on("click", function (e) {
            geocoderGetAddress(r, _, function (e) {
                var t = e,
                    o = urlPosition(r, _),
                    n =
                        "<table>\t\t\t\t\t\t<tr><td><strong>" +
                        la.ADDRESS +
                        ":</strong></td><td>" +
                        t +
                        "&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.POSITION +
                        ":</strong></td><td>" +
                        o +
                        "</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.LENGTH +
                        ":</strong></td><td>" +
                        i +
                        "</td></tr>\t\t\t\t\t\t<tr><td><strong>" +
                        la.DURATION +
                        ":</strong></td><td>" +
                        s +
                        "</td></tr>\t\t\t\t\t\t</table>";
                (n +=
                    '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="utilsRouteBetweenPointsSave();">' +
                    la.SAVE_AS_ROUTE +
                    "</a> " +
                    la.OR),
                    (n +=
                        ' <a href="#" class="" onClick="utilsRouteBetweenPointsHide();">' +
                        la.HIDE.toLowerCase() +
                        "</a></div>"),
                    addPopupToMap(r, _, [0, -28 * a], n, "");
            });
        });
        var c = t.getBounds();
        map.fitBounds(c), mapLayers.utils.addLayer(d);
    });
}
function utilsRouteBetweenPointsSave() {
    if (1 != gsValues.map_bussy) {
        var e = Math.ceil(utilsRouteBetweenPointsData.route_points.length / 200),
            t = new Array();
        for (i = 0; i < utilsRouteBetweenPointsData.route_points.length; i += e) {
            var a = utilsRouteBetweenPointsData.route_points[i].lat,
                o = utilsRouteBetweenPointsData.route_points[i].lng;
            t.push(L.latLng(a, o));
        }
        placesRouteSave(t), utilsRouteBetweenPointsHide();
    }
}
function utilsRouteBetweenPointsHide() {
    (utilsRouteBetweenPointsData.route_points = !1),
        mapLayers.utils.clearLayers(),
        destroyMapPopup();
}
function utilsCamera(e) {
    var t = objectsData[e].last_img_file;
    if ("" != t) {
        var a = "data/img/" + t;
        imageExists(a, function (e) {
            document.getElementById("camera_control").innerHTML = e
                ? '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="' +
                a +
                '">'
                : '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="img/no-image.svg">';
        });
    } else
        document.getElementById("camera_control").innerHTML =
            '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="img/no-image.svg">';
}

// function utilsStreetViewObject(e, t) {
//     // console.log(e)
//     // console.log(t)
//     // console.log(objectsData[e])

//     if ("" != objectsData[e].data) {
//         var a = "https://maps.google.com/maps?q=&layer=c&cbll=" + objectsData[e].data[0].lat + "," + objectsData[e].data[0].lng;
//         1 == t && window.open(a, "_blank")
//     } else
//         notifyBox("info", la.INFORMATION, la.NO_DATA_HAS_BEEN_RECEIVED_YET)
// }
// function utilsStreetViewPoint(e, t, a) {
//     // console.log(e)
//     // console.log(t)
//     // console.log(objectsData[e])
//     var i = "https://maps.google.com/maps?q=&layer=c&cbll=" + e + "," + t;
//     1 == a && window.open(i, "_blank")
// }

// utilsStreetViewData?.prev_lat = !1,
//     utilsStreetViewData?.prev_lng = !1;
// if (objectsData[e].last_img_file) {
//     var a = "data/img/" + objectsData[e].last_img_file;
//     imageExists(a, function (e) {
//         document.getElementById("camera_control").innerHTML = e ? '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="' + a + '">' : '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="img/no-image.svg">'
//     });
// } else {
//     document.getElementById("camera_control").innerHTML = '<img style="image-orientation: from-image; object-fit: contain; height: 100%; width: 100%;" src="img/no-image.svg">';
// }

function objectUpdateList() {
    for (var e in objectsData) {
        if ("" != objectsData[e].data) {
            if (null != document.getElementById("object_status_" + e)) {
                (document.getElementById("object_visible_" + e).checked =
                    objectsData[e].visible),
                    (document.getElementById("object_follow_" + e).checked =
                        objectsData[e].follow);
                var t = objectsData[e].status_string;
                "server" == settingsUserData.od
                    ? (document.getElementById("object_status_" + e).innerHTML =
                        objectsData[e].data[0].dt_server)
                    : "status" == settingsUserData.od && "" != t
                        ? (document.getElementById("object_status_" + e).innerHTML = t)
                        : (document.getElementById("object_status_" + e).innerHTML =
                            objectsData[e].data[0].dt_tracker),
                    (document.getElementById("object_speed_" + e).innerHTML =
                        objectsData[e].data[0].speed + " " + la.UNIT_SPEED);
                var a = getSensorFromType(e, "acc");
                0 == a || 0 == objectsData[e].connection
                    ? (document.getElementById("object_engine_" + e).innerHTML = "")
                    : 1 == getSensorValue(objectsData[e].data[0].params, a[0]).value
                        ? (document.getElementById("object_engine_" + e).innerHTML =
                            getEngineIcon(1))
                        : (document.getElementById("object_engine_" + e).innerHTML =
                            getEngineIcon(0)),
                    (document.getElementById("object_connection_" + e).innerHTML =
                        getConnectionIcon(objectsData[e].connection)),
                    1 == objectsData[e].selected &&
                    showExtraData("object", e, objectsData[e].data[0]);
            }
        } else
            null != document.getElementById("object_status_" + e) &&
                ((document.getElementById("object_visible_" + e).checked =
                    objectsData[e].visible),
                    (document.getElementById("object_follow_" + e).checked =
                        objectsData[e].follow),
                    (document.getElementById("object_status_" + e).innerHTML = la.NO_DATA),
                    (document.getElementById("object_speed_" + e).innerHTML =
                        "0 " + la.UNIT_SPEED),
                    (document.getElementById("object_engine_" + e).innerHTML = ""),
                    (document.getElementById("object_connection_" + e).innerHTML =
                        getConnectionIcon(objectsData[e].connection)));
        objectSetListStatus(
            e,
            objectsData[e].status,
            objectsData[e].event_ohc_color
        );
    }
    for (var o in settingsObjectGroupData)
        null != document.getElementById("object_group_visible_" + o) &&
            (document.getElementById("object_group_visible_" + o).checked =
                settingsObjectGroupData[o].visible),
            null != document.getElementById("object_group_follow_" + o) &&
            (document.getElementById("object_group_follow_" + o).checked =
                settingsObjectGroupData[o].follow);
}

function objectSetListStatus(e, t, a) {
    var o = getObjectListColor(t, a),
        i = $("#side_panel_objects_object_list_grid");
    $(i).jqGrid("setRowData", e, false, {
        background: o,
    });
}

function objectRemoveAllFromMap() {
    mapLayers.realtime.clearLayers();
}
function objectSetStatusEvent(e, t, a) {
    if (null != objectsData[e])
        if (0 == t && 0 == a) {
            if (
                ((objectsData[e].event = !1),
                    (objectsData[e].event_arrow_color = !1),
                    (objectsData[e].event_ohc_color = !1),
                    "arrow" == settingsObjectData[e].map_icon)
            ) {
                var i = objectsData[e].data[0].speed,
                    o = objectsData[e].status,
                    s = getMarkerIcon(e, i, o, !1);
                objectsData[e].layers.marker.setIcon(s);
            }
            objectSetListStatus(e, objectsData[e].status, !1);
        } else {
            if (
                ((objectsData[e].event = !0),
                    (objectsData[e].event_arrow_color = t),
                    (objectsData[e].event_ohc_color = a),
                    "arrow" == settingsObjectData[e].map_icon)
            ) {
                (i = objectsData[e].data[0].speed),
                    (o = objectsData[e].status),
                    (s = getMarkerIcon(e, i, o, t));
                objectsData[e].layers.marker.setIcon(s);
            }
            objectSetListStatus(e, o, a);
        }
}
function objectAddToMap(e) {
    var t = settingsObjectData[e].name;
    if ("" != objectsData[e].data)
        var a = objectsData[e].data[0].lat,
            i = objectsData[e].data[0].lng,
            o = objectsData[e].data[0].altitude,
            s = objectsData[e].data[0].angle,
            n = objectsData[e].data[0].speed,
            l = objectsData[e].data[0].dt_tracker,
            d = objectsData[e].data[0].params;
    else (a = 0), (i = 0), (n = 0), (d = !1);
    var r = settingsUserData.map_is,
        _ = s;
    "arrow" != settingsObjectData[e].map_icon && (_ = 0);
    var c = objectsData[e].status,
        g = objectsData[e].event_arrow_color,
        m = getMarkerIcon(e, n, c, g),
        u = L.marker([a, i], {
            icon: m,
            iconAngle: _,
        }),
        p = t + " (" + n + " " + la.UNIT_SPEED + ")";
    u
        .bindTooltip(p, {
            permanent: !0,
            offset: [20 * r, 0],
            direction: "right",
        })
        .openTooltip(),
        u.on("click", function (_) {
            objectSelect(e),
                "" != objectsData[e].data &&
                geocoderGetAddress(a, i, function (_) {
                    var c = _,
                        g = urlPosition(a, i),
                        m = "",
                        u = "",
                        p = "",
                        y = new Array();
                    for (var h in settingsObjectData[e].sensors)
                        y.push(settingsObjectData[e].sensors[h]);
                    var v = sortArrayByElement(y, "name");
                    for (var h in v) {
                        var b = v[h];
                        if ("true" == b.popup)
                            if ("fuelsumup" == b.type) {
                                var E = getSensorValueFuelLevelSumUp(e, d, b);
                                m +=
                                    "<tr><td><strong>" +
                                    b.name +
                                    ":</strong></td><td>" +
                                    E.value_full +
                                    "</td></tr>";
                            } else {
                                E = getSensorValue(d, b);
                                m +=
                                    "<tr><td><strong>" +
                                    b.name +
                                    ":</strong></td><td>" +
                                    E.value_full +
                                    "</td></tr>";
                            }
                    }
                    var f = new Array();
                    for (var h in settingsObjectData[e].custom_fields)
                        f.push(settingsObjectData[e].custom_fields[h]);
                    var I = sortArrayByElement(f, "name");
                    for (var h in I) {
                        var B = I[h];
                        "true" == B.popup &&
                            (u +=
                                "<tr><td><strong>" +
                                B.name +
                                ":</strong></td><td>" +
                                textToLinks(B.value) +
                                "</td></tr>");
                    }
                    var D = new Array();
                    for (var h in objectsData[e].service)
                        D.push(objectsData[e].service[h]);
                    var O = sortArrayByElement(D, "name");
                    for (var h in O)
                        "true" == O[h].popup &&
                            (p +=
                                "<tr><td><strong>" +
                                O[h].name +
                                ":</strong></td><td>" +
                                O[h].status +
                                "</td></tr>");
                    var k =
                        "<table>\t\t\t\t\t<tr><td><strong>" +
                        la.OBJECT +
                        ":</strong></td><td>" +
                        t +
                        "</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.ADDRESS +
                        ":</strong></td><td>" +
                        c +
                        "</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.POSITION +
                        ":</strong></td><td>" +
                        g +
                        "</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.ALTITUDE +
                        ":</strong></td><td>" +
                        o +
                        " " +
                        la.UNIT_HEIGHT +
                        "</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.ANGLE +
                        ":</strong></td><td>" +
                        s +
                        " &deg;</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.SPEED +
                        ":</strong></td><td>" +
                        n +
                        " " +
                        la.UNIT_SPEED +
                        "</td></tr>\t\t\t\t\t<tr><td><strong>" +
                        la.TIME +
                        ":</strong></td><td>" +
                        l +
                        "</td></tr>",
                        j = getObjectOdometer(e, !1);
                    -1 != j &&
                        (k +=
                            "<tr><td><strong>" +
                            la.ODOMETER +
                            ":</strong></td><td>" +
                            j +
                            " " +
                            la.UNIT_DISTANCE +
                            "</td></tr>");
                    var T = getObjectEngineHours(e, !1);
                    -1 != T &&
                        (k +=
                            "<tr><td><strong>" +
                            la.ENGINE_HOURS +
                            ":</strong></td><td>" +
                            T +
                            "</td></tr>");
                    var R = k + u + m + p;
                    addPopupToMap(
                        a,
                        i,
                        [0, -14 * r],
                        (k += "</table>"),
                        (R += "</table>")
                    );
                });
        }),
        u.on("add", function (t) {
            0 == gsValues.map_object_labels && u.closeTooltip(),
                objectAddTailToMap(e);
        }),
        u.on("remove", function (t) {
            null != objectsData[e] &&
                objectsData[e].layers.tail &&
                mapLayers.realtime.removeLayer(objectsData[e].layers.tail);
        }),
        (u.imei = e),
        mapLayers.realtime.addLayer(u),
        (objectsData[e].layers.marker = u);
}
function objectAddTailToMap(e) {
    if (settingsObjectData[e].tail_points > 0) {
        objectsData[e].layers.tail &&
            mapLayers.realtime.removeLayer(objectsData[e].layers.tail);
        var t,
            a = new Array();
        for (t = 0; t < objectsData[e].data.length; t++) {
            var i = objectsData[e].data[t].lat,
                o = objectsData[e].data[t].lng;
            a.push(L.latLng(i, o));
        }
        var s = L.polyline(a, {
            color: settingsObjectData[e].tail_color,
            opacity: 0.8,
            weight: 3,
        });
        mapLayers.realtime.addLayer(s), (objectsData[e].layers.tail = s);
    }
}
function objectGroupVisibleToggle(e) {
    var t = document.getElementById("object_group_visible_" + e).checked;
    for (var a in settingsObjectData)
        settingsObjectData[a].group_id == e &&
            ((settingsObjectGroupData[e].visible = t),
                null != document.getElementById("object_visible_" + a) &&
                ((document.getElementById("object_visible_" + a).checked = t),
                    (objectsData[a].visible = t),
                    objectVisible(a)));
}
function objectVisibleToggle(e) {
    var t = document.getElementById("object_visible_" + e).checked;
    (objectsData[e].visible = t), objectVisible(e);
}
function objectVisible(e) {
    1 == objectsData[e].visible
        ? mapLayers.realtime.addLayer(objectsData[e].layers.marker)
        : mapLayers.realtime.removeLayer(objectsData[e].layers.marker);
}
function objectVisibleAllToggle() {
    1 == gsValues.objects_visible ? objectVisibleAll(!1) : objectVisibleAll(!0);
}
function objectVisibleAll(e) {
    for (var t in ((gsValues.objects_visible = e), objectsData))
        (objectsData[t].visible = e),
            null != document.getElementById("object_visible_" + t) &&
            (document.getElementById("object_visible_" + t).checked = e),
            objectVisible(t);
    for (var a in settingsObjectGroupData)
        null != document.getElementById("object_group_visible_" + a) &&
            ((settingsObjectGroupData[a].visible = e),
                (document.getElementById("object_group_visible_" + a).checked = e));
}
function objectGroupFollowToggle(e) {
    var t = document.getElementById("object_group_follow_" + e).checked;
    for (var a in settingsObjectData)
        settingsObjectData[a].group_id == e &&
            ((settingsObjectGroupData[e].follow = t),
                null != document.getElementById("object_follow_" + a) &&
                ((document.getElementById("object_follow_" + a).checked = t),
                    (objectsData[a].follow = t)));
    objectFollow();
}
function objectFollowToggle(e) {
    var t = document.getElementById("object_follow_" + e).checked;
    (objectsData[e].follow = t), objectFollow();
}
function objectFollowAllToggle() {
    1 == gsValues.objects_follow ? objectFollowAll(!1) : objectFollowAll(!0);
}
function objectFollowAll(e) {
    for (var t in ((gsValues.objects_follow = e), objectsData))
        (objectsData[t].follow = e),
            null != document.getElementById("object_follow_" + t) &&
            (document.getElementById("object_follow_" + t).checked = e);
    for (var a in settingsObjectGroupData)
        null != document.getElementById("object_group_follow_" + a) &&
            ((settingsObjectGroupData[a].follow = e),
                (document.getElementById("object_group_follow_" + a).checked = e));
    objectFollow();
}
function objectPanToZoom(e) {
    if ("" != objectsData[e].data) {
        var t = objectsData[e].data[0].lat,
            a = objectsData[e].data[0].lng;
        map.setView([t, a], 15);
    }
}
function objectPanTo(e) {
    if ("" != objectsData[e].data) {
        var t = objectsData[e].data[0].lat,
            a = objectsData[e].data[0].lng;
        map.panTo({
            lat: t,
            lng: a,
        });
    }
}
function objectSelect(e) {
    if (
        (objectUnSelectAll(),
            0 != objectsData[e].event && objectSetStatusEvent(e, !1, !1),
            "" != objectsData[e].data)
    ) {
        if (
            ((objectsData[e].selected = !0),
                datalistShowData("object", e, objectsData[e].data[0]),
                1 == gsValues.map_street_view)
        )
            utilsStreetView(
                objectsData[e].data[0].lat,
                objectsData[e].data[0].lng,
                objectsData[e].data[0].angle
            );
        1 == gsValues.map_camera && utilsCamera(e);
    } else
        notifyBox("info", la.INFORMATION, la.NO_DATA_HAS_BEEN_RECEIVED_YET),
            datalistShowData("object", e, "");
}
function objectUnSelectAll() {
    for (var e in objectsData) objectsData[e].selected = !1;
}

function utilsCheckPrivileges(e) {
    switch (e) {
        case "viewer":
            if (
                ("" == settingsUserData.privileges ||
                    "viewer" == settingsUserData.privileges) &&
                0 == settingsUserData.cpanel_privileges
            )
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "subuser":
            if ("subuser" == settingsUserData.privileges)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "obj_add":
            if (
                0 != settingsUserData.manager_id ||
                "false" == settingsUserData.obj_add
            )
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "obj_edit":
            if ("true" != settingsUserData.obj_edit)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "obj_delete":
            if ("true" != settingsUserData.obj_delete)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "obj_history_clear":
            if ("true" != settingsUserData.obj_history_clear)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "dashboard":
            if (1 != settingsUserData.privileges_dashboard)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "history":
            console.log(settingsUserData.privileges_history ? (settingsSubaccountData.privileges_history ? settingsSubaccountData.privileges_history : settingsUserData.privileges_history) : '')
            if (1 != settingsUserData.privileges_history)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "reports":
            if (1 != settingsUserData.privileges_reports)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "tachograph":
            if (1 != settingsUserData.privileges_tachograph)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "tasks":
            if (1 != settingsUserData.privileges_tasks)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "rilogbook":
            if (1 != settingsUserData.privileges_rilogbook)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "dtc":
            if (1 != settingsUserData.privileges_dtc)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "maintenance":
            if (1 != settingsUserData.privileges_maintenance)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "expenses":
            if (1 != settingsUserData.privileges_expenses)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "object_control":
            if (1 != settingsUserData.privileges_object_control)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "image_gallery":
            if (1 != settingsUserData.privileges_image_gallery)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "chat":
            if (1 != settingsUserData.privileges_chat)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
            break;
        case "subaccounts":
            if (1 != settingsUserData.privileges_subaccounts)
                return (
                    notifyBox(
                        "error",
                        la.ERROR,
                        la.THIS_ACCOUNT_HAS_NO_PRIVILEGES_TO_DO_THAT
                    ),
                    !1
                );
    }
    return !0;
}
function placesZoneVisibleAll(e) {
    if (((gsValues.map_zones = e), 1 == e)) {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].zone_visible = !0),
                placesSetListCheckbox("zone_group_visible_" + t, !0);
        for (var t in placesZoneData.zones)
            (placesZoneData.zones[t].visible = !0),
                placesSetListCheckbox("zone_visible_" + t, !0),
                placesZoneVisible(t, !0);
    } else {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].zone_visible = !1),
                placesSetListCheckbox("zone_group_visible_" + t, !1);
        for (var t in placesZoneData.zones)
            (placesZoneData.zones[t].visible = !1),
                placesSetListCheckbox("zone_visible_" + t, !1);
        placesZoneRemoveAllFromMap();
    }
}
(placesZoneData.zones = new Array()),
    (placesZoneData.new_zone_id = 1),
    (placesZoneData.edit_zone_id = !1),
    (placesZoneData.edit_zone_layer = !1);
var placesRouteData = new Array();
function placesRouteReload() {
    placesGroupLoadData(),
        placesRouteLoadData(),
        $("#side_panel_places_route_list_grid").trigger("reloadGrid");
}
function placesRouteLoadData() {
    $.ajax({
        type: "POST",
        url: "func/fn_places.php",
        data: {
            cmd: "load_route_data",
        },
        dataType: "json",
        cache: !1,
        success: function (e) {
            (placesRouteData.routes = e),
                placesRouteInitLists(),
                placesRouteSetListCheckbox(),
                placesRouteSetListNumber(),
                "" != placesRouteData.routes
                    ? placesRouteAddAllToMap()
                    : placesRouteRemoveAllFromMap();
        },
    });
}
function placesRouteInitLists() {
    initSelectList("events_route_list"), initSelectList("subaccounts_route_list");
}
function placesRouteSetListNumber() {
    document.getElementById("side_panel_places_routes_num").innerHTML =
        "(" + Object.keys(placesRouteData.routes).length + ")";
}
function placesRouteSetListCheckbox() {
    for (var e in placesGroupData.groups)
        placesSetListCheckbox(
            "route_group_visible_" + e,
            placesGroupData.groups[e].route_visible
        );
    for (var e in placesRouteData.routes)
        placesSetListCheckbox(
            "route_visible_" + e,
            placesRouteData.routes[e].visible
        );
}
function placesRouteAddAllToMap() {
    var e = document.getElementById("side_panel_places_route_list_search").value;
    for (var t in (placesRouteRemoveAllFromMap(), placesRouteData.routes)) {
        var a = placesRouteData.routes[t];
        if (strMatches(a.data.name, e)) {
            var i = a.data.name,
                o = a.data.color,
                s = a.data.visible,
                n = a.data.name_visible,
                l = a.data.points;
            try {
                placesRouteAddRouteToMap(t, i, o, s, n, l);
            } catch (e) { }
        }
    }
}
function placesRouteAddRouteToMap(e, t, a, i, o, s) {
    var n = placesRoutePointsStringToLatLngs(s),
        l = L.polyline(n, {
            color: a,
            fill: !1,
            opacity: 0.8,
            weight: 3,
        }),
        d = n[0],
        r = L.tooltip({
            permanent: !0,
            direction: "top",
        });
    r.setLatLng(d),
        r.setContent(t),
        "false" != i && mapLayers.places_routes.addLayer(l),
        "false" != o && mapLayers.places_routes.addLayer(r),
        (placesRouteData.routes[e].route_layer = l),
        (placesRouteData.routes[e].label_layer = r);
}
function placesRouteRemoveAllFromMap() {
    mapLayers.places_routes.clearLayers();
}
function placesRouteSearchMap(e) {
    for (var t in placesRouteData.routes) {
        var a = placesRouteData.routes[t];
        strMatches(a.data.name, e)
            ? 1 == a.visible && placesRouteVisible(t, !0)
            : placesRouteVisible(t, !1);
    }
}
function placesRouteDeleteAll() {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ALL_ROUTES, function (e) {
            if (e) {
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: {
                        cmd: "delete_all_routes",
                    },
                    success: function (e) {
                        "OK" == e &&
                            (placesRouteLoadData(),
                                $("#side_panel_places_route_list_grid").trigger("reloadGrid"));
                    },
                });
            }
        });
}
function placesRouteDelete(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (placesRoutePanTo(e),
            confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
                if (t) {
                    var a = {
                        cmd: "delete_route",
                        route_id: e,
                    };
                    $.ajax({
                        type: "POST",
                        url: "func/fn_places.php",
                        data: a,
                        success: function (t) {
                            "OK" == t &&
                                (placesRouteVisible(e, !1),
                                    delete placesRouteData.routes[e],
                                    placesRouteSetListNumber(),
                                    placesRouteInitLists(),
                                    $("#side_panel_places_route_list_grid").trigger("reloadGrid"));
                        },
                    });
                }
            }));
}
function placesRouteSave(e) {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy
    ) {
        (gsValues.map_bussy = !0),
            document.getElementById("side_panel_places_tab").click(),
            document.getElementById("side_panel_places_routes_tab").click(),
            (document.getElementById("dialog_places_route_name").value =
                la.NEW_ROUTE + " " + placesRouteData.new_route_id),
            (document.getElementById("dialog_places_route_group").value = 0),
            $("#dialog_places_route_group").multipleSelect("refresh"),
            (document.getElementById("dialog_places_route_color").value = "FF0000"),
            (document.getElementById(
                "dialog_places_route_color"
            ).style.backgroundColor = "#FF0000"),
            (document.getElementById("dialog_places_route_visible").checked = !0),
            (document.getElementById("dialog_places_route_name_visible").checked =
                !0),
            (document.getElementById("dialog_places_route_deviation").value = "0.5"),
            $("#dialog_places_route_properties").dialog("open");
        (placesRouteData.edit_route_layer = L.polyline(e, {
            color: "#FF0000",
            fill: !1,
            opacity: 0.8,
            weight: 3,
        })),
            map.addLayer(placesRouteData.edit_route_layer),
            placesRouteData.edit_route_layer.enableEdit();
        var t = placesRouteData.edit_route_layer.getBounds();
        map.fitBounds(t);
    }
}
function placesRouteNew(e) {
    utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        1 != gsValues.map_bussy &&
        (map.doubleClickZoom.disable(),
            (gsValues.map_bussy = !0),
            (document.getElementById("dialog_places_route_name").value =
                la.NEW_ROUTE + " " + placesRouteData.new_route_id),
            (document.getElementById("dialog_places_route_group").value = 0),
            $("#dialog_places_route_group").multipleSelect("refresh"),
            (document.getElementById("dialog_places_route_color").value = "FF0000"),
            (document.getElementById(
                "dialog_places_route_color"
            ).style.backgroundColor = "#FF0000"),
            (document.getElementById("dialog_places_route_visible").checked = !0),
            (document.getElementById("dialog_places_route_name_visible").checked = !0),
            (document.getElementById("dialog_places_route_deviation").value = "0.5"),
            $("#dialog_places_route_properties").dialog("open"),
            null != e
                ? (map.editTools.startPolyline(e),
                    (placesRouteData.edit_start_label_layer = L.tooltip({
                        permanent: !0,
                        offset: [10, 0],
                        direction: "right",
                    })),
                    placesRouteData.edit_start_label_layer.setLatLng(e),
                    placesRouteData.edit_start_label_layer.setContent(la.ROUTE_START),
                    map.addLayer(placesRouteData.edit_start_label_layer))
                : map.editTools.startPolyline(),
            map.on("editable:editing editable:drag", function (e) {
                placesRouteData.edit_route_layer = e.layer;
                var t = placesRouteData.edit_route_layer.getLatLngs(),
                    a = t[0],
                    i = t[t.length - 1];
                map.hasLayer(placesRouteData.edit_start_label_layer)
                    ? placesRouteData.edit_start_label_layer.setLatLng(a)
                    : ((placesRouteData.edit_start_label_layer = L.tooltip({
                        permanent: !0,
                        offset: [10, 0],
                        direction: "right",
                    })),
                        placesRouteData.edit_start_label_layer.setLatLng(i),
                        placesRouteData.edit_start_label_layer.setContent(la.ROUTE_START),
                        map.addLayer(placesRouteData.edit_start_label_layer)),
                    t.length > 1 &&
                    (map.hasLayer(placesRouteData.edit_end_label_layer)
                        ? placesRouteData.edit_end_label_layer.setLatLng(i)
                        : ((placesRouteData.edit_end_label_layer = L.tooltip({
                            permanent: !0,
                            offset: [10, 0],
                            direction: "right",
                        })),
                            placesRouteData.edit_end_label_layer.setLatLng(i),
                            placesRouteData.edit_end_label_layer.setContent(la.ROUTE_END),
                            map.addLayer(placesRouteData.edit_end_label_layer)));
            }));
}
function placesRouteLatLngsToPointsString(e) {
    for (var t = [], a = 0; a < e.length; a++) {
        var i = e[a],
            o = i.lat,
            s = i.lng;
        t.push(parseFloat(o).toFixed(6) + "," + parseFloat(s).toFixed(6));
    }
    return t.toString();
}
function placesRoutePointsStringToLatLngs(e) {
    var t = e.split(","),
        a = [];
    for (j = 0; j < t.length; j += 2)
        (lat = t[j]), (lng = t[j + 1]), a.push(L.latLng(lat, lng));
    return a;
}
function placesRouteProperties(e) {
    if (utilsCheckPrivileges("viewer") && utilsCheckPrivileges("subuser"))
        switch (e) {
            default:
                if (1 == gsValues.map_bussy) return;
                map.doubleClickZoom.disable(), (gsValues.map_bussy = !0);
                var t = e;
                (placesRouteData.edit_route_id = t),
                    (document.getElementById("dialog_places_route_name").value =
                        placesRouteData.routes[t].data.name),
                    (document.getElementById("dialog_places_route_group").value =
                        placesRouteData.routes[t].data.group_id),
                    $("#dialog_places_route_group").multipleSelect("refresh"),
                    (document.getElementById("dialog_places_route_color").value =
                        placesRouteData.routes[t].data.color.substr(1)),
                    (document.getElementById(
                        "dialog_places_route_color"
                    ).style.backgroundColor = placesRouteData.routes[t].data.color),
                    (document.getElementById("dialog_places_route_visible").checked =
                        strToBoolean(placesRouteData.routes[t].data.visible)),
                    (document.getElementById("dialog_places_route_name_visible").checked =
                        strToBoolean(placesRouteData.routes[t].data.name_visible)),
                    (document.getElementById("dialog_places_route_deviation").value =
                        placesRouteData.routes[t].data.deviation),
                    $("#dialog_places_route_properties").dialog("open"),
                    placesRouteVisible(placesRouteData.edit_route_id, !1);
                var a = (o = placesRouteData.routes[placesRouteData.edit_route_id]).data
                    .color,
                    i = placesRoutePointsStringToLatLngs(o.data.points);
                (placesRouteData.edit_route_layer = L.polyline(i, {
                    color: a,
                    fill: !1,
                    opacity: 0.8,
                    weight: 3,
                })),
                    map.addLayer(placesRouteData.edit_route_layer),
                    placesRouteFitBounds(t),
                    setTimeout(function () {
                        placesRouteData.edit_route_layer.enableEdit();
                    }, 200);
                break;
            case "cancel":
                map.off("editable:editing editable:drag"),
                    map.editTools.stopDrawing(),
                    map.hasLayer(placesRouteData.edit_route_layer) &&
                    map.removeLayer(placesRouteData.edit_route_layer),
                    map.hasLayer(placesRouteData.edit_start_label_layer) &&
                    map.removeLayer(placesRouteData.edit_start_label_layer),
                    map.hasLayer(placesRouteData.edit_end_label_layer) &&
                    map.removeLayer(placesRouteData.edit_end_label_layer);
                var o = placesRouteData.routes[placesRouteData.edit_route_id];
                0 != placesRouteData.edit_route_id &&
                    1 == o.visible &&
                    placesRouteVisible(placesRouteData.edit_route_id, !0),
                    (placesRouteData.edit_route_layer = !1),
                    (placesRouteData.edit_start_label_layer = !1),
                    (placesRouteData.edit_end_label_layer = !1),
                    (placesRouteData.edit_route_id = !1),
                    (gsValues.map_bussy = !1),
                    map.doubleClickZoom.enable(),
                    $("#dialog_places_route_properties").dialog("close");
                break;
            case "save":
                var s = document.getElementById("dialog_places_route_name").value,
                    n = document.getElementById("dialog_places_route_group").value,
                    l = "#" + document.getElementById("dialog_places_route_color").value,
                    d = document.getElementById("dialog_places_route_visible").checked,
                    r = document.getElementById(
                        "dialog_places_route_name_visible"
                    ).checked,
                    _ = document.getElementById("dialog_places_route_deviation").value;
                if ("" == s) {
                    notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                    break;
                }
                if (_ < 0 || "" == _) {
                    notifyBox("error", la.ERROR, la.DEVIATION_CANT_BE_LESS_THAN_0);
                    break;
                }
                if (!placesRouteData.edit_route_layer) {
                    notifyBox("error", la.ERROR, la.DRAW_ROUTE_ON_MAP_BEFORE_SAVING);
                    break;
                }
                if (placesRouteData.edit_route_layer.getLatLngs().length < 2) {
                    notifyBox("error", la.ERROR, la.DRAW_ROUTE_ON_MAP_BEFORE_SAVING);
                    break;
                }
                if (placesRouteData.edit_route_layer.getLatLngs().length > 200)
                    return void notifyBox(
                        "error",
                        la.ERROR,
                        la.ROUTE_CANT_HAVE_MORE_THAN_NUM_POINTS
                    );
                i = placesRouteLatLngsToPointsString(
                    placesRouteData.edit_route_layer.getLatLngs()
                );
                map.off("editable:editing editable:drag"),
                    map.editTools.stopDrawing(),
                    map.hasLayer(placesRouteData.edit_route_layer) &&
                    map.removeLayer(placesRouteData.edit_route_layer),
                    map.hasLayer(placesRouteData.edit_start_label_layer) &&
                    map.removeLayer(placesRouteData.edit_start_label_layer),
                    map.hasLayer(placesRouteData.edit_end_label_layer) &&
                    map.removeLayer(placesRouteData.edit_end_label_layer),
                    0 == placesRouteData.edit_route_id &&
                    (placesRouteData.new_route_id += 1);
                var c = {
                    cmd: "save_route",
                    route_id: placesRouteData.edit_route_id,
                    group_id: n,
                    route_name: s,
                    route_color: l,
                    route_visible: d,
                    route_name_visible: r,
                    route_deviation: _,
                    route_points: i,
                };
                $.ajax({
                    type: "POST",
                    url: "func/fn_places.php",
                    data: c,
                    success: function (e) {
                        (placesRouteData.edit_route_layer = !1),
                            (placesRouteData.edit_start_label_layer = !1),
                            (placesRouteData.edit_end_label_layer = !1),
                            (placesRouteData.edit_route_id = !1),
                            (gsValues.map_bussy = !1),
                            map.doubleClickZoom.enable(),
                            $("#dialog_places_route_properties").dialog("close"),
                            "OK" == e
                                ? (placesRouteLoadData(),
                                    $("#side_panel_places_route_list_grid").trigger("reloadGrid"))
                                : "ERROR_ROUTE_LIMIT" == e &&
                                notifyBox("error", la.ERROR, la.ROUTE_LIMIT_IS_REACHED);
                    },
                });
        }
}
function placesRoutePanTo(e) {
    try {
        var t = placesRouteData.routes[e].route_layer.getBounds().getCenter();
        map.panTo(t);
    } catch (e) { }
}
function placesRouteFitBounds(e) {
    var t = placesRouteData.routes[e].route_layer.getBounds();
    map.fitBounds(t);
}
function placesRouteVisibleToggle(e) {
    var t = document.getElementById("route_visible_" + e).checked;
    (placesRouteData.routes[e].visible = t), placesRouteVisible(e, t);
}
function placesRouteVisible(e, t) {
    var a = placesRouteData.routes[e].route_layer,
        i = placesRouteData.routes[e].label_layer;
    1 == t
        ? ("true" == placesRouteData.routes[e].data.visible
            ? mapLayers.places_routes.addLayer(a)
            : mapLayers.places_routes.removeLayer(a),
            "true" == placesRouteData.routes[e].data.name_visible
                ? mapLayers.places_routes.addLayer(i)
                : mapLayers.places_routes.removeLayer(i))
        : (mapLayers.places_routes.removeLayer(a),
            mapLayers.places_routes.removeLayer(i));
}
function routeGroupVisibleToggle(e) {
    var t = document.getElementById("route_group_visible_" + e).checked;
    for (var a in placesRouteData.routes)
        placesRouteData.routes[a].data.group_id == e &&
            ((placesGroupData.groups[e].route_visible = t),
                (placesRouteData.routes[a].visible = t),
                placesSetListCheckbox("route_visible_" + a, t),
                placesRouteVisible(a, t));
}
function placesRouteVisibleAllToggle() {
    1 == gsValues.map_routes
        ? placesRouteVisibleAll(!1)
        : placesRouteVisibleAll(!0);
}
function placesRouteVisibleAll(e) {
    if (((gsValues.map_routes = e), 1 == e)) {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].route_visible = !0),
                placesSetListCheckbox("route_group_visible_" + t, !0);
        for (var t in placesRouteData.routes)
            (placesRouteData.routes[t].visible = !0),
                placesSetListCheckbox("route_visible_" + t, !0),
                placesRouteVisible(t, !0);
    } else {
        for (var t in placesGroupData.groups)
            (placesGroupData.groups[t].route_visible = !1),
                placesSetListCheckbox("route_group_visible_" + t, !1);
        for (var t in placesRouteData.routes)
            (placesRouteData.routes[t].visible = !1),
                placesSetListCheckbox("route_visible_" + t, !1);
        placesRouteRemoveAllFromMap();
    }
}

function settingsReloadObjects() {
    loadSettings("objects", function () {
        1 != $("#dialog_settings").dialog("isOpen") && objectReloadData();
    }),
        $("#settings_main_object_list_grid").trigger("reloadGrid");
}

function settingsObjectClearHistorySelected() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        utilsCheckPrivileges("obj_history_clear")
    ) {
        var e = $("#settings_main_object_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_CLEAR_SELECTED_ITEMS_HISTORY_EVENTS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "clear_history_selected_objects",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.objects.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjects();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}
function settingsOpen() {
    loadSettings("user", function () {
        loadSettings("objects", function () {
            $("#settings_main_object_list_grid").trigger("reloadGrid"),
                $("#dialog_settings").dialog("open");
        });
    });
}
function settingsClose() {
    loadSettings("objects", function () {
        objectReloadData();
    });
}

function settingsObjectDeleteSelected() {
    if (
        utilsCheckPrivileges("viewer") &&
        utilsCheckPrivileges("subuser") &&
        utilsCheckPrivileges("obj_delete")
    ) {
        var e = $("#settings_main_object_list_grid").jqGrid(
            "getGridParam",
            "selarrrow"
        );
        "" != e
            ? confirmDialog(
                la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
                function (t) {
                    if (t) {
                        var a = {
                            cmd: "delete_selected_objects",
                            items: e,
                        };
                        $.ajax({
                            type: "POST",
                            url: "func/fn_settings.objects.php",
                            data: a,
                            success: function (e) {
                                "OK" == e && settingsReloadObjects();
                            },
                        });
                    }
                }
            )
            : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
}

function settingsObjectTrailerProperties(e) {
    switch (e) {
        default:
            var t = e;
            (settingsEditData.trailer_id = t),
                (document.getElementById("dialog_settings_object_trailer_name").value =
                    settingsObjectTrailerData[t].name),
                (document.getElementById(
                    "dialog_settings_object_trailer_assign_id"
                ).value = settingsObjectTrailerData[t].assign_id),
                (document.getElementById("dialog_settings_object_trailer_model").value =
                    settingsObjectTrailerData[t]?.model),
                (document.getElementById("dialog_settings_object_trailer_vin").value =
                    settingsObjectTrailerData[t]?.vin),
                (document.getElementById(
                    "dialog_settings_object_trailer_plate_number"
                ).value = settingsObjectTrailerData[t].plate_number),
                (document.getElementById("dialog_settings_object_trailer_desc").value =
                    settingsObjectTrailerData[t].desc),
                $("#dialog_settings_object_trailer_properties").dialog("open");
            break;
        case "add":
            (settingsEditData.trailer_id = !1),
                (document.getElementById("dialog_settings_object_trailer_name").value =
                    ""),
                (document.getElementById(
                    "dialog_settings_object_trailer_assign_id"
                ).value = ""),
                (document.getElementById("dialog_settings_object_trailer_model").value =
                    ""),
                (document.getElementById("dialog_settings_object_trailer_vin").value =
                    ""),
                (document.getElementById(
                    "dialog_settings_object_trailer_plate_number"
                ).value = ""),
                (document.getElementById("dialog_settings_object_trailer_desc").value =
                    ""),
                $("#dialog_settings_object_trailer_properties").dialog("open");
            break;
        case "cancel":
            $("#dialog_settings_object_trailer_properties").dialog("close");
            break;
        case "save":
            if (!utilsCheckPrivileges("viewer")) return;
            var a = document.getElementById(
                "dialog_settings_object_trailer_name"
            ).value,
                i = document.getElementById(
                    "dialog_settings_object_trailer_assign_id"
                ).value,
                o = document.getElementById(
                    "dialog_settings_object_trailer_model"
                ).value,
                s = document.getElementById("dialog_settings_object_trailer_vin").value,
                n = document.getElementById(
                    "dialog_settings_object_trailer_plate_number"
                ).value,
                l = document.getElementById(
                    "dialog_settings_object_trailer_desc"
                ).value;
            if ("" == a) {
                notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY);
                break;
            }
            var d = {
                cmd: "save_object_trailer",
                trailer_id: settingsEditData.trailer_id,
                trailer_name: a,
                trailer_assign_id: i,
                trailer_model: o,
                trailer_vin: s,
                trailer_plate_number: n,
                trailer_desc: l,
            };
            $.ajax({
                type: "POST",
                url: "func/fn_settings.trailers.php",
                data: d,
                cache: !1,
                success: function (e) {
                    "OK" == e &&
                        (settingsReloadObjectTrailers(),
                            $("#dialog_settings_object_trailer_properties").dialog("close"),
                            notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
                },
            });
    }
}

(placesRouteData.routes = new Array()),
    (placesRouteData.new_route_id = 1),
    (placesRouteData.edit_route_id = !1),
    (placesRouteData.edit_route_layer = !1),
    (placesRouteData.edit_start_label_layer = !1),
    (placesRouteData.edit_end_label_layer = !1);
var settingsEditData = new Array(),
    settingsUserData = new Array(),
    settingsObjectData = new Array(),
    settingsObjectGroupData = new Array(),
    settingsObjectDriverData = new Array(),
    settingsObjectTrailerData = new Array(),
    settingsEventData = new Array(),
    settingsTemplateData = new Array(),
    settingsKMLData = new Array(),
    settingsSubaccountData = new Array();





function notifyCheck(e) {
    switch (e) {
        case "expiring_objects":
            if (1 == gsValues.notify_obj_expire)
                for (var t in settingsObjectData)
                    if (
                        "true" == (a = settingsObjectData[t]).active &&
                        "true" == a.object_expire &&
                        getDateDifference(new Date(a.object_expire_dt), new Date()) <=
                        gsValues.notify_obj_expire_period
                    ) {
                        notifyBox(
                            "error",
                            la.EXPIRING_OBJECTS,
                            sprintf(
                                la.SOME_OF_YOUR_OBJECTS_ACTIVATION_WILL_EXPIRE_SOON,
                                "settingsOpen();"
                            )
                        );
                        break;
                    }
            break;
        case "inactive_objects":
            if (1 == gsValues.notify_obj_expire)
                for (var t in settingsObjectData) {
                    var a = settingsObjectData[t];
                    if ("false" == a.active) {
                        notifyBox(
                            "error",
                            la.INACTIVE_OBJECTS,
                            sprintf(
                                la.THERE_ARE_INACTIVE_OBJECTS_IN_YOUR_ACCOUNT,
                                "settingsOpen();"
                            )
                        );
                        break;
                    }
                }
            break;
        case "session_check":
            if (0 == gsValues.session_check) break;
            clearTimeout(timer_sessionCheck);
            var o = {
                cmd: "session_check",
            };
            $.ajax({
                type: "POST",
                url: "func/fn_connect.php",
                data: o,
                cache: false,
                error: function (e, t) {
                    timer_sessionCheck = setTimeout(
                        "notifyCheck('session_check');",
                        1e3 * gsValues.session_check
                    );
                },
                success: function (res) {
                    "false" == res
                        ? $("#blocking_panel").show()
                        : (timer_sessionCheck = setTimeout(
                            "notifyCheck('session_check');",
                            1e3 * gsValues.session_check
                        ));
                },
            });
    }
}

// function addPopupToMap(e, t, a, o, i) {
//     if ("" != i && o != i) {
//         if (1 == gsValues.map_popup_detailed) var s = 'style="display:none;"',
//             n = "";
//         else var s = "",
//             n = 'style="display:none;"';
//         o = '<div id="popup_short" ' + s + ">" + o, o += '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="switchPopupDetailed(true)">' + la.DETAILED + "</a></div>", o += "</div>", o += '<div id="popup_detailed" ' + n + ">" + i, o += '<div style="width:100%; text-align: right;"><a href="#" class="" onClick="switchPopupDetailed(false)">' + la.SHORT + "</a></div>", o += "</div>"
//     }
//     mapPopup = L.popup({
//         offset: a
//     }).setLatLng([e, t]).setContent(o).openOn(map)
// }

function switchPopupDetailed(e) {
    switch (e) {
        case false:
            (document.getElementById("popup_short").style.display = ""),
                (document.getElementById("popup_detailed").style.display = "none"),
                (gsValues.map_popup_detailed = false);
            break;
        case true:
            (document.getElementById("popup_short").style.display = "none"),
                (document.getElementById("popup_detailed").style.display = ""),
                (gsValues.map_popup_detailed = true);
    }
}

function destroyMapPopup() {
    map.closePopup();
}

function settingsCheck() {
    document.getElementById("settings_main_dst").checked
        ? ((document.getElementById("settings_main_dst_start_mmdd").disabled = !1),
            (document.getElementById("settings_main_dst_start_hhmm").disabled = !1),
            (document.getElementById("settings_main_dst_end_mmdd").disabled = !1),
            (document.getElementById("settings_main_dst_end_hhmm").disabled = !1))
        : ((document.getElementById("settings_main_dst_start_mmdd").disabled = !0),
            (document.getElementById("settings_main_dst_start_hhmm").disabled = !0),
            (document.getElementById("settings_main_dst_end_mmdd").disabled = !0),
            (document.getElementById("settings_main_dst_end_hhmm").disabled = !0));
}


// function loadSettings(e, t) {
//     switch (e) {
//         case "cookies":
//             var a = getCookie("gs_dragbars");
//             null == a &&
//                 (a =
//                     guiDragbars.objects +
//                     ";" +
//                     guiDragbars.events +
//                     ";" +
//                     guiDragbars.history +
//                     ";" +
//                     guiDragbars.bottom_panel),
//                 null != (a = a.split(";"))[0] &&
//                 "" != a[0] &&
//                 (guiDragbars.objects = a[0]),
//                 null != a[1] && "" != a[1] && (guiDragbars.events = a[1]),
//                 null != a[2] && "" != a[2] && (guiDragbars.history = a[2]),
//                 null != a[3] && "" != a[3] && (guiDragbars.bottom_panel = a[3]);
//             var i = getCookie("gs_map");
//             null == i &&
//                 ((i =
//                     gsValues.map_lat +
//                     ";" +
//                     gsValues.map_lng +
//                     ";" +
//                     gsValues.map_zoom +
//                     ";" +
//                     gsValues.map_layer +
//                     ";"),
//                     (i +=
//                         gsValues.map_objects +
//                         ";" +
//                         gsValues.map_object_labels +
//                         ";" +
//                         gsValues.map_markers +
//                         ";" +
//                         gsValues.map_routes +
//                         ";" +
//                         gsValues.map_zones +
//                         ";" +
//                         gsValues.map_clusters +
//                         ";" +
//                         gsValues.map_kml)),
//                 (i = i.split(";")),
//                 "last" == settingsUserData.map_sp &&
//                 (null != i[0] && "" != i[0] && (gsValues.map_lat = i[0]),
//                     null != i[1] && "" != i[1] && (gsValues.map_lng = i[1]),
//                     null != i[2] && "" != i[2] && (gsValues.map_zoom = i[2])),
//                 null != i[3] && "" != i[3] && (gsValues.map_layer = i[3]),
//                 null != i[4] &&
//                 "" != i[4] &&
//                 (gsValues.map_objects = strToBoolean(i[4])),
//                 null != i[5] &&
//                 "" != i[5] &&
//                 (gsValues.map_object_labels = strToBoolean(i[5])),
//                 null != i[6] &&
//                 "" != i[6] &&
//                 (gsValues.map_markers = strToBoolean(i[6])),
//                 null != i[7] &&
//                 "" != i[7] &&
//                 (gsValues.map_routes = strToBoolean(i[7])),
//                 null != i[8] && "" != i[8] && (gsValues.map_zones = strToBoolean(i[8])),
//                 null != i[9] &&
//                 "" != i[9] &&
//                 (gsValues.map_clusters = strToBoolean(i[9])),
//                 null != i[10] &&
//                 "" != i[10] &&
//                 (gsValues.map_kml = strToBoolean(i[10])),
//                 t(!0);
//             break;
//         case "server":
//             var o = {
//                 cmd: "load_server_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (gsValues.url_root = e.url_root),
//                         (gsValues.map_custom = e.map_custom),
//                         (gsValues.map_osm = strToBoolean(e.map_osm)),
//                         (gsValues.map_bing = strToBoolean(e.map_bing)),
//                         (gsValues.map_google = strToBoolean(e.map_google)),
//                         (gsValues.map_google_street_view = strToBoolean(
//                             e.map_google_street_view
//                         )),
//                         (gsValues.map_google_traffic = strToBoolean(e.map_google_traffic)),
//                         (gsValues.map_mapbox = strToBoolean(e.map_mapbox)),
//                         (gsValues.map_arcgis = strToBoolean(e.map_arcgis)),
//                         (gsValues.map_yandex = strToBoolean(e.map_yandex)),
//                         (gsValues.map_bing_key = e.map_bing_key),
//                         (gsValues.map_mapbox_key = e.map_mapbox_key),
//                         (gsValues.map_arcgis_key = e.map_arcgis_key),
//                         (gsValues.routing_osmr_service_url = e.routing_osmr_service_url),
//                         (gsValues.map_layer = e.map_layer),
//                         (gsValues.map_zoom = e.map_zoom),
//                         (gsValues.map_lat = e.map_lat),
//                         (gsValues.map_lng = e.map_lng),
//                         (gsValues.address_display_object_data_list = strToBoolean(
//                             e.address_display_object_data_list
//                         )),
//                         (gsValues.address_display_event_data_list = strToBoolean(
//                             e.address_display_event_data_list
//                         )),
//                         (gsValues.address_display_history_route_data_list = strToBoolean(
//                             e.address_display_history_route_data_list
//                         )),
//                         (gsValues.notify_obj_expire = strToBoolean(e.notify_obj_expire)),
//                         (gsValues.notify_obj_expire_period = e.notify_obj_expire_period),
//                         (gsValues.notify_account_expire = strToBoolean(
//                             e.notify_account_expire
//                         )),
//                         (gsValues.notify_account_expire_period =
//                             e.notify_account_expire_period),
//                         (gsValues.sim_number = strToBoolean(e.sim_number)),
//                         (gsValues.object_control_default_templates = strToBoolean(
//                             e.object_control_default_templates
//                         )),
//                         t(!0);
//                 },
//             });
//             break;
//         case "user":
//             o = {
//                 cmd: "load_user_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     e.privileges == 'subuser' ? settingsUserData.language = e.language : settingsUserData = e;
//                     "subuser" != (settingsUserData = e).privileges &&
//                         ((document.getElementById("settings_main_sms_gateway").checked =
//                             strToBoolean(settingsUserData.sms_gateway)),
//                             "" == settingsUserData.sms_gateway_type &&
//                             (settingsUserData.sms_gateway_type = "app"),
//                             (document.getElementById("settings_main_sms_gateway_type").value =
//                                 settingsUserData.sms_gateway_type),
//                             (document.getElementById("settings_main_sms_gateway_url").value =
//                                 settingsUserData.sms_gateway_url),
//                             (document.getElementById(
//                                 "settings_main_sms_gateway_identifier"
//                             ).value = settingsUserData.sms_gateway_identifier),
//                             (document.getElementById(
//                                 "settings_main_sms_gateway_total_in_queue"
//                             ).innerHTML = settingsUserData.sms_gateway_total_in_queue),
//                             settingsSMSGatewaySwitchType()),
//                         (document.getElementById(
//                             "settings_main_push_notify_desktop"
//                         ).checked = strToBoolean(settingsUserData.push_notify_desktop)),
//                         "" == settingsUserData.chat_notify &&
//                         (settingsUserData.chat_notify = "alarm1.mp3"),
//                         (document.getElementById(
//                             "settings_main_chat_notify_sound_file"
//                         ).value = settingsUserData.chat_notify),
//                         (document.getElementById(
//                             "settings_main_dashboard_open_after_login"
//                         ).checked = settingsUserData.dashboard.open_after_login),
//                         (document.getElementById(
//                             "settings_main_map_startup_possition"
//                         ).value = settingsUserData.map_sp),
//                         (document.getElementById("settings_main_map_icon_size").value =
//                             settingsUserData.map_is),
//                         (document.getElementById(
//                             "settings_main_history_route_color"
//                         ).value = settingsUserData.map_rc.substr(1)),
//                         (document.getElementById(
//                             "settings_main_history_route_color"
//                         ).style.backgroundColor = settingsUserData.map_rc),
//                         (document.getElementById(
//                             "settings_main_history_route_highlight_color"
//                         ).value = settingsUserData.map_rhc.substr(1)),
//                         (document.getElementById(
//                             "settings_main_history_route_highlight_color"
//                         ).style.backgroundColor = settingsUserData.map_rhc),
//                         (document.getElementById(
//                             "settings_main_map_object_cluster_popup"
//                         ).checked = strToBoolean(settingsUserData.map_ocp)),
//                         (document.getElementById(
//                             "settings_main_groups_collapsed_objects"
//                         ).checked = settingsUserData.groups_collapsed.objects),
//                         (document.getElementById(
//                             "settings_main_groups_collapsed_markers"
//                         ).checked = settingsUserData.groups_collapsed.markers),
//                         (document.getElementById(
//                             "settings_main_groups_collapsed_routes"
//                         ).checked = settingsUserData.groups_collapsed.routes),
//                         (document.getElementById(
//                             "settings_main_groups_collapsed_zones"
//                         ).checked = settingsUserData.groups_collapsed.zones),
//                         (document.getElementById("settings_main_od").value =
//                             settingsUserData.od);
//                     settingsUserData.ohc;
//                     (document.getElementById("settings_main_ohc_no_connection").checked =
//                         settingsUserData.ohc.no_connection),
//                         (document.getElementById(
//                             "settings_main_ohc_no_connection_color"
//                         ).value = settingsUserData.ohc.no_connection_color.substr(1)),
//                         (document.getElementById(
//                             "settings_main_ohc_no_connection_color"
//                         ).style.backgroundColor = settingsUserData.ohc.no_connection_color),
//                         (document.getElementById("settings_main_datalist_position").value =
//                             settingsUserData.datalist);
//                     var a = document.getElementById("settings_main_datalist_items");
//                     if (0 != a) {
//                         var i = settingsUserData.datalist_items.split(",");
//                         multiselectSetValues(a, i);
//                     }
//                     if (
//                         ((document.getElementById("settings_main_ohc_stopped").checked =
//                             settingsUserData.ohc.stopped),
//                             (document.getElementById("settings_main_ohc_stopped_color").value =
//                                 settingsUserData.ohc.stopped_color.substr(1)),
//                             (document.getElementById(
//                                 "settings_main_ohc_stopped_color"
//                             ).style.backgroundColor = settingsUserData.ohc.stopped_color),
//                             (document.getElementById("settings_main_ohc_moving").checked =
//                                 settingsUserData.ohc.moving),
//                             (document.getElementById("settings_main_ohc_moving_color").value =
//                                 settingsUserData.ohc.moving_color.substr(1)),
//                             (document.getElementById(
//                                 "settings_main_ohc_moving_color"
//                             ).style.backgroundColor = settingsUserData.ohc.moving_color),
//                             (document.getElementById("settings_main_ohc_engine_idle").checked =
//                                 settingsUserData.ohc.engine_idle),
//                             (document.getElementById(
//                                 "settings_main_ohc_engine_idle_color"
//                             ).value = settingsUserData.ohc.engine_idle_color.substr(1)),
//                             (document.getElementById(
//                                 "settings_main_ohc_engine_idle_color"
//                             ).style.backgroundColor = settingsUserData.ohc.engine_idle_color),
//                             (document.getElementById("settings_main_language").value =
//                                 settingsUserData.language),
//                             (document.getElementById("system_language")?.value =
//                                 settingsUserData.language),
//                             (document.getElementById("settings_main_distance_unit").value =
//                                 settingsUserData.unit_distance),
//                             (document.getElementById("settings_main_capacity_unit").value =
//                                 settingsUserData.unit_capacity),
//                             (document.getElementById("settings_main_temperature_unit").value =
//                                 settingsUserData.unit_temperature),
//                             (document.getElementById("settings_main_currency").value =
//                                 settingsUserData.currency),
//                             (document.getElementById("settings_main_timezone").value =
//                                 settingsUserData.timezone),
//                             11 == settingsUserData.dst_start.length &&
//                             11 == settingsUserData.dst_end.length)
//                     ) {
//                         document.getElementById("settings_main_dst").checked = strToBoolean(
//                             settingsUserData.dst
//                         );
//                         var o = settingsUserData.dst_start.split(" ");
//                         (document.getElementById("settings_main_dst_start_mmdd").value =
//                             o[0]),
//                             (document.getElementById("settings_main_dst_start_hhmm").value =
//                                 o[1]);
//                         var s = settingsUserData.dst_end.split(" ");
//                         (document.getElementById("settings_main_dst_end_mmdd").value =
//                             s[0]),
//                             (document.getElementById("settings_main_dst_end_hhmm").value =
//                                 s[1]);
//                     } else
//                         (document.getElementById("settings_main_dst").checked = !1),
//                             (document.getElementById("settings_main_dst_start_mmdd").value =
//                                 ""),
//                             (document.getElementById("settings_main_dst_start_hhmm").value =
//                                 "00:00"),
//                             (document.getElementById("settings_main_dst_end_mmdd").value =
//                                 ""),
//                             (document.getElementById("settings_main_dst_end_hhmm").value =
//                                 "00:00");
//                     var n = settingsUserData.info;
//                     (document.getElementById("settings_main_name_surname").value =
//                         n.name),
//                         (document.getElementById("settings_main_company").value =
//                             n.company),
//                         (document.getElementById("settings_main_address").value =
//                             n.address),
//                         (document.getElementById("settings_main_post_code").value =
//                             n.post_code),
//                         (document.getElementById("settings_main_city").value = n.city),
//                         (document.getElementById("settings_main_country").value =
//                             n.country),
//                         (document.getElementById("settings_main_phone1").value = n.phone1),
//                         (document.getElementById("settings_main_phone2").value = n.phone2),
//                         (document.getElementById("settings_main_email").value = n.email),
//                         (document.getElementById("settings_main_old_password").value = ""),
//                         (document.getElementById("settings_main_new_password").value = ""),
//                         (document.getElementById("settings_main_new_password_rep").value =
//                             ""),
//                         (document.getElementById(
//                             "settings_main_usage_email_daily"
//                         ).innerHTML =
//                             settingsUserData.usage_email_daily_cnt +
//                             "/" +
//                             settingsUserData.usage_email_daily),
//                         (document.getElementById(
//                             "settings_main_usage_sms_daily"
//                         ).innerHTML =
//                             settingsUserData.usage_sms_daily_cnt +
//                             "/" +
//                             settingsUserData.usage_sms_daily),
//                         (document.getElementById(
//                             "settings_main_usage_webhook_daily"
//                         ).innerHTML =
//                             settingsUserData.usage_webhook_daily_cnt +
//                             "/" +
//                             settingsUserData.usage_webhook_daily),
//                         (document.getElementById(
//                             "settings_main_usage_api_daily"
//                         ).innerHTML =
//                             settingsUserData.usage_api_daily_cnt +
//                             "/" +
//                             settingsUserData.usage_api_daily),
//                         settingsCheck(),
//                         t(!0);
//                 },
//             });
//             break;
//         case "objects":
//             o = {
//                 cmd: "load_object_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.objects.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     // console.log(e)
//                     for (var a in ((e = transformsToSettingsObjectData(e)),
//                         console.log('transformed', e),
//                         (settingsObjectData = e),
//                         (settingsEditData.sensor_id = !1),
//                         settingsObjectData)) {
//                         var i = settingsObjectData[a];
//                         null == settingsObjectGroupData[i.group_id] &&
//                             (settingsObjectData[a].group_id = "0");
//                     }
//                     initSelectList("group_object_list"),
//                         initSelectList("events_object_list"),
//                         initSelectList("subaccounts_object_list"),
//                         initSelectList("history_object_list"),
//                         initSelectList("report_object_list"),
//                         initSelectList("tasks_object_list"),
//                         initSelectList("task_object_list"),
//                         initSelectList("rilogbook_object_list"),
//                         initSelectList("dtc_object_list"),
//                         initSelectList("cmd_gprs_object_list"),
//                         // initSelectList("cmd_sms_object_list"),
//                         initSelectList("image_gallery_object_list"),
//                         initSelectList("maintenance_object_list"),
//                         initSelectList("expense_object_list"),
//                         initSelectList("share_position_object_list"),
//                         loadObjectMapMarkerIcons(),
//                         t(!0);
//                 },
//             });
//             break;
//         case "object_groups":
//             o = {
//                 cmd: "load_object_group_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.groups.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsObjectGroupData = e),
//                         (settingsEditData.group_id = !1),
//                         initSelectList("object_group_list"),
//                         t(!0);
//                 },
//             });
//             break;
//         case "object_drivers":
//             o = {
//                 cmd: "load_object_driver_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.drivers.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsObjectDriverData = e),
//                         (settingsEditData.driver_id = !1),
//                         initSelectList("object_driver_list"),
//                         t(!0);
//                 },
//             });
//             break;
//         case "object_trailers":
//             o = {
//                 cmd: "load_object_trailer_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.trailers.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsObjectTrailerData = e),
//                         (settingsEditData.trailer_id = !1),
//                         initSelectList("object_trailer_list"),
//                         t(!0);
//                 },
//             });
//             break;
//         case "events":
//             o = {
//                 cmd: "load_event_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.events.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsEventData = e), (settingsEditData.event_id = !1), t(!0);
//                 },
//             });
//             break;
//         case "templates":
//             o = {
//                 cmd: "load_template_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.templates.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsTemplateData = e),
//                         (settingsEditData.template_id = !1),
//                         initSelectList("email_sms_template_list"),
//                         t(!0);
//                 },
//             });
//             break;
//         case "kml":
//             o = {
//                 cmd: "load_kml_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.kml.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsKMLData = e), (settingsEditData.kml_id = !1), t(!0);
//                 },
//             });
//             break;
//         case "subaccounts":
//             o = {
//                 cmd: "load_subaccount_data",
//             };
//             $.ajax({
//                 type: "POST",
//                 url: "func/fn_settings.subaccounts.php",
//                 data: o,
//                 dataType: "json",
//                 cache: !1,
//                 success: function (e) {
//                     (settingsSubaccountData = e),
//                         (settingsEditData.subaccount_id = !1),
//                         t(!0);
//                 },
//             });
//     }
// }
function geocoderGetAddress(lat, lng, response) {
    // console.log(lat, lng, response);
    var path = "tools/gc_post.php";

    if (isMobileVersion() || isObjectFollow()) {
        var path = "../" + path;
    } else if (isSharePosition()) {
        var path = "../../" + path;
    }

    var data = {
        cmd: "latlng",
        lat: lat,
        lng: lng,
    };

    $.ajax({
        type: "POST",
        url: path,
        data: data,
        dataType: "json",
        cache: false,
        success: function (result) {
            // console.log(result);
            if (result === null) {
                response("");
            } else {
                response(result);
            }
        },
    });
}


function showBottomPanel(e) {
    // console.log('lsdkfsd')
    document.getElementById("bottom_panel").style.display = "block";
    void 0 === e && (e = true),
      (document.getElementById("bottom_panel").style.display = "block"),
      guiDragbars.bottom_panel < 178 && (guiDragbars.bottom_panel = 178),
      guiDragbars.bottom_panel > window.innerHeight / 2 &&
        (guiDragbars.bottom_panel = window.innerHeight / 2),
      $("#bottom_panel").css("height", guiDragbars.bottom_panel),
      (document.getElementById("map").style.bottom =
        parseInt(guiDragbars.bottom_panel) + 5 + "px"),
      (document.getElementById("bottom_panel_dragbar").style.bottom =
        guiDragbars.bottom_panel + "px"),
      $("#bottom_panel_msg_list_grid").setGridHeight(
        guiDragbars.bottom_panel - 99
      ),
      $("#bottom_panel_graph_plot").css("height", guiDragbars.bottom_panel - 75),
      $("#bottom_panel_dragbar").css("cursor", "row-resize"),
      (document.getElementById("street_view_control").style.bottom =
        parseInt(guiDragbars.bottom_panel) + 16 + "px"),
      1 == e && map.invalidateSize(true);
  }

  

////////////////////////////////////////////////////////////////////////////////




function cmdReset() {
    (document.getElementById("cmd_gprs_template_list").value = ""),
      (document.getElementById("cmd_gateway").value = "gprs"),
      $("#cmd_gateway").multipleSelect("refresh"),
      (document.getElementById("cmd_gprs_cmd_type").value = "ascii"),
      $("#cmd_gprs_cmd_type").multipleSelect("refresh"),
      (document.getElementById("cmd_gprs_cmd").value = "");
  }
  
  function cmdSend() {
    var e = document.getElementById("cmd_gprs_object_list").value,
      t = $("#cmd_gprs_template_list :selected").text(),
      a = document.getElementById("cmd_gateway").value,
      o = document.getElementById("cmd_gprs_cmd_type").value,
      i = document.getElementById("cmd_gprs_cmd").value;
    cmdCheck() && cmdGPRSExec(e, t, a, o, i);
  }
  
  function cmdCheck() {
    var e = document.getElementById("cmd_gprs_object_list").value,
      t = document.getElementById("cmd_gateway").value,
      a = document.getElementById("cmd_gprs_cmd_type").value,
      o = document.getElementById("cmd_gprs_cmd").value;
    return (
      "" != e &&
      ("" == o
        ? (notifyBox("error", la.ERROR, la.COMMAND_CANT_BE_EMPTY, true), false)
        : "sms" == t && "" == settingsObjectData[e].sim_number
        ? (notifyBox(
            "error",
            la.ERROR,
            la.OBJECT_SIM_CARD_NUMBER_IS_NOT_SET,
            true
          ),
          false)
        : !(
            "hex" == a &&
            ((o = o.toUpperCase()), !isHexValid(o.replace("%IMEI%", "")))
          ) ||
          (notifyBox("error", la.ERROR, la.COMMAND_HEX_NOT_VALID, true), false))
    );
  }
  
//   function cmdExec(e, t, a, o, i) {
//     if (utilsCheckPrivileges("viewer")) {
//       var s = settingsObjectData[e].sim_number;
//       "hex" == o && (i = i.toUpperCase()), loadingData(true);
//       var n = {
//         cmd: "exec_cmd",
//         imei: e,
//         name: t,
//         gateway: a,
//         sim_number: s,
//         type: o,
//         cmd_: i,
//       };
//       $.ajax({
//         type: "POST",
//         url: "func/fn_cmd.php",
//         data: n,
//         success: function (res) {
//           loadingData(false),
//             "OK" == res
//               ? (cmdReset(),
//                 $("#cmd_gprs_status_list_grid").trigger("reloadGrid"),
//                 notifyBox(
//                   "info",
//                   la.INFORMATION,
//                   la.COMMAND_SENT_FOR_EXECUTION,
//                   true
//                 ))
//               : "ERROR_NOT_SENT" == res &&
//                 ($("#cmd_gprs_status_list_grid").trigger("reloadGrid"),
//                 notifyBox(
//                   "error",
//                   la.ERROR,
//                   la.UNABLE_TO_SEND_SMS_MESSAGE,
//                   true
//                 ));
//         },
//         error: function (e, t) {
//           loadingData(false);
//         },
//       });
//     }
//   }
  
  function cmdExecDelete(e) {
    utilsCheckPrivileges("viewer") &&
      confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
        if (t) {
          var a = {
            cmd: "delete_cmd_exec",
            cmd_id: e,
          };
          $.ajax({
            type: "POST",
            url: "func/fn_cmd.php",
            data: a,
            success: function (res) {
              "OK" == res && $("#cmd_gprs_status_list_grid").trigger("reloadGrid");
            },
          });
        }
      });
  }
  
  function cmdExecDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
      var e = $("#cmd_gprs_status_list_grid").jqGrid("getGridParam", "selarrrow");
      "" != e
        ? confirmDialog(
            la.ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS,
            function (t) {
              if (t) {
                var a = {
                  cmd: "delete_selected_cmd_execs",
                  items: e,
                };
                $.ajax({
                  type: "POST",
                  url: "func/fn_cmd.php",
                  data: a,
                  success: function (res) {
                    "OK" == res &&
                      $("#cmd_gprs_status_list_grid").trigger("reloadGrid");
                  },
                });
              }
            }
          )
        : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
  }
  
  function cmdTemplateSwitch() {
    var e = document.getElementById("cmd_gprs_template_list").value;
    "" != e
      ? ((document.getElementById("cmd_gateway").value =
          cmdData.cmd_templates[e].gateway),
        (document.getElementById("cmd_gprs_cmd_type").value =
          cmdData.cmd_templates[e].type),
        (document.getElementById("cmd_gprs_cmd").value = cmdData.cmd_templates[e].cmd))
      : ((document.getElementById("cmd_gateway").value = "gprs"),
        (document.getElementById("cmd_gprs_cmd_type").value = "ascii"),
        (document.getElementById("cmd_gprs_cmd").value = "")),
      $("#cmd_gateway").multipleSelect("refresh"),
      $("#cmd_gprs_cmd_type").multipleSelect("refresh");
  }
  
  function cmdTemplateList() {
    var e = document.getElementById("cmd_gprs_object_list").value;
    if (void 0 != settingsObjectData[e]) {
      var t = settingsObjectData[e].protocol,
        a = document.getElementById("cmd_gprs_template_list");
      a.options.length = 0;
      for (var o in cmdData.cmd_templates) {
        var i = cmdData.cmd_templates[o];
        i.protocol.toLowerCase() == t.toLowerCase()
          ? a.options.add(new Option(i.name, o))
          : "" == i.protocol.toLowerCase() &&
            a.options.add(new Option(i.name, o));
      }
      sortSelectList(a), a.options.add(new Option(la.CUSTOM, ""), 0);
    }
    cmdGPRSReset();
  }
  
  function cmdScheduleProtocolList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
      t = document.getElementById("dialog_cmd_schedule_protocol");
    t.options.length = 0;
    for (var a = getAllProtocolsArray(), o = 0; o < a.length; o++)
      "" != a[o] && t.options.add(new Option(a[o], a[o]));
    sortSelectList(t),
      t.options.add(new Option(la.ALL_PROTOCOLS, ""), 0),
      (document.getElementById("dialog_cmd_schedule_protocol").value = e),
      $("#dialog_cmd_schedule_protocol").multipleSelect("refresh");
  }
  
  function cmdScheduleObjectList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
      t = document.getElementById("dialog_cmd_schedule_object_list");
    multiselectClear(t);
    var a = getGroupsObjectsArray(e);
    multiselectSetGroups(t, a);
  }
  
  function cmdScheduleTemplateList() {
    var e = document.getElementById("dialog_cmd_schedule_protocol").value,
      t = document.getElementById("dialog_cmd_schedule_template_list");
    t.options.length = 0;
    for (var a in cmdData.cmd_templates) {
      var o = cmdData.cmd_templates[a];
      "" == e
        ? t.options.add(new Option(o.name, a))
        : o.protocol.toLowerCase() == e.toLowerCase() &&
          t.options.add(new Option(o.name, a));
    }
    sortSelectList(t),
      t.options.add(new Option(la.CUSTOM, ""), 0),
      (document.getElementById("dialog_cmd_schedule_template_list").value = ""),
      $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_cmd_gateway").value = "gprs"),
      $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_cmd_type").value = "ascii"),
      $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = "");
  }
  
  function cmdScheduleSwitchExactTime() {
    1 == document.getElementById("dialog_cmd_schedule_exact_time").checked
      ? ((document.getElementById(
          "dialog_cmd_schedule_exact_time_date"
        ).enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_exact_time_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_mon").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_mon_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_tue").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_tue_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_wed").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_wed_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_thu").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_thu_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_fri").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_fri_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_sat").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_sat_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_sun").enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_daily_sun_time"
        ).enable = true))
      : ((document.getElementById(
          "dialog_cmd_schedule_exact_time_date"
        ).enable = true),
        (document.getElementById(
          "dialog_cmd_schedule_exact_time_time"
        ).enable = true),
        (document.getElementById("dialog_cmd_schedule_daily_mon").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_mon_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_tue").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_tue_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_wed").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_wed_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_thu").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_thu_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_fri").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_fri_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_sat").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_sat_time"
        ).enable = false),
        (document.getElementById("dialog_cmd_schedule_daily_sun").enable = false),
        (document.getElementById(
          "dialog_cmd_schedule_daily_sun_time"
        ).enable = false));
  }
  
  function cmdScheduleSwitchProtocol() {
    cmdScheduleObjectList(), cmdScheduleTemplateList();
  }
  
  function cmdScheduleTemplateSwitch() {
    var e = document.getElementById("dialog_cmd_schedule_template_list").value;
    "" != e
      ? ((document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
          cmdData.cmd_templates[e].gateway),
        (document.getElementById("dialog_cmd_schedule_cmd_type").value =
          cmdData.cmd_templates[e].type),
        (document.getElementById("dialog_cmd_schedule_cmd_cmd").value =
          cmdData.cmd_templates[e].cmd))
      : ((document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
          "gprs"),
        (document.getElementById("dialog_cmd_schedule_cmd_type").value = "ascii"),
        (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = "")),
      $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
      $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh");
  }
  
  function cmdScheduleResetDailyTime() {
    (document.getElementById("dialog_cmd_schedule_daily_mon").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_mon_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_mon_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_tue").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_tue_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_tue_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_wed").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_wed_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_wed_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_thu").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_thu_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_thu_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_fri").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_fri_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_fri_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_sat").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_sat_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_sat_time").multipleSelect("refresh"),
      (document.getElementById("dialog_cmd_schedule_daily_sun").checked = false),
      (document.getElementById("dialog_cmd_schedule_daily_sun_time").value =
        "00:00"),
      $("#dialog_cmd_schedule_daily_sun_time").multipleSelect("refresh");
  }
  
  function cmdScheduleProperties(e) {
    switch (e) {
      default:
        var t = e;
        cmdData.edit_cmd_schedule_id = t;
        u = {
          cmd: "load_cmd_schedule",
          cmd_id: cmdData.edit_cmd_schedule_id,
        };
        $.ajax({
          type: "POST",
          url: "func/fn_cmd.php",
          data: u,
          dataType: "json",
          cache: false,
          success: function (res) {
            (document.getElementById("dialog_cmd_schedule_active").checked =
              strToBoolean(res.active)),
              (document.getElementById("dialog_cmd_schedule_name").value =
                res.name);
            var t = strToBoolean(res.exact_time);
            (document.getElementById("dialog_cmd_schedule_exact_time").checked =
              t),
              cmdScheduleSwitchExactTime(),
              1 == t
                ? ((document.getElementById(
                    "dialog_cmd_schedule_exact_time_date"
                  ).value = res.exact_time_dt.substring(0, 10)),
                  (document.getElementById(
                    "dialog_cmd_schedule_exact_time_time"
                  ).value = res.exact_time_dt.substring(11, 16)))
                : ((document.getElementById(
                    "dialog_cmd_schedule_exact_time_date"
                  ).value = ""),
                  (document.getElementById(
                    "dialog_cmd_schedule_exact_time_time"
                  ).value = "00:00")),
              $("#dialog_cmd_schedule_exact_time_time").multipleSelect("refresh");
            var a = res.day_time;
            null != a
              ? ((document.getElementById(
                  "dialog_cmd_schedule_daily_mon"
                ).checked = a.mon),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_mon_time"
                ).value = a.mon_time),
                $("#dialog_cmd_schedule_daily_mon_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_tue"
                ).checked = a.tue),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_tue_time"
                ).value = a.tue_time),
                $("#dialog_cmd_schedule_daily_tue_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_wed"
                ).checked = a.wed),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_wed_time"
                ).value = a.wed_time),
                $("#dialog_cmd_schedule_daily_wed_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_thu"
                ).checked = a.thu),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_thu_time"
                ).value = a.thu_time),
                $("#dialog_cmd_schedule_daily_thu_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_fri"
                ).checked = a.fri),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_fri_time"
                ).value = a.fri_time),
                $("#dialog_cmd_schedule_daily_fri_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_sat"
                ).checked = a.sat),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_sat_time"
                ).value = a.sat_time),
                $("#dialog_cmd_schedule_daily_sat_time").multipleSelect(
                  "refresh"
                ),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_sun"
                ).checked = a.sun),
                (document.getElementById(
                  "dialog_cmd_schedule_daily_sun_time"
                ).value = a.sun_time),
                $("#dialog_cmd_schedule_daily_sun_time").multipleSelect(
                  "refresh"
                ))
              : cmdScheduleResetDailyTime(),
              cmdScheduleProtocolList(),
              (document.getElementById("dialog_cmd_schedule_protocol").value =
                res.protocol),
              $("#dialog_cmd_schedule_protocol").multipleSelect("refresh"),
              cmdScheduleSwitchProtocol();
            var o = document.getElementById("dialog_cmd_schedule_object_list"),
              i = res.imei.split(",");
            multiselectSetValues(o, i),
              $("#dialog_cmd_schedule_object_list").multipleSelect("refresh"),
              (document.getElementById(
                "dialog_cmd_schedule_template_list"
              ).value = ""),
              $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
              (document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
                res.gateway),
              $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
              (document.getElementById("dialog_cmd_schedule_cmd_type").value =
                res.type),
              $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
              (document.getElementById("dialog_cmd_schedule_cmd_cmd").value =
                res.cmd);
          },
        }),
          $("#dialog_cmd_schedule_properties").dialog("open");
        break;
      case "add":
        (cmdData.edit_cmd_schedule_id = false),
          (document.getElementById("dialog_cmd_schedule_active").checked = true),
          (document.getElementById("dialog_cmd_schedule_name").value = ""),
          (document.getElementById(
            "dialog_cmd_schedule_exact_time"
          ).checked = false),
          cmdScheduleSwitchExactTime(),
          (document.getElementById("dialog_cmd_schedule_exact_time_date").value =
            ""),
          (document.getElementById("dialog_cmd_schedule_exact_time_time").value =
            "00:00"),
          $("#dialog_cmd_schedule_exact_time_time").multipleSelect("refresh"),
          cmdScheduleResetDailyTime(),
          cmdScheduleProtocolList(),
          (document.getElementById("dialog_cmd_schedule_protocol").value = ""),
          $("#dialog_cmd_schedule_protocol").multipleSelect("refresh"),
          cmdScheduleSwitchProtocol(),
          (document.getElementById("dialog_cmd_schedule_template_list").value =
            ""),
          $("#dialog_cmd_schedule_template_list").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_schedule_cmd_gateway").value =
            "gprs"),
          $("#dialog_cmd_schedule_cmd_gateway").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_schedule_cmd_type").value =
            "ascii"),
          $("#dialog_cmd_schedule_cmd_type").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_schedule_cmd_cmd").value = ""),
          $("#dialog_cmd_schedule_properties").dialog("open");
        break;
      case "cancel":
        $("#dialog_cmd_schedule_properties").dialog("close");
        break;
      case "save":
        if (!utilsCheckPrivileges("viewer")) return;
        var a = document.getElementById("dialog_cmd_schedule_name").value;
        if ("" == a)
          return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY, true);
        var o = document.getElementById("dialog_cmd_schedule_active").checked,
          i = document.getElementById("dialog_cmd_schedule_exact_time").checked,
          s = document.getElementById(
            "dialog_cmd_schedule_exact_time_date"
          ).value,
          n = document.getElementById(
            "dialog_cmd_schedule_exact_time_time"
          ).value;
        if (1 == i) {
          if ("" == s)
            return void notifyBox("error", la.ERROR, la.DATE_CANT_BE_EMPTY, true);
          l = s + " " + n + ":00";
        } else var l = "";
        var r = {
          mon: document.getElementById("dialog_cmd_schedule_daily_mon").checked,
          mon_time: document.getElementById("dialog_cmd_schedule_daily_mon_time")
            .value,
          tue: document.getElementById("dialog_cmd_schedule_daily_tue").checked,
          tue_time: document.getElementById("dialog_cmd_schedule_daily_tue_time")
            .value,
          wed: document.getElementById("dialog_cmd_schedule_daily_wed").checked,
          wed_time: document.getElementById("dialog_cmd_schedule_daily_wed_time")
            .value,
          thu: document.getElementById("dialog_cmd_schedule_daily_thu").checked,
          thu_time: document.getElementById("dialog_cmd_schedule_daily_thu_time")
            .value,
          fri: document.getElementById("dialog_cmd_schedule_daily_fri").checked,
          fri_time: document.getElementById("dialog_cmd_schedule_daily_fri_time")
            .value,
          sat: document.getElementById("dialog_cmd_schedule_daily_sat").checked,
          sat_time: document.getElementById("dialog_cmd_schedule_daily_sat_time")
            .value,
          sun: document.getElementById("dialog_cmd_schedule_daily_sun").checked,
          sun_time: document.getElementById("dialog_cmd_schedule_daily_sun_time")
            .value,
        };
        r = JSON.stringify(r);
        var d = document.getElementById("dialog_cmd_schedule_protocol").value,
          _ = document.getElementById("dialog_cmd_schedule_object_list");
        if (!multiselectIsSelected(_))
          return void notifyBox(
            "error",
            la.ERROR,
            la.AT_LEAST_ONE_OBJECT_SELECTED
          );
        _ = multiselectGetValues(_);
        var c = document.getElementById("dialog_cmd_schedule_cmd_gateway").value,
          g = document.getElementById("dialog_cmd_schedule_cmd_type").value,
          m = document.getElementById("dialog_cmd_schedule_cmd_cmd").value;
        if ("" == m)
          return void notifyBox(
            "error",
            la.ERROR,
            la.COMMAND_CANT_BE_EMPTY,
            true
          );
        if (
          "hex" == g &&
          ((m = m.toUpperCase()), !isHexValid(m.replace("%IMEI%", "")))
        )
          return void notifyBox(
            "error",
            la.ERROR,
            la.COMMAND_HEX_NOT_VALID,
            true
          );
        var u = {
          cmd: "save_cmd_schedule",
          cmd_id: cmdData.edit_cmd_schedule_id,
          name: a,
          active: o,
          exact_time: i,
          exact_time_dt: l,
          day_time: r,
          protocol: d,
          imei: _,
          gateway: c,
          type: g,
          cmd_: m,
        };
        $.ajax({
          type: "POST",
          url: "func/fn_cmd.php",
          data: u,
          cache: false,
          success: function (res) {
            "OK" == res &&
              ($("#cmd_gprs_schedule_list_grid").trigger("reloadGrid"),
              $("#dialog_cmd_schedule_properties").dialog("close"),
              notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
          },
        });
    }
  }
  
  function cmdScheduleDelete(e) {
    utilsCheckPrivileges("viewer") &&
      confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
        if (t) {
          var a = {
            cmd: "delete_cmd_schedule",
            cmd_id: e,
          };
          $.ajax({
            type: "POST",
            url: "func/fn_cmd.php",
            data: a,
            success: function (res) {
              "OK" == res && $("#cmd_gprs_schedule_list_grid").trigger("reloadGrid");
            },
          });
        }
      });
  }
  
  function cmdScheduleDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
      var e = $("#cmd_gprs_schedule_list_grid").jqGrid("getGridParam", "selarrrow");
      "" != e
        ? confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
              var a = {
                cmd: "delete_selected_cmd_schedules",
                items: e,
              };
              $.ajax({
                type: "POST",
                url: "func/fn_cmd.php",
                data: a,
                success: function (res) {
                  "OK" == res &&
                    $("#cmd_gprs_schedule_list_grid").trigger("reloadGrid");
                },
              });
            }
          })
        : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
  }
  
  function cmdTemplateReload() {
    cmdTemplateLoadData(), $("#cmd_gprs_template_list_grid").trigger("reloadGrid");
  }
  
  function cmdTemplateLoadData() {
    var e = {
      cmd: "load_cmd_template_data",
    };
    $.ajax({
      type: "POST",
      url: "func/fn_cmd.php",
      data: e,
      dataType: "json",
      cache: false,
      success: function (res) {
        (cmdData.cmd_templates = res),
          cmdTemplateList(),
          cmdScheduleTemplateList();
      },
    });
  }
  
  function cmdTemplateImport() {
    utilsCheckPrivileges("viewer") &&
      (document
        .getElementById("load_file")
        .addEventListener("change", cmdTemplateImportCTEFile, false),
      document.getElementById("load_file").click());
  }
  
  function cmdTemplateExport() {
    if (utilsCheckPrivileges("viewer")) {
      var e = "func/fn_export.php?format=cte";
      window.location = e;
    }
  }
  
  function cmdTemplateImportCTEFile(e) {
    var t = e.target.files,
      a = new FileReader();
    (a.onload = function (e) {
      try {
        var t = $.parseJSON(e.target.result);
        if ("0.1v" == t.cte) {
          var a = t.templates.length;
          if (0 == a)
            return void notifyBox(
              "info",
              la.INFORMATION,
              la.NOTHING_HAS_BEEN_FOUND_TO_IMPORT
            );
          confirmDialog(
            sprintf(la.TEMPLATES_FOUND, a) +
              " " +
              la.ARE_YOU_SURE_YOU_WANT_TO_IMPORT,
            function (t) {
              if (t) {
                loadingData(true);
                var a = {
                  format: "cte",
                  data: e.target.result,
                };
                $.ajax({
                  type: "POST",
                  url: "func/fn_import.php",
                  data: a,
                  cache: false,
                  success: function (res) {
                    loadingData(false), "OK" == res && cmdTemplateReload();
                  },
                  error: function (e, t) {
                    loadingData(false);
                  },
                });
              }
            }
          );
        } else notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
      } catch (e) {
        notifyBox("error", la.ERROR, la.INVALID_FILE_FORMAT);
      }
      document.getElementById("load_file").value = "";
    }),
      a.readAsText(t[0], "UTF-8"),
      this.removeEventListener("change", cmdTemplateImportCTEFile, false);
  }
  
  function cmdTemplateProtocolList() {
    var e = document.getElementById("dialog_cmd_template_protocol").value,
      t = document.getElementById(
        "dialog_cmd_template_hide_unsed_protocols"
      ).checked,
      a = document.getElementById("dialog_cmd_template_protocol");
    if (((a.options.length = 0), 1 == t))
      for (var o = getAllProtocolsArray(), i = 0; i < o.length; i++)
        "" != o[i] && a.options.add(new Option(o[i], o[i]));
    else
      for (var s in gsValues.protocol_list) {
        var n = gsValues.protocol_list[s];
        a.options.add(new Option(n.name, n.name));
      }
    sortSelectList(a),
      a.options.add(new Option(la.ALL_PROTOCOLS, ""), 0),
      (document.getElementById("dialog_cmd_template_protocol").value = e),
      $("#dialog_cmd_template_protocol").multipleSelect("refresh");
  }
  
  function cmdTemplateProperties(e) {
    switch (e) {
      default:
        var t = e;
        (cmdData.edit_cmd_template_id = t),
          (document.getElementById(
            "dialog_cmd_template_hide_unsed_protocols"
          ).checked = false),
          cmdTemplateProtocolList(),
          (document.getElementById("dialog_cmd_template_name").value =
            cmdData.cmd_templates[t].name),
          (document.getElementById("dialog_cmd_template_protocol").value =
            cmdData.cmd_templates[t].protocol),
          $("#dialog_cmd_template_protocol").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_gateway").value =
            cmdData.cmd_templates[t].gateway),
          $("#dialog_cmd_template_gateway").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_type").value =
            cmdData.cmd_templates[t].type),
          $("#dialog_cmd_template_type").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_cmd").value =
            cmdData.cmd_templates[t].cmd),
          $("#dialog_cmd_template_properties").dialog("open");
        break;
      case "add":
        (cmdData.edit_cmd_template_id = false),
          (document.getElementById(
            "dialog_cmd_template_hide_unsed_protocols"
          ).checked = false),
          cmdTemplateProtocolList(),
          (document.getElementById("dialog_cmd_template_name").value = ""),
          (document.getElementById("dialog_cmd_template_protocol").value = ""),
          $("#dialog_cmd_template_protocol").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_gateway").value = "gprs"),
          $("#dialog_cmd_template_gateway").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_type").value = "ascii"),
          $("#dialog_cmd_template_type").multipleSelect("refresh"),
          (document.getElementById("dialog_cmd_template_cmd").value = ""),
          $("#dialog_cmd_template_properties").dialog("open");
        break;
      case "cancel":
        $("#dialog_cmd_template_properties").dialog("close");
        break;
      case "save":
        if (!utilsCheckPrivileges("viewer")) return;
        var a = document.getElementById("dialog_cmd_template_name").value,
          o = document.getElementById("dialog_cmd_template_protocol").value,
          i = document.getElementById("dialog_cmd_template_gateway").value,
          s = document.getElementById("dialog_cmd_template_type").value,
          n = document.getElementById("dialog_cmd_template_cmd").value;
        if ("" == a)
          return void notifyBox("error", la.ERROR, la.NAME_CANT_BE_EMPTY, true);
        if ("" == n)
          return void notifyBox(
            "error",
            la.ERROR,
            la.COMMAND_CANT_BE_EMPTY,
            true
          );
        if (
          "hex" == s &&
          ((n = n.toUpperCase()), !isHexValid(n.replace("%IMEI%", "")))
        )
          return void notifyBox(
            "error",
            la.ERROR,
            la.COMMAND_HEX_NOT_VALID,
            true
          );
        var l = {
          cmd: "save_cmd_template",
          cmd_id: cmdData.edit_cmd_template_id,
          name: a,
          protocol: o,
          gateway: i,
          type: s,
          cmd_: n,
        };
        $.ajax({
          type: "POST",
          url: "func/fn_cmd.php",
          data: l,
          cache: false,
          success: function (res) {
            "OK" == res &&
              (cmdTemplateReload(),
              $("#dialog_cmd_template_properties").dialog("close"),
              notifyBox("info", la.INFORMATION, la.CHANGES_SAVED_SUCCESSFULLY));
          },
        });
    }
  }
  
  function cmdTemplateDelete(e) {
    utilsCheckPrivileges("viewer") &&
      confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
        if (t) {
          var a = {
            cmd: "delete_cmd_template",
            cmd_id: e,
          };
          $.ajax({
            type: "POST",
            url: "func/fn_cmd.php",
            data: a,
            success: function (res) {
              "OK" == res && cmdTemplateReload();
            },
          });
        }
      });
  }
  
  function cmdTemplateDeleteSelected() {
    if (utilsCheckPrivileges("viewer")) {
      var e = $("#cmd_gprs_template_list_grid").jqGrid("getGridParam", "selarrrow");
      "" != e
        ? confirmDialog(la.ARE_YOU_SURE_YOU_WANT_TO_DELETE, function (t) {
            if (t) {
              var a = {
                cmd: "delete_selected_cmd_templates",
                items: e,
              };
              $.ajax({
                type: "POST",
                url: "func/fn_cmd.php",
                data: a,
                success: function (res) {
                  "OK" == res && cmdTemplateReload();
                },
              });
            }
          })
        : notifyBox("error", la.ERROR, la.NO_ITEMS_SELECTED);
    }
  }

  