// Comprobar si el auto permite corte de motor y/o abrir puerta
function tieneCorteMotor(corteMotor) {
    try {
        if (corteMotor == 1 || corteMotor == 3) {
          return true;
        } else {
          return false;
        }
    } catch (e) {
        console.error(e);
        return false;
    }
}
  
  //Validar rele para mostrar el boton correspondiente
function validarEstadoRele(releActivo) {
    try {
        if ([0, 1].includes(+releActivo)) return +releActivo;
    } catch (e) {
        console.error(e);
        return 2;
    }
    return 2;
}
  
  //enviar comando corte
  /* 
  @param index: int
  @param accion: (motor | abrir_puertas | cerrar_puertas)
   */
//   function enviarComandoCorte({ imei, corte_motor, rele_activo }, comando, baseUrl = "http://198.58.110.186:19881/motor_cut") {
  function enviarComandoCorte({ object_imei, corte_motor, rele_activo }, comando, baseUrl = "http://170.187.134.232:2023/motor_cut") {

    console.log(object_imei, corte_motor, rele_activo, comando,baseUrl);

    const infoComando = {
        object_imei,
        comando
    };

    textInputDialog({
            title: "Confirmar Acción",
            text: "Ingrese su contraseña de usuario.",
            placeholder: "Contraseña",
            type: "password"
        },
        async (value, text, close) => {


            $("#dialog_text_input").val(""); // Limpiar campo de texto

            if (!value) {
                console.warn("No se ingresó contraseña.");
                return;
            }

            if (!tieneCorteMotor(corte_motor)) {
                console.error("No tiene corte motor.");
                return;
            }
            if (![0, 1].includes(validarEstadoRele(rele_activo))) {
                console.error("Valor del rele inválido:", rele_activo);
                return;
            }

            const header = {
                "Content-Type": "application/json"
            };

            // Añadir la contraseña al objeto de comando
            infoComando.password = text;

            const url = encodeURI(baseUrl);
            console.log(infoComando)
            try {
                console.log("Enviando solicitud POST...");
                const res = await fetch(
                    url,
                    {
                        method: "POST",
                        headers: header,
                        body: JSON.stringify(infoComando),
                    }
                );

                if (!res) {
                    console.error("Sin respuesta de la API.");
                    throw new Error("Sin respuesta...");
                }

                console.log("Respuesta recibida con código de estado:", res.status);

                if (res.status) {
                    code = res.status;

                    if (res.status == 200) {
                        console.log("Comando ejecutado con éxito, refrescando indicador de rele...");
                        refrescarIndicadorRele(rele_activo,object_imei);
                        return;
                    }
                    if (res.status == 403) {
                        console.warn("Acceso prohibido, mostrando mensaje de error...");
                        notifyDialog(await res.text());
                        return;
                    }
                } else {
                    console.error("Respuesta inesperada:", res);
                }

            } catch (error) {
                console.error("Error en la solicitud:", error);
            }
        }
    );
}


const colorMap = new Map([ ["0", "#9CC602"], ["1", "#ff5e5e"] ]);
// Cambia color de círculo que indica si el motor se encuentra encendido o apagado



function refrescarIndicadorRele(rele_activo, imei) {
    var color = rele_activo == 0 ?  "#ff5e5e" : "#9CC602";
    if (!imei) {
        document.getElementById("indicador_rele_activo").style.backgroundColor = color
    } else {
        document.querySelector(`#object_rele_${imei} path`).style.fill = color;
    }
}
