<?
    require_once "../config.php";

    session_start();
    
    function error($code = 500, $msg = "Unknown Error") {
        http_response_code($code);
        session_write_close();
        die($msg);
    };
    
    $body = file_get_contents('php://input');
    // error_log($body,3,"log.log");
    $params = json_decode($body);
    // error_log('------------------------------------------------------------------------',3,"log.log");
    // error_log($params,3,"log.log");
// error_log($params->object_imei.' '.$params->comando.' '. $params->password,3,"log.log");
    if (isset($params->object_imei) && isset($params->comando) && isset($params->password)) {
        $imei = $params->object_imei;
        $comando = $params->comando;
        $password = $params->password;
    } else {
        error(400, "Error: Parámetros faltantes 'imei' o 'comando'");
    }

    $mysqli = new mysqli($gsValues["DB_HOSTNAME"], $gsValues["DB_USERNAME"], $gsValues["DB_PASSWORD"], $gsValues["DB_NAME"], $gsValues["DB_PORT"]);

    // error_log($gsValues["DB_HOSTNAME"].$gsValues["DB_USERNAME"].$gsValues["DB_PASSWORD"].$gsValues["DB_NAME"].$gsValues["DB_PORT"],3,"log.log");

    if ($mysqli->connect_errno) {
        error(500, "Error de conexión: $mysqli->connect_error");
    }

    function getUserData($id) {
        global $mysqli;
        $password = $api = $email = '';  // Define separate variables for each value
        
        $q = "SELECT password, api, email FROM gs_users WHERE id = ?";
        
        if ($stmt = $mysqli->prepare($q)) {
            try {
                $stmt->bind_param("i", $id);
            } catch (Exception $e) {
                error(500, $e);
            }
    
            $stmt->execute();
    
            if ($stmt->errno) {
                error(500, "Error: $stmt->error");
            }
    
            // Bind the result to separate variables
            $stmt->bind_result($password, $api, $email);
    
            if ($stmt->fetch()) {
                // Store the results in the $result array or return directly
                $stmt->close();
                return ["password" => $password, "api" => $api, "email" => $email];
            }
            error();
        }
    }
    

    $userData = getUserData($_SESSION["user_id"]);

    if (
        md5($password) !== $userData["password"]
        || $userData["api"] !== "true"
    ) {
        error(403, "No tiene autorización para realizar esta acción");
    }
    
    $procedureCall = "CALL appv3_vehiculos_corte_motor(?, ?, ?)";
    $query = "SELECT rele_activo FROM gs_objects WHERE imei = ?";
    
    if ($stmt = $mysqli->prepare($procedureCall)) {
        try {
            $stmt->bind_param("sss", $imei, $comando, $userData["email"]);
        } catch (Exception $e) {
            error(500, $e);
        }
        
        $stmt->execute();

        if ($stmt->errno) {
            error(500, "Error: $stmt->error");
        }
        // error_log(print_r($stmt, true), 3, "log.log");
        $stmt->close();
    } else {
        error();
    }
    
    if ($mysqli->errno) {
        error(500, "Error: $mysqli->error");
    }

    if ($stmt = $mysqli->prepare($query)) {
        try {
            $stmt->bind_param("s", $imei);
        } catch (Exception $e) {
            error(500, $e);
        }
        
        $stmt->execute();

        $stmt->bind_result($res);
        
        if ($stmt->errno) {
            http_response_code(500);
            die("Error: $stmt->error");
        }
        
        $stmt->close();

        if ($mysqli->errno) {
            error(500, "Error: $mysqli->error");
        }

        echo $res;
    } else {
        error();
    }
    
    $mysqli->close();

    session_write_close();
    