<?

session_start();
include('../init.php');
include('fn_common.php');
checkUserSession();

// check privileges
if ($_SESSION["privileges"] == 'subuser') {
	$user_id = $_SESSION["manager_id"];
} else {
	$user_id = $_SESSION["user_id"];
}

if (@$_POST['cmd'] == 'load_last_event') {
	$last_id = $_POST['last_id'];

	$result = array();

	// check privileges		
	if ($_SESSION["privileges"] == 'subuser') {
		$q = "SELECT * FROM `gs_user_events_data` WHERE `user_id`='" . $user_id . "' AND `imei` IN (" . $_SESSION["privileges_imei"] . ")";
	} else {
		$q = "SELECT * FROM `gs_user_events_data` WHERE `user_id`='" . $user_id . "'";
	}

	if ($last_id == -1) {
		$q .= " ORDER BY event_id DESC LIMIT 1";
	} else {
		$q .= " AND `event_id`>'" . $last_id . "' ORDER BY event_id ASC";
	}

	$r = mysqli_query($ms, $q);

	if ($r) {
		while ($row = mysqli_fetch_array($r)) {
			if ($row['name'] == "") {
				$row['name'] = getObjectName($row['imei']);
			}

			$row['dt_server'] = convUserTimezone($row['dt_server']);
			$row['dt_tracker'] = convUserTimezone($row['dt_tracker']);

			$result[] = $row;
		}
	}

	header('Content-type: application/json');
	echo json_encode($result);
	die;
}

if (@$_POST['cmd'] == 'delete_all_events') {
	$q = "DELETE FROM `gs_user_events_data` WHERE `user_id`='" . $user_id . "'";
	$r = mysqli_query($ms, $q);

	$q = "DELETE FROM `gs_user_events_data` WHERE `user_id`='" . $user_id . "'";
	$r = mysqli_query($ms, $q);

	//write log
	// writelog('object_op', 'Clear all object events: successful.');

	echo 'OK';
	die;
}

// if ($_POST['cmd'] == 'load_all_event_data' && $imei = $_POST['imei'] ?? false) {
// 	$result = array();

// 	$q_objects = "SELECT * FROM gs_objects WHERE imei = '$imei'";
// 	$result_objects = mysqli_query($ms, $q_objects);
// 	$objects_data = [];
// 	while ($row = mysqli_fetch_assoc($result_objects)) {
// 		$row['dt_server'] = convUserTimezone($row['dt_server']);
// 		$row['dt_tracker'] = convUserTimezone($row['dt_tracker']);
// 		$row['params'] = json_decode($row['params'], true);
// 		$objects_data[] = $row;
// 	}

// 	$q_events = "SELECT * FROM gs_user_events_data WHERE imei = '$imei'";
// 	$result_events = mysqli_query($ms, $q_events);
// 	$events_data = [];
// 	while ($row = mysqli_fetch_assoc($result_events)) {
// 		$row['dt_server'] = convUserTimezone($row['dt_server']);
// 		$row['dt_tracker'] = convUserTimezone($row['dt_tracker']);
// 		$row['params'] = json_decode($row['params'], true);
// 		$events_data[] = $row;
// 	}
// 	header('Content-type: application/json');
// 	echo json_encode($response);
// 	die;
// }

if (@$_POST['cmd'] == 'load_event_data') {
	$result = array();

	$event_id = $_POST['event_id'];

	// check privileges		
	if ($_SESSION["privileges"] == 'subuser') {
		$q = "SELECT * FROM `gs_user_events_data`
			WHERE `user_id`='" . $user_id . "' AND `event_id`='" . $event_id . "' LIMIT 1";
	} else {
		$q = "SELECT * FROM `gs_user_events_data`
			WHERE `user_id`='" . $user_id . "' AND `event_id`='" . $event_id . "' LIMIT 1";
	}

	$r = mysqli_query($ms, $q);
	$row = mysqli_fetch_array($r);

	if ($row) {
		if ($row['name'] == "") {
			$row['name'] = getObjectName($row['imei']);
		}

		$row['speed'] = convSpeedUnits($row['speed'], 'km', $_SESSION["unit_distance"]);
		$row['altitude'] = convAltitudeUnits($row['altitude'], 'km', $_SESSION["unit_distance"]);

		$params = json_decode($row['params'], true);

		$result = array(
			'event_id' => $row['event_id'],
			'name' => $row['name'],
			'imei' => $row['imei'],
			'event_desc' => $row['event_desc'],
			'dt_server' => convUserTimezone($row['dt_server']),
			'dt_tracker' => convUserTimezone($row['dt_tracker']),
			'lat' => $row['lat'],
			'lng' => $row['lng'],
			'altitude' => $row['altitude'],
			'angle' => $row['angle'],
			'speed' => $row['speed'],
			'params' => $params,
			'type' => $row['type']
		);
	}

	header('Content-type: application/json');
	echo json_encode($result);
	die;
}


if (@$_GET['cmd'] == 'load_event_list') {
	$page = $_GET['page']; // get the requested page
	$limit = $_GET['rows']; // get how many rows we want to have into the grid
	$sidx = $_GET['sidx']; // get index row - i.e. user click to sort
	$sord = $_GET['sord']; // get the direction
	$search = strtoupper(@$_GET['s']); // get search

	if (!$sidx) $sidx = 1;

	// check privileges
	if ($_SESSION["privileges"] == 'subuser') {
		$q = "SELECT * FROM `gs_user_events_data`
			WHERE `user_id`='" . $user_id . "'
			AND (UPPER(`event_desc`) LIKE '%$search%' OR UPPER(`name`) LIKE '%$search%')
			AND `imei` IN (" . $_SESSION["privileges_imei"] . ")";
	} else {
		$q = "SELECT * FROM `gs_user_events_data`
			WHERE `user_id`='" . $user_id . "'
			AND (UPPER(`event_desc`) LIKE '%$search%' OR UPPER(`name`) LIKE '%$search%')";
	}

	$r = mysqli_query($ms, $q);
	$count = mysqli_num_rows($r);

	if ($count > 0) {
		$total_pages = ceil($count / $limit);
	} else {
		$total_pages = 1;
	}

	if ($page > $total_pages) $page = $total_pages;
	$start = $limit * $page - $limit; // do not put $limit*($page - 1)

	$q .= " ORDER BY gs_user_events_data.$sidx $sord LIMIT $start, $limit";
	$r = mysqli_query($ms, $q);

	$response = new stdClass();
	$response->page = $page;
	$response->total = $total_pages;
	$response->records = $count;

	if ($r) {
		$i = 0;
		while ($row = mysqli_fetch_array($r)) {
			$response->rows[$i]['id'] = $row['event_id'];
			$response->rows[$i]['cell'] = array($row['dt_tracker'], $row['name'], $row['event_desc']);
			$i++;
		}
	}


	header('Content-type: application/json');
	echo json_encode($response);
	die;
}



if (isset($_POST['action']) && $_POST['action'] == 'testcrta') {
	$imei = $_POST['imei'] ?? false;
	$comando = $_POST['comando'] ?? false;
	$email = $_POST['email'] ?? false;

	if ($imei && $comando && $email) {
		cortaMotor($imei, $comando, $email);
	} else {
		http_response_code(400);
		echo "Missing required parameters.";
		exit();
	}
}

function cortaMotor($imei, $comando, $email)
{
	global $ms;
	$procedureCall = "CALL appv3_vehiculos_corte_motor(?, ?, ?)";

	if ($stmt = $ms->prepare($procedureCall)) {
		try {
			$stmt->bind_param("sss", $imei, $comando, $email);
			$stmt->execute();

			if ($stmt->errno) {
				http_response_code(500);
				echo "Error: " . $stmt->error;
				exit();
			} else {
				http_response_code(200);
				echo "Procedure executed successfully.";
			}
		} catch (Exception $e) {
			http_response_code(500);
			echo "Exception: " . $e->getMessage();
			exit();
		} finally {
			$stmt->close();
		}
	} else {
		http_response_code(500);
		echo "Error preparing statement.";
		exit();
	}
}
