<?php 
 ?>

<style>
    
.compass-container:after{
  content: '';
    background: linear-gradient(302deg, #000a680d 222%, #ffffff00 1%, transparent);
    width: 1000vw;
    height: 1000vh;
    position: absolute;
    right: -200vw;
    top: -150vh;
}

    .compass-container {
      width: 30vw;
    height: 30vw;
    margin: auto;
    padding: 100px;
    position: absolute;
    z-index: 9999;
    scale: .3;
    left: 37vw;
    top: 12vh;
    display:none
}

.compass-container svg {
  width: 100%;
  height: 100%;
  transition:.4s
}


.compass-container svg path{
  transition: .4s;
  animation: colorCycle 4s infinite alternate;
}

.arrowthing{
  animation: 2s pointerMove cubic-bezier(0.1, 0.36, 0.54, 0.67) infinite
}

@keyframes pointerMove{
  0%{
    transform-origin: center;
  }
 
  25%{
    transform-origin: center;
    transform: rotate(75deg) translate(50px, -35px);
  }
  75%{
    transform: rotate(-75deg) translate(-50px, -35px);
    transform-origin: center;
  }
  100%{
    transform-origin: center;
  }
}


.handle{
  z-index:9999999!important;
  overflow:hidden
}

.sky{
  z-index:-99999!important;
  overflow:hidden
}


</style>


<div class="compass-container">
    <svg width="701" height="886" viewBox="0 0 701 886" fill="none" xmlns="http://www.w3.org/2000/svg" >
      <path d="M175.447 580.182L113.447 633.682L346.947 885.682L580.499 633.682L518.499 580.182L346.947 777.682L175.447 580.182Z" fill="#3A3A3A"/>
      
      <path class="darkgreen" d="M232.447 21.3257L252.447 70.7022C323.927 42.6863 379.019 44.6863 450.499 72.7022L468.499 21.3257C392.177 -7.10856 308.769 -7.10856 232.447 21.3257Z" fill="#9EC059"/>
      <path class="sky" d="M70 573.834L118.5 532.223C90.5 493.223 65.9445 443.682 59.6156 398.182L29.6061 401.932L2.59663 405.682C9.19956 460.584 35.6425 521.613 70 573.834Z" fill="#0097D5"/>
      <path class="darksky" d="M0.46362 380.682L58.2917 377.182C56.5725 322.484 70.9397 264.505 98.2541 210.682L47.4294 181.682C14.1176 241.068 -3.11059 310.016 0.46362 380.682Z" fill="#0083C3"/>
      <path class="orange" d="M640.655 377.182L700.483 380.682C704.057 310.016 686.829 241.068 653.517 181.682L604.692 209.682C632.007 263.505 642.374 322.484 640.655 377.182Z" fill="#ECA63A"/>
      <path class="yellow" fill-rule="evenodd" clip-rule="evenodd" d="M503.499 36.6492C557.864 64.1692 603.499 105.481 637.154 155.182L590.543 184.682C563.582 141.782 525.282 108.388 473.999 83.0754L503.499 36.6492Z" fill="#F9CF23"/>
      <path class="red" d="M580.499 533.601L621.953 577.682C656.31 525.461 691.747 460.584 698.35 405.682L639.331 398.182C634.304 450.897 607.762 505.372 580.499 533.601Z" fill="#DF6D53"/>
      <path class="green" fill-rule="evenodd" clip-rule="evenodd" d="M63.7925 155.182L111.777 186.682C138.77 143.363 177.266 106.584 228.947 81.0754L197.447 36.6492C143.082 64.1692 97.4473 105.481 63.7925 155.182Z" fill="#23A457"/>
      <path class="arrowthing" d="M282 535.712C282 589.267 316.89 609.682 350.06 609.682C383.23 609.682 420 589.267 420 535.712C420 499.261 410 509.849 389.686 449.368C368.312 355.841 355.093 247.896 351.171 207.682H348.829C344.907 247.896 331.688 355.841 310.314 449.368C290 509.849 282 499.261 282 535.712Z" fill="#3A3A3A"/>
      <path class="handle" d="M176.447 548.922L86 631.422L49.5 591.422L137.5 515.922L176.447 548.922Z" fill="#3A3A3A"/>
      <path class="handle" d="M532.999 546.182L615.499 626.682L636.999 593.682L565.999 518.182L532.999 546.182Z" fill="#3A3A3A"/>
    </svg>

  </div>



  <script>
const c = ['sky', 'darksky', 'green', 'darkgreen', 'yellow', 'orange', 'red'],
      a = {
        sky: '#0097d5',
        darksky: '#0083c3',
        green: '#23A457',
        darkgreen: '#9ec059',
        yellow: '#f9cf23',
        orange: '#eca63a',
        red: '#df6d53',
        neutral: '#858585'
      },
      t = (i, on) => {
        const element = document.querySelector('.' + c[i]);
        if (!element) return; 

        Object.assign(
          element.style,
          on
            ? {          fill: a[c[i]], 
               zIndex: -99,
          transform: 'scale(1.05)' } 
            : { fill: a.neutral, 
               stroke: '',
               transform: 'scale(1)',
               zIndex: -99
              }     
        );
      };

let running = true;

(() => {
  let i = 0, d = 5, nd = 140, pd = 150; 
  (function step() {
    if (!running) return;

    t(i, d > 0);
    i += d;
    
    if (i < 0) {
      i = 0;
      d = 1;
      setTimeout(step, pd);
    } else if (i >= c.length) {
      i = c.length - 1;
      d = -1;
      setTimeout(step, pd);
    } else {
      setTimeout(step, nd);
    }
  })();
})();

  </script>
