<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $logMessage = $_POST['message'] ?? 'No message provided';
    $logFile = $_POST['filename'] ?? 'object_update_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[{$timestamp}] {$logMessage}\n";

    // Save the log entry to the file
    file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);

    echo json_encode(['status' => 'success', 'message' => 'Log saved.']);
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
