<?php 


function getObjectImei($plate_number)
{
    global $ms;

    $q = "SELECT * FROM `gs_objects` WHERE `plate_number`='".$plate_number."'";
    $r = mysqli_query($ms, $q);
    $row = mysqli_fetch_array($r);

    return $row['imei'];
}


function reportsAddHeaderStart($format)
{
    global $ms, $gsValues;
    
    $result = '';
    
    if (($format == 'html') || ($format == 'pdf'))
    {
        $result = 	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html>
                    <head>
                    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    <title>'.$gsValues['NAME'].' '.$gsValues['VERSION'].'</title>';
                    
        if (file_exists('../favicon.png'))
        {
            $result .= '<link rel="shortcut icon" href="'.$gsValues['URL_ROOT'].'/favicon.png" type="image/x-icon">';
        }
        else
        {
            $result .= '<link rel="shortcut icon" href="'.$gsValues['URL_ROOT'].'/favicon.ico" type="image/x-icon">';
        }	
                    
    }
    else if ($format == 'xls')
    {
        $result = 	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7">
                    <title></title>';
    }
    
    return $result;
}



function reportsAddStyle($type, $format)
{
    global $gsValues;
    
    $result = "<style type='text/css'>";
    
    if ($format == 'html')
    {
    $result .= "@import url(https://fonts.googleapis.com/css?family=Open+Sans:400,600,300,700&subset=latin,greek,greek-ext,cyrillic,cyrillic-ext,latin-ext,vietnamese);
            
            html, body {
                text-align: left; 
                margin: 10px;
                padding: 0px;
                font-size: 11px;
                font-family: 'open sans';
                color: #444444;
            }";
    }
    else if ($format == 'pdf')
    {
        if ($_SESSION["language"] == 'thai')
        {
            $result .= "html, body {
                        text-align: left; 
                        margin: 10px;
                        padding: 0px;
                        font-size: 11px;
                        font-family: 'Garuda';
                        color: #444444;
                    }";
        }
        else
        {
            $result .= "html, body {
                        text-align: left; 
                        margin: 10px;
                        padding: 0px;
                        font-size: 11px;
                        font-family: 'DejaVu Sans';
                        color: #444444;
                    }";				
        }
    }
    else if ($format == 'xls')
    {
    $result .= "html, body {
                text-align: left; 
                margin: 10px;
                padding: 0px;
                font-size: 11px;
                color: #444444;
            }";
    }
    
    $result .= ".logo { border:0px; width:250px; height:56px; }
    
            h3 { 
                font-size: 13px;
                font-weight: 600;
            }
            
            hr {
                border-color: #eeeeee;
                border-style: solid none none;
                border-width: 1px 0 0;
                height: 1px;
                margin-left: 1px;
                margin-right: 1px;
            }
            
            a,
            a:hover { text-decoration: none; color: #2b82d4; }
            b, strong{ font-weight: 600; }
            
            .graph-controls
            {
                margin-bottom: 10px;
                display: table;
                width: 100%;
            }
            .graph-controls div
            {
                display: inline-block;
                vertical-align: middle;
                font-size: 11px;
            }
            .graph-controls-left
            {
                float: left;
                margin-top: 5px;
            }
            .graph-controls-right
            {
                float: right;
            }
            .graph-label
            {
                line-height: 24px;
                margin-right: 5px;
            }
            .panel-button img {
                display: block;
                padding: 6px;
                background: #f5f5f5;
            }				
            .panel-button img:hover {
                background: #ffffff;
            }
            
            caption,
            th,
            td { vertical-align: middle; }
            
            table.report {
                border: 1px solid #eeeeee;
                border-collapse: collapse;
            }
            
            table.report th {
                font-weight: 600;
                padding: 2px;
                border: 1px solid #eeeeee;
                background-color: #eeeeee;
            }
            
            table.report td {
                padding: 2px;
                border: 1px solid #eeeeee;
            }
            
            table.report td.night {
                background-color: #f5f5f5;
            }
            
            table.report tr.night {
                background-color: #f5f5f5;
            }
            
            table.report tr:hover { background-color: #f8f8f8; }
            
            td { mso-number-format:'\@';/*force text*/ }
            
        </style>";
        
        
    if (($type == 'routes') || ($type == 'routes_stops'))
    {
        $result .= '<link type="text/css" href="'.$gsValues['URL_ROOT'].'/theme/leaflet/leaflet.css" rel="Stylesheet" />';
        
        $result .= "<style type='text/css'>			
                .map {
                    width: 640px;
                    height: 480px;
                }
            </style>";
    }
        
    return $result;
}

function reportsAddJS($type)
{
    global $gsValues;
    
    $result = '';
    
    if (($type == 'speed_graph') || ($type == 'altitude_graph') || ($type == 'acc_graph') || ($type == 'fuellevel_graph') || ($type == 'temperature_graph') || ($type == 'sensor_graph'))
    {
        $result .= '<script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery-2.1.4.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery-migrate-1.2.1.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.crosshair.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.navigate.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.selection.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.time.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery.flot.resize.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/gs.common.js"></script>
                
            <script type="text/javascript">
                var graphPlot = new Array();
                
                function initGraph(id, graph)
                {
                    if (!graph)
                    {
                        var data = []; // if no data, just create array for empty graph
                        var units = "";
                        var steps_flag = false;
                        var points_flag = false;
                    } 
                    else
                    {
                        var data = graph["data"];
                        var units = graph["units"];
                        
                        if (graph["result_type"] == "logic")
                        {
                            var steps_flag = true;
                            var points_flag = false;
                        }
                        else
                        {
                            var steps_flag = false;
                            var points_flag = false;
                        }
                    }
                    
                    var minzoomRange = 30000;//	min zoom in is within 1 minute range (1*60*1000 = 60000)
                    var maxzoomRange = 30 * 86400000;//	max zoom out is 5 times greater then chosen period (default is equal to 30 days 30 * 24*60*60*1000 = 86400000 )
                    
                    var options = {
                        xaxis: {
                            mode: "time", 
                            zoomRange: [minzoomRange, maxzoomRange]
                            },
                        yaxis: {
                            //min: 0, 
                            tickFormatter: function (v) {
                                    var result = "";
                                    if (graph)
                                    {
                                        result = Math.round(v * 100)/100  + " " + units;
                                    }
                                    return result;
                                }, 
                            zoomRange: [0, 0], 
                            panRange: false
                            },
                        selection: {mode: "x"},
                        crosshair: {mode: "x"},
                        lines: {show: true, lineWidth: 1, fill: true, fillColor: "rgba(43,130,212,0.3)", steps: steps_flag},
                        series: {lines: {show: true} , points: { show: points_flag, radius: 1 }},
                        colors: ["#2b82d4"],
                        grid: {hoverable: true, autoHighlight: true, clickable: true},
                        zoom: {
                            //interactive: true,
                            animate: true,
                            trigger: "dblclick", // or "click" for single click
                            amount: 3         // 2 = 200% (zoom in), 0.5 = 50% (zoom out)
                        },
                        pan: {interactive: false, animate: true}
                    };
                    
                    graphPlot[id] = $.plot($("#graph_plot_"+id), [data], options);
                
                    $("#graph_plot_"+id).unbind("plothover");
                    $("#graph_plot_"+id).bind("plothover", function (event, pos, item) {
                        if (item)
                        {
                            var dt_tracker = getDatetimeFromTimestamp(item.datapoint[0]);
                            
                            var value = item.datapoint[1];
                            document.getElementById("graph_label_"+id).innerHTML = value + " " + units + " - " + dt_tracker;			
                        }
                    });
                    
                    $("#graph_plot_"+id).unbind("plotpan");
                    $("#graph_plot_"+id).bind("plotpan", function (event, plot) {							
                        var scrollTop = document.documentElement.scrollTop;							
                        setTimeout(function(){
                            document.documentElement.scrollTop = scrollTop;
                        }, 1);
                    });
                    
                    $("#graph_plot_"+id).unbind("plotzoom");
                    $("#graph_plot_"+id).bind("plotzoom", function (event, plot) {							
                        var scrollTop = document.documentElement.scrollTop;
                        
                        setTimeout(function(){
                            document.documentElement.scrollTop = scrollTop;
                        }, 1);
                    });
                    
                    $("#graph_plot_"+id).unbind("plotselected");
                    $("#graph_plot_"+id).bind("plotselected", function (event, ranges) {
                        graphPlot[id] = $.plot($("#graph_plot_"+id), 
                        [data],
                        $.extend(true, {}, options, {
                            xaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to }
                        }));
                        
                        // dont fire event on the overview to prevent eternal loop
                        overview.setSelection(ranges, true);
                    });
                }
                function graphPanLeft(id)
                {						
                    graphPlot[id].pan({left: -100});						
                }
                
                function graphPanRight(id)
                {
                    graphPlot[id].pan({left: +100});
                }
                
                function graphZoomIn(id)
                {
                    graphPlot[id].zoom();
                }
                
                function graphZoomOut(id)
                {
                    graphPlot[id].zoomOut();
                }
            </script>';
    }
    else if (($type == 'routes') || ($type == 'routes_stops'))
    {
        $result .= '<script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/jquery-2.1.4.min.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/leaflet/leaflet.js"></script>
            <script type="text/javascript" src="'.$gsValues['URL_ROOT'].'/js/gs.common.js"></script>
            
            <script type="text/javascript">				
                var map = new Array();
                var zoom = 1;
                var icon_size_x = 28 * zoom;
                var icon_size_y = 28 * zoom;
                var icon_anc_x = 14 * zoom;
                var icon_anc_y = 28 * zoom;
                
                var routeStartMarkerIcon = L.icon({
                    iconUrl: "'.$gsValues['URL_ROOT'].'/img/markers/route-start.svg",
                    iconSize:     [icon_size_x, icon_size_y],
                    iconAnchor:   [icon_anc_x, icon_anc_y],
                    popupAnchor:  [0, 0]
                });
                    
                var routeEndMarkerIcon = L.icon({
                    iconUrl: "'.$gsValues['URL_ROOT'].'/img/markers/route-end.svg",
                    iconSize:     [icon_size_x, icon_size_y],
                    iconAnchor:   [icon_anc_x, icon_anc_y],
                    popupAnchor:  [0, 0]
                });
                
                var routeStopMarkerIcon = L.icon({
                    iconUrl: "'.$gsValues['URL_ROOT'].'/img/markers/route-stop.svg",
                    iconSize:     [icon_size_x, icon_size_y],
                    iconAnchor:   [icon_anc_x, icon_anc_y],
                    popupAnchor:  [0, 0]
                });
                
                function initMap(imei)
                {
                    map[imei] = L.map("map_"+imei, {minZoom: 3, maxZoom: 18, editable: false, zoomControl: false});
                    
                    var mapLayer = new L.TileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {attribution: "&copy; <a href=\"http://osm.org/copyright\">OpenStreetMap</a> contributors"});
                    
                    map[imei].addLayer(mapLayer);
                }
                
                function showRoute(imei, data, stops)
                {
                    // prepare points
                    var route_points = new Array();
                    for (i = 0; i<data["route"].length; i++)
                    {
                        var lat = data["route"][i]["lat"];
                        var lng = data["route"][i]["lng"];
                        
                        route_points.push(L.latLng(lat, lng));
                    }
                    
                    // draw route
                    var routeLayer = L.polyline(route_points, {color: "'.$_SESSION['map_rc'].'", opacity: 0.8, weight: 3});
                    map[imei].addLayer(routeLayer);
                    
                    // add route start marker
                    var lng = data["route"][0]["lng"];
                    var lat = data["route"][0]["lat"];						
                    var routeStartMarker = L.marker([lat, lng], {icon: routeStartMarkerIcon});						
                    map[imei].addLayer(routeStartMarker);
                    
                    // add route end marker
                    var lng = data["route"][data["route"].length-1]["lng"];
                    var lat = data["route"][data["route"].length-1]["lat"];						
                    var routeEndMarker = L.marker([lat, lng], {icon: routeEndMarkerIcon});						
                    map[imei].addLayer(routeEndMarker);
                    
                    // put stop markers
                    if (stops)
                    {
                        for (i=0;i<data["stops"].length;i++)
                        {
                            var lng = data["stops"][i]["lng"];
                            var lat = data["stops"][i]["lat"];
                            
                            var routeStopMarker = L.marker([lat, lng], {icon: routeStopMarkerIcon});
                            
                            map[imei].addLayer(routeStopMarker);
                        }	
                    }
                    
                    // zoom to fit route
                    var bounds = routeLayer.getBounds();
                    map[imei].fitBounds(bounds);
                }
            </script>';
    }
    
    return $result;
}


	




function TipoDato($dato) {
    if($dato == -1){
         return "sin datos";
    }
    else{
        return $dato;
    }
}




function reportsGenerateRagConductor($dtini, $dtfin, $speed_limit,$tipo ,$user_id, $patente = '')
{
    global $_SESSION, $la,$ms, $gsValues;

    //echo $patente;
    //die;

    if ($patente != '') {
         $imei = getObjectImei($patente);
         $qr = "SELECT imei from gs_user_objects where user_id = ". $user_id . " and imei = '".$imei."'";

        //echo $qr;

    }else{
        $qr = "SELECT imei from gs_user_objects where user_id = ". $user_id ;
    }

    $rs   = mysqli_query($ms,$qr);

    $conductores = [];
   
    while ($row = mysqli_fetch_array($rs)) {
        $imei = $row['imei'];
      
        $query       = 

            "SELECT     gs_objects.imei,
                gs_objects.plate_number,'' as 'user_id','entra_sale' as 'type',
                CONCAT('Hora Entrada ',
                                                REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','')) as 'event_desc',
                gs_object_data_$imei.dt_server,
                gs_object_data_$imei.dt_tracker,
                gs_object_data_$imei.lat,
                gs_object_data_$imei.lng,
                gs_object_data_$imei.speed,
                gs_object_data_$imei.dt_tracker AS 'dt_event',
                REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','') as 'RFID',
                gs_user_object_drivers.driver_name
            FROM gs_object_data_$imei,gs_objects,gs_user_object_drivers
            WHERE gs_object_data_$imei.dt_tracker BETWEEN '$dtini' AND  '$dtfin'
                AND gs_object_data_$imei.params NOT LIKE '%\"io78\":0%'
                AND gs_objects.imei = '$imei'
                                            AND gs_user_object_drivers.driver_assign_id = REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','')";
            
            

            $resultSet   = mysqli_query($ms,$query);
        
            
            
            if (!$resultSet && mysqli_errno($ms) > 0) {
                die(mysqli_error($ms));
            }


            while ($row = mysqli_fetch_array($resultSet)) {

                
                    $imei         = $row['imei'];
                    $plate_number = $row['plate_number'];  
                    $user_id      = $row['user_id'];
                    $type         = $row['type'];
                    $event_desc   = $row['event_desc'];
                    $dt_server    = $row['dt_server'];
                    $dt_tracker   = $row['dt_tracker'];
                    $lat          = $row['lat'];
                    $lng          = $row['lng'];
                    $speed        = $row['speed'];
                    $dt_event     = $row['dt_event'];
                    $rfid         = $row['RFID'];
                    $driver_name  = $row['driver_name'];
                    

                    $query_tramo = "SELECT
                                        dt_tracker
                                    FROM gs_object_data_$imei
                                    WHERE dt_tracker > '".$dt_tracker."' 
                                        AND (params LIKE '%\"io239\":0%' or params LIKE '%\"io1\":0%')
                                        AND speed = 0 ORDER BY dt_tracker LIMIT 1"; 

                    $rs1 = mysqli_query($ms,$query_tramo);
                    
                    while ($row1 = mysqli_fetch_array($rs1)) {
                        $fin_dt_tracker = $row1['dt_tracker']; 
                    }

                    $haccel_count = 0;
                    $hbrake_count = 0;
                    $hcorn_count = 0;
                    $rag_score = 0;

                    $query_count = "SELECT COUNT(*) AS 'cantidad',SUBSTRING(gs_object_data_$imei.params,
                                        LOCATE('io253',gs_object_data_$imei.params)+7,
                                        LOCATE('\"',SUBSTRING(gs_object_data_$imei.params,
                                        LOCATE('io253',gs_object_data_$imei.params)+7,LENGTH(gs_object_data_$imei.params)))-2) as 'tipo'
                                    FROM gs_object_data_$imei where locate('io253',params) > 0 
                                        AND dt_tracker BETWEEN '".$dt_tracker."' AND '".$fin_dt_tracker."' group by 
                                            SUBSTRING(gs_object_data_$imei.params,
                                            LOCATE('io253',gs_object_data_$imei.params)+7,
                                            LOCATE('\"',SUBSTRING(gs_object_data_$imei.params,
                                            LOCATE('io253',gs_object_data_$imei.params)+7,LENGTH(gs_object_data_$imei.params)))-2)";
                                    
        
                    $rs2 = mysqli_query($ms,$query_count);
                    
                    while ($row2 = mysqli_fetch_array($rs2)) {
                        $htipo     = $row2['tipo']; 
                        $cantidad  = $row2['cantidad']; 

                        if ($htipo == '1') {
                            $haccel_count = $cantidad;
                        }
                        if ($htipo == '2') {
                            $hbrake_count = $cantidad;
                        }
                        if ($htipo == '3') {
                            $hcorn_count  = $cantidad;
                        }
                    }

                    $overspeed_duration = 0;
                    $getRoute     = getRoute($imei, $dt_tracker ,$fin_dt_tracker, 1, true);
                    if ($getRoute["route"] == []) {
                        continue;
                    }
                    $route_length = $getRoute['route_length'];

                    if ($speed_limit > 0) {
                        $overspeed = 0;
                        $overspeed_start = "";

                        for ($j = 0; $j < count($getRoute['route']); ++$j) {
                            $speed = $getRoute['route'][$j][5];
                            
                            if ($speed > $speed_limit) {
                                
                                if ($overspeed == 0) {
                                    $overspeed_start    = $getRoute['route'][$j][0];
                                    $overspeed          = 1;
                                }
                            } else {
                                if ($overspeed == 1) {
                                    $overspeed_end      = $getRoute['route'][$j][0];
                                    $overspeed_duration += strtotime($overspeed_end) - strtotime($overspeed_start);
                                    $overspeed          = 0;
                                }
                            }
                        }
                    } else {
                        $overspeeds_count = 0;
                    }

                    if ($route_length > 0) {

                        $overspeed_score = $overspeed_duration / 10 / ($route_length * 100);
                        $overspeed_score = sprintf('%0.2f', $overspeed_score);

                        $haccel_score = $haccel_count / $route_length * 100;
                        $haccel_score = sprintf('%0.2f', $haccel_score);

                        $hbrake_score = $hbrake_count / $route_length * 100;
                        $hbrake_score = sprintf('%0.2f', $hbrake_score);

                        $hcorn_score = $hcorn_count / $route_length * 100;
                        $hcorn_score = sprintf('%0.2f', $hcorn_score);
                    } else {

                        $route_length = 0;
                        $overspeed_score = 0;
                        $haccel_score = 0;
                        $hbrake_score = 0;
                        $hcorn_score = 0;
                        $rag_score = 0;
                        $haccel_count = 0;
                        $hbrake_count = 0;
                        $hcorn_count = 0;
                    }

                    $rag_score += $overspeed_score;
                    $rag_score += $haccel_score;
                    $rag_score += $hbrake_score;
                    $rag_score += $hcorn_score;
                    $rag       = sprintf('%0.2f', $rag_score);

                    if($rag <= 10){
                        $rag_color = '#00FF00';
                    }elseif($rag > 10 && $rag <= 30){
                        $rag_color = '#FFFF00';
                    }elseif($rag > 30){
                        $rag_color = '#FF4343';
                    }


                    $tramo = [
                        "imei"               => $imei,
                        "patente"            => $plate_number,
                        "inicio"             => $dt_tracker,
                        "fin"                => $fin_dt_tracker,
                        "route_length"       => $route_length,
                        "overspeed_duration" => $overspeed_duration,
                        "speedscore"         => $speed,
                        "aceleracion"        => $haccel_score,
                        "counthaccel"        => $haccel_count,
                        "frenado"            => $hbrake_score,
                        "counthbrake"        => $hbrake_count,
                        "curva"              => $hcorn_score,
                        "counthcorn"         => $hcorn_count,
                        "ragscore"           => $rag_score
                    ];
                    
                    if (isset($conductores[$rfid])) {
                        array_push($conductores[$rfid]["tramos"], $tramo);
                    } else {
                        $conductor = [
                            "nombre" =>$driver_name,
                            "id"     =>$rfid,
                            "tramos" => [$tramo]
                        ];
                        $conductores[$rfid] = $conductor;
                    }
            }
            
    }

     if($tipo == 'json'){

        $lista_conductores = array_values($conductores);

        return json_encode($lista_conductores);
    }else{
                
        http_response_code(400);
        return json_encode([
            "msg"   => "Tipo de reporte inválido",
            "error" => "400"
        ]);
    }



} 


function reportsAddReportHeaderConductor($user_id, $dtf = false, $dtt = false)
{
    global $la, $user_id;
    $result = '<table>';
        // $result .= '<tr><td><strong>'.$la['DRIVER'].':</strong></td><td>'.getObjectDriverPrueba($user_id).'</td></tr>';
        $result .= '<tr><td><strong>'.$la['PERIOD'].':</strong></td><td>'.$dtf.' - '.$dtt.'</td></tr>';
    $result .= '</table><br/>';
    return $result;
}



function reportsGenerateRagConductor3($imei,$dtini, $dtfin, $speed_limit,$data_items,$tipo ,$user_id){


    global $la, $user_id,$ms;

   
    $usuario     = $user_id;

    $utc_dtini = convUserUTCTimezone($dtini);
    $utc_dtfin = convUserUTCTimezone($dtfin);
    
    $query       = 
    "SELECT gs_objects.imei,
                gs_objects.plate_number,".$user_id." as 'user_id','entra_sale' as 'type', 
                CONCAT('Hora Entrada ',
                REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','')) as 'event_desc', 
                gs_object_data_$imei.dt_server,
                gs_object_data_$imei.dt_tracker,
                gs_object_data_$imei.lat, 
                gs_object_data_$imei.lng, 
                gs_object_data_$imei.speed, 
                gs_object_data_$imei.dt_tracker AS 'dt_event',
                REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','') as 'RFID',
                gs_user_object_drivers.driver_name
                FROM gs_object_data_$imei,gs_objects,gs_user_object_drivers  
                WHERE gs_object_data_$imei.dt_tracker BETWEEN '".$utc_dtini."' AND  '".$utc_dtfin."' 
                AND gs_object_data_$imei.params NOT LIKE '%\"io78\":0%' 
                AND gs_objects.imei = ".$imei." AND gs_user_object_drivers.driver_assign_id = REPLACE(JSON_EXTRACT(gs_object_data_$imei.params, '$.io78'),'\"','')";

    $resultSet   = mysqli_query($ms,$query);
    if (mysqli_errno($ms) > 0) {
        die(mysqli_error($ms));
    }
    $event_count = mysqli_num_rows($resultSet);

    if ($event_count <= 0) {
        return;
    }

    if (mysqli_errno($ms) > 0) {
        die(mysqli_error($ms));
    }


    $prev_route_length = null;
    $prev_fin_dt_tracker = null;
    $row_index = 0;

    while ($row = mysqli_fetch_array($resultSet)) {

        $imei         = $row['imei'];
        $plate_number = $row['plate_number'];  
        $user_id      = $row['user_id'];
        $type         = $row['type'];
        $event_desc   = $row['event_desc'];
        $dt_server    = $row['dt_server'];
        $dt_tracker   = $row['dt_tracker'];
        $lat          = $row['lat'];
        $lng          = $row['lng'];
        $speed        = $row['speed'];
        $dt_event     = $row['dt_event'];
        $rfid         = $row['RFID'];
        $driver_name  = $row['driver_name'];


        $query_tramo = "SELECT
                            dt_tracker
                        FROM gs_object_data_$imei
                        WHERE dt_tracker >  '$dt_tracker' 
                        AND (params LIKE '%\"io239\":0%' or params LIKE '%\"io1\":0%')
                        AND speed = 0
                        ORDER BY dt_tracker LIMIT 1";

        $rs1 = mysqli_query($ms,$query_tramo);
        while ($row1 = mysqli_fetch_array($rs1)) {
            $fin_dt_tracker = $row1['dt_tracker']; 
        }

        $haccel_count = 0;
        $hbrake_count = 0;
        $hcorn_count = 0;
        $rag_score = 0;

        $query_count = "SELECT COUNT(*) as 'cantidad',SUBSTRING(gs_object_data_$imei.params,
                            LOCATE('io253',gs_object_data_$imei.params)+7,
                            LOCATE('\"',SUBSTRING(gs_object_data_$imei.params,
                            LOCATE('io253',gs_object_data_$imei.params)+7,LENGTH(gs_object_data_$imei.params)))-2) AS 'tipo'
                        FROM gs_object_data_$imei
                        WHERE LOCATE('io253',params) > 0 
                            AND dt_tracker BETWEEN '$dt_tracker' AND '$fin_dt_tracker'
                        GROUP BY
                            SUBSTRING(gs_object_data_$imei.params,
                            LOCATE('io253',gs_object_data_$imei.params)+7,
                            LOCATE('\"',SUBSTRING(gs_object_data_$imei.params,
                            LOCATE('io253',gs_object_data_$imei.params)+7,LENGTH(gs_object_data_$imei.params)))-2)";
                        

        $rs2 = mysqli_query($ms,$query_count);
        
        while ($row2 = mysqli_fetch_array($rs2)) {
            $htipo     = $row2['tipo']; 
            $cantidad  = $row2['cantidad']; 

            if ($htipo == '1') {
                $haccel_count = $cantidad;
            }
            if ($htipo == '2') {
                $hbrake_count = $cantidad;
            }
            if ($htipo == '3') {
                $hcorn_count  = $cantidad;
            }
        }

        $overspeed_duration = 0;

        $getRoute     = getRoute($imei, $dt_tracker ,$fin_dt_tracker, 1, true);
        $route_length = $getRoute['route_length'];
        $overspeed = 0;
        $overspeed_start = '';

        if ($speed_limit > 0) {

            for ($j = 0; $j < count($getRoute['route']); ++$j) {
                $speed = $getRoute['route'][$j][5];
                
                if ($speed > $speed_limit) {
                    
                    if ($overspeed == 0) {
                        $overspeed_start    = $getRoute['route'][$j][0];
                        $overspeed          = 1;
                    }
                } else {
                    if ($overspeed == 1) {
                        $overspeed_end      = $getRoute['route'][$j][0];
                        $overspeed_duration += strtotime($overspeed_end) - strtotime($overspeed_start);
                        $overspeed          = 0;
                    }
                }
            } 
        } else {
            $overspeeds_count = 0;
        }

        if ($route_length > 0) {

            $overspeed_score = $overspeed_duration / 10 / ($route_length * 100);
            $overspeed_score = sprintf('%0.2f', $overspeed_score);

            $haccel_score = $haccel_count / $route_length * 100;
            $haccel_score = sprintf('%0.2f', $haccel_score);

            $hbrake_score = $hbrake_count / $route_length * 100;
            $hbrake_score = sprintf('%0.2f', $hbrake_score);

            $hcorn_score = $hcorn_count / $route_length * 100;
            $hcorn_score = sprintf('%0.2f', $hcorn_score);
        } else {

            $route_length = 0;
            $overspeed_score = 0;
            $haccel_score = 0;
            $hbrake_score = 0;
            $hcorn_score = 0;
            $rag_score = 0;
            $haccel_count = 0;
            $hbrake_count = 0;
            $hcorn_count = 0;
        }

        $rag_score += $overspeed_score;
        $rag_score += $haccel_score;
        $rag_score += $hbrake_score;
        $rag_score += $hcorn_score;
        $rag       = sprintf('%0.2f', $rag_score);

        if($rag <= 10){
            $rag_color = '#00FF00';
        }elseif($rag > 10 && $rag <= 30){
            $rag_color = '#FFFF00';
        }elseif($rag > 30){
            $rag_color = '#FF4343';
        }


        if ($route_length <= 0 || ($route_length === $prev_route_length && $fin_dt_tracker === $prev_fin_dt_tracker)) {
            continue;
        }
        
        if ($row_index === 0) {
            $result = '<h3>'.$la['DRIVER_BEHAVIOR_RAG'].' por Conductor </h3>';
            $result .= reportsAddReportHeaderConductor('', $dtini, $dtfin);
            $result .= '<table class="report" width="100%"><tr align="center">';
            $result .= '<tr align="center">';
            $result .= '<th>Nombre Conductor</th>';
            $result .= '<th>Id card</th>';
            $result .= '<th>Patente</th>';
            $result .= '<th>Fecha Entrada</th>';
            // $result .= '<th>Fecha Salida</th>';
            $result .= '<th>Logitud de ruta</th>';
            $result .= '<th>Duración del exceso de velocidad</th>';
            $result .= '<th>Marcador exceso de Velocidad</th>';
            $result .= '<th>Contador de Aceleraciones violentas</th>';
            $result .= '<th>Marcador de aceleraciones violentas</th>';
            $result .= '<th>Contador de frenadas violentas</th>';
            $result .= '<th>Marcador de frenadas violentas</th>';
            $result .= '<th>Contador de curvas violentas</th>';
            $result .= '<th>Marcador de curvas violentas</th>';
           // $result .= '<th>RAG</th>';
            $result .= '</tr>';
            $result .= '</table>';
            $result .= '<table class="report" width="100%" ><tr align="center">';
        }
        
        $prev_route_length = $route_length;
        $prev_fin_dt_tracker = $fin_dt_tracker;
        $row_index++;
        
        $result .= '<tr align="center">';
        $result .= '<td>'.$driver_name.'</td>';
        $result .= '<td>'.$rfid.'</td>';
        $result .= '<td>'.$plate_number.'</td>';
        $result .= '<td>'.convUserTimezone($dt_tracker).'</td>';
        // $result .= '<td>'.convUserTimezone($fin_dt_tracker).'</td>';
        $result .= '<td>'.$route_length.' '.$la['UNIT_DISTANCE'].'</td>';
        $result .= '<td>'.$overspeed_duration.' '.$la['UNIT_S'].'</td>';
        $result .= '<td>'.$overspeed_score.'</td>';
        $result .= '<td>'.$haccel_count.'</td>';
        $result .= '<td>'.$haccel_score.'</td>';
        $result .= '<td>'.$hbrake_count.'</td>';
        $result .= '<td>'.$hbrake_score.'</td>';
        $result .= '<td>'.$hcorn_count.'</td>';
        $result .= '<td>'.$hcorn_score.'</td>';
        //$result .= '<td bgcolor="'.$rag_color.'">'.$rag.'</td>';
        /* $result .= '<tr><td></td>'; */
        $result .= '</tr>';

    }
    if ($row_index > 0) {
        $result .= '</table>';
        $result .= '<br/><hr/>';
    }
    return $result;
}


function reportsGenerateRag($imeis, $dtf, $dtt, $speed_limit, $data_items)
{
    global $ms, $_SESSION, $la, $user_id;

    $result = '<table class="report" width="100%" ><tr align="center">';

    $result .= '<th>'.$la['DRIVER'].'</th>';
    $result .= '<th>'.$la['OBJECT'].'</th>';
    $result .= '<th>'.$la['ROUTE_LENGTH'].'</th>';

    if (in_array("overspeed_score", $data_items)) {
        $result .= '<th>'.$la['OVERSPEED_DURATION'].'</th>';
        $result .= '<th>'.$la['OVERSPEED_SCORE'].'</th>';
    }

    if (in_array("harsh_acceleration_score", $data_items)) {
        $result .= '<th>'.$la['HARSH_ACCELERATION_COUNT'].'</th>';
        $result .= '<th>'.$la['HARSH_ACCELERATION_SCORE'].'</th>';
    }

    if (in_array("harsh_braking_score", $data_items)) {
        $result .= '<th>'.$la['HARSH_BRAKING_COUNT'].'</th>';
        $result .= '<th>'.$la['HARSH_BRAKING_SCORE'].'</th>';
    }

    if (in_array("harsh_cornering_score", $data_items)) {
        $result .= '<th>'.$la['HARSH_CORNERING_COUNT'].'</th>';
        $result .= '<th>'.$la['HARSH_CORNERING_SCORE'].'</th>';
    }

    $result .= '<th>'.$la['RAG'].'</th>';
    $result .= '</tr>';

    $rag = array();

    for ($i=0; $i<count($imeis); ++$i) {
        $imei = $imeis[$i];

        $data = getRoute($imei, $dtf, $dtt, 1, true);

        if (count($data['route']) == 0) {
            continue;
        }

        $haccel_count = 0;
        $hbrake_count = 0;
        $hcorn_count = 0;

        $q = "SELECT * FROM `gs_user_events_data` WHERE `user_id`='".$user_id."' AND `imei`='".$imei."'
        AND `type`='haccel' AND dt_tracker BETWEEN '".$dtf."' AND '".$dtt."' ORDER BY dt_tracker ASC";
        $r = mysqli_query($ms, $q);

        $haccel_count = mysqli_num_rows($r);

        $q = "SELECT * FROM `gs_user_events_data` WHERE `user_id`='".$user_id."' AND `imei`='".$imei."'
        AND `type`='hbrake' AND dt_tracker BETWEEN '".$dtf."' AND '".$dtt."' ORDER BY dt_tracker ASC";
        $r = mysqli_query($ms, $q);

        $hbrake_count = mysqli_num_rows($r);

        $q = "SELECT * FROM `gs_user_events_data` WHERE `user_id`='".$user_id."' AND `imei`='".$imei."'
        AND `type`='hcorn' AND dt_tracker BETWEEN '".$dtf."' AND '".$dtt."' ORDER BY dt_tracker ASC";
        $r = mysqli_query($ms, $q);

        $hcorn_count = mysqli_num_rows($r);

        $q = "SELECT * FROM `gs_objects` WHERE `imei`='".$imei."'";
        $r = mysqli_query($ms, $q);
        $row = mysqli_fetch_array($r);
        $params = json_decode($row['params'], true);
        $driver = getObjectDriver($user_id, $imei, $params);

        if ($driver == false) {
            continue;
        }

        $route_length = $data['route_length'];

        $overspeed_duration = 0;
        $overspeed = 0;

        for ($j=0; $j<count($data['route']); ++$j) {
            $speed = $data['route'][$j][5];

            if ($speed > $speed_limit) {
                if ($overspeed == 0) {
                    $overspeed_start = $data['route'][$j][0];
                    $overspeed = 1;
                }
            } else {
                if ($overspeed == 1) {
                    $overspeed_end = $data['route'][$j][0];
                    $overspeed_duration += strtotime($overspeed_end) - strtotime($overspeed_start);
                    $overspeed = 0;
                }
            }
        }

        if ($route_length > 0) {
            $overspeed_score = $overspeed_duration / 10 / $route_length * 100;
            $overspeed_score = sprintf('%0.2f', $overspeed_score);

            $haccel_score = $haccel_count / $route_length * 100;
            $haccel_score = sprintf('%0.2f', $haccel_score);

            $hbrake_score = $hbrake_count / $route_length * 100;
            $hbrake_score = sprintf('%0.2f', $hbrake_score);

            $hcorn_score = $hcorn_count / $route_length * 100;
            $hcorn_score = sprintf('%0.2f', $hcorn_score);
        } else {
            $overspeed_score = 0;
            $haccel_score = 0;
            $hbrake_score = 0;
            $hcorn_score = 0;
        }

        $rag_score = 0;

        if (in_array("overspeed_score", $data_items)) {
            $rag_score += $overspeed_score;
        }

        if (in_array("harsh_acceleration_score", $data_items)) {
            $rag_score += $haccel_score;
        }

        if (in_array("harsh_braking_score", $data_items)) {
            $rag_score += $hbrake_score;
        }

        if (in_array("harsh_cornering_score", $data_items)) {
            $rag_score += $hcorn_score;
        }

        $rag_score = sprintf('%0.2f', $rag_score);

        $rag[] = array('driver_name' => $driver['driver_name'],
                'object_name' => getObjectName($imei),
                'route_length' => $route_length,
                'overspeed_duration' => $overspeed_duration,
                'overspeed_score' => $overspeed_score,
                'haccel_count' => $haccel_count,
                'haccel_score' => $haccel_score,
                'hbrake_count' => $hbrake_count,
                'hbrake_score' => $hbrake_score,
                'hcorn_count' => $hcorn_count,
                'hcorn_score' => $hcorn_score,
                'rag_score' => $rag_score
        );
    }

    if (count($rag) == 0) {
        $result .= '<tr><td align="center" colspan="12">'.$la['NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST'].'</td></tr>';
    }

    // list all drivers
    for ($i=0; $i<count($rag); ++$i) {
        $result .= '<tr align="center">';

        $result .= '<td>'.$rag[$i]['driver_name'].'</td>';
        $result .= '<td>'.$rag[$i]['object_name'].'</td>';
        $result .= '<td>'.$rag[$i]['route_length'].' '.$la['UNIT_DISTANCE'].'</td>';

        if (in_array("overspeed_score", $data_items)) {
            $result .= '<td>'.$rag[$i]['overspeed_duration'].' '.$la['UNIT_S'].'</td>';
            $result .= '<td>'.$rag[$i]['overspeed_score'].'</td>';
        }

        if (in_array("harsh_acceleration_score", $data_items)) {
            $result .= '<td>'.$rag[$i]['haccel_count'].'</td>';
            $result .= '<td>'.$rag[$i]['haccel_score'].'</td>';
        }

        if (in_array("harsh_braking_score", $data_items)) {
            $result .= '<td>'.$rag[$i]['hbrake_count'].'</td>';
            $result .= '<td>'.$rag[$i]['hbrake_score'].'</td>';
        }

        if (in_array("harsh_cornering_score", $data_items)) {
            $result .= '<td>'.$rag[$i]['hcorn_count'].'</td>';
            $result .= '<td>'.$rag[$i]['hcorn_score'].'</td>';
        }

        if ($rag[$i]['rag_score'] <= 10) {
            $rag_color = '#00FF00';
        } elseif (($rag[$i]['rag_score'] > 10) && ($rag[$i]['rag_score'] <= 30)) {
            $rag_color = '#FFFF00';
        } elseif ($rag[$i]['rag_score'] > 30) {
            $rag_color = '#FF0000';
        }

        $result .= '<td bgcolor="'.$rag_color.'">'.$rag[$i]['rag_score'].'</td>';

        $result .= '</tr>';
    }

    $result .= '</table>';

    return $result;
}




function overSpeedGeo($imei, $dtf, $dtt, $speed_limit, $show_coordinates, $show_addresses, $zones_addresses, $data_items,$zone_ids,$menorA,$mayorA) //OVERSPEED
{
    global $ms, $_SESSION, $la, $user_id;

    $route = array();
    $q = "SELECT DISTINCT gued.dt_tracker,
    gued.lat,
    gued.lng,
    gued.altitude,
    gued.angle,
    gued.speed,
    gued.params,
    gued.event_id,
    gued.event_desc,
    gue.checked_value,
    (gued.speed - gue.checked_value) as diferencia,
    guz.zone_name,
    guz.zone_vertices
    FROM gs_user_events_data gued
    inner join gs_user_events gue on gued.event_desc = gue.name
    inner join gs_user_zones guz on guz.zone_id = gue.zones
    WHERE (gued.speed - gue.checked_value) > 0 and gue.zones !=''
    AND  gued.imei = '".$imei."' and gued.user_id = '".$user_id."'
    AND gued.type = 'overspeed' and gue.zones in (".$zone_ids.")
    AND gued.dt_tracker BETWEEN '".$dtf."' AND '".$dtt."' ORDER BY gued.dt_tracker ASC";

    $r = mysqli_query($ms, $q);

    while($route_data=mysqli_fetch_array($r))
    {
        $dt_tracker = convUserTimezone($route_data['dt_tracker']);
        $lat = $route_data['lat'];
        $lng = $route_data['lng'];
        $altitude = $route_data['altitude'];
        $angle = $route_data['angle'];
        $speed = $route_data['speed'];
        $event_id = $route_data['event_id'];
        $event_desc = $route_data['event_desc'];
        $checked_value = $route_data['checked_value'];



        $params = json_decode($route_data['params'],true);
        $params2 = $route_data['params'];

        $speed = convSpeedUnits($speed, 'km', $_SESSION["unit_distance"]);
        $altitude = convAltitudeUnits($altitude, 'km', $_SESSION["unit_distance"]);

            if (($lat != 0) && ($lng != 0))
            {
                $route[] = array(	$dt_tracker,
                            $lat,
                            $lng,
                            $altitude,
                            $angle,
                            $speed,
                            $params,
                            $event_id,
                            $event_desc,
                            $checked_value

                            );
            }
    }

    $overspeeds = getRouteOverspeedsEvent($route);


        $sql  =  "select gs_user_object_groups.group_name from gs_user_objects, gs_user_object_groups
                    where gs_user_objects.group_id = gs_user_object_groups.group_id
                    and gs_user_objects.user_id = gs_user_object_groups.user_id
                    and gs_user_objects.imei = '".$imei."' and gs_user_objects.user_id = ".$user_id;

        $result2 = $ms->query($sql);
        $grupos = "sin grupo";
        while($row = $result2->fetch_assoc()) {
            $grupos = $row['group_name'];

        }

        if($grupos != "sin grupo"){
        $grupos = $grupos;
        }
        else {
            $grupos = "sin grupo";
        }

    $prueba = $zone_ids;
    $prueba2 = explode(",", $prueba);

    $q = "SELECT * FROM `gs_user_zones` WHERE `user_id`='".$user_id."'";
    $r = mysqli_query($ms, $q);
    $zones = array();

    while ($row=mysqli_fetch_array($r)) {
        if (in_array($row['zone_id'], $prueba2)) {
            $mineq=0;
            $mayeq=0;

            if(isset($row['menor_igual_a'])){
                $mineq=$row['menor_igual_a'];
            }

            if(isset($row['mayor_igual_a'])){
                $mayeq=$row['mayor_igual_a'];
            }
            

            $zones[] = array($row['zone_id'],$row['zone_name'], $row['zone_vertices'],$row['menor_igual_a'],$row['mayor_igual_a']);


        }
    }

 if($route){

    $result = '<table class="report" width="100%"><tr align="center">';

    $result .= '<th>Patente</th>';
    $result .= '<th>Nombre</th>';
    $result .= '<th>Grupo</th>';
    $result .= '<th>Mes</th>';
    $result .= '<th>'."Fecha evento".'</th>';
    // $result .= '<th>'.$la['END'].'</th>';
    // $result .= '<th>'.$la['DURATION'].'</th>';
    $result .= '<th>'.$la['TOP_SPEED'].'</th>';
    // $result .= '<th>'.$la['AVG_SPEED'].'</th>';
    $result .= '<th>'."Nombre Geocerca".'</th>';
    $result .= '<th>'."Límite Velocidad Geocerca".'</th>';
    $result .= '<th>'."Diferencial".'</th>';
    $result .= '<th>Clasificacion de evento</th>';
    $result .= '<th>'."Direccion".'</th>';
    $result .= '<th>Nombre evento</th>';
    $result .= '</tr>';

            $in_zones = array();
            $in_zone = 0;
            $in_zone_route_length = 0;

            for ($i=0; $i<count($route); ++$i) {

                $point_lat = $route[$i][1];
                $point_lng = $route[$i][2];

                for ($j=0; $j<count($zones); ++$j) {
                    $zone_id = $zones[$j][0];
                    $zone_name = $zones[$j][1];
                    $zone_vertices = $zones[$j][2];
                    $menor_igual_a = $zones[$j][3];
                    $mayor_igual_a = $zones[$j][4];


                    $query = "SELECT * FROM `gs_user_events` WHERE `imei` LIKE '%$imei%' AND zones != ''  AND `type` = 'overspeed' AND `zones` LIKE '%$zone_id%'";
                    $resultado = mysqli_query($ms, $query);
                    $zonasReporte = mysqli_fetch_assoc($resultado);

                    $checkValue = $zonasReporte['checked_value'];
                    $diferenciaO = $overspeeds[$i][3] - $checkValue;
                    if ($diferenciaO>0) {

                    $isPointInPoylgon = isPointInPolygon($zone_vertices, $point_lat, $point_lng);

                    if ($isPointInPoylgon == 1) {

                        //$patente = getObjectPlate($imei);
                        // $menorA = $_COOKIE['nuevaCookieMenor'];
                        // $mayorA = $_COOKIE['nuevaCookieMayor'];

                        if(!$checkValue || $menorA == '' || $menorA == 0 || $mayorA == '' || $mayorA == 0){
                            $checkValue = -1;
                            $diferenciaO = -1;
                            $nivelLmc = -1;
                        }
                        else{
                        //resta exceso velocidad vehiculo con exceso velocidad configurado
                        $diferenciaO = $overspeeds[$i][3] - $checkValue;
                        //Niveles de gravedad
                        $nivelLmc = "";

                                if($diferenciaO < $menorA +1){
                                    $nivelLmc = "Leve";
                                }
                                elseif ($diferenciaO > $menorA && $diferenciaO < $mayorA){
                                    $nivelLmc = "Grave";
                                }
                                elseif ($diferenciaO > $mayorA -1){
                                    $nivelLmc = "Muy Grave";
                        }

                        }

                        $fechaComoEntero = strtotime($overspeeds[$i][1]);
                        $mes = (int) date("m", $fechaComoEntero);
                        $año = (int) date("Y", $fechaComoEntero);

                        setlocale(LC_TIME, 'es_ES');
                        $monthNum  = $mes;
                        $dateObj   = DateTime::createFromFormat('!m', $monthNum);
                        $monthName = strftime('%B', $dateObj->getTimestamp());

                        switch($monthNum)
                        {
                            case 1:
                            $monthNameSpanish = "Enero";
                            break;
                            case 2:
                            $monthNameSpanish = "Febrero";
                            break;
                            case 3:
                            $monthNameSpanish = "Marzo";
                            break;
                            case 4:
                            $monthNameSpanish = "Abril";
                            break;
                            case 5:
                            $monthNameSpanish = "Mayo";
                            break;
                            case 6:
                            $monthNameSpanish = "Junio";
                            break;
                            case 7:
                            $monthNameSpanish = "Julio";
                            break;
                            case 8:
                            $monthNameSpanish = "Agosto";
                            break;
                            case 9:
                            $monthNameSpanish = "Septiembre";
                            break;
                            case 10:
                            $monthNameSpanish = "Octubre";
                            break;
                            case 11:
                            $monthNameSpanish = "Noviembre";
                            break;
                            case 12:
                            $monthNameSpanish = "Diciembre";
                            break;

                        }


                            // $result = '<table class="report" width="100%"><tr align="center">';
                                $result .= '<tr align="center">';
                                $result .= '<td>'.getObjectPlate($imei).'</td>';
                                $result .= '<td>'.getObjectName($imei).'</td>';
                                $result .= '<td>'.$grupos.'</td>';
                                $result .= '<td>'.$monthNameSpanish.' '.$año.'</td>';
                                $result .= '<td>'.$overspeeds[$i][0].'</td>';
                                // $result .= '<td>'.$overspeeds[$i][1].'</td>';
                                // $result .= '<td>'.$overspeeds[$i][2].'</td>';
                                $result .= '<td>'.$overspeeds[$i][3].' '.$la["UNIT_SPEED"].'</td>';
                                //  $result .= '<td>'.$overspeeds[$i][7].' '.$la["UNIT_SPEED"].'</td>';
                                $result .= '<td>'.$zone_name.'</td>';
                                $result .= '<td>'.TipoDato($checkValue).'</td>';
                                $result .= '<td>'.TipoDato($diferenciaO).'</td>';
                                $result .= '<td>'.TipoDato($nivelLmc).'</td>';
                                $result .= '<td>'.reportsGetPossition($overspeeds[$i][5], $overspeeds[$i][6], $show_coordinates, $show_addresses, $zones_addresses).'</td>';
                                $result .= '<td>'.$event_desc.'</td>';
                                $result .= '</tr>';

                                setcookie("nuevaCookieMenor", "", time() - 1 );
                                setcookie("nuevaCookieMayor", "", time() - 1 );


                        }
                      }
                    }

            }

            $result .= '</table>';
        }
 else{

    $result = '<h3>'.$la['NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST'].'</h3>';

   }
 return $result;

}


function reportsGenerateOverspeed3EH($imei, $dtf, $dtt, $speed_limit, $show_coordinates, $show_addresses, $zones_addresses, $data_items,$cantidadhoras,$fechaenvio) //OVERSPEED SP
{
    global $_SESSION, $la, $user_id,$ms;

     $accuracy = getObjectAccuracy($imei);

    $result = "";
    $mifecha = date('Y-m-d H:i:s'); 
    $desde   = strtotime ( "".'-'."$cantidadhoras".' hour'."" , strtotime ($mifecha)) ; 
    $desde   = date('Y-m-d H:i:s',$desde);
  

    $q2  = "SELECT dt_tracker,lat,lng,speed,overpass, abs(overpass-speed) FROM gs_object_data_".$imei."
            WHERE dt_tracker BETWEEN '".$desde."' AND '".$mifecha."' and overpass-speed < 0
            and overpass > 0 ";

    $r2 = mysqli_query($ms, $q2);


    $sql  =  "select gs_user_object_groups.group_name from gs_user_objects, gs_user_object_groups 
                where gs_user_objects.group_id = gs_user_object_groups.group_id  
                and gs_user_objects.user_id = gs_user_object_groups.user_id 
                and gs_user_objects.imei = ".$imei." and gs_user_objects.user_id = ".$user_id;

     $result2 = $ms->query($sql);
     $grupos = "sin grupo";

        while($row = $result2->fetch_assoc()) {
            $grupos = $row['group_name'];
            
        }
        

    while ($row2 = mysqli_fetch_row($r2)) {
        $dt_tracker = $row2[0];
        $lat = $row2[1];
        $lng = $row2[2];
        $speed = $row2[3];
        $overspeed = $row2[4];
        $overspeedDif = $row2[5];


        if ($row2[0] = '') {
            return '<table><tr><td>'.$la['NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST'].'</td></tr></table>';
        } else {

        round($speed);
        round($overspeedDif);

            $result .= '<tr align="center">';
            $result .= '<td>'.getObjectName($imei).'</td>';
            $result .= '<td>'.getObjectPlate($imei).'</td>';
            $result .= '<td>'.$grupos.'</td>';
            $result .= '<td>'.convUserTimezone($dt_tracker).'</td>';
            $result .= '<td>'.round($speed,0).'</td>';
            $result .= '<td>'.$overspeed.'</td>'; 
            $result .= '<td>'.round($overspeedDif,0).'</td>';
            $result .= '<td>'.reportsGetPossition($lat, $lng, $show_coordinates, $show_addresses, $zones_addresses).'</td>';
            $result .= '</tr>';
        }
    }

    // $result .= '</table>';

    return $result;
}




function reportsGenerateTravelSheet2($imei, $dtf, $dtt, $stop_duration, $show_coordinates, $show_addresses, $zones_addresses, $data_items) //TRAVEL_SHEET
{
    global $_SESSION, $la, $user_id,$ms;

    $result = '';
    $data = getRoute($imei, $dtf, $dtt, $stop_duration, true);

    if (count($data['drives']) < 1) {
        //	return '<table><tr><td>'.$la['NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST'].'</td></tr></table>';
    }

    //		$result = '<table class="report" width="100%"><tr align="center">';

    $total_route_length = 0;
    $total_fuel_consumption = 0;
    $total_fuel_cost = 0;

    for ($j=0; $j<count($data['drives']); ++$j) {
        $route_id_a = $data['drives'][$j][0];
        $route_id_b = $data['drives'][$j][2];

        $lat1 = sprintf("%01.6f", $data['route'][$route_id_a][1]);
        $lng1 = sprintf("%01.6f", $data['route'][$route_id_a][2]);
        $lat2 = sprintf("%01.6f", $data['route'][$route_id_b][1]);
        $lng2 = sprintf("%01.6f", $data['route'][$route_id_b][2]);

        $time_a = $data['drives'][$j][4];

        $time_b = $data['drives'][$j][5];

        if (!isset($position_a)) {
            $position_a = reportsGetPossition($lat1, $lng1, $show_coordinates, $show_addresses, $zones_addresses);
        } else {
            $position_a = $position_b;
        }

        $position_b = reportsGetPossition($lat2, $lng2, $show_coordinates, $show_addresses, $zones_addresses);

        $duration = $data['drives'][$j][6];

        $route_length = $data['drives'][$j][7];
        $fuel_consumption = $data['drives'][$j][10];
        $fuel_cost = $data['drives'][$j][11];

        //			$result .= '<tr align="center">';
        $result .= '<td>'.getObjectName($imei).'</td>';
        $result .= '<td>'.$time_a.'</td>';
        $result .= '<td>'.$position_a.'</td>';
        $result .= '<td>'.$time_b.'</td>';
        $result .= '<td>'.$position_b.'</td>';
        $result .= '<td>'.$duration.'</td>';
        $result .= '<td>'.$route_length.' '.$la["UNIT_DISTANCE"].'</td>';

        $total_route_length += $route_length;

        $result .= '</tr>';
    }

    //	$result .= '</table>';

    return $result;
}



function reportsGenerateOverspeedLmcE($imei, $dtf, $dtt, $speed_limit, $show_coordinates, $show_addresses, $zones_addresses, $data_items,$menorA,$mayorA) //OVERSPEED
	{

		global $_SESSION, $la, $user_id,$ms;

		$accuracy = getObjectAccuracy($imei);

		$route = getRouteRaw($imei, $accuracy, $dtf, $dtt);
		//$route = removeRouteFakeCoordinates($route, array());
		$overspeeds = getRouteOverspeeds($route, $speed_limit);


	   //  $conn = new mysqli('104.200.25.198', 'root', 'Stech..,', 'gpsimple');
	   //  $conn = new mysqli('10.118.144.7', 'root', 'Stech@306..,', 'gpsimple');


		$sql  =  "select gs_user_object_groups.group_name from gs_user_objects, gs_user_object_groups
					where gs_user_objects.group_id = gs_user_object_groups.group_id
					and gs_user_objects.user_id = gs_user_object_groups.user_id
					and gs_user_objects.imei = '".$imei."' and gs_user_objects.user_id = ".$user_id;

		$result2 = $ms->query($sql);

			while($row = $result2->fetch_assoc()) {
			   $grupos = $row['group_name'];

			}
			if($grupos){
			  $grupos = $grupos;
			}
			else {
				$grupos = "sin grupo";
			}



		if (count($route) == 0){
			return '<table><tr><td>'.$la['NOTHING_HAS_BEEN_FOUND_ON_YOUR_REQUEST'].'</td></tr></table>';
		}

		// $result = '<table class="report" width="100%"><tr align="center">';

		//     $result .= '<th>Patente</th>';
		//     $result .= '<th>Nombre</th>';
		//     $result .= '<th>Grupo</th>';
		//     $result .= '<th>Mes</th>';
		//     $result .= '<th>'.$la['START'].'</th>';
		//     $result .= '<th>'.$la['END'].'</th>';
		//     $result .= '<th>'.$la['DURATION'].'</th>';
		//     $result .= '<th>'.$la['TOP_SPEED'].'</th>';
		//     $result .= '<th>'.$la['AVG_SPEED'].'</th>';
		//     $result .= '<th>'.$la['OVERSPEED_POSITION'].'</th>';
		//     $result .= '<th>'."Diferencial".'</th>';
		//     $result .= '<th>Clasificacion de eventos</th>';
		//     $result .= '</tr>';

		$result = "";
	   //  $menorA = $_COOKIE['nuevaCookieMenor'];
	   //  $mayorA = $_COOKIE['nuevaCookieMayor'];


		for ($i=0; $i<count($overspeeds); ++$i) {

		$patente = getObjectPlate($imei);
			if($menorA < 0 || $menorA == '' || $menorA == 0 || $mayorA == '' || $mayorA == 0 || $mayorA < 0){

				$diferenciaO = -1;
				$nivelLmc = -1;
			}
			else{
				//resta exceso velocidad vehiculo con exceso velocidad configurado
				$diferenciaO = $overspeeds[$i][3] - $speed_limit;
				//Niveles de gravedad
				$nivelLmc = "";
					if($diferenciaO <= $menorA){
						$nivelLmc = "leve";
					}
					else if ($diferenciaO > $menorA && $diferenciaO < $mayorA){
						$nivelLmc = "medio";
					}
					else if ($diferenciaO >= $mayorA){
						$nivelLmc = "critico";
					}
			}


		$fechaComoEntero = strtotime($overspeeds[$i][1]);
		$mes = (int) date("m", $fechaComoEntero);
		$año = (int) date("Y", $fechaComoEntero);

		setlocale(LC_TIME, 'es_ES');
		$monthNum  = $mes;
		$dateObj   = DateTime::createFromFormat('!m', $monthNum);
		$monthName = strftime('%B', $dateObj->getTimestamp());

		switch($monthNum)
		{
			case 1:
			$monthNameSpanish = "Enero";
			break;
			case 2:
			$monthNameSpanish = "Febrero";
			break;
			case 3:
			$monthNameSpanish = "Marzo";
			break;
			case 4:
			$monthNameSpanish = "Abril";
			break;
			case 5:
			$monthNameSpanish = "Mayo";
			break;
			case 6:
			$monthNameSpanish = "Junio";
			break;
			case 7:
			$monthNameSpanish = "Julio";
			break;
			case 8:
			$monthNameSpanish = "Agosto";
			break;
			case 9:
			$monthNameSpanish = "Septiembre";
			break;
			case 10:
			$monthNameSpanish = "Octubre";
			break;
			case 11:
			$monthNameSpanish = "Noviembre";
			break;
			case 12:
			$monthNameSpanish = "Diciembre";
			break;

		}

		// echo $monthName;
		   if ($diferenciaO > 0) {
			   # code...
			   $result .= '<tr align="center">';

			// if (in_array("start", $data_items)) {
				$result .= '<td>'.$patente.'</td>';
				$result .= '<td>'.getObjectName($imei).'</td>';
				$result .= '<td>'.$grupos.'</td>';
				$result .= '<td>'.$monthNameSpanish.' '.$año.'</td>';
				$result .= '<td>'.$overspeeds[$i][0].'</td>';
			// }
			// if (in_array("end", $data_items)) {
				$result .= '<td>'.$overspeeds[$i][1].'</td>';
			// }
			// if (in_array("duration", $data_items)) {
				$result .= '<td>'.$overspeeds[$i][2].'</td>';
			// }
			// if (in_array("top_speed", $data_items)) {
				$result .= '<td>'.$overspeeds[$i][3].' '.$la["UNIT_SPEED"].'</td>';
			// }
			// if (in_array("avg_speed", $data_items)) {
				$result .= '<td>'.$overspeeds[$i][4].' '.$la["UNIT_SPEED"].'</td>';
			// }
			//if (in_array("rpm", $data_items)) {
				//$result .= '<td>'.$overspeeds[$i][7].' rpm</td>';
			//}
			// if (in_array("overspeed_position", $data_items)) {
				$result .= '<td>'.reportsGetPossition($overspeeds[$i][5], $overspeeds[$i][6], $show_coordinates, $show_addresses, $zones_addresses).'</td>';
				$result .= '<td>'.TipoDato($diferenciaO).'</td>';
				$result .= '<td>'.TipoDato($nivelLmc).'</td>';


			$result .= '</tr>';

		   }

		}


		return $result;
	}

